/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import java.io.Serializable;

public class GridPoint3
implements Serializable {
    private static final long serialVersionUID = 5922187982746752830L;
    public int x;
    public int y;
    public int z;

    public GridPoint3() {
    }

    public GridPoint3(int x2, int y2, int z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public GridPoint3(GridPoint3 point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public GridPoint3 set(GridPoint3 point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
        return this;
    }

    public GridPoint3 set(int x2, int y2, int z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        return this;
    }

    public float dst2(GridPoint3 other) {
        int xd = other.x - this.x;
        int yd = other.y - this.y;
        int zd = other.z - this.z;
        return xd * xd + yd * yd + zd * zd;
    }

    public float dst2(int x2, int y2, int z2) {
        int xd = x2 - this.x;
        int yd = y2 - this.y;
        int zd = z2 - this.z;
        return xd * xd + yd * yd + zd * zd;
    }

    public float dst(GridPoint3 other) {
        int xd = other.x - this.x;
        int yd = other.y - this.y;
        int zd = other.z - this.z;
        return (float)Math.sqrt(xd * xd + yd * yd + zd * zd);
    }

    public float dst(int x2, int y2, int z2) {
        int xd = x2 - this.x;
        int yd = y2 - this.y;
        int zd = z2 - this.z;
        return (float)Math.sqrt(xd * xd + yd * yd + zd * zd);
    }

    public GridPoint3 add(GridPoint3 other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public GridPoint3 add(int x2, int y2, int z2) {
        this.x += x2;
        this.y += y2;
        this.z += z2;
        return this;
    }

    public GridPoint3 sub(GridPoint3 other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        return this;
    }

    public GridPoint3 sub(int x2, int y2, int z2) {
        this.x -= x2;
        this.y -= y2;
        this.z -= z2;
        return this;
    }

    public GridPoint3 cpy() {
        return new GridPoint3(this);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || o2.getClass() != this.getClass()) {
            return false;
        }
        GridPoint3 g2 = (GridPoint3)o2;
        return this.x == g2.x && this.y == g2.y && this.z == g2.z;
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + this.x;
        result = 17 * result + this.y;
        result = 17 * result + this.z;
        return result;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

