/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.utils.SnapshotArray;

public class Group
extends Actor
implements Cullable {
    private static final Vector2 tmp = new Vector2();
    final SnapshotArray<Actor> children = new SnapshotArray(true, 4, Actor.class);
    private final Affine2 worldTransform = new Affine2();
    private final Matrix4 computedTransform = new Matrix4();
    private final Matrix4 oldTransform = new Matrix4();
    boolean transform = true;
    private Rectangle cullingArea;

    @Override
    public void act(float delta) {
        super.act(delta);
        Actor[] actors = this.children.begin();
        int n2 = this.children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            actors[i2].act(delta);
        }
        this.children.end();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.transform) {
            this.applyTransform(batch, this.computeTransform());
        }
        this.drawChildren(batch, parentAlpha);
        if (this.transform) {
            this.resetTransform(batch);
        }
    }

    protected void drawChildren(Batch batch, float parentAlpha) {
        parentAlpha *= this.color.a;
        SnapshotArray<Actor> children = this.children;
        Actor[] actors = children.begin();
        Rectangle cullingArea = this.cullingArea;
        if (cullingArea != null) {
            float cullLeft = cullingArea.x;
            float cullRight = cullLeft + cullingArea.width;
            float cullBottom = cullingArea.y;
            float cullTop = cullBottom + cullingArea.height;
            if (this.transform) {
                int n2 = children.size;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Actor child = actors[i2];
                    if (!child.isVisible()) continue;
                    float cx2 = child.x;
                    float cy2 = child.y;
                    if (!(cx2 <= cullRight) || !(cy2 <= cullTop) || !(cx2 + child.width >= cullLeft) || !(cy2 + child.height >= cullBottom)) continue;
                    child.draw(batch, parentAlpha);
                }
            } else {
                float offsetX = this.x;
                float offsetY = this.y;
                this.x = 0.0f;
                this.y = 0.0f;
                int n3 = children.size;
                for (int i3 = 0; i3 < n3; ++i3) {
                    Actor child = actors[i3];
                    if (!child.isVisible()) continue;
                    float cx3 = child.x;
                    float cy3 = child.y;
                    if (!(cx3 <= cullRight) || !(cy3 <= cullTop) || !(cx3 + child.width >= cullLeft) || !(cy3 + child.height >= cullBottom)) continue;
                    child.x = cx3 + offsetX;
                    child.y = cy3 + offsetY;
                    child.draw(batch, parentAlpha);
                    child.x = cx3;
                    child.y = cy3;
                }
                this.x = offsetX;
                this.y = offsetY;
            }
        } else if (this.transform) {
            int n4 = children.size;
            for (int i4 = 0; i4 < n4; ++i4) {
                Actor child = actors[i4];
                if (!child.isVisible()) continue;
                child.draw(batch, parentAlpha);
            }
        } else {
            float offsetX = this.x;
            float offsetY = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            int n5 = children.size;
            for (int i5 = 0; i5 < n5; ++i5) {
                Actor child = actors[i5];
                if (!child.isVisible()) continue;
                float cx4 = child.x;
                float cy4 = child.y;
                child.x = cx4 + offsetX;
                child.y = cy4 + offsetY;
                child.draw(batch, parentAlpha);
                child.x = cx4;
                child.y = cy4;
            }
            this.x = offsetX;
            this.y = offsetY;
        }
        children.end();
    }

    @Override
    public void drawDebug(ShapeRenderer shapes) {
        this.drawDebugBounds(shapes);
        if (this.transform) {
            this.applyTransform(shapes, this.computeTransform());
        }
        this.drawDebugChildren(shapes);
        if (this.transform) {
            this.resetTransform(shapes);
        }
    }

    protected void drawDebugChildren(ShapeRenderer shapes) {
        SnapshotArray<Actor> children = this.children;
        Actor[] actors = children.begin();
        if (this.transform) {
            int n2 = children.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                Actor child = actors[i2];
                if (!child.isVisible() || !child.getDebug() && !(child instanceof Group)) continue;
                child.drawDebug(shapes);
            }
            shapes.flush();
        } else {
            float offsetX = this.x;
            float offsetY = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            int n3 = children.size;
            for (int i3 = 0; i3 < n3; ++i3) {
                Actor child = actors[i3];
                if (!child.isVisible() || !child.getDebug() && !(child instanceof Group)) continue;
                float cx2 = child.x;
                float cy2 = child.y;
                child.x = cx2 + offsetX;
                child.y = cy2 + offsetY;
                child.drawDebug(shapes);
                child.x = cx2;
                child.y = cy2;
            }
            this.x = offsetX;
            this.y = offsetY;
        }
        children.end();
    }

    protected Matrix4 computeTransform() {
        Affine2 worldTransform = this.worldTransform;
        float originX = this.originX;
        float originY = this.originY;
        worldTransform.setToTrnRotScl(this.x + originX, this.y + originY, this.rotation, this.scaleX, this.scaleY);
        if (originX != 0.0f || originY != 0.0f) {
            worldTransform.translate(-originX, -originY);
        }
        Group parentGroup = this.parent;
        while (parentGroup != null && !parentGroup.transform) {
            parentGroup = parentGroup.parent;
        }
        if (parentGroup != null) {
            worldTransform.preMul(parentGroup.worldTransform);
        }
        this.computedTransform.set(worldTransform);
        return this.computedTransform;
    }

    protected void applyTransform(Batch batch, Matrix4 transform) {
        this.oldTransform.set(batch.getTransformMatrix());
        batch.setTransformMatrix(transform);
    }

    protected void resetTransform(Batch batch) {
        batch.setTransformMatrix(this.oldTransform);
    }

    protected void applyTransform(ShapeRenderer shapes, Matrix4 transform) {
        this.oldTransform.set(shapes.getTransformMatrix());
        shapes.setTransformMatrix(transform);
    }

    protected void resetTransform(ShapeRenderer shapes) {
        shapes.setTransformMatrix(this.oldTransform);
    }

    @Override
    public void setCullingArea(Rectangle cullingArea) {
        this.cullingArea = cullingArea;
    }

    public Rectangle getCullingArea() {
        return this.cullingArea;
    }

    @Override
    public Actor hit(float x2, float y2, boolean touchable) {
        if (touchable && this.getTouchable() == Touchable.disabled) {
            return null;
        }
        Vector2 point = tmp;
        Actor[] childrenArray = (Actor[])this.children.items;
        for (int i2 = this.children.size - 1; i2 >= 0; --i2) {
            Actor child = childrenArray[i2];
            if (!child.isVisible()) continue;
            child.parentToLocalCoordinates(point.set(x2, y2));
            Actor hit = child.hit(point.x, point.y, touchable);
            if (hit == null) continue;
            return hit;
        }
        return super.hit(x2, y2, touchable);
    }

    protected void childrenChanged() {
    }

    public void addActor(Actor actor) {
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeActor(actor, false);
        }
        this.children.add(actor);
        actor.setParent(this);
        actor.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorAt(int index, Actor actor) {
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeActor(actor, false);
        }
        if (index >= this.children.size) {
            this.children.add(actor);
        } else {
            this.children.insert(index, actor);
        }
        actor.setParent(this);
        actor.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorBefore(Actor actorBefore, Actor actor) {
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeActor(actor, false);
        }
        int index = this.children.indexOf(actorBefore, true);
        this.children.insert(index, actor);
        actor.setParent(this);
        actor.setStage(this.getStage());
        this.childrenChanged();
    }

    public void addActorAfter(Actor actorAfter, Actor actor) {
        int index;
        if (actor.parent != null) {
            if (actor.parent == this) {
                return;
            }
            actor.parent.removeActor(actor, false);
        }
        if ((index = this.children.indexOf(actorAfter, true)) == this.children.size) {
            this.children.add(actor);
        } else {
            this.children.insert(index + 1, actor);
        }
        actor.setParent(this);
        actor.setStage(this.getStage());
        this.childrenChanged();
    }

    public boolean removeActor(Actor actor) {
        return this.removeActor(actor, true);
    }

    public boolean removeActor(Actor actor, boolean unfocus) {
        Stage stage;
        if (!this.children.removeValue(actor, true)) {
            return false;
        }
        if (unfocus && (stage = this.getStage()) != null) {
            stage.unfocus(actor);
        }
        actor.setParent(null);
        actor.setStage(null);
        this.childrenChanged();
        return true;
    }

    public void clearChildren() {
        Actor[] actors = this.children.begin();
        int n2 = this.children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Actor child = actors[i2];
            child.setStage(null);
            child.setParent(null);
        }
        this.children.end();
        this.children.clear();
        this.childrenChanged();
    }

    @Override
    public void clear() {
        super.clear();
        this.clearChildren();
    }

    public <T extends Actor> T findActor(String name) {
        int i2;
        SnapshotArray<Actor> children = this.children;
        int n2 = children.size;
        for (i2 = 0; i2 < n2; ++i2) {
            if (!name.equals(((Actor)children.get(i2)).getName())) continue;
            return (T)((Actor)children.get(i2));
        }
        n2 = children.size;
        for (i2 = 0; i2 < n2; ++i2) {
            T actor;
            Actor child = (Actor)children.get(i2);
            if (!(child instanceof Group) || (actor = ((Group)child).findActor(name)) == null) continue;
            return actor;
        }
        return null;
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        Actor[] childrenArray = (Actor[])this.children.items;
        int n2 = this.children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            childrenArray[i2].setStage(stage);
        }
    }

    public boolean swapActor(int first, int second) {
        int maxIndex = this.children.size;
        if (first < 0 || first >= maxIndex) {
            return false;
        }
        if (second < 0 || second >= maxIndex) {
            return false;
        }
        this.children.swap(first, second);
        return true;
    }

    public boolean swapActor(Actor first, Actor second) {
        int firstIndex = this.children.indexOf(first, true);
        int secondIndex = this.children.indexOf(second, true);
        if (firstIndex == -1 || secondIndex == -1) {
            return false;
        }
        this.children.swap(firstIndex, secondIndex);
        return true;
    }

    public SnapshotArray<Actor> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size > 0;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public boolean isTransform() {
        return this.transform;
    }

    public Vector2 localToDescendantCoordinates(Actor descendant, Vector2 localCoords) {
        Group parent = descendant.parent;
        if (parent == null) {
            throw new IllegalArgumentException("Child is not a descendant: " + descendant);
        }
        if (parent != this) {
            this.localToDescendantCoordinates(parent, localCoords);
        }
        descendant.parentToLocalCoordinates(localCoords);
        return localCoords;
    }

    public void setDebug(boolean enabled, boolean recursively) {
        this.setDebug(enabled);
        if (recursively) {
            for (Actor child : this.children) {
                if (child instanceof Group) {
                    ((Group)child).setDebug(enabled, recursively);
                    continue;
                }
                child.setDebug(enabled);
            }
        }
    }

    public Group debugAll() {
        this.setDebug(true, true);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        this.toString(buffer, 1);
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    void toString(StringBuilder buffer, int indent) {
        buffer.append(super.toString());
        buffer.append('\n');
        Actor[] actors = this.children.begin();
        int n2 = this.children.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int ii = 0; ii < indent; ++ii) {
                buffer.append("|  ");
            }
            Actor actor = actors[i2];
            if (actor instanceof Group) {
                ((Group)actor).toString(buffer, indent + 1);
                continue;
            }
            buffer.append(actor);
            buffer.append('\n');
        }
        this.children.end();
    }
}

