/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

public class ProgressBar
extends Widget
implements Disableable {
    private ProgressBarStyle style;
    private float min;
    private float max;
    private float stepSize;
    private float value;
    private float animateFromValue;
    float position;
    final boolean vertical;
    private float animateDuration;
    private float animateTime;
    private Interpolation animateInterpolation = Interpolation.linear;
    boolean disabled;
    private Interpolation visualInterpolation = Interpolation.linear;
    private boolean round = true;

    public ProgressBar(float min, float max, float stepSize, boolean vertical, Skin skin) {
        this(min, max, stepSize, vertical, skin.get("default-" + (vertical ? "vertical" : "horizontal"), ProgressBarStyle.class));
    }

    public ProgressBar(float min, float max, float stepSize, boolean vertical, Skin skin, String styleName) {
        this(min, max, stepSize, vertical, skin.get(styleName, ProgressBarStyle.class));
    }

    public ProgressBar(float min, float max, float stepSize, boolean vertical, ProgressBarStyle style) {
        if (min > max) {
            throw new IllegalArgumentException("max must be > min. min,max: " + min + ", " + max);
        }
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException("stepSize must be > 0: " + stepSize);
        }
        this.setStyle(style);
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
        this.vertical = vertical;
        this.value = min;
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public void setStyle(ProgressBarStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.invalidateHierarchy();
    }

    public ProgressBarStyle getStyle() {
        return this.style;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.animateTime > 0.0f) {
            this.animateTime -= delta;
            Stage stage = this.getStage();
            if (stage != null && stage.getActionsRequestRendering()) {
                Gdx.graphics.requestRendering();
            }
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        ProgressBarStyle style = this.style;
        boolean disabled = this.disabled;
        Drawable knob = this.getKnobDrawable();
        Drawable bg2 = disabled && style.disabledBackground != null ? style.disabledBackground : style.background;
        Drawable knobBefore = disabled && style.disabledKnobBefore != null ? style.disabledKnobBefore : style.knobBefore;
        Drawable knobAfter = disabled && style.disabledKnobAfter != null ? style.disabledKnobAfter : style.knobAfter;
        Color color = this.getColor();
        float x2 = this.getX();
        float y2 = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        float knobHeight = knob == null ? 0.0f : knob.getMinHeight();
        float knobWidth = knob == null ? 0.0f : knob.getMinWidth();
        float percent = this.getVisualPercent();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        if (this.vertical) {
            float positionHeight = height;
            float bgTopHeight = 0.0f;
            if (bg2 != null) {
                if (this.round) {
                    bg2.draw(batch, Math.round(x2 + (width - bg2.getMinWidth()) * 0.5f), y2, Math.round(bg2.getMinWidth()), height);
                } else {
                    bg2.draw(batch, x2 + width - bg2.getMinWidth() * 0.5f, y2, bg2.getMinWidth(), height);
                }
                bgTopHeight = bg2.getTopHeight();
                positionHeight -= bgTopHeight + bg2.getBottomHeight();
            }
            float knobHeightHalf = 0.0f;
            if (this.min != this.max) {
                if (knob == null) {
                    knobHeightHalf = knobBefore == null ? 0.0f : knobBefore.getMinHeight() * 0.5f;
                    this.position = (positionHeight - knobHeightHalf) * percent;
                    this.position = Math.min(positionHeight - knobHeightHalf, this.position);
                } else {
                    knobHeightHalf = knobHeight * 0.5f;
                    this.position = (positionHeight - knobHeight) * percent;
                    this.position = Math.min(positionHeight - knobHeight, this.position) + bg2.getBottomHeight();
                }
                this.position = Math.max(0.0f, this.position);
            }
            if (knobBefore != null) {
                float offset = 0.0f;
                if (bg2 != null) {
                    offset = bgTopHeight;
                }
                if (this.round) {
                    knobBefore.draw(batch, Math.round(x2 + (width - knobBefore.getMinWidth()) * 0.5f), Math.round(y2 + offset), Math.round(knobBefore.getMinWidth()), Math.round(this.position + knobHeightHalf));
                } else {
                    knobBefore.draw(batch, x2 + (width - knobBefore.getMinWidth()) * 0.5f, y2 + offset, knobBefore.getMinWidth(), this.position + knobHeightHalf);
                }
            }
            if (knobAfter != null) {
                if (this.round) {
                    knobAfter.draw(batch, Math.round(x2 + (width - knobAfter.getMinWidth()) * 0.5f), Math.round(y2 + this.position + knobHeightHalf), Math.round(knobAfter.getMinWidth()), Math.round(height - this.position - knobHeightHalf));
                } else {
                    knobAfter.draw(batch, x2 + (width - knobAfter.getMinWidth()) * 0.5f, y2 + this.position + knobHeightHalf, knobAfter.getMinWidth(), height - this.position - knobHeightHalf);
                }
            }
            if (knob != null) {
                if (this.round) {
                    knob.draw(batch, Math.round(x2 + (width - knobWidth) * 0.5f), Math.round(y2 + this.position), Math.round(knobWidth), Math.round(knobHeight));
                } else {
                    knob.draw(batch, x2 + (width - knobWidth) * 0.5f, y2 + this.position, knobWidth, knobHeight);
                }
            }
        } else {
            float positionWidth = width;
            float bgLeftWidth = 0.0f;
            if (bg2 != null) {
                if (this.round) {
                    bg2.draw(batch, x2, Math.round(y2 + (height - bg2.getMinHeight()) * 0.5f), width, Math.round(bg2.getMinHeight()));
                } else {
                    bg2.draw(batch, x2, y2 + (height - bg2.getMinHeight()) * 0.5f, width, bg2.getMinHeight());
                }
                bgLeftWidth = bg2.getLeftWidth();
                positionWidth -= bgLeftWidth + bg2.getRightWidth();
            }
            float knobWidthHalf = 0.0f;
            if (this.min != this.max) {
                if (knob == null) {
                    knobWidthHalf = knobBefore == null ? 0.0f : knobBefore.getMinWidth() * 0.5f;
                    this.position = (positionWidth - knobWidthHalf) * percent;
                    this.position = Math.min(positionWidth - knobWidthHalf, this.position);
                } else {
                    knobWidthHalf = knobWidth * 0.5f;
                    this.position = (positionWidth - knobWidth) * percent;
                    this.position = Math.min(positionWidth - knobWidth, this.position) + bgLeftWidth;
                }
                this.position = Math.max(0.0f, this.position);
            }
            if (knobBefore != null) {
                float offset = 0.0f;
                if (bg2 != null) {
                    offset = bgLeftWidth;
                }
                if (this.round) {
                    knobBefore.draw(batch, Math.round(x2 + offset), Math.round(y2 + (height - knobBefore.getMinHeight()) * 0.5f), Math.round(this.position + knobWidthHalf), Math.round(knobBefore.getMinHeight()));
                } else {
                    knobBefore.draw(batch, x2 + offset, y2 + (height - knobBefore.getMinHeight()) * 0.5f, this.position + knobWidthHalf, knobBefore.getMinHeight());
                }
            }
            if (knobAfter != null) {
                if (this.round) {
                    knobAfter.draw(batch, Math.round(x2 + this.position + knobWidthHalf), Math.round(y2 + (height - knobAfter.getMinHeight()) * 0.5f), Math.round(width - this.position - knobWidthHalf), Math.round(knobAfter.getMinHeight()));
                } else {
                    knobAfter.draw(batch, x2 + this.position + knobWidthHalf, y2 + (height - knobAfter.getMinHeight()) * 0.5f, width - this.position - knobWidthHalf, knobAfter.getMinHeight());
                }
            }
            if (knob != null) {
                if (this.round) {
                    knob.draw(batch, Math.round(x2 + this.position), Math.round(y2 + (height - knobHeight) * 0.5f), Math.round(knobWidth), Math.round(knobHeight));
                } else {
                    knob.draw(batch, x2 + this.position, y2 + (height - knobHeight) * 0.5f, knobWidth, knobHeight);
                }
            }
        }
    }

    public float getValue() {
        return this.value;
    }

    public float getVisualValue() {
        if (this.animateTime > 0.0f) {
            return this.animateInterpolation.apply(this.animateFromValue, this.value, 1.0f - this.animateTime / this.animateDuration);
        }
        return this.value;
    }

    public float getPercent() {
        return (this.value - this.min) / (this.max - this.min);
    }

    public float getVisualPercent() {
        return this.visualInterpolation.apply((this.getVisualValue() - this.min) / (this.max - this.min));
    }

    protected Drawable getKnobDrawable() {
        return this.disabled && this.style.disabledKnob != null ? this.style.disabledKnob : this.style.knob;
    }

    protected float getKnobPosition() {
        return this.position;
    }

    public boolean setValue(float value) {
        float oldValue;
        if ((value = this.clamp((float)Math.round(value / this.stepSize) * this.stepSize)) == (oldValue = this.value)) {
            return false;
        }
        float oldVisualValue = this.getVisualValue();
        this.value = value;
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        boolean cancelled = this.fire(changeEvent);
        if (cancelled) {
            this.value = oldValue;
        } else if (this.animateDuration > 0.0f) {
            this.animateFromValue = oldVisualValue;
            this.animateTime = this.animateDuration;
        }
        Pools.free(changeEvent);
        return !cancelled;
    }

    protected float clamp(float value) {
        return MathUtils.clamp(value, this.min, this.max);
    }

    public void setRange(float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("min must be <= max");
        }
        this.min = min;
        this.max = max;
        if (this.value < min) {
            this.setValue(min);
        } else if (this.value > max) {
            this.setValue(max);
        }
    }

    public void setStepSize(float stepSize) {
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException("steps must be > 0: " + stepSize);
        }
        this.stepSize = stepSize;
    }

    @Override
    public float getPrefWidth() {
        if (this.vertical) {
            Drawable knob = this.getKnobDrawable();
            Drawable bg2 = this.disabled && this.style.disabledBackground != null ? this.style.disabledBackground : this.style.background;
            return Math.max(knob == null ? 0.0f : knob.getMinWidth(), bg2.getMinWidth());
        }
        return 140.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.vertical) {
            return 140.0f;
        }
        Drawable knob = this.getKnobDrawable();
        Drawable bg2 = this.disabled && this.style.disabledBackground != null ? this.style.disabledBackground : this.style.background;
        return Math.max(knob == null ? 0.0f : knob.getMinHeight(), bg2 == null ? 0.0f : bg2.getMinHeight());
    }

    public float getMinValue() {
        return this.min;
    }

    public float getMaxValue() {
        return this.max;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setAnimateDuration(float duration) {
        this.animateDuration = duration;
    }

    public void setAnimateInterpolation(Interpolation animateInterpolation) {
        if (animateInterpolation == null) {
            throw new IllegalArgumentException("animateInterpolation cannot be null.");
        }
        this.animateInterpolation = animateInterpolation;
    }

    public void setVisualInterpolation(Interpolation interpolation) {
        this.visualInterpolation = interpolation;
    }

    public void setRound(boolean round) {
        this.round = round;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public static class ProgressBarStyle {
        public Drawable background;
        public Drawable disabledBackground;
        public Drawable knob;
        public Drawable disabledKnob;
        public Drawable knobBefore;
        public Drawable knobAfter;
        public Drawable disabledKnobBefore;
        public Drawable disabledKnobAfter;

        public ProgressBarStyle() {
        }

        public ProgressBarStyle(Drawable background, Drawable knob) {
            this.background = background;
            this.knob = knob;
        }

        public ProgressBarStyle(ProgressBarStyle style) {
            this.background = style.background;
            this.disabledBackground = style.disabledBackground;
            this.knob = style.knob;
            this.disabledKnob = style.disabledKnob;
            this.knobBefore = style.knobBefore;
            this.knobAfter = style.knobAfter;
            this.disabledKnobBefore = style.disabledKnobBefore;
            this.disabledKnobAfter = style.disabledKnobAfter;
        }
    }
}

