/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;

public class TiledDrawable
extends TextureRegionDrawable {
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);

    public TiledDrawable() {
    }

    public TiledDrawable(TextureRegion region) {
        super(region);
    }

    public TiledDrawable(TextureRegionDrawable drawable) {
        super(drawable);
    }

    @Override
    public void draw(Batch batch, float x2, float y2, float width, float height) {
        float v2;
        float u2;
        float batchColor = batch.getPackedColor();
        batch.setColor(batch.getColor().mul(this.color));
        TextureRegion region = this.getRegion();
        float regionWidth = region.getRegionWidth();
        float regionHeight = region.getRegionHeight();
        int fullX = (int)(width / regionWidth);
        int fullY = (int)(height / regionHeight);
        float remainingX = width - regionWidth * (float)fullX;
        float remainingY = height - regionHeight * (float)fullY;
        float startX = x2;
        float startY = y2;
        float endX = x2 + width - remainingX;
        float endY = y2 + height - remainingY;
        for (int i2 = 0; i2 < fullX; ++i2) {
            y2 = startY;
            for (int ii = 0; ii < fullY; ++ii) {
                batch.draw(region, x2, y2, regionWidth, regionHeight);
                y2 += regionHeight;
            }
            x2 += regionWidth;
        }
        Texture texture = region.getTexture();
        float u3 = region.getU();
        float v22 = region.getV2();
        if (remainingX > 0.0f) {
            u2 = u3 + remainingX / (float)texture.getWidth();
            v2 = region.getV();
            y2 = startY;
            for (int ii = 0; ii < fullY; ++ii) {
                batch.draw(texture, x2, y2, remainingX, regionHeight, u3, v22, u2, v2);
                y2 += regionHeight;
            }
            if (remainingY > 0.0f) {
                v2 = v22 - remainingY / (float)texture.getHeight();
                batch.draw(texture, x2, y2, remainingX, remainingY, u3, v22, u2, v2);
            }
        }
        if (remainingY > 0.0f) {
            u2 = region.getU2();
            v2 = v22 - remainingY / (float)texture.getHeight();
            x2 = startX;
            for (int i3 = 0; i3 < fullX; ++i3) {
                batch.draw(texture, x2, y2, regionWidth, remainingY, u3, v22, u2, v2);
                x2 += regionWidth;
            }
        }
        batch.setColor(batchColor);
    }

    @Override
    public void draw(Batch batch, float x2, float y2, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        throw new UnsupportedOperationException();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public TiledDrawable tint(Color tint) {
        TiledDrawable drawable = new TiledDrawable(this);
        drawable.color.set(tint);
        drawable.setLeftWidth(this.getLeftWidth());
        drawable.setRightWidth(this.getRightWidth());
        drawable.setTopHeight(this.getTopHeight());
        drawable.setBottomHeight(this.getBottomHeight());
        return drawable;
    }
}

