/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DataInput
extends DataInputStream {
    private char[] chars = new char[32];

    public DataInput(InputStream in) {
        super(in);
    }

    public int readInt(boolean optimizePositive) throws IOException {
        int b2 = this.read();
        int result = b2 & 0x7F;
        if ((b2 & 0x80) != 0) {
            b2 = this.read();
            result |= (b2 & 0x7F) << 7;
            if ((b2 & 0x80) != 0) {
                b2 = this.read();
                result |= (b2 & 0x7F) << 14;
                if ((b2 & 0x80) != 0) {
                    b2 = this.read();
                    result |= (b2 & 0x7F) << 21;
                    if ((b2 & 0x80) != 0) {
                        b2 = this.read();
                        result |= (b2 & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result : result >>> 1 ^ -(result & 1);
    }

    public String readString() throws IOException {
        int charCount = this.readInt(true);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        char[] chars = this.chars;
        int charIndex = 0;
        int b2 = 0;
        while (charIndex < charCount && (b2 = this.read()) <= 127) {
            chars[charIndex++] = (char)b2;
        }
        if (charIndex < charCount) {
            this.readUtf8_slow(charCount, charIndex, b2);
        }
        return new String(chars, 0, charCount);
    }

    private void readUtf8_slow(int charCount, int charIndex, int b2) throws IOException {
        char[] chars = this.chars;
        while (true) {
            switch (b2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b2;
                    break;
                }
                case 12: 
                case 13: {
                    chars[charIndex] = (char)((b2 & 0x1F) << 6 | this.read() & 0x3F);
                    break;
                }
                case 14: {
                    chars[charIndex] = (char)((b2 & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                }
            }
            if (++charIndex >= charCount) break;
            b2 = this.read() & 0xFF;
        }
    }
}

