/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;

public final class ScreenUtils {
    public static TextureRegion getFrameBufferTexture() {
        int w2 = Gdx.graphics.getBackBufferWidth();
        int h2 = Gdx.graphics.getBackBufferHeight();
        return ScreenUtils.getFrameBufferTexture(0, 0, w2, h2);
    }

    public static TextureRegion getFrameBufferTexture(int x2, int y2, int w2, int h2) {
        int potW = MathUtils.nextPowerOfTwo(w2);
        int potH = MathUtils.nextPowerOfTwo(h2);
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(x2, y2, w2, h2);
        Pixmap potPixmap = new Pixmap(potW, potH, Pixmap.Format.RGBA8888);
        potPixmap.drawPixmap(pixmap, 0, 0);
        Texture texture = new Texture(potPixmap);
        TextureRegion textureRegion = new TextureRegion(texture, 0, h2, w2, -h2);
        potPixmap.dispose();
        pixmap.dispose();
        return textureRegion;
    }

    public static Pixmap getFrameBufferPixmap(int x2, int y2, int w2, int h2) {
        Gdx.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(w2, h2, Pixmap.Format.RGBA8888);
        ByteBuffer pixels = pixmap.getPixels();
        Gdx.gl.glReadPixels(x2, y2, w2, h2, 6408, 5121, pixels);
        return pixmap;
    }

    public static byte[] getFrameBufferPixels(boolean flipY) {
        int w2 = Gdx.graphics.getBackBufferWidth();
        int h2 = Gdx.graphics.getBackBufferHeight();
        return ScreenUtils.getFrameBufferPixels(0, 0, w2, h2, flipY);
    }

    public static byte[] getFrameBufferPixels(int x2, int y2, int w2, int h2, boolean flipY) {
        Gdx.gl.glPixelStorei(3333, 1);
        ByteBuffer pixels = BufferUtils.newByteBuffer(w2 * h2 * 4);
        Gdx.gl.glReadPixels(x2, y2, w2, h2, 6408, 5121, pixels);
        int numBytes = w2 * h2 * 4;
        byte[] lines = new byte[numBytes];
        if (flipY) {
            int numBytesPerLine = w2 * 4;
            for (int i2 = 0; i2 < h2; ++i2) {
                pixels.position((h2 - i2 - 1) * numBytesPerLine);
                pixels.get(lines, i2 * numBytesPerLine, numBytesPerLine);
            }
        } else {
            pixels.clear();
            pixels.get(lines);
        }
        return lines;
    }
}

