/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.FuncMapping;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.FuncTime;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.PsyInfo;
import com.jcraft.jorbis.StaticCodeBook;

public class Info {
    private static final int OV_EBADPACKET = -136;
    private static final int OV_ENOTAUDIO = -135;
    private static byte[] _vorbis = "vorbis".getBytes();
    private static final int VI_TIMEB = 1;
    private static final int VI_FLOORB = 2;
    private static final int VI_RESB = 3;
    private static final int VI_MAPB = 1;
    private static final int VI_WINDOWB = 1;
    public int version;
    public int channels;
    public int rate;
    int bitrate_upper;
    int bitrate_nominal;
    int bitrate_lower;
    int[] blocksizes = new int[2];
    int modes;
    int maps;
    int times;
    int floors;
    int residues;
    int books;
    int psys;
    InfoMode[] mode_param = null;
    int[] map_type = null;
    Object[] map_param = null;
    int[] time_type = null;
    Object[] time_param = null;
    int[] floor_type = null;
    Object[] floor_param = null;
    int[] residue_type = null;
    Object[] residue_param = null;
    StaticCodeBook[] book_param = null;
    PsyInfo[] psy_param = new PsyInfo[64];
    int envelopesa;
    float preecho_thresh;
    float preecho_clamp;

    public void init() {
        this.rate = 0;
    }

    public void clear() {
        int n2 = 0;
        while (n2 < this.modes) {
            this.mode_param[n2] = null;
            ++n2;
        }
        this.mode_param = null;
        int n3 = 0;
        while (n3 < this.maps) {
            FuncMapping.mapping_P[this.map_type[n3]].free_info(this.map_param[n3]);
            ++n3;
        }
        this.map_param = null;
        int n4 = 0;
        while (n4 < this.times) {
            FuncTime.time_P[this.time_type[n4]].free_info(this.time_param[n4]);
            ++n4;
        }
        this.time_param = null;
        int n5 = 0;
        while (n5 < this.floors) {
            FuncFloor.floor_P[this.floor_type[n5]].free_info(this.floor_param[n5]);
            ++n5;
        }
        this.floor_param = null;
        int n6 = 0;
        while (n6 < this.residues) {
            FuncResidue.residue_P[this.residue_type[n6]].free_info(this.residue_param[n6]);
            ++n6;
        }
        this.residue_param = null;
        int n7 = 0;
        while (n7 < this.books) {
            if (this.book_param[n7] != null) {
                this.book_param[n7].clear();
                this.book_param[n7] = null;
            }
            ++n7;
        }
        this.book_param = null;
        int n8 = 0;
        while (n8 < this.psys) {
            this.psy_param[n8].free();
            ++n8;
        }
    }

    int unpack_info(Buffer buffer) {
        this.version = buffer.read(32);
        if (this.version != 0) {
            return -1;
        }
        this.channels = buffer.read(8);
        this.rate = buffer.read(32);
        this.bitrate_upper = buffer.read(32);
        this.bitrate_nominal = buffer.read(32);
        this.bitrate_lower = buffer.read(32);
        this.blocksizes[0] = 1 << buffer.read(4);
        this.blocksizes[1] = 1 << buffer.read(4);
        if (this.rate < 1 || this.channels < 1 || this.blocksizes[0] < 8 || this.blocksizes[1] < this.blocksizes[0] || buffer.read(1) != 1) {
            this.clear();
            return -1;
        }
        return 0;
    }

    int unpack_books(Buffer buffer) {
        this.books = buffer.read(8) + 1;
        if (this.book_param == null || this.book_param.length != this.books) {
            this.book_param = new StaticCodeBook[this.books];
        }
        int n2 = 0;
        while (n2 < this.books) {
            this.book_param[n2] = new StaticCodeBook();
            if (this.book_param[n2].unpack(buffer) != 0) {
                this.clear();
                return -1;
            }
            ++n2;
        }
        this.times = buffer.read(6) + 1;
        if (this.time_type == null || this.time_type.length != this.times) {
            this.time_type = new int[this.times];
        }
        if (this.time_param == null || this.time_param.length != this.times) {
            this.time_param = new Object[this.times];
        }
        int n3 = 0;
        while (n3 < this.times) {
            this.time_type[n3] = buffer.read(16);
            if (this.time_type[n3] < 0 || this.time_type[n3] >= 1) {
                this.clear();
                return -1;
            }
            this.time_param[n3] = FuncTime.time_P[this.time_type[n3]].unpack(this, buffer);
            if (this.time_param[n3] == null) {
                this.clear();
                return -1;
            }
            ++n3;
        }
        this.floors = buffer.read(6) + 1;
        if (this.floor_type == null || this.floor_type.length != this.floors) {
            this.floor_type = new int[this.floors];
        }
        if (this.floor_param == null || this.floor_param.length != this.floors) {
            this.floor_param = new Object[this.floors];
        }
        int n4 = 0;
        while (n4 < this.floors) {
            this.floor_type[n4] = buffer.read(16);
            if (this.floor_type[n4] < 0 || this.floor_type[n4] >= 2) {
                this.clear();
                return -1;
            }
            this.floor_param[n4] = FuncFloor.floor_P[this.floor_type[n4]].unpack(this, buffer);
            if (this.floor_param[n4] == null) {
                this.clear();
                return -1;
            }
            ++n4;
        }
        this.residues = buffer.read(6) + 1;
        if (this.residue_type == null || this.residue_type.length != this.residues) {
            this.residue_type = new int[this.residues];
        }
        if (this.residue_param == null || this.residue_param.length != this.residues) {
            this.residue_param = new Object[this.residues];
        }
        int n5 = 0;
        while (n5 < this.residues) {
            this.residue_type[n5] = buffer.read(16);
            if (this.residue_type[n5] < 0 || this.residue_type[n5] >= 3) {
                this.clear();
                return -1;
            }
            this.residue_param[n5] = FuncResidue.residue_P[this.residue_type[n5]].unpack(this, buffer);
            if (this.residue_param[n5] == null) {
                this.clear();
                return -1;
            }
            ++n5;
        }
        this.maps = buffer.read(6) + 1;
        if (this.map_type == null || this.map_type.length != this.maps) {
            this.map_type = new int[this.maps];
        }
        if (this.map_param == null || this.map_param.length != this.maps) {
            this.map_param = new Object[this.maps];
        }
        int n6 = 0;
        while (n6 < this.maps) {
            this.map_type[n6] = buffer.read(16);
            if (this.map_type[n6] < 0 || this.map_type[n6] >= 1) {
                this.clear();
                return -1;
            }
            this.map_param[n6] = FuncMapping.mapping_P[this.map_type[n6]].unpack(this, buffer);
            if (this.map_param[n6] == null) {
                this.clear();
                return -1;
            }
            ++n6;
        }
        this.modes = buffer.read(6) + 1;
        if (this.mode_param == null || this.mode_param.length != this.modes) {
            this.mode_param = new InfoMode[this.modes];
        }
        int n7 = 0;
        while (n7 < this.modes) {
            this.mode_param[n7] = new InfoMode();
            this.mode_param[n7].blockflag = buffer.read(1);
            this.mode_param[n7].windowtype = buffer.read(16);
            this.mode_param[n7].transformtype = buffer.read(16);
            this.mode_param[n7].mapping = buffer.read(8);
            if (this.mode_param[n7].windowtype >= 1 || this.mode_param[n7].transformtype >= 1 || this.mode_param[n7].mapping >= this.maps) {
                this.clear();
                return -1;
            }
            ++n7;
        }
        if (buffer.read(1) != 1) {
            this.clear();
            return -1;
        }
        return 0;
    }

    public int synthesis_headerin(Comment comment, Packet packet) {
        Buffer buffer = new Buffer();
        if (packet != null) {
            buffer.readinit(packet.packet_base, packet.packet, packet.bytes);
            byte[] byArray = new byte[6];
            int n2 = buffer.read(8);
            buffer.read(byArray, 6);
            if (byArray[0] != 118 || byArray[1] != 111 || byArray[2] != 114 || byArray[3] != 98 || byArray[4] != 105 || byArray[5] != 115) {
                return -1;
            }
            switch (n2) {
                case 1: {
                    if (packet.b_o_s == 0) {
                        return -1;
                    }
                    if (this.rate != 0) {
                        return -1;
                    }
                    return this.unpack_info(buffer);
                }
                case 3: {
                    if (this.rate == 0) {
                        return -1;
                    }
                    return comment.unpack(buffer);
                }
                case 5: {
                    if (this.rate == 0 || comment.vendor == null) {
                        return -1;
                    }
                    return this.unpack_books(buffer);
                }
            }
        }
        return -1;
    }

    int pack_info(Buffer buffer) {
        buffer.write(1, 8);
        buffer.write(_vorbis);
        buffer.write(0, 32);
        buffer.write(this.channels, 8);
        buffer.write(this.rate, 32);
        buffer.write(this.bitrate_upper, 32);
        buffer.write(this.bitrate_nominal, 32);
        buffer.write(this.bitrate_lower, 32);
        buffer.write(Info.ilog2(this.blocksizes[0]), 4);
        buffer.write(Info.ilog2(this.blocksizes[1]), 4);
        buffer.write(1, 1);
        return 0;
    }

    int pack_books(Buffer buffer) {
        buffer.write(5, 8);
        buffer.write(_vorbis);
        buffer.write(this.books - 1, 8);
        int n2 = 0;
        while (n2 < this.books) {
            if (this.book_param[n2].pack(buffer) != 0) {
                return -1;
            }
            ++n2;
        }
        buffer.write(this.times - 1, 6);
        int n3 = 0;
        while (n3 < this.times) {
            buffer.write(this.time_type[n3], 16);
            FuncTime.time_P[this.time_type[n3]].pack(this.time_param[n3], buffer);
            ++n3;
        }
        buffer.write(this.floors - 1, 6);
        int n4 = 0;
        while (n4 < this.floors) {
            buffer.write(this.floor_type[n4], 16);
            FuncFloor.floor_P[this.floor_type[n4]].pack(this.floor_param[n4], buffer);
            ++n4;
        }
        buffer.write(this.residues - 1, 6);
        int n5 = 0;
        while (n5 < this.residues) {
            buffer.write(this.residue_type[n5], 16);
            FuncResidue.residue_P[this.residue_type[n5]].pack(this.residue_param[n5], buffer);
            ++n5;
        }
        buffer.write(this.maps - 1, 6);
        int n6 = 0;
        while (n6 < this.maps) {
            buffer.write(this.map_type[n6], 16);
            FuncMapping.mapping_P[this.map_type[n6]].pack(this, this.map_param[n6], buffer);
            ++n6;
        }
        buffer.write(this.modes - 1, 6);
        int n7 = 0;
        while (n7 < this.modes) {
            buffer.write(this.mode_param[n7].blockflag, 1);
            buffer.write(this.mode_param[n7].windowtype, 16);
            buffer.write(this.mode_param[n7].transformtype, 16);
            buffer.write(this.mode_param[n7].mapping, 8);
            ++n7;
        }
        buffer.write(1, 1);
        return 0;
    }

    public int blocksize(Packet packet) {
        Buffer buffer = new Buffer();
        buffer.readinit(packet.packet_base, packet.packet, packet.bytes);
        if (buffer.read(1) != 0) {
            return -135;
        }
        int n2 = 0;
        int n3 = this.modes;
        while (n3 > 1) {
            ++n2;
            n3 >>>= 1;
        }
        int n4 = buffer.read(n2);
        if (n4 == -1) {
            return -136;
        }
        return this.blocksizes[this.mode_param[n4].blockflag];
    }

    private static int ilog2(int n2) {
        int n3 = 0;
        while (n2 > 1) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }

    public String toString() {
        return "version:" + new Integer(this.version) + ", channels:" + new Integer(this.channels) + ", rate:" + new Integer(this.rate) + ", bitrate:" + new Integer(this.bitrate_upper) + "," + new Integer(this.bitrate_nominal) + "," + new Integer(this.bitrate_lower);
    }
}

