/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

public class OutputBuffer {
    public static final int BUFFERSIZE = 2304;
    private static final int MAXCHANNELS = 2;
    private Float replayGainScale;
    private int channels;
    private byte[] buffer;
    private int[] channelPointer;
    private boolean isBigEndian;

    public OutputBuffer(int n2, boolean bl2) {
        this.channels = n2;
        this.isBigEndian = bl2;
        this.buffer = new byte[2304 * n2];
        this.channelPointer = new int[n2];
        this.reset();
    }

    private void append(int n2, short s2) {
        byte by2;
        byte by3;
        if (this.isBigEndian) {
            by3 = (byte)(s2 >>> 8 & 0xFF);
            by2 = (byte)(s2 & 0xFF);
        } else {
            by3 = (byte)(s2 & 0xFF);
            by2 = (byte)(s2 >>> 8 & 0xFF);
        }
        this.buffer[this.channelPointer[n2]] = by3;
        this.buffer[this.channelPointer[n2] + 1] = by2;
        int n3 = n2;
        this.channelPointer[n3] = this.channelPointer[n3] + this.channels * 2;
    }

    public void appendSamples(int n2, float[] fArray) {
        if (this.replayGainScale != null) {
            int n3 = 0;
            while (n3 < 32) {
                short s2 = this.clip(fArray[n3++] * this.replayGainScale.floatValue());
                this.append(n2, s2);
            }
        } else {
            int n4 = 0;
            while (n4 < 32) {
                short s3 = this.clip(fArray[n4++]);
                this.append(n2, s3);
            }
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reset() {
        int n2;
        try {
            int n3 = this.channels - 1;
            n2 = this.channelPointer[n3] - n3 * 2;
        }
        catch (Throwable throwable) {
            for (int i2 = 0; i2 < this.channels; ++i2) {
                this.channelPointer[i2] = i2 * 2;
            }
            throw throwable;
        }
        for (int i3 = 0; i3 < this.channels; ++i3) {
            this.channelPointer[i3] = i3 * 2;
        }
        return n2;
    }

    public void setReplayGainScale(Float f2) {
        this.replayGainScale = f2;
    }

    public boolean isStereo() {
        return this.channelPointer[1] == 2;
    }

    private final short clip(float f2) {
        return (short)(f2 > 32767.0f ? Short.MAX_VALUE : (short)(f2 < -32768.0f ? Short.MIN_VALUE : (short)f2));
    }
}

