/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import java.util.ArrayList;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAfters
extends Statement {
    private final Statement fNext;
    private final Object fTarget;
    private final List<FrameworkMethod> fAfters;

    public RunAfters(Statement next, List<FrameworkMethod> afters, Object target) {
        this.fNext = next;
        this.fAfters = afters;
        this.fTarget = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate() throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.fNext.evaluate();
        }
        catch (Throwable e2) {
            errors.add(e2);
        }
        finally {
            for (FrameworkMethod each : this.fAfters) {
                try {
                    each.invokeExplosively(this.fTarget, new Object[0]);
                }
                catch (Throwable e3) {
                    errors.add(e3);
                }
            }
        }
        MultipleFailureException.assertEmpty(errors);
    }
}

