/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.util.ArrayList;
import java.util.List;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestWatcher
implements TestRule {
    @Override
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                TestWatcher.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    TestWatcher.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e2) {
                    errors.add(e2);
                    TestWatcher.this.skippedQuietly(e2, description, errors);
                }
                catch (Throwable t2) {
                    errors.add(t2);
                    TestWatcher.this.failedQuietly(t2, description, errors);
                }
                finally {
                    TestWatcher.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t2) {
            errors.add(t2);
        }
    }

    private void failedQuietly(Throwable t2, Description description, List<Throwable> errors) {
        try {
            this.failed(t2, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e2, Description description, List<Throwable> errors) {
        try {
            this.skipped(e2, description);
        }
        catch (Throwable t2) {
            errors.add(t2);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t2) {
            errors.add(t2);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t2) {
            errors.add(t2);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e2, Description description) {
    }

    protected void skipped(AssumptionViolatedException e2, Description description) {
    }

    protected void starting(Description description) {
    }

    protected void finished(Description description) {
    }
}

