local default_dist_cost = 32
local max_sanity_cost = 15
local min_hunger_cost = 5
local sanity_cost_ratio = 20/75
local find_dist = (max_sanity_cost / sanity_cost_ratio - min_hunger_cost) * default_dist_cost

local ownershiptag = "uid_private"
local traveltag = "FastTravelling"
local FTSignTag = "fast_travel"

local FastTravel = Class(function(self, inst)
    self.inst = inst
	self.destinations = {}
	self.site = nil
	self.totalsites = 0
	self.currentplayer = nil
	self.traveltask = nil
	self.dist_cost = default_dist_cost
	self.inst:AddTag(FTSignTag)
	self.ownership = false
end)

local function IsNearDanger(inst)
   
    
    local burnable = inst.components.burnable
    if burnable ~= nil and (burnable:IsBurning() or burnable:IsSmoldering()) then
        return true
    end
    if inst:HasTag("spiderwhisperer") then
        return FindEntity(inst, 10,
                function(target)
                    return (target.components.combat ~= nil and target.components.combat.target == inst)
                        or (not (target:HasTag("player") or target:HasTag("spider"))
                            and (target:HasTag("monster") or target:HasTag("pig")))
                end,
                nil, nil, { "monster", "pig", "_combat" }) ~= nil
    end
    return FindEntity(inst, 10,
            function(target)
                return (target.components.combat ~= nil and target.components.combat.target == inst)
                    or (target:HasTag("monster") and not target:HasTag("player"))
            end,
            nil, nil, { "monster", "_combat" }) ~= nil
end

function FastTravel:ListDestination(traveller)
	local x, y, z = self.inst.Transform:GetWorldPosition()
	local dests = TheSim:FindEntities(x, y, z, find_dist, FTSignTag)
	local dest = {}
	
	for k,v in pairs(dests) do
		if v ~= self.inst and v.components.fasttravel and not (v.components.fasttravel.ownership and v:HasTag(ownershiptag) and traveller.userid ~= nil and not v:HasTag('uid_'..traveller.userid)) then
			table.insert(dest, v)
		end
	end
	
	self.destinations = dest
	self.site = self.site or #dest
	self.totalsites = #dest
end

function FastTravel:SelectDestination(traveller)
	if traveller == nil then return	end
	self:ListDestination(traveller)
	local comment = self.inst.components.talker
	local talk = traveller.components.talker
	
	if self.ownership and self.inst:HasTag(ownershiptag) and traveller.userid ~= nil and not self.inst:HasTag('uid_'..traveller.userid) then
		if comment then comment:Say("˽˲Ʋ.")
		elseif talk then talk:Say("ƪ˽˲Ʋ") end
		return
	elseif self.totalsites < 1 then
		if comment then comment:Say("ûпõĿĵء")
		elseif talk then talk:Say("ûеطȥ") end
		return
	end
	
	-- Restart travel tasks
	traveller:RemoveTag(traveltag)
	if traveller.untraveltask ~= nil then
		traveller.untraveltask:Cancel()
		traveller.untraveltask = nil
	end
	if self.traveltask ~= nil then
		self.traveltask:Cancel()
		self.traveltask = nil
	end
	if self.traveltask1 ~= nil then
		self.traveltask1:Cancel()
		self.traveltask1 = nil
	end
	if self.traveltask2 ~= nil then
		self.traveltask2:Cancel()
		self.traveltask2 = nil
	end
	if self.traveltask3 ~= nil then
		self.traveltask3:Cancel()
		self.traveltask3 = nil
	end
	if self.traveltask4 ~= nil then
		self.traveltask4:Cancel()
		self.traveltask4 = nil
	end
	if self.traveltask5 ~= nil then
		self.traveltask5:Cancel()
		self.traveltask5 = nil
	end
	
	-- Select next site
	if self.currentplayer ~= nil and self.currentplayer == traveller then
		self.site = self.site + 1
		if self.site > self.totalsites then self.site = 1 end
	end
	self.currentplayer = traveller
	local destination = self.destinations[self.site]
	if destination == nil then return end
	
	-- If next site is self, try next next site
	if destination == self.inst then
		self.site = self.site + 1
		if self.site > self.totalsites then self.site = 1 end
		destination = self.destinations[self.site]
		if destination == self.inst then
			return
		end
	end
	
	-- Site information
	local desc = destination and destination.components.signdata and destination.components.signdata.data.str
	local description = desc and string.format('"%s"', desc) or "δ֪Ŀĵ"
	local information = ""
	local cost_hunger = min_hunger_cost
	local cost_sanity = 0
	local xi,yi,zi = self.inst.Transform:GetWorldPosition()
	local xf,yf,zf = destination.Transform:GetWorldPosition()
	local dist = math.sqrt((xi-xf)^2 + (zi-zf)^2)
	
	if destination and destination.components.fasttravel then
		traveller:AddTag(traveltag)
		traveller.untraveltask = traveller:DoTaskInTime(15, function() traveller:RemoveTag(traveltag) end)
		cost_hunger = cost_hunger + math.ceil(dist / self.dist_cost)
		cost_sanity = cost_hunger * sanity_cost_ratio
		
		
		information = "ȥ: "..description.." ("..string.format("%.0f", self.site).."/"..string.format("%.0f", self.totalsites)..")".."\n".."ģ"..string.format("%.0f", cost_hunger).."\n".."ֵ: "..string.format("%.1f", cost_sanity)
		if comment then
			comment:Say(string.format(information),3)
		elseif talk then
			talk:Say(string.format(information),3)
		end
		
		self.traveltask = self.inst:DoTaskInTime(8, function()
			local travellers = TheSim:FindEntities(xi, yi, zi, 5, {traveltag,"player"},{"playerghost"})
			
			for k, who in pairs(travellers) do
				who.beingfollowed = false
				if who.components.leader and who.components.leader.followers then
					for k1,v1 in pairs(who.components.leader.followers) do
						if k1.prefab and (k1.prefab ~= 'spore_small' or k1.prefab ~= 'spore_medium' or k1.prefab ~= 'spore_tall') then
							who.beingfollowed = true
						end
					end
				end
					
				if destination == nil or not destination:IsValid() then
					if comment then comment:Say("Ŀĵزǿɵ.")
					elseif talk then talk:Say("Ŀĵزǿɵ.") end
				elseif who == nil or (who.components.health and who.components.health:IsDead()) then
					if comment then comment:Say("ûдĲк.") end
				elseif IsNearDanger(who) then
					if talk then talk:Say("вȫ.")
					elseif comment then comment:Say("вȫ.") end
				--elseif who.beingfollowed then
					--if talk then talk:Say("û׷.")
					--elseif comment then comment:Say("û׷.") end
				elseif destination.components.fasttravel.ownership and destination:HasTag(ownershiptag) and who.userid ~= nil and not destination:HasTag('uid_'..who.userid) then
					if comment then comment:Say("˽Ŀġûο.")
					elseif talk then talk:Say("Ŀĵ˽˵.") end
				elseif who.components.hunger and who.components.hunger.current >= cost_hunger and who.components.sanity and who.components.sanity.current >= cost_sanity then
					who.components.hunger:DoDelta(-cost_hunger)
					who.components.sanity:DoDelta(-cost_sanity)
					if who.Physics ~= nil then
						who.Physics:Teleport(xf, 0, zf)
					else
						who.Transform:SetPosition(xf, 0, zf)
					end
					traveller:RemoveTag(traveltag)
					if traveller.untraveltask ~= nil then
						traveller.untraveltask:Cancel()
						traveller.untraveltask = nil
					end
				else
					if talk then talk:Say("Ҳ.")
					elseif comment then comment:Say("㲻.") end
				end
			end
		end)
		
		self.traveltask5 = self.inst:DoTaskInTime(3, function() comment:Say("5뿪ʼͣ")
		end)
		self.traveltask4 = self.inst:DoTaskInTime(4, function() comment:Say("㣬4룡")
		self.inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_down") end)
		self.traveltask3 = self.inst:DoTaskInTime(5, function() comment:Say("3룡") 
		self.inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_down") end)
		self.traveltask2 = self.inst:DoTaskInTime(6, function() comment:Say("2룡")
		self.inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_down") end)
		self.traveltask1 = self.inst:DoTaskInTime(7, function() comment:Say("1룡!",1)
		self.inst.SoundEmitter:PlaySound("dontstarve/HUD/craft_down") end)
			
	elseif comment then
		comment:Say("Ŀĵңɼ.")
	elseif talk then
		talk:Say("Ŀĵңɼ.")
	end
end

return FastTravel