require "class"

local Deployable = Class(function(self, inst)
    self.inst = inst
    self.min_spacing = 2
    
    local notags = {'NOBLOCK', 'player', 'FX'}
local function default_test(inst, pt)
	local tiletype = GetGroundTypeAtPosition(pt)
	local ground_OK = tiletype ~= GROUND.IMPASSABLE
	if ground_OK then
		local MouseCharacter = TheInput:GetWorldEntityUnderMouse()
		if MouseCharacter and not MouseCharacter:HasTag("player") then
			return false
		end
	    local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 4, nil, notags) -- or we could include a flag to the search?
		local min_spacing = inst.components.deployable.min_spacing or 2

	    for k, v in pairs(ents) do
			if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() and not v.components.placer and v.parent == nil then
				if distsq( Vector3(v.Transform:GetWorldPosition()), pt) < min_spacing*min_spacing then
					return false
				end
			end
		end
		return true
	end
	return false
end
    
    local CTRL = false
    local function ShouldRound(self, deployer, player)
		local continue = false
			if self.placer == nil or (self.placer ~= "gridplacer"
							and self.placer:sub(1,5) ~= "wall_"
							and self.placer:sub(1,5) ~= "mech_")
			then
				continue = true
			end
		if continue then
			return CTRL == TheInput:IsKeyDown(KEY_CTRL) and (player == nil or deployer == player)
		else	
			return false
		end
	end
	
	local OldCanDeploy = self.CanDeploy
		OldCanDeploy = function(self, ...)
			if self.test then
				return self.test(self.inst, ...)
			else
				return default_test(self.inst, ...)
			end
		end
	local function NewCanDeploy(self, pt, mouseover, ...)
		local player = GetPlayer()
		if ShouldRound(self, player, player) then
			pt = Vector3( pt.x+.25-(pt.x+.25)%.5, 0, pt.z+.25-(pt.z+.25)%.5)
		end
		return OldCanDeploy(self, pt, nil, ...) --removing mouseover should help some DST things
	end
	self.CanDeploy = NewCanDeploy
	
	local OldDeploy = self.Deploy
	local function NewDeploy(self, pt, deployer, ...)
		local player = GetPlayer()
		if ShouldRound(self, deployer, player) then
			pt = Vector3( pt.x+.25-(pt.x+.25)%.5, 0, pt.z+.25-(pt.z+.25)%.5)
		end
		return OldDeploy(self, pt, deployer, ...)
	end
	self.Deploy = NewDeploy
    
end)



local notags = {'NOBLOCK', 'player', 'FX'}
local function default_test(inst, pt)
	local tiletype = GetGroundTypeAtPosition(pt)
	local ground_OK = tiletype ~= GROUND.IMPASSABLE
	if ground_OK then
		local MouseCharacter = TheInput:GetWorldEntityUnderMouse()
		if MouseCharacter and not MouseCharacter:HasTag("player") then
			return false
		end
	    local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 4, nil, notags) -- or we could include a flag to the search?
		local min_spacing = inst.components.deployable.min_spacing or 2

	    for k, v in pairs(ents) do
			if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() and not v.components.placer and v.parent == nil then
				if distsq( Vector3(v.Transform:GetWorldPosition()), pt) < min_spacing*min_spacing then
					return false
				end
			end
		end
		return true
	end
	return false
end

function Deployable:CanDeploy(pt)
    return self.test and self.test(self.inst, pt) or default_test(self.inst, pt)
end

function Deployable:Deploy(pt, deployer)
    if not self.test or self.test(self.inst, pt, deployer) then
		if self.ondeploy then
	        self.ondeploy(self.inst, pt, deployer)
		end
		return true
	end
end

function Deployable:CollectPointActions(doer, pos, actions, right)
    if right and self:CanDeploy(pos) then
        table.insert(actions, ACTIONS.DEPLOY)
    end
end

function Deployable:CollectInventoryActions(doer, actions, right)
    local player = GetPlayer()

    if player and self.inst.components.inventoryitem and self.inst.components.inventoryitem:GetGrandOwner() == player then
        local playercontroller = player.components.playercontroller
        if playercontroller then
            if not playercontroller.deploy_mode then
                table.insert(actions, ACTIONS.TOGGLE_DEPLOY_MODE)
            end
        end
    end
end

return Deployable

