local Placer = Class(function(self, inst)
    self.inst = inst
	self.can_build = false
	self.radius = 1
	self.selected_pos = nil
	self.inst:AddTag("NOCLICK")
	
	self.buildgrid = nil
	self.lastpt = nil
	self.baseinst = self.inst

local CTRL = false
local BUILDGRID = true
local SMALLGRIDSIZE = 10  --网格数量[2, 6, 10]数量改小可解决卡顿
local MEDGRIDSIZE = 6  --同上
local BIGGRIDSIZE = 6  --同上
local h = 1
local l = 1/8
local badcolor = Vector3(h, l, l)
local goodcolor = Vector3(l, h, l)
local HIDEPLACER = false  --隐藏物品摆放贴图[true, false]改为true可以减少卡顿
local HIDECURSOR = false  --隐藏物品摆放倒影[true, false]改为true可以减少卡顿

	local function SetCursorVisibility(show)
		if TheFrontEnd and TheFrontEnd.screenstack
			and TheFrontEnd.screenstack[1]
			and TheFrontEnd.screenstack[1].controls
			and TheFrontEnd.screenstack[1].controls.mousefollow
			and TheFrontEnd.screenstack[1].controls.mousefollow.children
			then
			local cursor_object = nil
			for k,v in pairs(TheFrontEnd.screenstack[1].controls.mousefollow.children) do
				if v then cursor_object = v end
			end
			if cursor_object then
				if show then
					if cursor_object.image then cursor_object.image:Show() end
					if cursor_object.quantity then cursor_object.quantity:Show() end
					if cursor_object.percent then cursor_object.percent:Show() end
				else
					if cursor_object.image then cursor_object.image:Hide() end
					if cursor_object.quantity then cursor_object.quantity:Hide() end
					if cursor_object.percent then cursor_object.percent:Hide() end
				end
			end
		end
	end
	
	local function MakeGridInst()	
		self.gridinst = SpawnPrefab("buildgridplacer")	
		self.gridinst.AnimState:SetBank("buildgridplacer")
		self.gridinst.AnimState:SetBuild("buildgridplacer")
		self.gridinst.AnimState:PlayAnimation("anim", true)
		self.gridinst.AnimState:SetOrientation(ANIM_ORIENTATION.Default)
		self.gridinst.Transform:SetScale(1.7,1.7,1.7)
	end
	
	local function testpoint(pt)
		local canbuild = self.testfn == nil or self.testfn(pt)--:Get())
		return canbuild, canbuild and goodcolor or badcolor
	end
		
	local function RefreshBuildGrid()
		for x,r in pairs(self.buildgrid) do
			for z,bgp in pairs(r) do
				local bgpt = Vector3(x, 0, z)
				local can_build, color = testpoint(bgpt)
				bgp.AnimState:SetAddColour(color.x, color.y, color.z, 0)
			end
		end
	end
	
	local function RemoveBuildGrid()
		if self.buildgrid then for x,r in pairs(self.buildgrid) do
			for z,e in pairs(r) do
				e:Remove()
			end
		end end
		self.buildgrid = nil
	end
	
	local OldOnUpdate = self.OnUpdate
	local function NewOnUpdate(self, dt)
		--#rezecib Need these here to let the rest of the code match Placer:OnUpdate for easy syncing
		local TheWorld = GetWorld()
		--#rezecib Restores the default game behavior by holding ctrl
		if CTRL ~= TheInput:IsKeyDown(KEY_CTRL) then
			RemoveBuildGrid()
			if self.gridinst then
				self.gridinst.AnimState:SetAddColour(0,0,0,0)
				self.gridinst.AnimState:SetMultColour(0,0,0,0)
			end
			self.baseinst.AnimState:SetMultColour(1,1,1,1)
			self.inst = self.baseinst
			SetCursorVisibility(true)
			return OldOnUpdate(self, dt)
		end
		local pt = nil --#rezecib Added to keep the pt location for the build grid
		local ThePlayer = GetPlayer()
		if ThePlayer == nil then
			return
		elseif not TheInput:ControllerAttached() then
			-- Mouse input
			pt = self.selected_pos or TheInput:GetWorldPosition() --#rezecib Removed local
			if self.snap_to_tile then
				pt = Vector3(TheWorld.Map:GetTileCenterPoint(pt:Get()))
			elseif self.snap_to_meters then
				pt = Vector3(math.floor(pt.x)+.5, 0, math.floor(pt.z)+.5)
			elseif self.snap_to_flood then 
				-- Flooding tiles exist at odd-numbered integer coordinates
				local center = Vector3(TheWorld.Flooding:GetTileCenterPoint(pt:Get()))
				pt.x = center.x
				pt.y = center.y
				pt.z = center.z
			else --#rezecib Added this block, everything else should match Placer:OnUpdate
				pt = Vector3( pt.x+.25-(pt.x+.25)%.5, 0, pt.z+.25-(pt.z+.25)%.5)
			end
			
		else -- Controller input
			local offset = 1
			if self.recipe then 
				if self.recipe.distance then 
					offset = self.recipe.distance - 1
					offset = math.max(offset, 1)
				end 
			elseif self.invobject then 
				if self.invobject.components.deployable then 
					offset = self.invobject.components.deployable.deploydistance or offset
				end 
			end
			
			if self.snap_to_tile then
				--Using an offset in this causes a bug in the terraformer functionality while using a controller.
				pt = Vector3(ThePlayer.entity:LocalToWorldSpace(0,0,0)) --#rezecib Removed local
				pt = Vector3(TheWorld.Map:GetTileCenterPoint(pt:Get()))
			elseif self.snap_to_meters then
				pt = Vector3(ThePlayer.entity:LocalToWorldSpace(offset,0,0)) --#rezecib Removed local
				pt = Vector3(math.floor(pt.x)+.5, 0, math.floor(pt.z)+.5)
			elseif self.snap_to_flood then 
				pt = Vector3(ThePlayer.entity:LocalToWorldSpace(offset,0,0))
				local center = Vector3(TheWorld.Flooding:GetTileCenterPoint(pt:Get()))
				pt.x = center.x
				pt.y = center.y
				pt.z = center.z
			else
				pt = ThePlayer:GetPosition()
				pt = Vector3( pt.x+offset+.25-(pt.x+.25)%.5, 0, pt.z+.25-(pt.z+.25)%.5)
			end
		end
		self.inst.Transform:SetPosition(pt:Get())	
		
		if self.fixedcameraoffset ~= nil then
			self.inst.Transform:SetRotation(self.fixedcameraoffset - TheCamera:GetHeading()) -- rotate against the camera
		end
		
		local color = nil
		self.can_build, color = testpoint(self.inst:GetPosition())

		self.inst.AnimState:SetAddColour(color.x*2, color.y*2, color.z*2, 0)
		if HIDEPLACER and not self.snap_to_tile then
			if self.gridinst == nil then MakeGridInst() end
			self.gridinst.AnimState:SetAddColour(1,1,1,0)
			self.gridinst.AnimState:SetMultColour(1,1,1,1)
			self.baseinst.AnimState:SetAddColour(0,0,0,0)
			self.baseinst.AnimState:SetMultColour(0,0,0,0)
			self.inst = self.gridinst
		end
		if HIDECURSOR then
			SetCursorVisibility(false)
		end
		
		--#rezecib added everything below for build grid
		local function BuildGridPoint(x, z, bgp)
			-- print((bgp and "moved to" or "added"), x, z)
			if not bgp then bgp = SpawnPrefab(self.placertype) end
			if not self.buildgrid[x] then self.buildgrid[x] = {} end
			self.buildgrid[x][z] = bgp
			local bgpt = Vector3(x, 0, z)
			bgp.Transform:SetPosition(bgpt:Get())
			local can_build, color = testpoint(bgpt)
			bgp.AnimState:SetAddColour(color.x, color.y, color.z, 0)
			if(self.placertype == "gridplacer") then
				bgp.AnimState:SetMultColour(.05, .05, .05, 0.05)
			end
		end
		
		local function RemoveBlock(lx, hx, ix, lz, hz, iz, removelist)
			if self.buildgrid == nil then return end
			if ix == 0 then ix = 1 end
			if iz == 0 then iz = 1 end
			for x = lx, hx, ix do
				for z = lz, hz, iz do
					local row = self.buildgrid[x]
					if row == nil then
						print("missing row:", x, z)
						--#rezecib this is to prevent crashes if it gets here
						RemoveBuildGrid()
						return
					end
					table.insert(removelist, row[z])
					self.buildgrid[x][z] = nil
				end
			end
		end
		
		local function AddBlock(lx, hx, ix, lz, hz, iz, removelist, i)
			for x = lx, hx, ix do
				for z = lz, hz, iz do
					BuildGridPoint(x, z, removelist[i])
					i = i + 1
				end
			end
			return i
		end
		
		local lastpt = self.lastpt
		self.lastpt = pt
		local hadgrid = self.buildgrid ~= nil
		if not hadgrid then self.buildgrid = {} end
		self.placertype = self.inst.prefab == "gridplacer" and "gridplacer" or "buildgridplacer"
		if self.placertype == "gridplacer" then
			self.inst.AnimState:SetAddColour(1,1,1,0)
		end
		if (not BUILDGRID) or 
			(hadgrid and lastpt and pt and lastpt.x == pt.x and lastpt.z == pt.z) then return end
		if pt and pt.x and pt.z then
			local d = 0.5
			local GRIDSIZE = SMALLGRIDSIZE
			if self.snap_to_meters then
				d = 1
				GRIDSIZE = MEDGRIDSIZE
			end
			if self.snap_to_flood then
				d = 2
				-- this shows the derivation, we're taking the average "size" of each of these,
				-- then scaling it to the new spacing, and rounding
				-- GRIDSIZE = math.floor((MEDGRIDSIZE*1 + BIGGRIDSIZE*4)/(2*2) + 0.5)
				GRIDSIZE = math.floor(MEDGRIDSIZE/4 + BIGGRIDSIZE + 0.5)
			end
			if self.snap_to_tile then
				d = 4
				GRIDSIZE = BIGGRIDSIZE
			end
			if hadgrid then
				local dx = (pt.x - lastpt.x)
				local sx = dx == 0 and 1 or dx/math.abs(dx)
				local dz = (pt.z - lastpt.z)
				local sz = dz == 0 and 1 or dz/math.abs(dz)
				local removelist = {}
				if math.abs(dx) > d*GRIDSIZE*2 or math.abs(dz) > d*GRIDSIZE*2 then
					--the old and new grids have no overlap, move all the points
					for x = lastpt.x - GRIDSIZE*d, lastpt.x + GRIDSIZE*d, d do
						for z = lastpt.z - GRIDSIZE*d, lastpt.z + GRIDSIZE*d, d do
							BuildGridPoint(x+dx, z+dz, self.buildgrid[x][z])
							self.buildgrid[x][z] = nil
						end
					end
				else
					-- removing these placers from buildgrid and adding them to the list
					if dx ~= 0 then RemoveBlock( -- x-side
						lastpt.x - sx*GRIDSIZE*d, pt.x - sx*(GRIDSIZE+1)*d, sx*d,
						pt.z - sz*GRIDSIZE*d, lastpt.z + sz*GRIDSIZE*d, sz*d,
						removelist
					) end
					if dz ~= 0 then RemoveBlock( -- z-side
						pt.x - sx*GRIDSIZE*d, lastpt.x + sx*GRIDSIZE*d, sx*d,
						lastpt.z - sz*GRIDSIZE*d, pt.z - sz*(GRIDSIZE+1)*d, sz*d,
						removelist
					) end
					if dx ~= 0 and dz ~= 0 then RemoveBlock( -- corner
						lastpt.x - sx*GRIDSIZE*d, pt.x - sx*(GRIDSIZE+1)*d, sx*d,
						lastpt.z - sz*GRIDSIZE*d, pt.z - sz*(GRIDSIZE+1)*d, sz*d,
						removelist
					) end
					
					-- moving the removed placers to the leading edges of the buildgrid
					local i = 1
					if dx ~= 0 then i = AddBlock( -- x-side
						pt.x + sx*GRIDSIZE*d, lastpt.x + sx*(GRIDSIZE+1)*d, -sx*d,
						lastpt.z + sz*GRIDSIZE*d, pt.z - sz*GRIDSIZE*d, -sz*d,
						removelist, i
					) end
					if dz ~= 0 then i = AddBlock( -- z-side
						lastpt.x + sx*GRIDSIZE*d, pt.x - sx*GRIDSIZE*d, -sx*d,
						pt.z + sz*GRIDSIZE*d, lastpt.z + sz*(GRIDSIZE+1)*d, -sz*d,
						removelist, i
					) end
					if dx ~= 0 and dz ~= 0 then i = AddBlock( -- corner
						pt.x + sx*GRIDSIZE*d, lastpt.x + sx*(GRIDSIZE+1)*d, -sx*d,
						pt.z + sz*GRIDSIZE*d, lastpt.z + sz*(GRIDSIZE+1)*d, -sz*d,
						removelist, i
					) end
				end

			else
				for bgx = -GRIDSIZE, GRIDSIZE do
					local x = pt.x + d*bgx
					for bgz = -GRIDSIZE, GRIDSIZE do
						local z = pt.z + d*bgz
						-- if bgx ~= 0 or bgz ~= 0 then
							BuildGridPoint(x, z)
						-- end
					end
				end			
			end
		end
		
		if self.buildgrid and self.buildgrid[pt.x] and self.buildgrid[pt.x][pt.z] then
			local addx, addy, addz, adda = self.buildgrid[pt.x][pt.z].AnimState:GetAddColour()
			if math.abs(color.x - addx) > 0.1 then
				RefreshBuildGrid()
			end
		end
	end
	self.OnUpdate = NewOnUpdate
	
	self.inst:ListenForEvent("onremove", function()
		RemoveBuildGrid()
		if self.gridinst then self.gridinst:Remove() end
	end)
	
end)

function Placer:SetBuilder(builder, recipe, invobject)
	self.builder = builder
	self.recipe = recipe
	self.invobject = invobject
	self.inst:StartUpdatingComponent(self)	
end

function Placer:GetDeployAction()
	if self.invobject then
		print("GetDeployAction")
		self.selected_pos = self.inst:GetPosition()
		local action = BufferedAction(self.builder, nil, ACTIONS.DEPLOY, self.invobject, self.selected_pos)
		table.insert(action.onsuccess, function() self.selected_pos = nil end)
		return action
	end
end

function Placer:OnUpdate(dt)

--[[
    local player = GetPlayer()
    if player and player.HUD then
        local hover = player.HUD.controls.hover
        if hover.inMenu then
            return
        end
    end
]]--

	if not TheInput:ControllerAttached() then
		local pt = self.selected_pos or Input:GetWorldPosition()
		if self.snap_to_tile and GetWorld().Map then
			pt = Vector3(GetWorld().Map:GetTileCenterPoint(pt:Get()))
		elseif self.snap_to_meters then
			pt = Vector3(math.floor(pt.x)+.5, 0, math.floor(pt.z)+.5)
		end
		self.inst.Transform:SetPosition(pt:Get())	
	else
		if self.snap_to_tile and GetWorld().Map then
			--Using an offset in this causes a bug in the terraformer functionality while using a controller.
			local pt = Vector3(GetPlayer().entity:LocalToWorldSpace(0,0,0))
			pt = Vector3(GetWorld().Map:GetTileCenterPoint(pt:Get()))
			self.inst.Transform:SetPosition(pt:Get())
		elseif self.snap_to_meters then
			local pt = Vector3(GetPlayer().entity:LocalToWorldSpace(1,0,0))
			pt = Vector3(math.floor(pt.x)+.5, 0, math.floor(pt.z)+.5)
			self.inst.Transform:SetPosition(pt:Get())
		else
			if self.inst.parent == nil then
				GetPlayer():AddChild(self.inst)
				self.inst.Transform:SetPosition(1,0,0)
			end
		end
	end
	
	self.can_build = true
	if self.testfn then
		self.can_build = self.testfn(Vector3(self.inst.Transform:GetWorldPosition()))
	end
	
	--self.inst.AnimState:SetMultColour(0,0,0,.5)
	
	local color = self.can_build and Vector3(.25,.75,.25) or Vector3(.75,.25,.25)
	self.inst.AnimState:SetAddColour(color.x, color.y, color.z ,0)

    if TheInput:IsTouchDown() then
        local player = GetPlayer()
        if player and player.HUD then
            local hover = player.HUD.controls.hover
            if hover.inMenu then
                self.inst:Hide()
            else
                self.inst:Show()
            end
        else
            self.inst:Show()
        end
    else
        self.inst:Hide()
    end
end

return Placer
