-- dirtyWheels
-- by modelleicher
-- date 10.05.2014
-- based on "washable" from Face 

dirtyWheels = {};

function dirtyWheels.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function dirtyWheels:load(xmlFile)
	self.setDirtyScale = dirtyWheels.setDirtyScale;
	local i = 1;
	self.dWheels = {};
	while true do
		local dWheel = {};
		dWheel.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dirtyWheels#index"..i));
		if dWheel.index == nil then
			break;
		end;
		dWheel.dirtyValue = 0;
		table.insert(self.dWheels, dWheel);
		i = i+1;
	end;
	self.dWheelsCnt = table.getn(self.dWheels);

	self.v1increase = 0.00003; -- cultivator
	self.v2increase = 0.000045; -- plough
	self.v3increase = 0.00002; -- sowing
end;

function dirtyWheels:readStream(streamId, connection)
	for i=1, self.dWheelsCnt do
		local dirtyValue = streamReadFloat32(streamId);
		self:setDirtyScale(i, dirtyValue);
	end;
end;

function dirtyWheels:writeStream(streamId, connection)
	for i=1, self.dWheelsCnt do
		streamWriteFloat32(streamId, self.dWheels[i].dirtyValue);
	end;
end;
function dirtyWheels:setDirtyScale(object, value)
	setShaderParameter(self.dWheels[object].index, "dirtScale", value, 0,0,0,false);
	self.dWheels[object].dirtyValue = value;
end;
function dirtyWheels:delete()
end;

function dirtyWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dirtyWheels:keyEvent(unicode, sym, modifier, isDown)
end;

function dirtyWheels:update(dt)
	if self:getIsActive() then
		self.kmhMath = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600))/2;
	end;
end;

function dirtyWheels:updateTick(dt)
	if self:getIsActive() then
		for i=1, self.dWheelsCnt do
			local x,y,z = getWorldTranslation(self.dWheels[i].index);
			local val1 = Utils.getDensity(g_currentMission.terrainDetailId, 0, x+0.04, z+0.04, x-0.04, z+0.04, x+0.04, z-0.04);
			local val2 = Utils.getDensity(g_currentMission.terrainDetailId, 1, x+0.04, z+0.04, x-0.04, z+0.04, x+0.04, z-0.04);
			local val3 = Utils.getDensity(g_currentMission.terrainDetailId, 2, x+0.04, z+0.04, x-0.04, z+0.04, x+0.04, z-0.04);
			local dirtyValue = 0;
			if val1 > 0 then
				dirtyValue = math.min(self.dWheels[i].dirtyValue + (self.v1increase*self.kmhMath)*dt, 1);
			elseif val2 > 0 then
				dirtyValue = math.min(self.dWheels[i].dirtyValue + (self.v2increase*self.kmhMath)*dt, 1);
			elseif val3 > 0 then
				dirtyValue = math.min(self.dWheels[i].dirtyValue + (self.v3increase*self.kmhMath)*dt, 1);
			else
				dirtyValue = math.max(self.dWheels[i].dirtyValue - (0.00002*dt)*self.kmhMath, 0);
			end;
			if dirtyValue ~= self.dWheels[i].dirtyValue then
				self.dWheels[i].dirtyValue = dirtyValue;
				setShaderParameter(self.dWheels[i].index, "dirtScale", self.dWheels[i].dirtyValue, 0,0,0,false);
			end;
		end;
	end;  
end;

function dirtyWheels:draw()
end;


function dirtyWheels:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		for i=1, self.dWheelsCnt do
			self:setDirtyScale(i, Utils.getNoNil(getXMLFloat(xmlFile, key.."#dirtyValue"..i),0));
		end;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function dirtyWheels:getSaveAttributesAndNodes(nodeIdent)
	local attributes1 = {};
	for i=1, self.dWheelsCnt do
		local attribute = 'dirtyValue'..i..'="'.. tostring(self.dWheels[i].dirtyValue) .. '" ';
		table.insert(attributes1, attribute);
	end;
	local attributes = table.concat(attributes1);
    return attributes, nil;
end;