/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.catengine;

import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Frame;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import java.util.HashMap;
import java.util.regex.Pattern;

public class Draw {
    Frame f;
    Hooks hs = new Hooks();
    static HashMap<String, Clr> knownColors = new HashMap();
    HashMap<String, Img> symbols = new HashMap();
    static final Pattern IS_ALPHA_CLR = Pattern.compile("[0-9a-fA-F]{10}");

    public Hooks getHooks() {
        return this.hs;
    }

    public Draw(Frame f) {
        this.f = f;
    }

    public Draw(Frame f, Hooks hs) {
        this.f = f;
        this.hs = hs;
    }

    public Frame frame() {
        return this.f;
    }

    public void shift(double dx, double dy) {
        this.f.shift(dx, dy);
    }

    public void scale(double xScale, double yScale) {
        this.f.scale(xScale, yScale);
    }

    public void rotate(double angle) {
        this.f.rotate(angle);
    }

    public void resetTransforms() {
        this.f.resetTransforms();
    }

    public Pt cursor() {
        return this.f.cursor();
    }

    public Draw blit(Img img, double x, double y) {
        this.f.blit(img, null, 1.0, x, y, 0.0, 0.0, 0.0);
        return this;
    }

    public Draw blit(Img img, double x, double y, double angle) {
        this.f.blit(img, null, 1.0, x, y, 0.0, 0.0, angle);
        return this;
    }

    public Draw blit(Img img, Clr c, double x, double y) {
        this.f.blit(img, c, 1.0, x, y, 0.0, 0.0, 0.0);
        return this;
    }

    public Draw blit(Img img, double x, double y, double width, double height) {
        this.f.blit(img, null, 1.0, x, y, width, height, 0.0);
        return this;
    }

    public Draw blit(Img img, Clr c, double x, double y, double width, double height) {
        this.f.blit(img, c, 1.0, x, y, width, height, 0.0);
        return this;
    }

    public Draw blit(Img img, Clr c, double x, double y, double angle) {
        this.f.blit(img, c, 1.0, x, y, 0.0, 0.0, angle);
        return this;
    }

    public Draw blit(Img img, Clr c, double x, double y, double width, double height, double angle) {
        this.f.blit(img, c, 1.0, x, y, width, height, angle);
        return this;
    }

    public Draw blit(Img img, Clr c, double alpha, double x, double y, double width, double height, double angle) {
        this.f.blit(img, c, alpha, x, y, width, height, angle);
        return this;
    }

    public Draw rect(Clr c, double x, double y, double width, double height) {
        this.f.rect(c, x, y, width, height, 0.0);
        return this;
    }

    public Draw rect(Clr c, double x, double y, double width, double height, double angle) {
        this.f.rect(c, x, y, width, height, angle);
        return this;
    }

    public Draw blit(Img img, double x, double y, Hook hook) {
        this.blit(img, x, y);
        this.hs.add(new Rect(x, y, img.srcWidth, img.srcHeight), hook);
        return this;
    }

    public Draw blit(Img img, Clr c, double x, double y, Hook hook) {
        this.blit(img, c, x, y);
        this.hs.add(new Rect(x, y, img.srcWidth, img.srcHeight), hook);
        return this;
    }

    public Draw blit(Img img, double x, double y, double width, double height, Hook hook) {
        this.blit(img, x, y, width, height);
        this.hs.add(new Rect(x, y, width, height), hook);
        return this;
    }

    public Draw blit(Img img, Clr c, double x, double y, double width, double height, Hook hook) {
        this.blit(img, c, x, y, width, height);
        this.hs.add(new Rect(x, y, width, height), hook);
        return this;
    }

    public Draw blit(Img img, Clr c, double alpha, double x, double y, double width, double height, Hook hook) {
        this.blit(img, c, alpha, x, y, width, height);
        this.hs.add(new Rect(x, y, width, height), hook);
        return this;
    }

    public Draw rect(Clr c, double x, double y, double width, double height, Hook hook) {
        this.rect(c, x, y, width, height);
        this.hs.add(new Rect(x, y, width, height), hook);
        return this;
    }

    public void addSymbols(HashMap<String, Img> symbols) {
        this.symbols.putAll(symbols);
    }

    public Draw text(String text, Fount f, double x, double y) {
        return this.text(text, f, x, y, 10000, 10000, true);
    }

    public Draw text(String text, Fount f, double x, double y, int maxWidth) {
        return this.text(text, f, x, y, maxWidth, 10000, true);
    }

    public Pt textSize(String text, Fount f) {
        return this.textSize(text, f, 10000, 10000, true);
    }

    public Rect textSize(String text, Fount f, double x, double y) {
        Pt ts = this.textSize(text, f);
        return new Rect(x, y, ts.x, ts.y);
    }

    public Rect textSize(String text, Fount f, double x, double y, int maxWidth) {
        Pt ts = this.textSize(text, f, maxWidth, 10000, true);
        return new Rect(x, y, ts.x, ts.y);
    }

    public Draw hook(double x, double y, double width, double height, Hook h) {
        this.hs.add(new Rect(x, y, width, height), h);
        return this;
    }

    public Draw text(String text, Fount fount, double x, double y, int maxWidth, int maxHeight, boolean allowCommands) {
        this.doText(true, text, fount, x, y, maxWidth, maxHeight, allowCommands);
        return this;
    }

    public Pt textSize(String text, Fount fount, int maxWidth, int maxHeight, boolean allowCommands) {
        return this.doText(false, text, fount, 0.0, 0.0, maxWidth, maxHeight, allowCommands);
    }

    public Pt doText(boolean doRender, String text, Fount fount, double x, double y, int maxWidth, int maxHeight, boolean allowCommands) {
        int rows = maxHeight / fount.lineHeight;
        int xOffset = 0;
        int row = 0;
        int textIndex = 0;
        Clr bgC = null;
        Clr tintC = null;
        double textAlpha = 1.0;
        Clr defaultTintC = null;
        int biggestWidth = 0;
        while (textIndex < text.length()) {
            char c;
            int nextWordWidth = 0;
            boolean inSquareBrackets = false;
            boolean inCurlyBrackets = false;
            for (int nextSpaceIndex = textIndex; nextSpaceIndex < text.length() && (c = text.charAt(nextSpaceIndex)) != ' ' && c != '\n'; ++nextSpaceIndex) {
                if (c == '[') {
                    inSquareBrackets = true;
                }
                if (c == ']') {
                    inSquareBrackets = false;
                }
                if (c == '{') {
                    inCurlyBrackets = true;
                }
                if (c == '}') {
                    inCurlyBrackets = false;
                }
                if (inCurlyBrackets || inSquareBrackets) continue;
                nextWordWidth += fount.getWidth(c) + fount.letterSpacing;
            }
            boolean justIncrementedRow = false;
            if (xOffset != 0 && xOffset + nextWordWidth > maxWidth) {
                biggestWidth = Math.max(biggestWidth, xOffset);
                xOffset = 0;
                ++row;
                justIncrementedRow = true;
            }
            if (row >= rows) break;
            if (text.charAt(textIndex) == '\\' && allowCommands) {
                ++textIndex;
            } else {
                int n2;
                if (text.charAt(textIndex) == '\n') {
                    if (!justIncrementedRow) {
                        biggestWidth = Math.max(biggestWidth, xOffset);
                        ++row;
                    }
                    xOffset = 0;
                    ++textIndex;
                    continue;
                }
                if (text.charAt(textIndex) == '{' && allowCommands) {
                    Img symImg;
                    String tintN;
                    n2 = textIndex + 1;
                    while (text.charAt(n2) != '}') {
                        ++n2;
                    }
                    String nameS = text.substring(textIndex + 1, n2);
                    String sym = null;
                    Clr symC = null;
                    if (nameS.startsWith("[") && nameS.contains("]") && !(tintN = nameS.substring(1, nameS.indexOf("]"))).isEmpty()) {
                        symC = knownColors.get(tintN);
                        if (symC == null && (symC = Clr.fromHex(tintN)) != null) {
                            knownColors.put(tintN, symC);
                        }
                        if (symC == null && (symC = Clr.getNamedColor(tintN)) != null) {
                            knownColors.put(tintN, symC);
                        }
                        if (symC != null) {
                            sym = nameS.substring(nameS.indexOf("]") + 1);
                        }
                    }
                    if (sym == null) {
                        sym = nameS;
                    }
                    if ((symImg = this.symbols.get(sym)) == null) {
                        symImg = new Img(sym);
                        this.symbols.put(sym, symImg);
                    }
                    if (doRender) {
                        this.blit(symImg, symC, x + (double)xOffset, y + (double)(row * fount.lineHeight));
                    }
                    textIndex = n2 + 1;
                    xOffset += symImg.srcWidth;
                    continue;
                }
                if (text.charAt(textIndex) == '[' && allowCommands) {
                    n2 = textIndex + 1;
                    while (text.charAt(n2) != ']') {
                        ++n2;
                    }
                    String tintN = text.substring(textIndex + 1, n2);
                    boolean def = false;
                    boolean bg = false;
                    if (tintN.startsWith("bg=")) {
                        bg = true;
                        tintN = tintN.substring(3);
                    }
                    if (tintN.startsWith("default=")) {
                        def = true;
                        tintN = tintN.substring("default=".length());
                    }
                    double newAlpha = 1.0;
                    Clr newC = null;
                    if (tintN.length() == 10 && IS_ALPHA_CLR.matcher(tintN).matches()) {
                        newAlpha = (double)Integer.parseInt(tintN.substring(8, 10), 16) / 255.0;
                        tintN = tintN.substring(0, 8);
                    }
                    if (!tintN.isEmpty()) {
                        newC = knownColors.get(tintN);
                        if (newC == null && (newC = Clr.fromHex(tintN)) != null) {
                            knownColors.put(tintN, newC);
                        }
                        if (newC == null && (newC = Clr.getNamedColor(tintN)) != null) {
                            knownColors.put(tintN, newC);
                        }
                    } else if (!bg) {
                        newC = defaultTintC;
                    }
                    if (bg) {
                        bgC = newC;
                    } else if (def) {
                        defaultTintC = newC;
                    } else {
                        tintC = newC;
                        textAlpha = newAlpha;
                    }
                    textIndex = n2 + 1;
                    continue;
                }
            }
            char currentChar = text.charAt(textIndex);
            int charWidth = fount.getWidth(currentChar) + fount.letterSpacing;
            if (doRender) {
                if (bgC != null) {
                    this.f.rect(bgC, x + (double)xOffset + (double)fount.letterOffset, y + (double)(row * (fount.lineHeight + fount.letterOffset)) + (double)fount.letterOffset, charWidth, fount.height, 0.0);
                }
                this.blit(fount.get(currentChar), tintC, textAlpha, x + (double)xOffset + (double)fount.letterOffset, y + (double)(row * (fount.lineHeight + fount.letterOffset)) + (double)fount.letterOffset, 0.0, 0.0, 0.0);
            }
            xOffset += charWidth;
            ++textIndex;
        }
        if (doRender) {
            return null;
        }
        return new Pt(Math.max(biggestWidth, xOffset), fount.lineHeight * (row + 1));
    }
}

