/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.catengine;

import com.zarkonnen.catengine.Condition;
import com.zarkonnen.catengine.Engine;
import com.zarkonnen.catengine.ExceptionHandler;
import com.zarkonnen.catengine.Frame;
import com.zarkonnen.catengine.Game;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.MusicCallback;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.KeyListener;
import org.newdawn.slick.MouseListener;
import org.newdawn.slick.Music;
import org.newdawn.slick.MusicListener;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.opengl.renderer.SGL;

public class SlickEngine
extends BasicGame
implements Engine,
KeyListener,
ExceptionHandler,
MouseListener {
    protected static SGL GL = Renderer.get();
    boolean doExit = false;
    int fps;
    Music currentMusic;
    String loadBase;
    String soundLoadBase;
    MyAppGameContainer agc;
    Game g;
    boolean fullscreen;
    boolean cursorVisible = true;
    String lastKeyPressed;
    final HashMap<String, SoftReference<Image>> images = new HashMap();
    final HashMap<String, Music> musics = new HashMap();
    final HashMap<String, SoftReference<Sound>> sounds = new HashMap();
    final Object soundLoadMutex = new Object();
    ExceptionHandler eh = this;
    int mouseWheelMovement = 0;
    char lastChar = '\u0000';
    int musicThreeStrikes = 3;
    byte[] emergencyMemoryStash = null;
    Pt lastClick;
    int clickButton;

    public SlickEngine(String title, String loadBase, String soundLoadBase, Integer fps) {
        super(title);
        this.loadBase = loadBase;
        this.soundLoadBase = soundLoadBase;
        this.fps = fps;
    }

    public void mouseWheelMoved(int i) {
        this.mouseWheelMovement += i;
    }

    public void handle(Exception e, boolean fatal) {
        e.printStackTrace();
    }

    public void setExceptionHandler(ExceptionHandler eh) {
        this.eh = eh;
    }

    public void init(GameContainer gc) throws SlickException {
        gc.setTargetFrameRate(this.fps);
        gc.setVSync(true);
        gc.setShowFPS(false);
    }

    public void update(GameContainer gc, int delta) throws SlickException {
        if (this.emergencyMemoryStash == null) {
            this.emergencyMemoryStash = new byte[0x800000];
        }
        this.g.input((Input)new MyInput(gc, delta));
        gc.getInput().clearKeyPressedRecord();
        gc.getInput().setMouseClickTolerance(10);
        this.mouseWheelMovement = 0;
        this.lastClick = null;
        this.clickButton = 0;
    }

    public void render(GameContainer gc, Graphics grphcs) throws SlickException {
        this.g.render((Frame)new MyFrame(gc, grphcs));
    }

    public void setup(Game g) {
        this.g = g;
        try {
            this.agc = new MyAppGameContainer((org.newdawn.slick.Game)this);
            this.agc.setDisplayMode(800, 600, false);
        }
        catch (Exception e) {
            this.eh.handle(e, true);
        }
    }

    public void runUntil(Condition u) {
        try {
            this.agc.runUntil(u);
        }
        catch (SlickException e) {
            this.eh.handle((Exception)((Object)e), true);
            this.agc.destroy();
            System.exit(1);
        }
    }

    public void destroy() {
        this.agc.destroy();
    }

    private void getImage(Img img) {
        Image image = null;
        if (this.images.containsKey(img.key)) {
            image = this.images.get(img.key).get();
        }
        if (image == null && img.flipped && this.images.containsKey(img.src) && (image = this.images.get(img.src).get()) != null) {
            image = image.getFlippedCopy(true, false);
            this.images.put(img.key, new SoftReference<Image>(image));
        }
        if (image == null) {
            image = this.loadImage(img.src);
            this.images.put(img.src, new SoftReference<Image>(image));
            if (img.flipped) {
                image = image.getFlippedCopy(true, false);
                this.images.put(img.key, new SoftReference<Image>(image));
            }
        }
        if (image == null) {
            return;
        }
        if (img.srcWidth != 0 && img.srcHeight != 0) {
            image = image.getSubImage(img.flipped ? image.getWidth() - img.srcX - img.srcWidth : img.srcX, img.srcY, img.srcWidth, img.srcHeight);
        }
        image.setCenterOfRotation((float)image.getWidth() / 2.0f, (float)image.getHeight() / 2.0f);
        img.machineImgCache = image;
        img.machineWCache = image.getWidth();
        img.machineHCache = image.getHeight();
    }

    private Image loadImage(String name) {
        if (!name.contains(".")) {
            name = name + ".png";
        }
        InputStream is = SlickEngine.class.getResourceAsStream(this.loadBase + name);
        try {
            return new Image(is, name, false);
        }
        catch (Exception e) {
            this.eh.handle(e, false);
            return null;
        }
    }

    public void keyPressed(int i, char c) {
        this.lastKeyPressed = org.newdawn.slick.Input.getKeyName((int)i);
        this.lastChar = c;
    }

    public void keyReleased(int i, char c) {
        String k = org.newdawn.slick.Input.getKeyName((int)i);
        if (k.equals(this.lastKeyPressed)) {
            this.lastKeyPressed = null;
        }
        if (c == this.lastChar) {
            this.lastChar = '\u0000';
        }
    }

    public void mouseClicked(int button, int x, int y, int clickCount) {
        super.mouseClicked(button, x, y, clickCount);
        this.lastClick = new Pt((double)x, (double)y);
        this.clickButton = button + 1;
    }

    private class MyFrame
    implements Frame {
        boolean colorNotWhite;
        final int gcW;
        final int gcH;
        final GameContainer gc;
        final Graphics g;

        private MyFrame(GameContainer gc, Graphics grphcs) {
            this.gc = gc;
            this.g = grphcs;
            this.gcW = gc.getWidth();
            this.gcH = gc.getHeight();
        }

        public Object nativeRenderer() {
            return this.g;
        }

        public int fps() {
            return this.gc.getFPS();
        }

        public ScreenMode mode() {
            return new ScreenMode(this.gc.getWidth(), this.gc.getHeight(), SlickEngine.this.fullscreen);
        }

        public void rect(Clr tint, double x, double y, double width, double height, double angle) {
            if (tint.machineColorCache == null) {
                tint.machineColorCache = new Color(tint.r, tint.g, tint.b, tint.a);
            }
            Color c = (Color)tint.machineColorCache;
            Graphics.setCurrent((Graphics)this.g);
            TextureImpl.bindNone();
            c.bind();
            float x1 = (float)x;
            float y1 = (float)y;
            float w = (float)width;
            float h = (float)height;
            if (angle == 0.0) {
                GL.glBegin(7);
                GL.glVertex2f(x1, y1);
                GL.glVertex2f(x1 + w, y1);
                GL.glVertex2f(x1 + w, y1 + h);
                GL.glVertex2f(x1, y1 + h);
                GL.glEnd();
            } else {
                this.g.rotate((float)(x + width / 2.0), (float)(y + height / 2.0), (float)(angle * 180.0 / Math.PI));
                GL.glBegin(7);
                GL.glVertex2f(x1, y1);
                GL.glVertex2f(x1 + w, y1);
                GL.glVertex2f(x1 + w, y1 + h);
                GL.glVertex2f(x1, y1 + h);
                GL.glEnd();
                this.g.rotate((float)(x + width / 2.0), (float)(y + height / 2.0), -((float)(angle * 180.0 / Math.PI)));
            }
        }

        public void blit(Img img, Clr tint, double alpha, double x, double y, double width, double height, double angle) {
            Image image;
            if (img == null) {
                return;
            }
            if (img.machineImgCache == null) {
                SlickEngine.this.getImage(img);
            }
            if ((image = (Image)img.machineImgCache) == null) {
                return;
            }
            width = width == 0.0 ? (double)img.machineWCache : width;
            height = height == 0.0 ? (double)img.machineHCache : height;
            image.setRotation((float)(angle * 180.0 / Math.PI));
            if (tint == null) {
                image.setAlpha((float)alpha);
                image.draw((float)x, (float)y, (float)width, (float)height);
            } else {
                if (tint.machineColorCache == null) {
                    tint.machineColorCache = new Color(tint.r, tint.g, tint.b);
                }
                Color c = (Color)tint.machineColorCache;
                if (tint.a == 255) {
                    image.setAlpha((float)alpha);
                    image.draw((float)x, (float)y, (float)width, (float)height, c);
                } else if (alpha == 1.0) {
                    image.setAlpha(1.0f);
                    image.draw((float)x, (float)y, (float)width, (float)height);
                    image.setAlpha((float)tint.a / 255.0f);
                    image.draw((float)x, (float)y, (float)width, (float)height, c);
                } else {
                    image.setAlpha((float)(alpha * (double)(255 - tint.a) / 255.0));
                    image.draw((float)x, (float)y, (float)width, (float)height);
                    image.setAlpha((float)(alpha * (double)tint.a / 255.0));
                    image.draw((float)x, (float)y, (float)width, (float)height, c);
                }
            }
        }

        public void shift(double dx, double dy) {
            this.g.translate((float)dx, (float)dy);
        }

        public void scale(double xScale, double yScale) {
            this.g.scale((float)xScale, (float)yScale);
        }

        public void rotate(double angle) {
            this.g.rotate(0.0f, 0.0f, (float)angle);
        }

        public void resetTransforms() {
            this.g.resetTransform();
        }

        public double getWidth(Img img) {
            if (img == null) {
                return 0.0;
            }
            if (img.srcWidth != 0) {
                return img.srcWidth;
            }
            if (img.machineImgCache == null) {
                SlickEngine.this.getImage(img);
            }
            return img.machineWCache;
        }

        public double getHeight(Img img) {
            if (img == null) {
                return 0.0;
            }
            if (img.srcHeight != 0) {
                return img.srcHeight;
            }
            if (img.machineImgCache == null) {
                SlickEngine.this.getImage(img);
            }
            return img.machineHCache;
        }

        public Pt cursor() {
            return new Pt((double)this.gc.getInput().getMouseX(), (double)this.gc.getInput().getMouseY());
        }
    }

    private class MyInput
    implements Input {
        GameContainer gc;
        int delta;

        public MyInput(GameContainer gc, int delta) {
            this.gc = gc;
            this.delta = delta;
        }

        public boolean keyDown(String key) {
            try {
                return this.gc.getInput().isKeyDown(org.newdawn.slick.Input.class.getField("KEY_" + key).getInt(null));
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean keyPressed(String key) {
            try {
                return this.gc.getInput().isKeyPressed(org.newdawn.slick.Input.class.getField("KEY_" + key).getInt(null));
            }
            catch (Exception e) {
                return false;
            }
        }

        public char getTypedChar() {
            return 'x';
        }

        public Pt cursor() {
            return new Pt((double)this.gc.getInput().getMouseX(), (double)this.gc.getInput().getMouseY());
        }

        public Pt mouseDown() {
            for (int i = 3; i >= 0; --i) {
                if (!this.gc.getInput().isMouseButtonDown(i)) continue;
                return this.cursor();
            }
            return null;
        }

        public Pt clicked() {
            return SlickEngine.this.lastClick;
        }

        public int clickButton() {
            return SlickEngine.this.clickButton;
        }

        public ScreenMode mode() {
            return new ScreenMode(this.gc.getWidth(), this.gc.getHeight(), SlickEngine.this.fullscreen);
        }

        public int msDelta() {
            return this.delta;
        }

        public Input setMode(ScreenMode mode) {
            try {
                this.gc.setMouseGrabbed(false);
                SlickEngine.this.agc.setDisplayMode(mode.width, mode.height, mode.fullscreen);
                SlickEngine.this.fullscreen = mode.fullscreen;
                this.setCursorVisible(SlickEngine.this.cursorVisible);
            }
            catch (Exception e) {
                SlickEngine.this.eh.handle(e, false);
            }
            return this;
        }

        public ArrayList<ScreenMode> modes() {
            ArrayList<ScreenMode> sm = new ArrayList<ScreenMode>();
            try {
                for (DisplayMode dm : Display.getAvailableDisplayModes()) {
                    sm.add(new ScreenMode(dm.getWidth(), dm.getHeight(), dm.isFullscreenCapable()));
                }
            }
            catch (Exception e) {
                SlickEngine.this.eh.handle(e, false);
                sm.add(new ScreenMode(800, 600, false));
            }
            return sm;
        }

        public void quit() {
            this.gc.exit();
        }

        public boolean isCursorVisible() {
            return SlickEngine.this.cursorVisible;
        }

        public Input setCursorVisible(boolean visible) {
            SlickEngine.this.cursorVisible = visible;
            this.gc.setMouseGrabbed(!visible);
            return this;
        }

        public void preload(List<Img> l) {
            for (Img img : l) {
                SlickEngine.this.getImage(img);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preloadSounds(List<String> l) {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                for (String snd : l) {
                    this.getSound(snd);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void play(String sound, double pitch, double volume, double x, double y) {
            if (volume == 0.0) {
                return;
            }
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                Sound s = this.getSound(sound);
                if (s != null) {
                    s.playAt((float)pitch, (float)volume, (float)x, (float)y, 0.0f);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Sound getSound(String sound) {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                Sound snd;
                SoftReference<Sound> ref;
                if (!sound.contains(".")) {
                    sound = sound + ".ogg";
                }
                if ((ref = SlickEngine.this.sounds.get(sound)) != null && (snd = ref.get()) != null) {
                    return snd;
                }
                for (int i = 0; i < 5; ++i) {
                    try {
                        Sound snd2 = new Sound(SlickEngine.class.getResource(SlickEngine.this.soundLoadBase + sound));
                        SlickEngine.this.sounds.put(sound, new SoftReference<Sound>(snd2));
                        return snd2;
                    }
                    catch (Throwable e) {
                        continue;
                    }
                }
                return null;
            }
        }

        public void preloadMusic(String music) {
            try {
                this.getMusic(music);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load music " + music, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Music getMusic(String music) throws SlickException {
            if (SlickEngine.this.musicThreeStrikes <= 0) {
                return null;
            }
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                if (!music.contains(".")) {
                    music = music + ".ogg";
                }
                if (SlickEngine.this.musics.containsKey(music)) {
                    return SlickEngine.this.musics.get(music);
                }
                try {
                    Music m = new Music(SlickEngine.class.getResource(SlickEngine.this.soundLoadBase + music));
                    SlickEngine.this.musics.put(music, m);
                    return m;
                }
                catch (OutOfMemoryError oom) {
                    SlickEngine.this.emergencyMemoryStash = null;
                    Runtime.getRuntime().gc();
                    for (Music m : SlickEngine.this.musics.values()) {
                        try {
                            m.release();
                        }
                        catch (Throwable t) {}
                    }
                    SlickEngine.this.musics.clear();
                    Runtime.getRuntime().gc();
                    --SlickEngine.this.musicThreeStrikes;
                    return null;
                }
            }
        }

        public void playMusic(final String music, final double volume, final MusicCallback startCallback, final MusicCallback doneCallback) {
            new Thread("MusicStarter"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = SlickEngine.this.soundLoadMutex;
                        synchronized (object) {
                            MyInput.this.stopMusic();
                            SlickEngine.this.currentMusic = MyInput.this.getMusic(music);
                            if (SlickEngine.this.currentMusic == null) {
                                doneCallback.run(music, volume);
                                return;
                            }
                            SlickEngine.this.currentMusic.play(1.0f, (float)volume);
                            if (startCallback != null) {
                                startCallback.run(music, volume);
                            }
                            SlickEngine.this.currentMusic.addListener(new MusicListener(){

                                public void musicEnded(Music m) {
                                    if (m == SlickEngine.this.currentMusic && doneCallback != null) {
                                        doneCallback.run(music, volume);
                                    }
                                    SlickEngine.this.currentMusic = null;
                                }

                                public void musicSwapped(Music oldM, Music newM) {
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopMusic() {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                if (SlickEngine.this.currentMusic != null && SlickEngine.this.currentMusic.playing()) {
                    SlickEngine.this.currentMusic.stop();
                    SlickEngine.this.currentMusic = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fadeOutMusic(int ms) {
            Object object = SlickEngine.this.soundLoadMutex;
            synchronized (object) {
                if (SlickEngine.this.currentMusic != null && SlickEngine.this.currentMusic.playing()) {
                    SlickEngine.this.currentMusic.fade(ms, 0.0f, true);
                }
            }
        }

        public String lastKeyPressed() {
            return SlickEngine.this.lastKeyPressed;
        }

        public int scrollAmount() {
            return SlickEngine.this.mouseWheelMovement;
        }

        public char lastInput() {
            return SlickEngine.this.lastChar;
        }
    }

    class MyAppGameContainer
    extends AppGameContainer {
        public MyAppGameContainer(org.newdawn.slick.Game game) throws SlickException {
            super(game, 800, 600, false);
            this.setup();
            this.getDelta();
        }

        public void runUntil(Condition c) throws SlickException {
            this.getDelta();
            while (!c.satisfied() && this.running()) {
                this.gameLoop();
            }
            if (SlickEngine.this.doExit) {
                System.exit(0);
            }
        }
    }
}

