/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.io.ObjectStreamClass;
import com.sun.corba.se.impl.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.impl.io.ObjectStreamField;
import com.sun.corba.se.impl.io.ValueHandlerImpl;
import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.org.omg.CORBA.AttributeDescription;
import com.sun.org.omg.CORBA.Initializer;
import com.sun.org.omg.CORBA.OperationDescription;
import com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.sun.org.omg.CORBA._IDLTypeStub;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.util.Stack;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;
import sun.corba.JavaCorbaAccess;
import sun.corba.SharedSecrets;

public class ValueUtility {
    public static final short PRIVATE_MEMBER = 0;
    public static final short PUBLIC_MEMBER = 1;
    private static final String[] primitiveConstants = new String[]{null, null, "S", "I", "S", "I", "F", "D", "Z", "C", "B", null, null, null, null, null, null, null, null, null, null, null, null, "J", "J", "D", "C", null, null, null, null, null, null};

    public static String getSignature(ValueMember valueMember) throws ClassNotFoundException {
        if (valueMember.type.kind().value() == 30 || valueMember.type.kind().value() == 29 || valueMember.type.kind().value() == 14) {
            Class clazz = RepositoryId.cache.getId(valueMember.id).getClassFromType();
            return ObjectStreamClass.getSignature(clazz);
        }
        return primitiveConstants[valueMember.type.kind().value()];
    }

    public static FullValueDescription translate(ORB oRB, ObjectStreamClass objectStreamClass, ValueHandler valueHandler) {
        int n;
        FullValueDescription fullValueDescription = new FullValueDescription();
        Class<?> clazz = objectStreamClass.forClass();
        ValueHandlerImpl valueHandlerImpl = (ValueHandlerImpl)valueHandler;
        String string = valueHandlerImpl.createForAnyType(clazz);
        fullValueDescription.name = valueHandlerImpl.getUnqualifiedName(string);
        if (fullValueDescription.name == null) {
            fullValueDescription.name = "";
        }
        fullValueDescription.id = valueHandlerImpl.getRMIRepositoryID(clazz);
        if (fullValueDescription.id == null) {
            fullValueDescription.id = "";
        }
        fullValueDescription.is_abstract = ObjectStreamClassCorbaExt.isAbstractInterface(clazz);
        fullValueDescription.is_custom = objectStreamClass.hasWriteObject() || objectStreamClass.isExternalizable();
        fullValueDescription.defined_in = valueHandlerImpl.getDefinedInId(string);
        if (fullValueDescription.defined_in == null) {
            fullValueDescription.defined_in = "";
        }
        fullValueDescription.version = valueHandlerImpl.getSerialVersionUID(string);
        if (fullValueDescription.version == null) {
            fullValueDescription.version = "";
        }
        fullValueDescription.operations = new OperationDescription[0];
        fullValueDescription.attributes = new AttributeDescription[0];
        IdentityKeyValueStack identityKeyValueStack = new IdentityKeyValueStack();
        fullValueDescription.members = ValueUtility.translateMembers(oRB, objectStreamClass, valueHandler, identityKeyValueStack);
        fullValueDescription.initializers = new Initializer[0];
        Class<?>[] classArray = objectStreamClass.forClass().getInterfaces();
        int n2 = 0;
        fullValueDescription.supported_interfaces = new String[classArray.length];
        for (n = 0; n < classArray.length; ++n) {
            fullValueDescription.supported_interfaces[n] = valueHandlerImpl.createForAnyType(classArray[n]);
            if (Remote.class.isAssignableFrom(classArray[n]) && Modifier.isPublic(classArray[n].getModifiers())) continue;
            ++n2;
        }
        fullValueDescription.abstract_base_values = new String[n2];
        for (n = 0; n < classArray.length; ++n) {
            if (Remote.class.isAssignableFrom(classArray[n]) && Modifier.isPublic(classArray[n].getModifiers())) continue;
            fullValueDescription.abstract_base_values[n] = valueHandlerImpl.createForAnyType(classArray[n]);
        }
        fullValueDescription.is_truncatable = false;
        Class<?> clazz2 = objectStreamClass.forClass().getSuperclass();
        fullValueDescription.base_value = Serializable.class.isAssignableFrom(clazz2) ? valueHandlerImpl.getRMIRepositoryID(clazz2) : "";
        fullValueDescription.type = oRB.get_primitive_tc(TCKind.tk_value);
        return fullValueDescription;
    }

    private static ValueMember[] translateMembers(ORB oRB, ObjectStreamClass objectStreamClass, ValueHandler valueHandler, IdentityKeyValueStack identityKeyValueStack) {
        ValueHandlerImpl valueHandlerImpl = (ValueHandlerImpl)valueHandler;
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
        int n = objectStreamFieldArray.length;
        ValueMember[] valueMemberArray = new ValueMember[n];
        block10: for (int i = 0; i < n; ++i) {
            int n2;
            String string = valueHandlerImpl.getRMIRepositoryID(objectStreamFieldArray[i].getClazz());
            valueMemberArray[i] = new ValueMember();
            valueMemberArray[i].name = objectStreamFieldArray[i].getName();
            valueMemberArray[i].id = string;
            valueMemberArray[i].defined_in = valueHandlerImpl.getDefinedInId(string);
            valueMemberArray[i].version = "1.0";
            valueMemberArray[i].type_def = new _IDLTypeStub();
            valueMemberArray[i].access = objectStreamFieldArray[i].getField() == null ? (short)0 : (Modifier.isPublic(n2 = objectStreamFieldArray[i].getField().getModifiers()) ? (short)1 : 0);
            switch (objectStreamFieldArray[i].getTypeCode()) {
                case 'B': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_octet);
                    continue block10;
                }
                case 'C': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(valueHandlerImpl.getJavaCharTCKind());
                    continue block10;
                }
                case 'F': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_float);
                    continue block10;
                }
                case 'D': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_double);
                    continue block10;
                }
                case 'I': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_long);
                    continue block10;
                }
                case 'J': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_longlong);
                    continue block10;
                }
                case 'S': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_short);
                    continue block10;
                }
                case 'Z': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_boolean);
                    continue block10;
                }
                default: {
                    valueMemberArray[i].type = ValueUtility.createTypeCodeForClassInternal(oRB, objectStreamFieldArray[i].getClazz(), valueHandlerImpl, identityKeyValueStack);
                    valueMemberArray[i].id = valueHandlerImpl.createForAnyType(objectStreamFieldArray[i].getType());
                }
            }
        }
        return valueMemberArray;
    }

    private static boolean exists(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(String string, FullValueDescription fullValueDescription, CodeBase codeBase) {
        if (ValueUtility.exists(string, fullValueDescription.supported_interfaces)) {
            return true;
        }
        if (string.equals(fullValueDescription.id)) {
            return true;
        }
        if (fullValueDescription.base_value != null && !fullValueDescription.base_value.equals("")) {
            FullValueDescription fullValueDescription2 = codeBase.meta(fullValueDescription.base_value);
            return ValueUtility.isAssignableFrom(string, fullValueDescription2, codeBase);
        }
        return false;
    }

    public static TypeCode createTypeCodeForClass(ORB oRB, Class clazz, ValueHandler valueHandler) {
        IdentityKeyValueStack identityKeyValueStack = new IdentityKeyValueStack();
        TypeCode typeCode = ValueUtility.createTypeCodeForClassInternal(oRB, clazz, valueHandler, identityKeyValueStack);
        return typeCode;
    }

    private static TypeCode createTypeCodeForClassInternal(ORB oRB, Class clazz, ValueHandler valueHandler, IdentityKeyValueStack identityKeyValueStack) {
        TypeCode typeCode = null;
        String string = (String)identityKeyValueStack.get(clazz);
        if (string != null) {
            return oRB.create_recursive_tc(string);
        }
        string = valueHandler.getRMIRepositoryID(clazz);
        if (string == null) {
            string = "";
        }
        identityKeyValueStack.push(clazz, string);
        typeCode = ValueUtility.createTypeCodeInternal(oRB, clazz, valueHandler, string, identityKeyValueStack);
        identityKeyValueStack.pop();
        return typeCode;
    }

    private static TypeCode createTypeCodeInternal(ORB oRB, Class clazz, ValueHandler valueHandler, String string, IdentityKeyValueStack identityKeyValueStack) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            TypeCode typeCode = clazz2.isPrimitive() ? ValueUtility.getPrimitiveTypeCodeForClass(oRB, clazz2, valueHandler) : ValueUtility.createTypeCodeForClassInternal(oRB, clazz2, valueHandler, identityKeyValueStack);
            TypeCode typeCode2 = oRB.create_sequence_tc(0, typeCode);
            return oRB.create_value_box_tc(string, "Sequence", typeCode2);
        }
        if (clazz == String.class) {
            TypeCode typeCode = oRB.create_string_tc(0);
            return oRB.create_value_box_tc(string, "StringValue", typeCode);
        }
        if (Remote.class.isAssignableFrom(clazz)) {
            return oRB.get_primitive_tc(TCKind.tk_objref);
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return oRB.get_primitive_tc(TCKind.tk_objref);
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass == null) {
            return oRB.create_value_box_tc(string, "Value", oRB.get_primitive_tc(TCKind.tk_value));
        }
        short s = objectStreamClass.isCustomMarshaled() ? (short)1 : 0;
        TypeCode typeCode = null;
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 != null && Serializable.class.isAssignableFrom(clazz3)) {
            typeCode = ValueUtility.createTypeCodeForClassInternal(oRB, clazz3, valueHandler, identityKeyValueStack);
        }
        ValueMember[] valueMemberArray = ValueUtility.translateMembers(oRB, objectStreamClass, valueHandler, identityKeyValueStack);
        return oRB.create_value_tc(string, clazz.getName(), s, typeCode, valueMemberArray);
    }

    public static TypeCode getPrimitiveTypeCodeForClass(ORB oRB, Class clazz, ValueHandler valueHandler) {
        if (clazz == Integer.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_long);
        }
        if (clazz == Byte.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_octet);
        }
        if (clazz == Long.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_longlong);
        }
        if (clazz == Float.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_float);
        }
        if (clazz == Double.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_double);
        }
        if (clazz == Short.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_short);
        }
        if (clazz == Character.TYPE) {
            return oRB.get_primitive_tc(((ValueHandlerImpl)valueHandler).getJavaCharTCKind());
        }
        if (clazz == Boolean.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_boolean);
        }
        return oRB.get_primitive_tc(TCKind.tk_any);
    }

    static {
        SharedSecrets.setJavaCorbaAccess((JavaCorbaAccess)new JavaCorbaAccess(){

            public ValueHandlerImpl newValueHandlerImpl() {
                return ValueHandlerImpl.getInstance();
            }

            public Class<?> loadClass(String string) throws ClassNotFoundException {
                if (Thread.currentThread().getContextClassLoader() != null) {
                    return Thread.currentThread().getContextClassLoader().loadClass(string);
                }
                return ClassLoader.getSystemClassLoader().loadClass(string);
            }
        });
    }

    private static class IdentityKeyValueStack {
        Stack pairs = null;

        private IdentityKeyValueStack() {
        }

        java.lang.Object get(java.lang.Object object) {
            if (this.pairs == null) {
                return null;
            }
            for (KeyValuePair keyValuePair : this.pairs) {
                if (keyValuePair.key != object) continue;
                return keyValuePair.value;
            }
            return null;
        }

        void push(java.lang.Object object, java.lang.Object object2) {
            if (this.pairs == null) {
                this.pairs = new Stack();
            }
            this.pairs.push(new KeyValuePair(object, object2));
        }

        void pop() {
            this.pairs.pop();
        }

        private static class KeyValuePair {
            java.lang.Object key;
            java.lang.Object value;

            KeyValuePair(java.lang.Object object, java.lang.Object object2) {
                this.key = object;
                this.value = object2;
            }

            boolean equals(KeyValuePair keyValuePair) {
                return keyValuePair.key == this.key;
            }
        }
    }
}

