/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior.iiop;

import com.sun.corba.se.impl.encoding.EncapsInputStream;
import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.impl.ior.EncapsulationUtility;
import com.sun.corba.se.impl.ior.iiop.IIOPAddressImpl;
import com.sun.corba.se.impl.logging.IORSystemException;
import com.sun.corba.se.impl.util.JDKBridge;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.IdentifiableBase;
import com.sun.corba.se.spi.ior.ObjectAdapterId;
import com.sun.corba.se.spi.ior.ObjectId;
import com.sun.corba.se.spi.ior.ObjectKey;
import com.sun.corba.se.spi.ior.ObjectKeyTemplate;
import com.sun.corba.se.spi.ior.TaggedProfile;
import com.sun.corba.se.spi.ior.TaggedProfileTemplate;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPFactories;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.ior.iiop.JavaCodebaseComponent;
import com.sun.corba.se.spi.oa.ObjectAdapter;
import com.sun.corba.se.spi.oa.ObjectAdapterFactory;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersion;
import com.sun.corba.se.spi.protocol.RequestDispatcherRegistry;
import java.util.Iterator;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.TaggedProfileHelper;
import sun.corba.EncapsInputStreamFactory;
import sun.corba.OutputStreamFactory;

public class IIOPProfileImpl
extends IdentifiableBase
implements IIOPProfile {
    private ORB orb;
    private IORSystemException wrapper;
    private ObjectId oid;
    private IIOPProfileTemplate proftemp;
    private ObjectKeyTemplate oktemp;
    protected String codebase = null;
    protected boolean cachedCodebase = false;
    private boolean checkedIsLocal = false;
    private boolean cachedIsLocal = false;
    private GIOPVersion giopVersion = null;

    public boolean equals(java.lang.Object object) {
        if (!(object instanceof IIOPProfileImpl)) {
            return false;
        }
        IIOPProfileImpl iIOPProfileImpl = (IIOPProfileImpl)object;
        return this.oid.equals(iIOPProfileImpl.oid) && this.proftemp.equals(iIOPProfileImpl.proftemp) && this.oktemp.equals(iIOPProfileImpl.oktemp);
    }

    public int hashCode() {
        return this.oid.hashCode() ^ this.proftemp.hashCode() ^ this.oktemp.hashCode();
    }

    @Override
    public ObjectId getObjectId() {
        return this.oid;
    }

    @Override
    public TaggedProfileTemplate getTaggedProfileTemplate() {
        return this.proftemp;
    }

    @Override
    public ObjectKeyTemplate getObjectKeyTemplate() {
        return this.oktemp;
    }

    private IIOPProfileImpl(ORB oRB) {
        this.orb = oRB;
        this.wrapper = IORSystemException.get(oRB, "oa.ior");
    }

    public IIOPProfileImpl(ORB oRB, ObjectKeyTemplate objectKeyTemplate, ObjectId objectId, IIOPProfileTemplate iIOPProfileTemplate) {
        this(oRB);
        this.oktemp = objectKeyTemplate;
        this.oid = objectId;
        this.proftemp = iIOPProfileTemplate;
    }

    public IIOPProfileImpl(InputStream inputStream) {
        this((ORB)inputStream.orb());
        this.init(inputStream);
    }

    public IIOPProfileImpl(ORB oRB, org.omg.IOP.TaggedProfile taggedProfile) {
        this(oRB);
        if (taggedProfile == null || taggedProfile.tag != 0 || taggedProfile.profile_data == null) {
            throw this.wrapper.invalidTaggedProfile();
        }
        EncapsInputStream encapsInputStream = EncapsInputStreamFactory.newEncapsInputStream((org.omg.CORBA.ORB)oRB, (byte[])taggedProfile.profile_data, (int)taggedProfile.profile_data.length);
        encapsInputStream.consumeEndian();
        this.init(encapsInputStream);
    }

    private void init(InputStream inputStream) {
        GIOPVersion gIOPVersion = new GIOPVersion();
        gIOPVersion.read(inputStream);
        IIOPAddressImpl iIOPAddressImpl = new IIOPAddressImpl(inputStream);
        byte[] byArray = EncapsulationUtility.readOctets(inputStream);
        ObjectKey objectKey = this.orb.getObjectKeyFactory().create(byArray);
        this.oktemp = objectKey.getTemplate();
        this.oid = objectKey.getId();
        this.proftemp = IIOPFactories.makeIIOPProfileTemplate(this.orb, gIOPVersion, iIOPAddressImpl);
        if (gIOPVersion.getMinor() > 0) {
            EncapsulationUtility.readIdentifiableSequence(this.proftemp, this.orb.getTaggedComponentFactoryFinder(), inputStream);
        }
        if (this.uncachedGetCodeBase() == null) {
            JavaCodebaseComponent javaCodebaseComponent = LocalCodeBaseSingletonHolder.comp;
            if (javaCodebaseComponent != null) {
                if (gIOPVersion.getMinor() > 0) {
                    this.proftemp.add(javaCodebaseComponent);
                }
                this.codebase = javaCodebaseComponent.getURLs();
            }
            this.cachedCodebase = true;
        }
    }

    @Override
    public void writeContents(OutputStream outputStream) {
        this.proftemp.write(this.oktemp, this.oid, outputStream);
    }

    @Override
    public int getId() {
        return this.proftemp.getId();
    }

    @Override
    public boolean isEquivalent(TaggedProfile taggedProfile) {
        if (!(taggedProfile instanceof IIOPProfile)) {
            return false;
        }
        IIOPProfile iIOPProfile = (IIOPProfile)taggedProfile;
        return this.oid.equals(iIOPProfile.getObjectId()) && this.proftemp.isEquivalent(iIOPProfile.getTaggedProfileTemplate()) && this.oktemp.equals(iIOPProfile.getObjectKeyTemplate());
    }

    @Override
    public ObjectKey getObjectKey() {
        ObjectKey objectKey = IORFactories.makeObjectKey(this.oktemp, this.oid);
        return objectKey;
    }

    @Override
    public org.omg.IOP.TaggedProfile getIOPProfile() {
        EncapsOutputStream encapsOutputStream = OutputStreamFactory.newEncapsOutputStream((ORB)this.orb);
        encapsOutputStream.write_long(this.getId());
        this.write(encapsOutputStream);
        InputStream inputStream = (InputStream)encapsOutputStream.create_input_stream();
        return TaggedProfileHelper.read(inputStream);
    }

    private String uncachedGetCodeBase() {
        Iterator iterator = this.proftemp.iteratorById(25);
        if (iterator.hasNext()) {
            JavaCodebaseComponent javaCodebaseComponent = (JavaCodebaseComponent)iterator.next();
            return javaCodebaseComponent.getURLs();
        }
        return null;
    }

    @Override
    public synchronized String getCodebase() {
        if (!this.cachedCodebase) {
            this.cachedCodebase = true;
            this.codebase = this.uncachedGetCodeBase();
        }
        return this.codebase;
    }

    @Override
    public ORBVersion getORBVersion() {
        return this.oktemp.getORBVersion();
    }

    @Override
    public synchronized boolean isLocal() {
        if (!this.checkedIsLocal) {
            this.checkedIsLocal = true;
            String string = this.proftemp.getPrimaryAddress().getHost();
            this.cachedIsLocal = this.orb.isLocalHost(string) && this.orb.isLocalServerId(this.oktemp.getSubcontractId(), this.oktemp.getServerId()) && this.orb.getLegacyServerSocketManager().legacyIsLocalServerPort(this.proftemp.getPrimaryAddress().getPort());
        }
        return this.cachedIsLocal;
    }

    @Override
    public java.lang.Object getServant() {
        if (!this.isLocal()) {
            return null;
        }
        RequestDispatcherRegistry requestDispatcherRegistry = this.orb.getRequestDispatcherRegistry();
        ObjectAdapterFactory objectAdapterFactory = requestDispatcherRegistry.getObjectAdapterFactory(this.oktemp.getSubcontractId());
        ObjectAdapterId objectAdapterId = this.oktemp.getObjectAdapterId();
        ObjectAdapter objectAdapter = null;
        try {
            objectAdapter = objectAdapterFactory.find(objectAdapterId);
        }
        catch (SystemException systemException) {
            this.wrapper.getLocalServantFailure(systemException, (java.lang.Object)objectAdapterId.toString());
            return null;
        }
        byte[] byArray = this.oid.getId();
        Object object = objectAdapter.getLocalServant(byArray);
        return object;
    }

    @Override
    public synchronized GIOPVersion getGIOPVersion() {
        return this.proftemp.getGIOPVersion();
    }

    @Override
    public void makeImmutable() {
        this.proftemp.makeImmutable();
    }

    private static class LocalCodeBaseSingletonHolder {
        public static JavaCodebaseComponent comp;

        private LocalCodeBaseSingletonHolder() {
        }

        static {
            String string = JDKBridge.getLocalCodebase();
            comp = string == null ? null : IIOPFactories.makeJavaCodebaseComponent(string);
        }
    }
}

