/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Main;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.io.FileUtils;

public strictfp final class AGame {
    public static final String ALPHABET = " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?<>,.;:\"'@\u00a3$%^&*()[]{}|\\~/\u00b1\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00c9\u00ca\u00c8\u00e9\u00ea\u00e8\u00eb\u00c7\u00e7\u00c0\u00e0\u00e2\u00fb";
    public static final String FILE_SAFE_ALPHABET = " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?<>,\"'@\u00a3$%^&*()[]{}|~\u00b1\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00c9\u00ca\u00c8\u00e9\u00ea\u00e8\u00eb\u00c7\u00e7\u00c0\u00e0\u00e2\u00fb";
    public static final String ENTITY_ALPHABET = " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?,.&()";
    public static final Fount FOUNT = Fount.fromResource((String)"libmono12", (String)"/com/zarkonnen/airships/images/libmono12.txt");
    public static final Fount FOUNT_OUTLINE = Fount.fromResource((String)"fatlibmono12", (String)"/com/zarkonnen/airships/images/fatlibmono12.txt");
    public static final Fount BIG_FOUNT = Fount.fromResource((String)"fledermaus18", (String)"/com/zarkonnen/airships/images/fledermaus18.txt");
    public static final Fount BIG_FOUNT_OUTLINE = Fount.fromResource((String)"fatfledermaus18", (String)"/com/zarkonnen/airships/images/fatfledermaus18.txt");
    public static final Fount HUGE_FOUNT = Fount.fromResource((String)"fledermaus64", (String)"/com/zarkonnen/airships/images/fledermaus64.txt");
    public static final Fount STENCIL = Fount.fromResource((String)"stencil", (String)"/com/zarkonnen/airships/images/stencil.txt");
    public static final int SGS = 16;
    public static final int PX_TO_M = 7;
    public static final int LIGHTMAP_DOWNSCALE = 4;
    public static final Img CAST_IRON = new Img("cast_iron", 0, 0, 800, 600, false);
    public static final Clr HIGHLIGHT = new Clr(90, 255, 90, 200);
    public static final Clr DISCOURAGED = new Clr(255, 150, 100, 150);
    public static final Clr FORBIDDEN = new Clr(255, 90, 90);
    public static final Clr SKY = Clr.fromHex((String)"6aabed").mix(0.4, Clr.LIGHT_GREY);
    public static final Clr SKY_OVER = new Clr(190, 195, 230, 80);
    public static final Clr CLOUD = new Clr(210, 215, 250);
    public static final ArrayList<String> STRATEGIC_MUSIC = new ArrayList<String>(Arrays.asList("Suspensions"));
    public static final ArrayList<String> COMBAT_MUSIC = new ArrayList<String>(Arrays.asList("Xiuhtecuhtli", "Kartikeya", "Infernal Machines", "Ares"));
    public static final ArrayList<String> EDITOR_MUSIC = new ArrayList<String>(Arrays.asList("Stratospheres", "Shipyards"));
    public static final ArrayList<String> CITY_MUSIC = new ArrayList<String>(Arrays.asList("Hesperus"));
    public static final ArrayList<String> MENU_MUSIC = new ArrayList();
    public static final ArrayList<String> LOADING_MUSIC = new ArrayList<String>(Arrays.asList("Airships"));
    public static final ArrayList<String> NO_MUSIC = new ArrayList();
    public static final String VERSION = "7.1.1";
    public static final int GROUND_LEVEL = 512;
    public static final int HEIGHT_FOR_DOUBLE_LIFT = 300;
    public static final double G = 0.001;
    public static final int SERVER_TICK = 64;
    public static final Random ANIM_R = new Random();
    static ArrayList<String> shipNames;
    static Locale shipNamesLocale;
    static ArrayList<String> buildingNames;
    static Locale buildingNamesLocale;
    static ArrayList<String> aiShipNames;
    static Locale aiShipNamesLocale;

    private AGame() {
    }

    public static boolean isDebug() {
        return System.getProperty("debug", "false").equals("true");
    }

    public static boolean useAttractMode() {
        return System.getProperty("attract", "false").equals("true");
    }

    public static void copyStatic(String srcName, String dstName) throws IOException {
        File src = new File(AGame.getStaticGameDirectory(), srcName);
        File dst = new File(AGame.getGameDirectory(), dstName);
        if (!dst.exists()) {
            FileUtils.copyDirectory(src, dst);
        }
    }

    public static void overlayStatic(String srcName, String dstName) throws IOException {
        File src = new File(AGame.getStaticGameDirectory(), srcName);
        File dst = new File(AGame.getGameDirectory(), dstName);
        if (!dst.exists()) {
            FileUtils.copyDirectory(src, dst);
        } else {
            for (File f : src.listFiles()) {
                File f2 = new File(dst, f.getName());
                if (f2.exists()) continue;
                FileUtils.copyFile(f, f2);
            }
        }
    }

    public static File getStaticGameDirectory() {
        if (System.getProperty("os.name").contains("Mac") && !System.getProperty("dev", "false").equals("true")) {
            try {
                String path = Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                return new File(path).getParentFile().getParentFile().getParentFile().getParentFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new File("").getAbsoluteFile();
    }

    public static String getGameDirectoryPath(String path) {
        if (System.getProperty("os.name").contains("Mac") && !System.getProperty("dev", "false").equals("true")) {
            File f = AGame.getStaticGameDirectory();
            for (String bit : path.split("/")) {
                f = new File(f, bit);
            }
            return f.getAbsolutePath();
        }
        return path;
    }

    public static File getGameDirectory() {
        File dir;
        String home;
        String appdata = System.getenv("APPDATA");
        if (appdata != null) {
            File dir2 = new File(new File(appdata), "AirshipsGame").getAbsoluteFile();
            dir2.mkdirs();
            if (dir2.exists()) {
                return dir2;
            }
        }
        if ((home = System.getProperty("user.home")) != null) {
            if (System.getProperty("os.name").contains("Mac")) {
                dir = new File(new File(new File(home), "Documents"), "AirshipsGame").getAbsoluteFile();
                dir.mkdirs();
                if (dir.exists()) {
                    return dir;
                }
            } else {
                dir = new File(new File(home), ".airshipsgame").getAbsoluteFile();
                dir.mkdirs();
                if (dir.exists()) {
                    return dir;
                }
            }
        }
        dir = new File("userdata");
        dir.mkdirs();
        return dir;
    }

    public static String getClipboardString() {
        try {
            return (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCodeFromClipboard() {
        String cs = AGame.getClipboardString();
        if (cs == null || !cs.trim().matches("^[a-zA-Z0-9]{4}(-[a-zA-Z0-9]{4})*$")) {
            return null;
        }
        return cs.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getShipName() {
        if (shipNames == null || !Lang.currentLocale.equals(shipNamesLocale)) {
            shipNames = new ArrayList();
            File f = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), Lang.currentLocale.toLanguageTag() + "_airship_names.txt");
            BufferedReader r = null;
            try {
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                String l = null;
                while ((l = r.readLine()) != null) {
                    shipNames.add(l);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            shipNamesLocale = Lang.currentLocale;
        }
        return shipNames.get(ANIM_R.nextInt(shipNames.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuildingName() {
        if (buildingNames == null || !Lang.currentLocale.equals(buildingNamesLocale)) {
            buildingNames = new ArrayList();
            File f = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), Lang.currentLocale.toLanguageTag() + "_building_names.txt");
            BufferedReader r = null;
            try {
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                String l = null;
                while ((l = r.readLine()) != null) {
                    buildingNames.add(l);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            buildingNamesLocale = Lang.currentLocale;
        }
        return buildingNames.get(ANIM_R.nextInt(buildingNames.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAIShipName() {
        if (aiShipNames == null || !Lang.currentLocale.equals(aiShipNamesLocale)) {
            aiShipNames = new ArrayList();
            File f = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), Lang.currentLocale.toLanguageTag() + "_ai_airship_names.txt");
            BufferedReader r = null;
            try {
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                String l = null;
                while ((l = r.readLine()) != null) {
                    aiShipNames.add(l);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            aiShipNamesLocale = Lang.currentLocale;
        }
        return aiShipNames.get(ANIM_R.nextInt(aiShipNames.size()));
    }
}

