/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.catengine.Img;
import java.util.EnumSet;

public enum Achievement {
    RAMMING("ramming", "Smash the Skies", "Completely destroy an enemy ship by ramming it.", new Img("achievements/ramming.jpg"), new Img("achievements/ramming_off.jpg")),
    FORCE_DOWN("force_down", "Forced Landing", "Force down an enemy airship.", new Img("achievements/force_down.jpg"), new Img("achievements/force_down_off.jpg")),
    LAND_ROCK("land_rock", "A Convenient Perch", "Land your ship on a floating rock.", new Img("achievements/land_rock.jpg"), new Img("achievements/land_rock_off.jpg")),
    COA("coa", "Heraldry", "Register your coat of arms.", new Img("achievements/coa.jpg"), new Img("achievements/coa_off.jpg")),
    BOARDING("boarding", "Mandatory Change of Ownership", "Capture an enemy ship.", new Img("achievements/boarding.jpg"), new Img("achievements/boarding_off.jpg")),
    EVADE_BOARDERS("evade_boarders", "One Giant (Unplanned) Leap", "Cause enemy marines to mis-jump and fall to the ground.", new Img("achievements/evade_boarders.jpg"), new Img("achievements/evade_boarders_off.jpg")),
    BROADSIDE("broadside", "Broadside", "Fire ten heavy cannon at once.", new Img("achievements/broadside.jpg"), new Img("achievements/broadside_off.jpg")),
    MULTIPLAYER("multiplayer", "Conquer the 'Net", "Win a multiplayer battle.", new Img("achievements/multiplayer.jpg"), new Img("achievements/multiplayer_off.jpg")),
    MULTIPLAYER_200("multiplayer_200", "Dogfight", "Win a multiplayer battle in the $200 fleet limit category.", new Img("achievements/multiplayer_200.jpg"), new Img("achievements/multiplayer_200_off.jpg"));

    public final String officialName;
    public final String displayName;
    public final String desc;
    public final Img logo;
    public final Img offLogo;
    private static Achievement recentAchievement;
    private static int msSinceAchievement;
    private static EnumSet<Achievement> cache;
    private static boolean achievementsLoaded;

    private Achievement(String officialName, String displayName, String desc, Img logo, Img offLogo) {
        this.officialName = officialName;
        this.displayName = displayName;
        this.desc = desc;
        this.logo = logo;
        this.offLogo = offLogo;
    }

    public static Achievement getRecentAchievement() {
        return recentAchievement;
    }

    public static void tick(int ms) {
        if (!achievementsLoaded) {
            try {
                if (SteamBackend.isEnabled()) {
                    for (Achievement a : Achievement.values()) {
                        if (!SteamBackend._isAchieved(a.officialName)) continue;
                        cache.add(a);
                    }
                } else {
                    for (Achievement a : Achievement.values()) {
                        if (!AirshipGame.PREFS.getBoolean("achievement_" + a.officialName, false)) continue;
                        cache.add(a);
                    }
                }
                achievementsLoaded = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (recentAchievement != null && (msSinceAchievement += ms) > 4000) {
            recentAchievement = null;
        }
    }

    public static boolean isAchieved(Achievement a) {
        return cache.contains((Object)a);
    }

    public static void achieve(Achievement a) {
        if (!cache.contains((Object)a)) {
            recentAchievement = a;
            msSinceAchievement = 0;
            cache.add(a);
            if (SteamBackend.isEnabled()) {
                SteamBackend._achieve(a.officialName);
            } else {
                AirshipGame.PREFS.putBoolean("achievement_" + a.officialName, true);
            }
        }
    }

    public static void unAchieve(Achievement a) {
        if (cache.contains((Object)a)) {
            cache.remove((Object)a);
            if (SteamBackend.isEnabled()) {
                SteamBackend._unAchieve(a.officialName);
            } else {
                AirshipGame.PREFS.putBoolean("achievement_" + a.officialName, false);
            }
        }
    }

    static {
        recentAchievement = null;
        cache = EnumSet.noneOf(Achievement.class);
        achievementsLoaded = false;
    }
}

