/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Achievement;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class AchievementsScreen
implements Screen {
    public AirshipGame g;

    public AchievementsScreen(AirshipGame g) {
        this.g = g;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (in.keyPressed("ESCAPE") || in.keyPressed("L")) {
            this.g.s = new MainMenu(this.g);
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(AGame.CAST_IRON, sm);
        d.drawTopBar(sm);
        d.button(sm.width - 10 - 80, 11, 80, Lang._t("Leave", new Object[0]), "L", new Runnable(){

            @Override
            public void run() {
                AchievementsScreen.this.g.s = new MainMenu(AchievementsScreen.this.g);
            }
        });
        int y = 67;
        int w = 300;
        int cols = (int)Math.ceil((double)Achievement.values().length * 1.0 * 80.0 / (double)(sm.height - y - 10));
        int x = sm.width / 2 - (300 * cols + 12 * (cols - 1)) / 2;
        d.text(Lang._t("Achievements", new Object[0]), AGame.BIG_FOUNT, 10.0, 11.0);
        for (Achievement a : Achievement.values()) {
            boolean ia = Achievement.isAchieved(a);
            d.drawPanel(x, y, 68, 68);
            d.blit(ia ? a.logo : a.offLogo, x + 2, y + 2);
            d.text((ia ? "[c8b84f]" : "") + a.displayName.toUpperCase() + "\n" + a.desc, AGame.FOUNT, x + 68 + 12, y, w - 68 - 24);
            if ((y += 80) <= sm.height - 80) continue;
            x += w + 12;
            y = 67;
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

