/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BuildableFilter;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.json.JSONObject;
import org.json.JSONTokener;

public class AddConstructionButton
extends UniScreen.Button {
    public final ShipType type;
    public final int sideIndex;

    public AddConstructionButton(ShipType type, int sideIndex) {
        this.type = type;
        this.sideIndex = sideIndex;
    }

    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof SingleCombatSetupIntent && us.tool == UniScreen.NAVIGATE;
    }

    @Override
    public String text(UniScreen us) {
        if (us.tool instanceof PlaceShipTool) {
            return Lang._t("Cancel", new Object[0]);
        }
        return this.sideIndex == 0 ? Lang._t("_" + this.type.name() + "_left_", new Object[0]) : Lang._t("_" + this.type.name() + "_right_", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        if (us.tool instanceof PlaceShipTool) {
            us.tool = UniScreen.NAVIGATE;
        } else {
            this.addShip(us);
        }
    }

    @Override
    public boolean gold(UniScreen us) {
        if (!(us.intent instanceof SingleCombatSetupIntent)) {
            return false;
        }
        if (this.sideIndex == 0) {
            return us.combat.sides.get((int)0).ships.isEmpty();
        }
        return !us.combat.sides.get((int)0).ships.isEmpty() && us.combat.sides.get((int)1).ships.isEmpty();
    }

    private void addShip(UniScreen us) {
        ShipHelperWidget shw = ShipHelperWidget.get(new File(AGame.getGameDirectory(), this.type.dirName), us.combat.sides.get((int)this.sideIndex).arms, Bonus.STANDARD_BONUSES, 0);
        FileScreen fs = new FileScreen(ShipEditorUtils.shipsList(this.type, shw), new AddMission(us.g, us, this.sideIndex == 1 ^ !this.type.mobile, us.combat.sides.get(this.sideIndex), this.sideIndex, this.type), shw, new PriceInlineInfo(shw, null));
        fs.enabledFilter = new BuildableFilter(Bonus.STANDARD_BONUSES, shw);
        us.g.s = fs;
    }

    public static class AddMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;
        private final boolean flipped;
        private final Combat.Side side;
        private final int sideIndex;
        private final ShipType type;

        public AddMission(AirshipGame g, UniScreen us, boolean flipped, Combat.Side side, int sideIndex, ShipType type) {
            this.g = g;
            this.us = us;
            this.flipped = flipped;
            this.side = side;
            this.sideIndex = sideIndex;
            this.type = type;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Add_" + this.type.name() + "_to_fleet_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Add", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileSelected(String name) {
            this.g.s = this.us;
            BufferedReader r = null;
            try {
                r = new BufferedReader(new FileReader(new File(new File(AGame.getGameDirectory(), this.type.dirName), name + ".json")));
                Airship shipToPlace = new Airship(new JSONObject(new JSONTokener(r)));
                shipToPlace.setFlipped(this.flipped);
                shipToPlace.flipTo = this.flipped;
                shipToPlace.currentBonuses = Bonus.STANDARD_BONUSES;
                shipToPlace.constructionBonuses = Bonus.STANDARD_BONUSES;
                shipToPlace.repair();
                this.us.tool = new PlaceShipTool(shipToPlace, false, this.side, this.sideIndex);
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_" + this.type.name(), new Object[0]), e, null, false);
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

