/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Arc;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.Foot;
import com.zarkonnen.airships.Fragment;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.GridRef;
import com.zarkonnen.airships.Job;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.ShipLayers;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.Spring;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.airships.WheelBody;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;

public strictfp class Airship
extends GridBody
implements Comparator<Job>,
Cloneable {
    public static final Clr ARMOUR_BACK = new Clr(90, 90, 90);
    public static final Clr INSIDE = new Clr(70, 70, 70);
    public static final Clr LIT_EDGE = new Clr(255, 255, 255, 30);
    public static final Clr DARK_EDGE = new Clr(0, 0, 0, 70);
    public static final Clr HP_BG = new Clr(40, 40, 40, 128);
    public static final Clr COAL_FG = Clr.fromHex((String)"9d978c");
    public static final Clr COAL_BG = Clr.fromHex((String)"3a3222");
    public static final Clr WATER_FG = Clr.fromHex((String)"8b99ff");
    public static final Clr WATER_BG = Clr.fromHex((String)"4e568f");
    public static final Clr REPAIR_FG = Clr.fromHex((String)"886219");
    public static final Clr REPAIR_BG = Clr.fromHex((String)"4e390e");
    public static final Clr AMMO_FG = Clr.fromHex((String)"b6b784");
    public static final Clr AMMO_BG = Clr.fromHex((String)"6d6d4f");
    public static final double SPEED_TO_PX_PER_MS = 0.05;
    public static final double DROP_SPEED_PER_MS = 0.1;
    public static final double DRIFT_DOWN_SPEED_PER_MS = 0.4;
    public static final double FALL_SPEED_PER_MS = 0.75;
    public static final int MS_UNTIL_FULL_SPEED = 1500;
    public String networkID = "[no network ID]";
    public int chunkSubIDCounter = 1;
    public boolean focusOnShooting = true;
    public boolean focusOnRepair = false;
    public boolean focusOnFirefighting = false;
    public boolean focusOnMoving = false;
    public Pt moveTo = new Pt(0.0, 0.0);
    public boolean flipTo = false;
    public boolean ramming = false;
    public boolean grounding = false;
    public boolean sitting = false;
    public int flipMs = 0;
    public Airship fireAt;
    public Airship board;
    public FireMode fireMode = FireMode.NORMAL;
    public int commandPoints = 0;
    public static final int ASSIGN_JOBS_EVERY = 300;
    public int assignJobsMs = 300;
    public static final int[][] ADJ = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}};
    public String name;
    public ArrayList<Module> modules = new ArrayList();
    public ArrayList<Tile> tiles = new ArrayList();
    public ArrayList<Crewman> crew = new ArrayList();
    public ArrayList<Crewman> boarders = new ArrayList();
    public ArrayList<Decal> decals = new ArrayList();
    private int w;
    private int h;
    public boolean captured = false;
    public int msSinceLastXMove = 0;
    public boolean flipped = false;
    public transient int braking = 0;
    public transient boolean showingOutside = false;
    public boolean cachedGroundOffsetCalculated = false;
    public double cachedGroundOffset;
    public int timeMovingInSameXDirection = 0;
    public boolean movingLeft = false;
    public int msSinceOnGround;
    public transient LandFormation lastGrounded;
    public boolean enginesRunning;
    public boolean suspendiumRunning;
    public ShipType type;
    public EnumSet<Bonus> constructionBonuses = EnumSet.noneOf(Bonus.class);
    public transient EnumSet<Bonus> currentBonuses = EnumSet.noneOf(Bonus.class);
    private HashMap<Tile, HashMap<Module, ArrayList<Tile>>> paths = new HashMap();
    private HashMap<Tile, HashMap<Tile, ArrayList<Tile>>> tilePaths = new HashMap();
    private int crashSize = 0;
    private transient Tile[][] tileGrid = null;
    public transient TacticalAI ai;
    public transient boolean aiTmpCanMove;
    public transient int aiTmpAvailableLift;
    public transient boolean fireOrderSpoken;
    public transient boolean ramOrderSpoken;
    public transient boolean wasReadyForCommand = true;
    public transient int msUntilNextSailFlap = 0;
    public transient ArrayList<Airship> justRammedBy = new ArrayList();
    public transient ArrayList<Airship> justCollidedWith = new ArrayList();
    public transient boolean collidedWithFloatingRock;
    public transient int msSuspendiumOff;
    private static final Color FIRE_ARC_ARC = new Color(255, 255, 255, 120);
    private static final Color FIRE_ARC_LINE = new Color(255, 255, 255, 180);
    private static final Color FIRE_ARC_DISABLED_ARC = new Color(187, 66, 29, 120);
    private static final Color FIRE_ARC_DISABLED_LINE = new Color(187, 66, 29);
    public static final Clr DOOR_FREE = new Clr(180, 255, 180);
    public static final Clr DOOR_PRESENT = Clr.fromHex((String)"4d370d");
    public static final Clr DISCONNECTED = new Clr(200, 30, 30, 90);
    public transient double legBalanceFactor = 1.0;

    public double getCachedGroundOffset() {
        if (!this.cachedGroundOffsetCalculated) {
            this.cachedGroundOffset = this.groundOffset();
            this.cachedGroundOffsetCalculated = true;
        }
        return this.cachedGroundOffset;
    }

    public void setFlipped(boolean fl2) {
        if (fl2 != this.flipped) {
            for (Module m : this.modules) {
                m.weaponAngle = Direction.flipHorizontal(m.weaponAngle);
            }
        }
        this.flipped = fl2;
    }

    public JSONObject toJSON(Combat combat) {
        JSONObject o = new JSONObject().put("name", this.name).put("type", this.type.name()).put("x", this.x).put("y", this.y).put("w", this.w).put("h", this.h).put("flipped", this.flipped).put("xSpeed", this.xSpeed).put("ySpeed", this.ySpeed).put("assignJobsMs", this.assignJobsMs).put("commandPoints", this.commandPoints).put("focusOnShooting", this.focusOnShooting).put("focusOnFirefighting", this.focusOnFirefighting).put("focusOnRepair", this.focusOnRepair).put("focusOnMoving", this.focusOnMoving).put("fireMode", this.fireMode.name()).put("flipTo", this.flipTo).put("flipMs", this.flipMs).put("msSinceOnGround", this.msSinceOnGround).put("captured", this.captured).put("networkID", this.networkID).put("chunkSubIDCounter", this.chunkSubIDCounter).put("sitting", this.sitting);
        if (this.moveTo != null) {
            o.put("moveToX", this.moveTo.x).put("moveToY", this.moveTo.y).put("ramming", this.ramming);
        }
        if (combat != null && this.fireAt != null) {
            int fireAtSideIndex = -1;
            int fireAtShipIndex = -1;
            for (Combat.Side side : combat.sides) {
                for (Airship ship : side.ships) {
                    if (ship != this.fireAt) continue;
                    fireAtSideIndex = combat.sides.indexOf(side);
                    fireAtShipIndex = side.ships.indexOf(ship);
                }
            }
            if (fireAtShipIndex != -1) {
                o.put("fireAtSideIndex", fireAtSideIndex).put("fireAtShipIndex", fireAtShipIndex);
            }
        }
        if (combat != null && this.board != null) {
            int boardSideIndex = -1;
            int boardShipIndex = -1;
            for (Combat.Side side : combat.sides) {
                for (Airship ship : side.ships) {
                    if (ship != this.board) continue;
                    boardSideIndex = combat.sides.indexOf(side);
                    boardShipIndex = side.ships.indexOf(ship);
                }
            }
            if (boardShipIndex != -1) {
                o.put("boardSideIndex", boardSideIndex).put("boardShipIndex", boardShipIndex);
            }
        }
        JSONArray a = new JSONArray();
        o.put("modules", a);
        for (Module m : this.modules) {
            a.put(m.toJSON(combat));
        }
        a = new JSONArray();
        o.put("tiles", a);
        for (Tile t : this.tiles) {
            a.put(t.toJSON());
        }
        a = new JSONArray();
        o.put("crew", a);
        for (Crewman c : this.crew) {
            a.put(c.toJSON(combat));
        }
        a = new JSONArray();
        o.put("boarders", a);
        for (Crewman c : this.boarders) {
            a.put(c.toJSON(combat));
        }
        a = new JSONArray();
        o.put("decals", a);
        for (Decal d : this.decals) {
            a.put(d.toJSON());
        }
        a = new JSONArray();
        o.put("carrying", a);
        a = new JSONArray();
        o.put("constructionBonuses", a);
        for (Bonus b : this.constructionBonuses) {
            a.put(b.name());
        }
        return o;
    }

    public Airship(JSONObject o) {
        int i;
        JSONArray a;
        this.name = o.getString("name");
        this.networkID = o.optString("networkID", "[no network ID]");
        this.chunkSubIDCounter = o.optInt("chunkSubIDCounter", 1);
        this.type = ShipType.valueOf(o.optString("type", ShipType.AIRSHIP.name()));
        this.x = o.getDouble("x");
        this.y = o.getDouble("y");
        this.w = o.getInt("w");
        this.h = o.getInt("h");
        this.flipped = o.getBoolean("flipped");
        this.xSpeed = o.optDouble("xSpeed", 0.0);
        this.ySpeed = o.optDouble("ySpeed", 0.0);
        this.assignJobsMs = o.optInt("assignJobsMs", 300);
        this.commandPoints = o.optInt("commandPoints", 0);
        this.focusOnShooting = o.optBoolean("focusOnShooting", false);
        this.focusOnFirefighting = o.optBoolean("focusOnFirefighting", false);
        this.focusOnRepair = o.optBoolean("focusOnRepair", false);
        this.focusOnMoving = o.optBoolean("focusOnMoving", false);
        this.fireMode = FireMode.valueOf(o.optString("fireMode", FireMode.NORMAL.name()));
        this.flipTo = o.optBoolean("flipTo", o.getBoolean("flipped"));
        this.flipMs = o.optInt("flipMs", 0);
        this.msSinceOnGround = o.optInt("msSinceOnGround", 10000);
        this.captured = o.optBoolean("captured", false);
        this.sitting = o.optBoolean("sitting", false);
        if (o.has("moveToX")) {
            this.moveTo = new Pt(o.getDouble("moveToX"), o.getDouble("moveToY"));
        }
        this.ramming = o.optBoolean("ramming", false);
        if (o.has("constructionBonuses")) {
            a = o.getJSONArray("constructionBonuses");
            for (i = 0; i < a.length(); ++i) {
                this.constructionBonuses.add(Bonus.valueOf(a.getString(i)));
            }
        }
        a = o.getJSONArray("modules");
        for (i = 0; i < a.length(); ++i) {
            this.modules.add(new Module(a.getJSONObject(i), this));
        }
        a = o.getJSONArray("tiles");
        for (i = 0; i < a.length(); ++i) {
            this.tiles.add(new Tile(a.getJSONObject(i), this));
        }
        a = o.getJSONArray("crew");
        for (i = 0; i < a.length(); ++i) {
            this.crew.add(new Crewman(a.getJSONObject(i), this));
        }
        if (o.has("boarders")) {
            a = o.getJSONArray("boarders");
            for (i = 0; i < a.length(); ++i) {
                this.boarders.add(new Crewman(a.getJSONObject(i), this));
            }
        }
        if (o.has("decals")) {
            a = o.getJSONArray("decals");
            for (i = 0; i < a.length(); ++i) {
                this.decals.add(new Decal(a.getJSONObject(i)));
            }
        }
        this.layout();
        this.calcAdjacency();
        this.recalcHPs();
    }

    public void finish(JSONObject o, Combat combat) {
        int i;
        JSONArray a = o.getJSONArray("modules");
        for (i = 0; i < a.length(); ++i) {
            this.modules.get(i).finish(a.getJSONObject(i), combat);
        }
        if (o.has("fireAtSideIndex")) {
            this.fireAt = combat.sides.get((int)o.getInt((String)"fireAtSideIndex")).ships.get(o.getInt("fireAtShipIndex"));
        }
        if (o.has("boardSideIndex")) {
            this.board = combat.sides.get((int)o.getInt((String)"boardSideIndex")).ships.get(o.getInt("boardShipIndex"));
        }
        a = o.getJSONArray("crew");
        for (i = 0; i < a.length(); ++i) {
            this.crew.get(i).finishLoading(a.getJSONObject(i), combat);
        }
        if (o.has("boarders")) {
            a = o.getJSONArray("boarders");
            for (i = 0; i < a.length(); ++i) {
                this.boarders.get(i).finishLoading(a.getJSONObject(i), combat);
            }
        }
    }

    public static String getRandomName(ShipType type) {
        switch (type) {
            case BUILDING: {
                return AGame.getBuildingName();
            }
        }
        return AGame.getShipName();
    }

    public Airship(ShipType type) {
        this.type = type;
        this.name = Airship.getRandomName(type);
    }

    public int gridXToWorldX(int xVal, int spriteW) {
        return this.flipped ? this.w - xVal - spriteW : xVal;
    }

    public int gridXToWorldX(int xVal, int spriteW, boolean fl) {
        return fl ? this.w - xVal - spriteW : xVal;
    }

    public void drawOutline(Draw d, double x, double y, boolean oFlipped, Clr c) {
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            d.rect(c, x + (double)(this.gridXToWorldX(t.x, 1, oFlipped) * 16), y + (double)(t.y * 16), 16.0, 16.0);
        }
    }

    public void drawFireArcs(Draw d, double scrollX, double scrollY, double zoom, boolean showValids) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isWeapon() || !showValids && !m.noValidTarget) continue;
            this.drawFireArc(m, d, scrollX, scrollY, zoom, showValids || !m.noValidTarget);
            if (showValids || !m.noValidTarget) continue;
            Pt mz = m.fireFrom();
            int mX = (int)((mz.x + scrollX) * zoom);
            int mY = (int)((mz.y + scrollY) * zoom);
            int xOffset = 10;
            String nt = "[bb421d]" + Lang._t("No_target_available", new Object[0]);
            if (m.type.isBackOnly() != this.flipped) {
                xOffset = -10 - (int)d.textSize((String)nt, (Fount)AGame.FOUNT).x;
            }
            d.text(nt, AGame.FOUNT, (double)(mX + xOffset), (double)(mY - 5));
        }
    }

    public void drawFireArc(Module m, Draw d, double scrollX, double scrollY, double zoom, boolean enabled) {
        Pt mz = m.fireFrom();
        double mX = (mz.x + scrollX) * zoom;
        double mY = (mz.y + scrollY) * zoom;
        mz = new Pt(mX, mY);
        Arc arc = m.type.getFireArc();
        if (this.flipped) {
            arc = arc.flipHorizontal();
        }
        Graphics g = (Graphics)d.frame().nativeRenderer();
        if (m.type.getMaxUpRange() > 0 && m.type.getMaxXRange() > 0) {
            if (m.type.isFlipped()) {
                double upRange = (double)m.type.getMaxUpRange() * zoom;
                double xRange = (double)m.type.getMaxXRange() * zoom;
                double backAmt = -upRange / Math.tan(arc.from.radians);
                Pt intersect = new Pt(mz.x + (this.flipped ? backAmt : -backAmt), mz.y - upRange);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)mX, (float)mY, (float)intersect.x, (float)intersect.y);
                Pt end = (this.flipped ? arc.to : arc.from).fromBy(mz, 60.0);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                end = (this.flipped ? arc.to : arc.from).fromBy(mz, 80.0);
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)intersect.x, (float)(mY - upRange), (float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY - upRange));
                g.drawLine((float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY - upRange), (float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY + 60.0));
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY - upRange), (float)(mX + (this.flipped ? xRange : -xRange)), (float)(mY + 80.0));
            } else {
                double upRange = (double)m.type.getMaxUpRange() * zoom;
                double xRange = (double)m.type.getMaxXRange() * zoom;
                double backAmt = upRange / Math.tan(arc.from.radians);
                Pt intersect = new Pt(mz.x + (this.flipped ? backAmt : -backAmt), mz.y - upRange);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)mX, (float)mY, (float)intersect.x, (float)intersect.y);
                Pt end = (this.flipped ? arc.from : arc.to).fromBy(mz, 60.0);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                end = (this.flipped ? arc.from : arc.to).fromBy(mz, 80.0);
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
                g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
                g.drawLine((float)intersect.x, (float)(mY - upRange), (float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY - upRange));
                g.drawLine((float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY - upRange), (float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY + 60.0));
                g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
                g.drawLine((float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY - upRange), (float)(mX + (this.flipped ? -xRange : xRange)), (float)(mY + 80.0));
            }
        } else {
            g.setColor(enabled ? FIRE_ARC_LINE : FIRE_ARC_DISABLED_LINE);
            Pt start = arc.from.fromBy(mz, 180.0);
            g.drawLine((float)mX, (float)mY, (float)start.x, (float)start.y);
            Pt end = arc.to.fromBy(mz, 180.0);
            g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
            g.setColor(enabled ? FIRE_ARC_ARC : FIRE_ARC_DISABLED_ARC);
            start = arc.from.fromBy(mz, 200.0);
            g.drawLine((float)mX, (float)mY, (float)start.x, (float)start.y);
            end = arc.to.fromBy(mz, 200.0);
            g.drawLine((float)mX, (float)mY, (float)end.x, (float)end.y);
            g.drawArc((float)(mX - 90.0), (float)(mY - 90.0), 180.0f, 180.0f, (float)arc.from.getDegrees(), (float)arc.to.getDegrees());
        }
    }

    public void drawAsBlueprint(MyDraw d, double x, double y, int ms, boolean outside, float intensity) {
        if (outside) {
            int tsz = this.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = this.tiles.get(ti);
                if (t.armour.type == ArmourType.NONE) continue;
                t.armour.getApp().drawAsBlueprint(d, x + (double)(this.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), 16.0, 16.0, ms, this.flipped, intensity);
            }
        } else {
            int msz = this.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Pt offset;
                Module m = this.modules.get(mi);
                m.type.drawAsBlueprint(d, x + (double)(this.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, this.flipped, m.variant, intensity);
                WeaponAppearance wa = m.type.weaponAppearance();
                if (wa == null || Appearance.useSimpleGraphics) continue;
                Img barrel = this.flipped ? wa.flippedbarrel : wa.barrel;
                Pt pt = offset = this.flipped ? wa.flippedBarrelOffset : wa.barrelOffset;
                if (barrel == null || m.hp <= 0) continue;
                Appearance.drawAsBlueprint(barrel, d, x + (double)(this.gridXToWorldX(m.x, m.type.getW()) * 16) + offset.x, y + (double)(m.y * 16) + offset.y, barrel.srcWidth, barrel.srcHeight, this.flipped != m.type.isFlipped(), intensity);
            }
        }
    }

    public void draw(MyDraw d, double x, double y, int ms, boolean outside, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientTint) {
        for (UniScreen.ShipLayer l : ShipLayers.ALL) {
            l.lockShader(d, 1.0, light, lightStrength, ambient);
            l.draw(this, d, outside, 1.0, x, y, ms, displayStatusIcons, showDecals, coa, showHPBarsAndDoors, light, lightStrength, ambient, ambientTint);
            l.unlockShader(light, 1.0);
        }
    }

    public void highlightInaccessibleModules(MyDraw d, double x, double y, double zoom) {
        ArrayList<ArrayList<Module>> nonPathChunks;
        ArrayList<ArrayList<Module>> pathChunks = this.pathChunks(null);
        ArrayList<Module> largest = null;
        if (!pathChunks.isEmpty()) {
            largest = pathChunks.get(0);
            for (ArrayList<Module> ch : pathChunks) {
                if (ch.size() <= largest.size()) continue;
                largest = ch;
            }
            for (ArrayList<Module> chunk : pathChunks) {
                if (chunk == largest) continue;
                for (Module module : chunk) {
                    d.rect(DISCONNECTED, x + (double)(this.gridXToWorldX(module.x, module.type.getW()) * 16), y + (double)(module.y * 16), module.type.getW() * 16, module.type.getH() * 16);
                    d.tooltip((x + (double)(this.gridXToWorldX(module.x, module.type.getW()) * 16)) * zoom, (y + (double)(module.y * 16)) * zoom, (double)(module.type.getW() * 16) * zoom, (double)(module.type.getH() * 16) * zoom, Lang._t("inaccessible_module", new Object[0]));
                }
            }
        }
        if ((nonPathChunks = this.chunks(null)).size() < 2) {
            return;
        }
        ArrayList mainNonPathChunk = null;
        if (largest != null) {
            block3: for (ArrayList arrayList : nonPathChunks) {
                for (Module module : arrayList) {
                    if (!largest.contains(module)) continue;
                    mainNonPathChunk = arrayList;
                    break block3;
                }
            }
        }
        block5: for (Module module : this.modules) {
            if (mainNonPathChunk != null && mainNonPathChunk.contains(module)) continue;
            for (ArrayList arrayList : pathChunks) {
                if (!arrayList.contains(module)) continue;
                continue block5;
            }
            d.rect(DISCONNECTED, x + (double)(this.gridXToWorldX(module.x, module.type.getW()) * 16), y + (double)(module.y * 16), module.type.getW() * 16, module.type.getH() * 16);
            d.tooltip((x + (double)(this.gridXToWorldX(module.x, module.type.getW()) * 16)) * zoom, (y + (double)(module.y * 16)) * zoom, (double)(module.type.getW() * 16) * zoom, (double)(module.type.getH() * 16) * zoom, Lang._t("disconnected_module", new Object[0]));
        }
    }

    public void hookModuleTooltips(MyDraw d, double x, double y, double zoom) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            d.tooltip((x + (double)(this.gridXToWorldX(m.x, m.type.getW()) * 16)) * zoom, (y + (double)(m.y * 16)) * zoom, (double)(m.type.getW() * 16) * zoom, (double)(m.type.getH() * 16) * zoom, m.type.getDescription(this.currentBonuses));
        }
    }

    public int getCost() {
        int c = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            c += m.type.getCost(this.constructionBonuses);
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            c += t.armour.type.getCost(this.constructionBonuses);
        }
        return c;
    }

    public int getRefitCost(Airship original) {
        int[] myMCount = new int[ModuleType.values().length];
        for (Module m : this.modules) {
            int n = m.type.ordinal();
            myMCount[n] = myMCount[n] + 1;
        }
        int[] myACount = new int[ArmourType.values().length];
        for (Tile t : this.tiles) {
            int n = t.armour.type.ordinal();
            myACount[n] = myACount[n] + 1;
        }
        int[] oMCount = new int[ModuleType.values().length];
        for (Module m : original.modules) {
            int n = m.type.ordinal();
            oMCount[n] = oMCount[n] + 1;
        }
        int[] oACount = new int[ArmourType.values().length];
        for (Tile t : original.tiles) {
            int n = t.armour.type.ordinal();
            oACount[n] = oACount[n] + 1;
        }
        int cost = 1;
        for (int m = 0; m < myMCount.length; ++m) {
            if (myMCount[m] > oMCount[m]) {
                cost += (myMCount[m] - oMCount[m]) * ModuleType.values()[m].getCost(this.constructionBonuses);
                continue;
            }
            cost += (myMCount[m] - oMCount[m]) * ModuleType.values()[m].getCost(this.constructionBonuses) / 4;
        }
        for (int a = 0; a < myACount.length; ++a) {
            if (myACount[a] > oACount[a]) {
                cost += (myACount[a] - oACount[a]) * ArmourType.values()[a].getCost(this.constructionBonuses);
                continue;
            }
            cost += (myACount[a] - oACount[a]) * ArmourType.values()[a].getCost(this.constructionBonuses) / 4;
        }
        return cost;
    }

    public int getRequiredCrew() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getCrew();
        }
        return n;
    }

    public int getRequiredGuards() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getFixedGuards();
        }
        return n;
    }

    public boolean hasCrewType(CrewType ct) {
        int csz = this.crew.size();
        for (int i = 0; i < csz; ++i) {
            if (this.crew.get((int)i).type != ct) continue;
            return true;
        }
        return false;
    }

    public boolean hasModuleTypeAny(ModuleType ... mts) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            for (int mti = 0; mti < mts.length; ++mti) {
                if (m.type != mts[mti]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBeingBoarded() {
        int bsz = this.boarders.size();
        for (int bi = 0; bi < bsz; ++bi) {
            if (!this.boarders.get(bi).active()) continue;
            return true;
        }
        return false;
    }

    public int getRecommendedCrew() {
        int n = 2;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getRecommendedCrew();
        }
        return n;
    }

    public int getQuartered(CrewType ct) {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getQuartersType() != ct) continue;
            n += m.type.getQuarters();
        }
        return n;
    }

    public int getAllQuartered() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getQuarters();
        }
        return n;
    }

    public int getOwnWeight() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getWeight();
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            n += t.armour.type.getWeight(this.constructionBonuses);
        }
        return n;
    }

    public int getWeight() {
        int n = this.getOwnWeight();
        return n;
    }

    public int maintenanceCost() {
        int c = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            c += m.type.maintenanceCost();
        }
        if (this.currentBonuses.contains((Object)Bonus.WOLFPACK) && this.type.mobile && this.type.onGround && this.getWeight() <= 2000) {
            c /= 2;
        }
        return c;
    }

    public int getSupplyProvided() {
        int s = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            s += m.type.getSupplyProvided();
        }
        return s;
    }

    public int getSupplyRequired() {
        int s = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            s += m.type.getSupplyRequired();
        }
        return s;
    }

    public int getLift() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getLift(this.constructionBonuses);
        }
        return n;
    }

    public int getAmmoCapacity() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getAmmo();
        }
        return n;
    }

    public int getCoalCapacity() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getCoal();
        }
        return n;
    }

    public boolean requiresCoal() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getCoalReload() <= 0) continue;
            return true;
        }
        return false;
    }

    public int getWaterCapacity() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getWater();
        }
        return n;
    }

    public int getRepairCapacity() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getRepair();
        }
        return n;
    }

    public int getTotalResource(Resource r) {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.getResource(r);
        }
        return n;
    }

    public int getTotalResourceCapacity(Resource r) {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            n += m.type.getResourceCapacity(r);
        }
        return n;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void groundShip() {
        this.moveTo = new Pt((double)this.getX(), 1124.0);
        this.grounding = true;
        this.ramming = false;
    }

    public boolean abandonShip(Combat c) {
        if (!c.canAbandonShip(this)) {
            return false;
        }
        this.sitting = true;
        this.legBalanceFactor = 0.0;
        LandFormation lf = this.lastGrounded == null || this.msSinceOnGround > 99 ? c.landFormations.get(0) : this.lastGrounded;
        int btGridXStart = Math.max(0, (int)Math.floor((this.x - lf.x) / 16.0) - 4);
        int btGridXRange = Math.max(1, Math.min(lf.getGridWidth() - btGridXStart, this.w + 8));
        for (Crewman cm : this.crew) {
            if (cm.job != null && cm.job.isCaptain()) {
                cm.doShout(cm.pickShout("abandonShip"));
            }
            cm.abandonJob();
            cm.ultimateBoardTarget = lf;
            cm.proximateBoardTarget = null;
            int btGridX = btGridXStart + c.r.nextInt(btGridXRange);
            int btGridY = lf.firstSolidBlockYAt(btGridX);
            cm.walkToGR = new GridRef(btGridX, btGridY, lf);
        }
        return true;
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public boolean grounded() {
        return this.msSinceOnGround < 100 && this.moveTo.y + (double)(this.getHeight() * 16) > 1024.0;
    }

    public boolean useless() {
        return this.uselessReason() != null;
    }

    public String uselessReason() {
        if (this.getQuartered(CrewType.SAILOR) == 0) {
            return Lang._t("No_crew_quarters", new Object[0]);
        }
        if (this.crew.isEmpty()) {
            return Lang._t("No_crew", new Object[0]);
        }
        if (this.type.mobile && this.getSpeed() == 0.0) {
            return Lang._t("Immobile", new Object[0]);
        }
        if (!this.type.onGround && this.serviceCeiling() <= 0) {
            return Lang._t("Grounded", new Object[0]);
        }
        return null;
    }

    public String harmlessReason() {
        if (this.isArmed()) {
            if (!this.canShoot()) {
                return Lang._t("No_Ammo", new Object[0]);
            }
            return null;
        }
        return Lang._t("Disarmed", new Object[0]);
    }

    public int getBonusHPPerTile() {
        int sz = 0;
        int bonus = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            sz += m.type.getW() * m.type.getH();
            bonus += m.hp > 0 ? m.type.getShipHPBonus() : 0;
        }
        return bonus / sz;
    }

    public double getInaccuracyMultiplier() {
        double reduction = 0.0;
        ModuleType[] vs = ModuleType.values();
        block0: for (int mti = 0; mti < vs.length; ++mti) {
            ModuleType mt = vs[mti];
            if (!(mt.getAccuracyBonus() > 0.0)) continue;
            int msz = this.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = this.modules.get(mi);
                if (m.type != mt) continue;
                reduction += mt.getAccuracyBonus();
                continue block0;
            }
        }
        return Math.max(0.1, 1.0 - reduction);
    }

    public void precalcAIValues() {
        this.aiTmpCanMove = this.canMove();
        this.aiTmpAvailableLift = this.availableLift();
    }

    public int getCrewCount() {
        int n = 0;
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.crew.get(ci);
            if (cm.hp <= 0) continue;
            ++n;
        }
        return n;
    }

    public void resetLegs() {
        for (Module m : this.modules) {
            m.resetLegs();
        }
    }

    public void initLegs(LandFormation ground, ArrayList<LandFormation> floaters, ShipList ships) {
        for (Module m : this.modules) {
            m.initLegsAndWheels(ground, floaters, ships, true);
        }
    }

    @Override
    public int getGridWidth() {
        return this.w;
    }

    @Override
    public int getGridHeight() {
        return this.h;
    }

    @Override
    public boolean solidAt(int x, int y) {
        return this.tileAt(this.gridXToWorldX(x, 1), y) != null;
    }

    @Override
    public boolean enterableAt(int x, int y) {
        Tile t = this.tileAt(this.gridXToWorldX(x, 1), y);
        return t != null && t.enterable();
    }

    @Override
    public double yBoundaryAt(double worldX) {
        int gridX = this.gridXToWorldX((int)Math.floor((worldX - this.x) / 16.0), 1);
        if (gridX < 0 || gridX >= this.w) {
            return this.y;
        }
        for (int gy = 0; gy < this.h; ++gy) {
            if (this.tileAt(gridX, gy) == null) continue;
            return this.y + (double)(gy * 16);
        }
        return this.y;
    }

    @Override
    public int firstSolidBlockYAt(int gx) {
        if (gx < 0 || gx >= this.w) {
            return -1;
        }
        for (int gy = 0; gy < this.h; ++gy) {
            if (this.tileAt(gx, gy) == null) continue;
            return gy;
        }
        return -1;
    }

    @Override
    public boolean isAtSpeed() {
        return this.type.mobile;
    }

    private Tile unassignedPathingTile() {
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (!t.canOccupy || t.pathCostTmp != 0) continue;
            return t;
        }
        return null;
    }

    public boolean isPathingFullyConnected() {
        return this.pathChunks(null).size() < 2;
    }

    private ArrayList<ArrayList<Module>> pathChunks(Module ignore) {
        Tile unassignedTile;
        ArrayList<ArrayList<Module>> chunks = new ArrayList<ArrayList<Module>>();
        for (Tile t : this.tiles) {
            t.pathCostTmp = t.module == ignore ? -1 : 0;
        }
        int chunkID = 0;
        while ((unassignedTile = this.unassignedPathingTile()) != null) {
            LinkedList<Tile> tileQ = new LinkedList<Tile>();
            ArrayList<Module> chunk = new ArrayList<Module>();
            unassignedTile.pathCostTmp = ++chunkID;
            tileQ.add(unassignedTile);
            while (!tileQ.isEmpty()) {
                Tile t = (Tile)tileQ.pollFirst();
                if (!chunk.contains(t.module)) {
                    chunk.add(t.module);
                }
                for (int[] adj : ADJ) {
                    Tile t2;
                    if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                        if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                            continue;
                        }
                    } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                    if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp != 0 || t2.module != t.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                    t2.pathCostTmp = chunkID;
                    tileQ.add(t2);
                }
            }
            chunks.add(new ArrayList(chunk));
        }
        return chunks;
    }

    public boolean isFullyConnected() {
        return this.chunks(null).size() < 2;
    }

    private Tile unassignedTile() {
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (t.pathCostTmp != 0) continue;
            return t;
        }
        return null;
    }

    private ArrayList<ArrayList<Module>> chunks(Module ignore) {
        Tile unassignedTile;
        ArrayList<ArrayList<Module>> chunks = new ArrayList<ArrayList<Module>>();
        for (Tile t : this.tiles) {
            t.pathCostTmp = t.module == ignore ? -1 : 0;
        }
        int chunkID = 0;
        while ((unassignedTile = this.unassignedTile()) != null) {
            LinkedList<Tile> tileQ = new LinkedList<Tile>();
            ArrayList<Module> chunk = new ArrayList<Module>();
            unassignedTile.pathCostTmp = ++chunkID;
            tileQ.add(unassignedTile);
            while (!tileQ.isEmpty()) {
                Tile t = (Tile)tileQ.pollFirst();
                if (!chunk.contains(t.module)) {
                    chunk.add(t.module);
                }
                for (int[] adj : ADJ) {
                    Tile t2 = this.tileAt(t.x + adj[0], t.y + adj[1]);
                    if (t2 == null || t2.pathCostTmp != 0) continue;
                    t2.pathCostTmp = chunkID;
                    tileQ.add(t2);
                }
            }
            chunks.add(new ArrayList(chunk));
        }
        return chunks;
    }

    private void sanityCheck() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.ship != this) {
                System.err.println("Module on wrong ship.");
            }
            for (int ty = m.y; ty < m.y + m.type.getH(); ++ty) {
                for (int tx = m.x; tx < m.x + m.type.getW(); ++tx) {
                    if (this.tileAt(tx, ty) != null) continue;
                    System.err.println("Module " + m.type.getName() + " not fully covered with tiles.");
                }
            }
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            if (!this.modules.contains(t.module)) {
                System.err.println("Tile's module " + t.module.type.getName() + " is not in ship.");
            }
            if (t.x >= t.module.x && t.y >= t.module.y && t.x < t.module.x + t.module.type.getW() && t.y < t.module.y + t.module.type.getH()) continue;
            System.err.println("Tile not on top of its module " + t.module.type.getName() + ".");
        }
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.crew.get(ci);
            if (cm.ship != this) {
                System.err.println("Crewman on wrong ship.");
            }
            if (!this.tiles.contains(cm.currentTile)) {
                System.err.println("Crewman's tile (" + cm.currentTile.module.type.getName() + ") is not in ship.");
            }
            if (this.modules.contains(cm.currentTile.module)) continue;
            System.err.println("Crewman's module " + cm.currentTile.module.type.getName() + " is not in ship.");
        }
    }

    private void splitIfNeeded(Combat combat) {
        this.regenerateTileGrid();
        ArrayList<ArrayList<Module>> chunks = this.chunks(null);
        for (ArrayList<Module> ch : chunks) {
            for (Module module : ch) {
                if (!this.modules.contains(module)) {
                    System.err.println(module.type.name() + " not in ship");
                }
                boolean found = false;
                for (Tile t : this.tiles) {
                    if (t.module != module) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(module.type.name() + " not covered!");
            }
        }
        for (ArrayList<Module> c1 : chunks) {
            for (ArrayList arrayList : chunks) {
                if (c1 == arrayList) continue;
                for (Module m : arrayList) {
                    if (!c1.contains(m)) continue;
                    System.err.println("CHUNK OVERLAP OF " + m.type.getName());
                }
            }
        }
        if (chunks.size() < 2) {
            return;
        }
        Iterator<ArrayList<Module>> it = chunks.iterator();
        while (it.hasNext()) {
            ArrayList<Module> ms = it.next();
            if (ms.size() != 1) continue;
            this.destroyModule(ms.get(0), combat, true);
            it.remove();
        }
        if (chunks.size() < 2) {
            return;
        }
        ArrayList remainingShip = null;
        int mostW = 0;
        for (ArrayList arrayList : chunks) {
            int weight = 0;
            for (Module m : arrayList) {
                if (m.hp <= -m.type.getHp() / 2) continue;
                weight += m.type.getWeight();
            }
            if (remainingShip != null && mostW >= weight) continue;
            remainingShip = arrayList;
            mostW = weight;
        }
        Combat.Side mySide = this.mySide(combat);
        for (ArrayList<Module> chunk : chunks) {
            if (chunk == remainingShip) continue;
            Airship cs = new Airship(this.type);
            cs.name = "Fragment of " + this.name;
            cs.networkID = this.networkID + "." + this.chunkSubIDCounter;
            ++this.chunkSubIDCounter;
            cs.x = this.getX();
            cs.y = this.getY();
            cs.w = this.w;
            cs.h = this.h;
            cs.xSpeed = this.xSpeed;
            cs.ySpeed = this.ySpeed;
            cs.flipped = this.flipped;
            for (Module m : chunk) {
                cs.modules.add(m);
                m.ship = cs;
                boolean addedTileForModule = false;
                for (Tile t : new ArrayList<Tile>(this.tiles)) {
                    if (t.module != m) continue;
                    cs.tiles.add(t);
                    this.tiles.remove(t);
                    t.setShip(cs);
                    addedTileForModule = true;
                }
                if (!addedTileForModule) {
                    System.out.println("DIDN'T ADD TILE FOR MODULE");
                }
                for (Crewman cm : new ArrayList<Crewman>(this.crew)) {
                    if (cm.currentTile.module != m) continue;
                    cs.crew.add(cm);
                    cm.ship = cs;
                    this.crew.remove(cm);
                    if (cm.injuredCarried == null) continue;
                    cs.crew.add(cm.injuredCarried);
                    cm.injuredCarried.ship = cs;
                    this.crew.remove(cm.injuredCarried);
                }
                this.modules.remove(m);
            }
            for (Particle p : this.stuckParticles) {
                Particle p2 = new Particle(p.type, p.x - this.x + cs.x, p.y - this.y + cs.y, p.dx, p.dy);
                p2.life = p.life;
                p2.lifespan = p.lifespan;
                cs.stuckParticles.add(p2);
            }
            mySide.ships.add(cs);
            cs.sanityCheck();
            cs.layout();
            cs.recalcHPs();
            cs.assignJobs();
            cs.sanityCheck();
            cs.removeUnstuckParticles();
        }
        this.layout();
        this.paths.clear();
        this.tilePaths.clear();
        this.recalcHPs();
        this.assignJobs();
        this.crashSize = 2;
        this.sanityCheck();
        this.removeUnstuckParticles();
    }

    private Combat.Side mySide(Combat combat) {
        int ssz = combat.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side s = combat.sides.get(si);
            if (!s.ships.contains(this)) continue;
            return s;
        }
        return null;
    }

    private void destroyModule(Module m, Combat combat, boolean violently) {
        if (violently) {
            this.crashSize = 2;
        }
        m.dealDestructionDamage();
        this.modules.remove(m);
        Iterator<Tile> tit = this.tiles.iterator();
        while (tit.hasNext()) {
            Tile t = tit.next();
            if (t.module != m) continue;
            if (!t.armour.type.fragments.isEmpty()) {
                for (int fsi = t.armour.type.fragments.size() - 2; fsi < t.armour.type.fragments.size(); ++fsi) {
                    List frags = t.armour.type.fragments.get(fsi);
                    for (int i = 0; i < 3; ++i) {
                        ModuleType.FragmentImg fragI = (ModuleType.FragmentImg)frags.get(AGame.ANIM_R.nextInt(frags.size()));
                        combat.fragments.add(new Fragment(fragI.img, this.getX() + this.gridXToWorldX(t.x, 1) * 16 + fragI.dx, this.getY() + t.y * 16 + fragI.dy, AGame.ANIM_R.nextDouble() * 0.4 - 0.2, AGame.ANIM_R.nextDouble() * 0.4 - 0.2, 0.0, AGame.ANIM_R.nextDouble() * 0.02 - 0.01, 300 + AGame.ANIM_R.nextInt(600)));
                    }
                }
            }
            tit.remove();
        }
        int frameIndex = (m.time + m.animOffset) / m.type.getApp().interval % m.type.getApp().frames.size();
        int mx = this.getX() + this.gridXToWorldX(m.x, m.type.getW()) * 16;
        int my = this.getY() + m.y * 16;
        if (frameIndex < m.type.getAppFragments().size()) {
            for (ModuleType.FragmentImg fi : m.type.getAppFragments().get(frameIndex)) {
                if (m.type.isFlipped() ^ this.flipped) {
                    combat.fragments.add(new Fragment(fi.flipped, mx + m.type.getW() * 16 - fi.dx - fi.flipped.srcWidth, my + fi.dy, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200)));
                    continue;
                }
                combat.fragments.add(new Fragment(fi.img, mx + fi.dx, my + fi.dy, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200)));
            }
        }
        int extS = m.type.getExternalApps().size();
        for (int extI = 0; extI < extS; ++extI) {
            frameIndex = 0;
            ModuleType.ExternalApp extA = m.type.getExternalApps().get(extI);
            if (extI >= m.type.getExternalFragments().size() || frameIndex >= m.type.getExternalFragments().get(extI).size()) continue;
            for (ModuleType.FragmentImg fi : m.type.getExternalFragments().get(extI).get(frameIndex)) {
                int extADx;
                int n = extADx = m.type.isFlipped() ? (extA.app.width() - extA.dx) * 16 : extA.dx * 16;
                if (m.type.isFlipped() ^ this.flipped) {
                    combat.fragments.add(new Fragment(fi.flipped, mx + m.type.getW() * 16 - fi.dx - fi.flipped.srcWidth - extADx, my + fi.dy + extA.dy * 16, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200)));
                    continue;
                }
                combat.fragments.add(new Fragment(fi.img, mx + fi.dx + extADx, my + fi.dy + extA.dy * 16, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200)));
            }
        }
        Iterator<Crewman> cit = this.crew.iterator();
        while (cit.hasNext()) {
            Crewman cm = cit.next();
            if ((cm.beingCarried() || cm.currentTile.module != m) && (cm.carrier() == null || cm.carrier().currentTile.module != m)) continue;
            cit.remove();
        }
        Iterator<Crewman> bit = this.boarders.iterator();
        while (bit.hasNext()) {
            Crewman b = bit.next();
            if ((b.beingCarried() || b.currentTile.module != m) && (b.carrier() == null || b.carrier().currentTile.module != m)) continue;
            bit.remove();
        }
    }

    public void moveTimeForwardForFunctioningInEditorModules(int ms) {
        boolean hasCoal = this.getCoalCapacity() > 0;
        boolean hasAmmo = this.getAmmoCapacity() > 0;
        for (Module m : this.modules) {
            if (m.type.getCrew() > 0) {
                boolean pseudoCrewed = false;
                for (Crewman cm : this.crew) {
                    if (cm.currentTile.module != m) continue;
                    pseudoCrewed = true;
                    break;
                }
                if (!pseudoCrewed) continue;
            }
            if (m.type.isWeapon() && !hasAmmo || m.type.getCoalReload() > 0 && !hasCoal) continue;
            m.time += ms;
        }
    }

    public boolean canFlipSafely(Combat combat) {
        return true;
    }

    public boolean tick(int ms, Combat combat, boolean won, boolean lost) {
        double futureYXAngle;
        if (this.ai != null) {
            this.ai.tick();
        }
        if (Math.abs(this.xSpeed) > 0.001) {
            this.msSinceLastXMove = 0;
            if (this.xSpeed > 0.0) {
                this.timeMovingInSameXDirection = this.movingLeft ? 0 : (this.timeMovingInSameXDirection += ms);
                this.movingLeft = false;
            } else {
                this.timeMovingInSameXDirection = !this.movingLeft ? 0 : (this.timeMovingInSameXDirection += ms);
                this.movingLeft = true;
            }
        } else {
            this.msSinceLastXMove += ms;
        }
        this.updateBalancingOnLegs(ms);
        if (this.board != null && combat != null) {
            boolean friendly = combat.sideOf(this) == combat.sideOf(this.board);
            int csz = this.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = this.crew.get(ci);
                if (!friendly && (!cm.type.canBoard || cm.job instanceof Module.FixedGuardJob)) continue;
                cm.abandonJob();
                cm.ultimateBoardTarget = this.board;
                cm.proximateBoardTarget = null;
            }
            Combat.Side mySide = combat.sideOf(this);
            csz = mySide.troops.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = mySide.troops.get(ci);
                if (cm.attachedTo != this) continue;
                cm.ultimateBoardTarget = this.board;
                cm.proximateBoardTarget = null;
            }
            this.board = null;
        }
        this.msSinceOnGround += ms;
        boolean removed = false;
        ArrayList<Module> removeables = new ArrayList<Module>(this.modules);
        Collections.sort(removeables, new YCmp());
        int rmsz = removeables.size();
        for (int rmi = 0; rmi < rmsz; ++rmi) {
            Module m = removeables.get(rmi);
            if (m.hp > -m.type.getHp() / 2 || !this.isAtEdge(m)) continue;
            m.hp -= ms * 9;
            if (m.hp > -m.type.getHp() * 14) continue;
            removed = true;
            this.destroyModule(m, combat, true);
        }
        if (removed) {
            this.recalcHPs();
            this.splitIfNeeded(combat);
            this.layout();
            this.paths.clear();
            this.tilePaths.clear();
        }
        if (this.modules.isEmpty()) {
            return true;
        }
        this.commandPoints = Math.max(0, Math.min(this.commandPointsRequired(), this.commandPoints + this.commandPointsGenerated()));
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            m.tick(ms, combat);
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            this.tiles.get(ti).tick(combat, ms, this);
        }
        this.assignJobsMs += ms;
        if (this.assignJobsMs >= 300) {
            this.assignJobsMs -= 300;
            this.assignJobs();
        }
        int csz = this.crew.size();
        Combat.Side mySide = combat.sideOf(this);
        ArrayList<Crewman> cr = new ArrayList<Crewman>(this.crew);
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = cr.get(ci);
            cm.tick(ms, combat, mySide, won, lost);
        }
        int bsz = this.boarders.size();
        for (int bi = 0; bi < bsz; ++bi) {
            Crewman cm = this.boarders.get(bi);
            cm.tick(ms, combat, mySide, won, lost);
        }
        this.braking -= ms;
        int futureTest = this.type.onGround ? 80 : 500;
        double d = futureYXAngle = this.type.onGround ? -1.0 : 0.0;
        if (!this.ramming && this.moveTo != null && (Math.abs(this.moveTo.x - this.x) > 5.0 || Math.abs(this.moveTo.y - this.y) > 5.0)) {
            boolean brake = false;
            ArrayList<Body> bs = combat.physics.bodies;
            int bodsz = bs.size();
            for (int bi = 0; bi < bodsz; ++bi) {
                Body b = bs.get(bi);
                if (b == this || b instanceof LandFormation && this.grounding) continue;
                double box = b.x;
                double boy = b.y;
                b.x += b.xSpeed * (double)futureTest;
                b.y += b.ySpeed * (double)futureTest;
                if (!this.collidesWith(b, true)) {
                    double ox = this.x;
                    double oy = this.y;
                    this.x += this.xSpeed * (double)futureTest;
                    this.y += this.ySpeed * (double)futureTest + Math.abs(this.xSpeed * (double)futureTest) * futureYXAngle;
                    if (this.type.onGround && b instanceof LandFormation) {
                        this.y = (double)((LandFormation)b).getVerticalPosition(this, (int)this.x, true) - this.groundOffset();
                    }
                    if (this.collidesWith(b, true)) {
                        brake = true;
                    }
                    this.x = ox;
                    this.y = oy;
                }
                b.x = box;
                b.y = boy;
                if (brake) break;
            }
            if (this.type == ShipType.LANDSHIP) {
                boolean hasLegs = false;
                msz = this.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    if (this.modules.get((int)mi).legs.size() <= 2) continue;
                    hasLegs = true;
                    break;
                }
                int ssz = mySide.ships.size();
                for (int si = 0; si < ssz; ++si) {
                    Airship other = mySide.ships.get(si);
                    if (other == this || !other.type.onGround) continue;
                    boolean otherHasLegs = false;
                    msz = other.modules.size();
                    for (int mi = 0; mi < msz; ++mi) {
                        if (other.modules.get((int)mi).legs.size() <= 2) continue;
                        otherHasLegs = true;
                        break;
                    }
                    if (!hasLegs && !otherHasLegs) continue;
                    double myX = this.x + this.xSpeed * (double)futureTest;
                    double myY = (double)combat.landFormations.get(0).getVerticalPosition(this, (int)this.x, true) - this.groundOffset();
                    double myW = this.getBBWidth();
                    double myH = this.getBBHeight();
                    double ow = other.getBBWidth();
                    double oh = other.getBBHeight();
                    if (hasLegs && !Rect2D.intersects(this.x - myW / 2.0, this.y, myW * 2.0, myH + myW / 4.0, other.x, other.y, ow, oh) && Rect2D.intersects(myX - myW / 2.0, myY, myW * 2.0, myH + myW / 4.0, other.x, other.y, ow, oh)) {
                        brake = true;
                        break;
                    }
                    if (!otherHasLegs || Rect2D.intersects(this.x, this.y, myW, myH, other.x - ow / 2.0, other.y, ow * 2.0, oh + ow / 4.0) || !Rect2D.intersects(myX, myY, myW, myH, other.x - ow / 2.0, other.y, ow * 2.0, oh + ow / 4.0)) continue;
                    brake = true;
                    break;
                }
            }
            if (brake) {
                this.moveTo = new Pt(this.x, this.y);
                this.flipTo = this.flipped;
                this.commandPoints = Math.min(this.commandPointsRequired(), this.commandPoints + this.commandPointsRequired() / 2);
                this.braking = 500;
            }
        }
        if (this.moveTo != null) {
            boolean doFlip;
            boolean moveDirection = this.moveTo.x < this.x;
            boolean needToFlip = this.flipTo != this.flipped;
            boolean flipAtEnd = moveDirection == this.flipped;
            boolean nearEnd = Math.abs(this.moveTo.x - this.x) < 80.0;
            boolean bl = doFlip = needToFlip && (!flipAtEnd || nearEnd);
            if (doFlip && this.availableTurningCost() > 0 && this.canFlipSafely(combat)) {
                this.enginesRunning = true;
                this.flipMs += ms;
                if (this.flipMs >= this.availableTurningCost()) {
                    this.setFlipped(this.flipTo);
                    this.flipMs = 0;
                }
                this.yForce -= this.suspendiumForceForY(this.moveTo.y, false, 0.0, 0.0);
            } else {
                double ef = this.engineForceForX(this.moveTo.x);
                this.xForce += ef;
                this.enginesRunning = ef != 0.0;
                double adjF = ef * (Math.abs(this.moveTo.y - this.y) + 10.0) / (Math.abs(this.moveTo.x - this.x) + 10.0) * 1.8;
                double adjS = Math.abs(this.xSpeed) * (Math.abs(this.moveTo.y - this.y) + 10.0) / (Math.abs(this.moveTo.x - this.x) + 10.0) * 1.1;
                this.yForce -= this.suspendiumForceForY(this.moveTo.y, ef != 0.0, Math.abs(adjF), adjS);
            }
        } else {
            this.enginesRunning = false;
            this.yForce -= this.availableSuspendiumForce();
        }
        boolean bl = this.suspendiumRunning = !this.grounded();
        this.msSuspendiumOff = this.suspendiumRunning ? 0 : (this.msSuspendiumOff += ms);
        if (this.crashSize == 1) {
            combat.play("small_crash", this.getX() + this.getWidth() * 16 / 2, this.getY() + this.getHeight() * 16 / 2, 1.0);
        }
        if (this.crashSize == 2) {
            combat.play("large_crash", this.getX() + this.getWidth() * 16 / 2, this.getY() + this.getHeight() * 16 / 2, 2.0);
        }
        this.crashSize = 0;
        return false;
    }

    @Override
    public boolean removeMe() {
        return this.modules.isEmpty();
    }

    @Override
    public double elasticity() {
        return 0.5;
    }

    private double getAerodynamicHeight() {
        int msz = this.modules.size();
        double extraHeight = 0.0;
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            ArrayList<Leg.Spec> ls = m.type.getLegSpecs();
            if (ls.isEmpty()) continue;
            extraHeight = Math.max(extraHeight, ls.get((int)0).limbLength / 16.0);
        }
        return (double)this.getHeight() + extraHeight;
    }

    @Override
    public double horizontalAirFriction() {
        return 0.001 + this.getAerodynamicHeight() * 1.0 / (double)this.getWidth() * 0.002;
    }

    @Override
    public double verticalAirFriction() {
        return 0.001 + (double)this.getWidth() * 1.0 / this.getAerodynamicHeight() * 0.002;
    }

    @Override
    public int getCollisionMass() {
        return this.getWeight();
    }

    @Override
    public int getMass() {
        return this.getWeight();
    }

    @Override
    public boolean isImmobile() {
        return false;
    }

    @Override
    public double getBBWidth() {
        return this.getWidth() * 16;
    }

    @Override
    public double getBBHeight() {
        return this.getHeight() * 16;
    }

    @Override
    public boolean collidesWith(PhysicsRect b2) {
        if (b2 instanceof Foot && (((Foot)b2).ship == this || !((Foot)b2).isDown)) {
            return false;
        }
        if (b2 instanceof WheelBody) {
            if (((WheelBody)b2).ship == this) {
                return false;
            }
            return this.overlapsWith((WheelBody)b2);
        }
        if (b2 instanceof Airship) {
            return this.overlapsWith((Airship)b2);
        }
        if (b2 instanceof LandFormation) {
            return this.overlapsWith((LandFormation)b2, false);
        }
        return this.overlapsWith(b2);
    }

    public boolean collidesWith(PhysicsRect b2, boolean ignoreSoftThings) {
        if (b2 instanceof Airship) {
            return this.overlapsWith((Airship)b2);
        }
        if (b2 instanceof LandFormation) {
            return this.overlapsWith((LandFormation)b2, ignoreSoftThings);
        }
        return this.overlapsWith(b2);
    }

    @Override
    public void doCollision(Body b2, double hitEnergy, Combat combat, boolean atSpeed) {
        ArrayList<OverlappingTile> overlaps = b2 instanceof WheelBody ? this.overlaps((WheelBody)b2) : (b2 instanceof Airship ? this.overlaps((Airship)b2) : (b2 instanceof LandFormation ? this.overlaps((LandFormation)b2) : this.overlaps(b2)));
        if (overlaps.isEmpty()) {
            return;
        }
        if (b2 instanceof Foot && combat.sideOf(this) == combat.sideOf(((Foot)b2).ship)) {
            hitEnergy /= 4.0;
        }
        this.collideWith(overlaps, hitEnergy, combat, b2 instanceof LandFormation ? (LandFormation)b2 : null, b2 instanceof Airship ? (Airship)b2 : null, b2 instanceof LandFormation && !b2.isImmobile());
    }

    public boolean overlapsWith(WheelBody b2) {
        int tileW = this.getWidth();
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            double ty;
            Tile t = this.tiles.get(ti);
            double tx = this.x + (double)((this.flipped ? tileW - t.x - 1 : t.x) * 16);
            if (!b2.intersectsWithRect(tx, ty = this.y + (double)(t.y * 16), 16.0, 16.0)) continue;
            return true;
        }
        return false;
    }

    public boolean overlapsWith(LandFormation b2, boolean ignoreSoftThings) {
        int tileW = this.getWidth();
        double lfx = b2.x;
        double lfy = b2.y;
        int lfgw = b2.grid[0].length;
        int lfgh = b2.grid.length;
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            double tx = this.x + (double)((this.flipped ? tileW - t.x - 1 : t.x) * 16);
            double ty = this.y + (double)(t.y * 16);
            int lfgx = (int)Math.floor((tx - lfx) / 16.0);
            int lfgy = (int)Math.floor((ty - lfy) / 16.0);
            if (lfgy >= 0 && lfgy < lfgh && lfgx >= 0 && lfgx < lfgw && (ignoreSoftThings ? b2.grid[lfgy][lfgx].damageMultiplier > 0.4 : b2.grid[lfgy][lfgx].solid)) {
                return true;
            }
            if (lfgy + 1 >= 0 && lfgy + 1 < lfgh && lfgx + 1 >= 0 && lfgx + 1 < lfgw && (ignoreSoftThings ? b2.grid[lfgy + 1][lfgx + 1].damageMultiplier > 0.4 : b2.grid[lfgy + 1][lfgx + 1].solid)) {
                return true;
            }
            if (lfgy + 1 >= 0 && lfgy + 1 < lfgh && lfgx >= 0 && lfgx < lfgw && (ignoreSoftThings ? b2.grid[lfgy + 1][lfgx].damageMultiplier > 0.4 : b2.grid[lfgy + 1][lfgx].solid)) {
                return true;
            }
            if (lfgy < 0 || lfgy >= lfgh || lfgx + 1 < 0 || lfgx + 1 >= lfgw || !(ignoreSoftThings ? b2.grid[lfgy][lfgx + 1].damageMultiplier > 0.4 : b2.grid[lfgy][lfgx + 1].solid)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<OverlappingTile> overlaps(WheelBody b2) {
        ArrayList<OverlappingTile> overlaps = new ArrayList<OverlappingTile>();
        int tileW = this.getWidth();
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            double ty;
            Tile t = this.tiles.get(ti);
            double tx = this.x + (double)((this.flipped ? tileW - t.x - 1 : t.x) * 16);
            if (!b2.intersectsWithRect(tx, ty = this.y + (double)(t.y * 16), 16.0, 16.0)) continue;
            overlaps.add(new OverlappingTile(t, 0.3));
        }
        return overlaps;
    }

    private ArrayList<OverlappingTile> overlaps(LandFormation b2) {
        ArrayList<OverlappingTile> overlaps = new ArrayList<OverlappingTile>();
        int tileW = this.getWidth();
        double lfx = b2.x;
        double lfy = b2.y;
        int lfgw = b2.grid[0].length;
        int lfgh = b2.grid.length;
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            double tx = this.x + (double)((this.flipped ? tileW - t.x - 1 : t.x) * 16);
            double ty = this.y + (double)(t.y * 16);
            int lfgx = (int)Math.floor((tx - lfx) / 16.0);
            int lfgy = (int)Math.floor((ty - lfy) / 16.0);
            double damageMultiplier = 0.0;
            if (lfgy >= 0 && lfgy < lfgh && lfgx >= 0 && lfgx < lfgw && b2.grid[lfgy][lfgx].solid) {
                damageMultiplier = Math.max(damageMultiplier, b2.grid[lfgy][lfgx].damageMultiplier);
            }
            if (lfgy + 1 >= 0 && lfgy + 1 < lfgh && lfgx + 1 >= 0 && lfgx + 1 < lfgw && b2.grid[lfgy + 1][lfgx + 1].solid) {
                damageMultiplier = Math.max(damageMultiplier, b2.grid[lfgy + 1][lfgx + 1].damageMultiplier);
            }
            if (lfgy + 1 >= 0 && lfgy + 1 < lfgh && lfgx >= 0 && lfgx < lfgw && b2.grid[lfgy + 1][lfgx].solid) {
                damageMultiplier = Math.max(damageMultiplier, b2.grid[lfgy + 1][lfgx].damageMultiplier);
            }
            if (lfgy >= 0 && lfgy < lfgh && lfgx + 1 >= 0 && lfgx + 1 < lfgw && b2.grid[lfgy][lfgx + 1].solid) {
                damageMultiplier = Math.max(damageMultiplier, b2.grid[lfgy][lfgx + 1].damageMultiplier);
            }
            if (!(damageMultiplier > 0.0)) continue;
            overlaps.add(new OverlappingTile(t, damageMultiplier));
        }
        return overlaps;
    }

    public boolean overlapsWith(Airship b) {
        int tileW = this.getWidth();
        int bTileW = b.getWidth();
        double bx = b.x;
        double by = b.y;
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            double ty;
            int bty;
            Tile t = this.tiles.get(ti);
            double tx = this.flipped ? this.x + (double)((tileW - t.x - 1) * 16) : this.x + (double)(t.x * 16);
            int btx = b.flipped ? bTileW - 2 - (int)Math.floor((tx - bx) / 16.0) : (int)Math.floor((tx - bx) / 16.0);
            if (b.tileAt(btx, bty = (int)Math.floor(((ty = this.y + (double)(t.y * 16)) - by) / 16.0)) == null && b.tileAt(btx + 1, bty + 1) == null && b.tileAt(btx + 1, bty) == null && b.tileAt(btx, bty + 1) == null) continue;
            return true;
        }
        return false;
    }

    private ArrayList<OverlappingTile> overlaps(Airship b) {
        ArrayList<OverlappingTile> overlaps = new ArrayList<OverlappingTile>();
        int tileW = this.getWidth();
        int bTileW = b.getWidth();
        double bx = b.x;
        double by = b.y;
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            double ty;
            int bty;
            Tile t = this.tiles.get(ti);
            double tx = this.flipped ? this.x + (double)((tileW - t.x - 1) * 16) : this.x + (double)(t.x * 16);
            int btx = b.flipped ? bTileW - 2 - (int)Math.floor((tx - bx) / 16.0) : (int)Math.floor((tx - bx) / 16.0);
            if (b.tileAt(btx, bty = (int)Math.floor(((ty = this.y + (double)(t.y * 16)) - by) / 16.0)) == null && b.tileAt(btx + 1, bty + 1) == null && b.tileAt(btx + 1, bty) == null && b.tileAt(btx, bty + 1) == null) continue;
            overlaps.add(new OverlappingTile(t, 1.0));
        }
        return overlaps;
    }

    private boolean overlapsWith(PhysicsRect b2) {
        int tileW = this.getWidth();
        double bx = b2.x;
        double by = b2.y;
        double bw = b2.getBBWidth();
        double bh = b2.getBBHeight();
        if (this.flipped) {
            int tsz = this.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = this.tiles.get(ti);
                double tx = this.x + (double)((tileW - t.x - 1) * 16);
                double ty = this.y + (double)(t.y * 16);
                if (!Rect2D.intersects(bx, by, bw, bh, tx, ty, 16.0, 16.0)) continue;
                return true;
            }
        } else {
            int tsz = this.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = this.tiles.get(ti);
                double tx = this.x + (double)(t.x * 16);
                double ty = this.y + (double)(t.y * 16);
                if (!Rect2D.intersects(bx, by, bw, bh, tx, ty, 16.0, 16.0)) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<OverlappingTile> overlaps(Body b2) {
        ArrayList<OverlappingTile> overlaps = new ArrayList<OverlappingTile>();
        int tileW = this.getWidth();
        double bx = b2.x;
        double by = b2.y;
        double bw = b2.getBBWidth();
        double bh = b2.getBBHeight();
        if (this.flipped) {
            int tsz = this.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = this.tiles.get(ti);
                double tx = this.x + (double)((tileW - t.x - 1) * 16);
                double ty = this.y + (double)(t.y * 16);
                if (!Rect2D.intersects(bx, by, bw, bh, tx, ty, 16.0, 16.0)) continue;
                overlaps.add(new OverlappingTile(t, 1.0));
            }
        } else {
            int tsz = this.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = this.tiles.get(ti);
                double tx = this.x + (double)(t.x * 16);
                double ty = this.y + (double)(t.y * 16);
                if (!Rect2D.intersects(bx, by, bw, bh, tx, ty, 16.0, 16.0)) continue;
                overlaps.add(new OverlappingTile(t, 1.0));
            }
        }
        return overlaps;
    }

    private void collideWith(ArrayList<OverlappingTile> overlaps, double hitEnergy, Combat combat, LandFormation withLF, Airship withShip, boolean groundIsFloatingRock) {
        if (overlaps.isEmpty()) {
            return;
        }
        int dmg = (int)(hitEnergy * 0.8 / (double)overlaps.size()) - 1;
        if (withLF != null) {
            this.msSinceOnGround = 0;
            this.lastGrounded = withLF;
            this.collidedWithFloatingRock = groundIsFloatingRock;
        }
        int n = dmg > 8 ? 2 : (this.crashSize = dmg > 1 ? 1 : this.crashSize);
        if (this.crashSize == 2 && withShip != null) {
            this.justRammedBy.add(withShip);
        }
        if (withShip != null) {
            this.justCollidedWith.add(withShip);
        }
        if (dmg > 0) {
            int osz = overlaps.size();
            for (int ti = 0; ti < osz; ++ti) {
                OverlappingTile ot = overlaps.get(ti);
                Tile t = ot.tile;
                int aDmg = Math.max(0, (int)((double)dmg * ot.dmgMultiplier) - t.armour.type.getBlastDmgAbsorb(this.constructionBonuses) / 2 + t.armour.type.getPenDmgAbsorb(this.constructionBonuses) / 2);
                t.module.hp -= aDmg;
                t.armour.hp = Math.max(0, t.armour.hp - dmg / 4);
                List<ModuleType.FragmentImg> frags = t.armour.getFragments();
                if (!frags.isEmpty()) {
                    int nFrags = Math.min(4, dmg / 10 + 1);
                    ModuleType.FragmentImg fragI = frags.get(AGame.ANIM_R.nextInt(frags.size()));
                    for (int i = 0; i < nFrags; ++i) {
                        combat.fragments.add(new Fragment(fragI.img, this.getX() + this.gridXToWorldX(t.x, 1) * 16 + fragI.dx, this.getY() + t.y * 16 + fragI.dy, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, AGame.ANIM_R.nextDouble() * 0.2 - 0.1, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200)));
                    }
                }
                if (withLF == null || t.y != this.h - 1 || dmg <= 1 || AGame.ANIM_R.nextInt(3) != 0) continue;
                combat.particles.add(new Particle(Particle.Type.DUST, this.getX() + this.gridXToWorldX(t.x, 1) * 16 + 8, this.getY() + t.y * 16 + 8));
            }
        }
    }

    private boolean isValidDecalLocation(DecalType type, int x, int y) {
        for (int dy = 0; dy < type.h; ++dy) {
            for (int dx = 0; dx < type.w; ++dx) {
                Tile t = this.tileAt(x + dx, y + dy);
                if (t != null) continue;
                return false;
            }
        }
        return true;
    }

    private void clearInvalidDecals() {
        Iterator<Decal> it = this.decals.iterator();
        while (it.hasNext()) {
            Decal d = it.next();
            if (this.isValidDecalLocation(d.type, d.x, d.y)) continue;
            it.remove();
        }
    }

    public boolean canAddDecal(DecalType type, int x, int y) {
        if (!this.isValidDecalLocation(type, x, y)) {
            return false;
        }
        for (Decal d : this.decals) {
            if (x >= d.x + d.type.w || d.x >= x + type.w || y >= d.y + d.type.h || d.y >= y + type.h) continue;
            return false;
        }
        return true;
    }

    public void addDecal(DecalType type, int x, int y) {
        this.decals.add(new Decal(type, x, y));
    }

    public DecalType removeDecalAt(int x, int y) {
        for (Decal d : this.decals) {
            if (d.x > x || d.y > y || d.x + d.type.w <= x || d.y + d.type.h <= y) continue;
            this.decals.remove(d);
            return d.type;
        }
        return null;
    }

    public boolean frontObstructed(ModuleType type, int x, int y) {
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (!type.isFrontOnly() || bLeftEdge < aRightEdge || aBottomEdge <= bTopEdge || aTopEdge >= bBottomEdge) continue;
            return true;
        }
        return false;
    }

    public Module frontObstructing(ModuleType type, int x, int y) {
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (!m.type.isFrontOnly() || aLeftEdge <= bLeftEdge || aBottomEdge <= bTopEdge || aTopEdge >= bBottomEdge) continue;
            return m;
        }
        return null;
    }

    public boolean backObstructed(ModuleType type, int x, int y) {
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (!type.isBackOnly() || bLeftEdge >= aRightEdge || aBottomEdge <= bTopEdge || aTopEdge >= bBottomEdge) continue;
            return true;
        }
        return false;
    }

    public Module backObstructing(ModuleType type, int x, int y) {
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (!m.type.isBackOnly() || aLeftEdge >= bLeftEdge || aBottomEdge <= bTopEdge || aTopEdge >= bBottomEdge) continue;
            return m;
        }
        return null;
    }

    public boolean bottomObstructed(ModuleType type, int x, int y) {
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (!type.isBottomOnly() || aBottomEdge > bTopEdge || aRightEdge <= bLeftEdge || aLeftEdge >= bRightEdge) continue;
            return true;
        }
        return false;
    }

    public Module bottomObstructing(ModuleType type, int x, int y) {
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (!m.type.isBottomOnly() || bBottomEdge > aTopEdge || bRightEdge <= aLeftEdge || bLeftEdge >= aRightEdge) continue;
            return m;
        }
        return null;
    }

    public boolean topObstructed(ModuleType type, int x, int y) {
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (!type.isTopOnly() || aTopEdge < bBottomEdge || aRightEdge <= bLeftEdge || aLeftEdge >= bRightEdge) continue;
            return true;
        }
        return false;
    }

    public Module topObstructing(ModuleType type, int x, int y) {
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (!m.type.isTopOnly() || bTopEdge < aBottomEdge || bRightEdge <= aLeftEdge || bLeftEdge >= aRightEdge) continue;
            return m;
        }
        return null;
    }

    public boolean noModuleOverlapsOrObstructions(ModuleType type, int x, int y) {
        if (this.modules.isEmpty()) {
            return true;
        }
        for (Module m : this.modules) {
            int aLeftEdge = x;
            int aRightEdge = x + type.getW();
            int aTopEdge = y;
            int aBottomEdge = y + type.getH();
            int bLeftEdge = m.x;
            int bRightEdge = m.x + m.type.getW();
            int bTopEdge = m.y;
            int bBottomEdge = m.y + m.type.getH();
            if (aRightEdge > bLeftEdge && aLeftEdge < bRightEdge && aBottomEdge > bTopEdge && aTopEdge < bBottomEdge) {
                return false;
            }
            if (type.isBackOnly() && bLeftEdge < aRightEdge && aBottomEdge > bTopEdge && aTopEdge < bBottomEdge) {
                return false;
            }
            if (type.isFrontOnly() && bLeftEdge >= aRightEdge && aBottomEdge > bTopEdge && aTopEdge < bBottomEdge) {
                return false;
            }
            if (type.isBottomOnly() && aBottomEdge <= bTopEdge && aRightEdge > bLeftEdge && aLeftEdge < bRightEdge) {
                return false;
            }
            if (type.isTopOnly() && aTopEdge >= bBottomEdge && aRightEdge > bLeftEdge && aLeftEdge < bRightEdge) {
                return false;
            }
            if (m.type.isBackOnly() && aLeftEdge < bLeftEdge && aBottomEdge > bTopEdge && aTopEdge < bBottomEdge) {
                return false;
            }
            if (m.type.isFrontOnly() && aLeftEdge > bLeftEdge && aBottomEdge > bTopEdge && aTopEdge < bBottomEdge) {
                return false;
            }
            if (m.type.isBottomOnly() && bBottomEdge <= aTopEdge && bRightEdge > aLeftEdge && bLeftEdge < aRightEdge) {
                return false;
            }
            if (!m.type.isTopOnly() || bTopEdge < aBottomEdge || bRightEdge <= aLeftEdge || bLeftEdge >= aRightEdge) continue;
            return false;
        }
        return true;
    }

    public boolean canAddModule(ModuleType type, int x, int y) {
        if (this.modules.isEmpty()) {
            return true;
        }
        if (!this.noModuleOverlapsOrObstructions(type, x, y)) {
            return false;
        }
        boolean borders = false;
        boolean passableTile = false;
        block0: for (Module m : this.modules) {
            if (m.x + m.type.getW() > x && m.x < x + type.getW() && (m.y + m.type.getH() == y || m.y == y + type.getH())) {
                borders = true;
            }
            if (m.y + m.type.getH() > y && m.y < y + type.getH() && (m.x + m.type.getW() == x || m.x == x + type.getW())) {
                borders = true;
            }
            if (type.isOccupable() && this.isOccupable()) {
                for (int ady = 0; ady < type.getH(); ++ady) {
                    for (int adx = 0; adx < type.getW(); ++adx) {
                        if (!type.canOccupy(adx, ady)) continue;
                        for (int bdy = 0; bdy < m.type.getH(); ++bdy) {
                            for (int bdx = 0; bdx < m.type.getW(); ++bdx) {
                                if (!m.type.canOccupy(bdx, bdy)) continue;
                                for (int[] adj : ADJ) {
                                    if (x + adx + adj[0] != m.x + bdx || y + ady + adj[1] != m.y + bdy) continue;
                                    passableTile = true;
                                    continue block0;
                                }
                            }
                        }
                    }
                }
                continue;
            }
            passableTile = true;
        }
        if (passableTile && type.isOccupable() && this.isOccupable()) {
            Tile toTheLeft;
            passableTile = false;
            boolean[] leftDoors = type.getLeftDoors();
            for (int i = 0; !(i >= leftDoors.length || leftDoors[i] && (toTheLeft = this.tileAt(x - 1, y + i)) != null && (passableTile = toTheLeft.module.type.getRightDoors()[i - toTheLeft.module.y + y])); ++i) {
            }
            if (!passableTile) {
                Tile toTheRight;
                boolean[] rightDoors = type.getRightDoors();
                for (int i = 0; !(i >= rightDoors.length || rightDoors[i] && (toTheRight = this.tileAt(x + type.getW(), y + i)) != null && (passableTile = toTheRight.module.type.getLeftDoors()[i - toTheRight.module.y + y])); ++i) {
                }
            }
            if (!passableTile) {
                boolean[] upDoors = type.getUpDoors();
                for (int i = 0; i < upDoors.length; ++i) {
                    if (!upDoors[i]) continue;
                    Tile up = this.tileAt(x + i, y - 1);
                    boolean bl = passableTile = up != null;
                    if (passableTile) break;
                }
            }
            if (!passableTile) {
                Tile down;
                for (int i = 0; !(i >= type.getW() || (down = this.tileAt(x + i, y + type.getH())) != null && (passableTile = down.module.type.getUpDoors()[i - down.module.x + x])); ++i) {
                }
            }
        }
        return borders && passableTile;
    }

    public void addModule(ModuleType type, int x, int y, ArmourType at) {
        if (type.isExternal()) {
            at = ArmourType.NONE;
        }
        Module m = new Module(this, type, x, y);
        this.modules.add(m);
        for (int dy = 0; dy < type.getH(); ++dy) {
            for (int dx = 0; dx < type.getW(); ++dx) {
                Tile t = new Tile(this, m, x + dx, y + dy);
                t.armour.setType(at);
                this.tiles.add(t);
            }
        }
        this.layout();
        this.resetCrew();
        this.paths.clear();
        this.tilePaths.clear();
        this.repair();
    }

    public boolean isOccupable() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isOccupable()) continue;
            return true;
        }
        return false;
    }

    public void repair() {
        this.recalcHPs();
        for (Tile t : this.tiles) {
            t.armour.repair();
        }
        for (Module m : this.modules) {
            m.repairFully();
        }
        for (Decal d : this.decals) {
            d.enabled = true;
        }
        this.fireAt = null;
        this.board = null;
        this.assignJobsMs = 300;
        this.moveTo = new Pt(0.0, 0.0);
        this.sitting = false;
        this.focusOnFirefighting = false;
        this.focusOnRepair = false;
        this.focusOnShooting = true;
        this.msSinceOnGround = 10000;
        this.xSpeed = 0.0;
        this.ySpeed = 0.0;
        this.xForce = 0.0;
        this.yForce = 0.0;
        this.captured = false;
        this.resetCrew();
        this.assignJobs();
        this.commandPoints = this.commandPointsRequired();
        this.chunkSubIDCounter = 1;
        this.stuckParticles.clear();
    }

    public boolean canRemoveModuleAt(int x, int y) {
        if (this.modules.size() == 1) {
            return true;
        }
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.x > x || m.y > y || m.x + m.type.getW() <= x || m.y + m.type.getH() <= y) continue;
            return this.isAtEdge(m) && this.canRemoveCleanly(m);
        }
        return true;
    }

    private boolean isAtEdge(Module m) {
        for (int tx = m.x; tx < m.x + m.type.getW(); ++tx) {
            if (this.tileAt(tx, m.y - 1) != null && this.tileAt(tx, m.y + m.type.getH()) != null) continue;
            return true;
        }
        for (int ty = m.y; ty < m.y + m.type.getH(); ++ty) {
            if (this.tileAt(m.x - 1, ty) != null && this.tileAt(m.x + m.type.getW(), ty) != null) continue;
            return true;
        }
        return false;
    }

    private boolean canRemoveCleanly(Module m) {
        return this.pathChunks(m).size() == 1;
    }

    public Module removeModuleAt(int x, int y) {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.x > x || m.y > y || m.x + m.type.getW() <= x || m.y + m.type.getH() <= y) continue;
            this.removeModule(m);
            this.repair();
            this.layout();
            return m;
        }
        return null;
    }

    public void removeModule(Module m) {
        this.modules.remove(m);
        Iterator<Tile> it = this.tiles.iterator();
        while (it.hasNext()) {
            if (it.next().module != m) continue;
            it.remove();
        }
        this.layout();
        this.resetCrew();
        this.paths.clear();
        this.tilePaths.clear();
        this.assignJobs();
        this.recalcHPs();
    }

    private void recalcHPs() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            m.calcMaxHP();
        }
    }

    private void layout() {
        double oldX = this.x;
        double oldY = this.y;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            minX = Math.min(minX, m.x);
            minY = Math.min(minY, m.y);
            maxX = Math.max(maxX, m.x + m.type.getW());
            maxY = Math.max(maxY, m.y + m.type.getH());
        }
        int xShift = -minX;
        int yShift = -minY;
        int flippedXShift = this.w - maxX;
        this.w = maxX - minX;
        this.h = maxY - minY;
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            m.x += xShift;
            m.y += yShift;
        }
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = this.tiles.get(ti);
            t.x += xShift;
            t.y += yShift;
        }
        int dsz = this.decals.size();
        for (int di = 0; di < dsz; ++di) {
            Decal d = this.decals.get(di);
            d.x += xShift;
            d.y += yShift;
        }
        this.x = this.flipped ? (this.x += (double)(flippedXShift * 16)) : (this.x -= (double)(xShift * 16));
        this.y -= (double)(yShift * 16);
        for (Particle p : this.stuckParticles) {
            p.x = p.x + oldX - this.x;
            p.y = p.y + oldY - this.y;
        }
        this.calcAdjacency();
        this.regenerateTileGrid();
        this.clearInvalidDecals();
        this.removeUnstuckParticles();
    }

    private void regenerateTileGrid() {
        this.tileGrid = new Tile[this.h][this.w];
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t;
            this.tileGrid[t.y][t.x] = t = this.tiles.get(ti);
        }
    }

    private void calcAdjacency() {
        int tsz = this.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t1 = this.tiles.get(ti);
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    boolean adj = false;
                    for (int ti2 = 0; ti2 < tsz; ++ti2) {
                        Tile t2 = this.tiles.get(ti2);
                        if (t2.x != t1.x + dx || t2.y != t1.y + dy) continue;
                        adj = true;
                        break;
                    }
                    t1.adjacent[dy + 1][dx + 1] = adj;
                }
            }
        }
    }

    private void resetCrew() {
        int i;
        this.crew.clear();
        this.boarders.clear();
        int crewAvailable = this.getQuartered(CrewType.SAILOR);
        for (Module m : this.modules) {
            for (int i2 = 0; i2 < m.type.getCrew(); ++i2) {
                if (crewAvailable-- == 0) {
                    return;
                }
                this.crew.add(new Crewman(this, this.getMostEmptyTile(m), CrewType.SAILOR));
            }
        }
        boolean opts = false;
        for (Module m : this.modules) {
            opts = opts || m.type.getOptionalCrew() > 0;
        }
        block3: while (opts && crewAvailable > 0) {
            for (Module m : this.modules) {
                if (m.type.getOptionalCrew() <= 0) continue;
                if (crewAvailable-- == 0) break block3;
                this.crew.add(new Crewman(this, this.getMostEmptyTile(m), CrewType.SAILOR));
            }
        }
        block5: while (crewAvailable > 0) {
            for (Module m : this.modules) {
                if (m.type.getQuarters() <= 0 || m.type.getQuartersType() != CrewType.SAILOR) continue;
                if (crewAvailable-- == 0) break block5;
                this.crew.add(new Crewman(this, this.getMostEmptyTile(m), CrewType.SAILOR));
            }
        }
        for (Module m : this.modules) {
            m.numGuardsTmp = 0;
        }
        block8: for (CrewType ct : new CrewType[]{CrewType.GUARD, CrewType.MARINE}) {
            crewAvailable = this.getQuartered(ct);
            for (Module m : this.modules) {
                if (m.type.getFixedGuards() <= 0 || m.numGuardsTmp != 0) continue;
                if (crewAvailable-- <= 0) break;
                this.crew.add(new Crewman(this, this.getMostEmptyTile(m), ct));
                ++m.numGuardsTmp;
            }
            block10: for (int guardIndex = 3; guardIndex > 0; --guardIndex) {
                for (Module m : this.modules) {
                    if (m.type.getRecommendedGuards() < guardIndex || m.numGuardsTmp >= m.type.getRecommendedGuards()) continue;
                    if (crewAvailable-- <= 0) break block10;
                    this.crew.add(new Crewman(this, this.getMostEmptyTile(m), ct));
                    ++m.numGuardsTmp;
                }
            }
            while (crewAvailable > 0) {
                for (Module m : this.modules) {
                    if (m.type.getQuarters() <= 0 || m.type.getQuartersType() != ct) continue;
                    if (crewAvailable-- <= 0) continue block8;
                    this.crew.add(new Crewman(this, this.getMostEmptyTile(m), ct));
                }
            }
        }
        for (Module m : this.modules) {
            if (m.type.getQuarters() <= 0 || m.type.getQuartersType() != CrewType.GRENADIER) continue;
            for (i = 0; i < m.type.getQuarters(); ++i) {
                this.crew.add(new Crewman(this, this.getMostEmptyTile(m), CrewType.GRENADIER));
            }
        }
        for (Module m : this.modules) {
            if (m.type.getQuarters() <= 0 || m.type.getQuartersType() != CrewType.ARACHNID) continue;
            for (i = 0; i < m.type.getQuarters(); ++i) {
                this.crew.add(new Crewman(this, this.getMostEmptyTile(m), CrewType.ARACHNID));
            }
        }
    }

    public ArrayList<Tile> getPath(Tile src, Tile target) {
        if (!this.tilePaths.containsKey(src) || !this.tilePaths.get(src).containsKey(target)) {
            this.calcTilePathsForTarget(target);
        }
        return this.tilePaths.containsKey(src) ? this.tilePaths.get(src).get(target) : null;
    }

    public ArrayList<Tile> getPath(Tile src, Module target) {
        if (!this.paths.containsKey(src) || !this.paths.get(src).containsKey(target)) {
            this.calcPathsForTarget(target);
        }
        return this.paths.containsKey(src) ? this.paths.get(src).get(target) : null;
    }

    private void calcTilePathsForTarget(Tile target) {
        if (!target.canOccupy) {
            return;
        }
        LinkedList<Tile> tileQ = new LinkedList<Tile>();
        HashSet<Tile> tileQSet = new HashSet<Tile>();
        for (Tile t : this.tiles) {
            t.pathCostTmp = 0x1FFFFFFF;
        }
        target.pathCostTmp = 0;
        tileQ.add(target);
        tileQSet.add(target);
        while (!tileQ.isEmpty()) {
            Tile t = (Tile)tileQ.pollFirst();
            tileQSet.remove(t);
            for (int[] adj : ADJ) {
                Tile t2;
                if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                    if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                        continue;
                    }
                } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp <= t.pathCostTmp + t2.getMoveDelay() || t2.module != t.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                t2.pathCostTmp = t.pathCostTmp + t2.getMoveDelay();
                if (tileQSet.contains(t2)) continue;
                tileQ.add(t2);
                tileQSet.add(t2);
            }
        }
        for (Tile source : this.tiles) {
            if (!source.canOccupy) continue;
            ArrayList<Tile> path = new ArrayList<Tile>();
            Tile t = source;
            while (t.pathCostTmp > 0) {
                Tile best = null;
                int lowest = t.pathCostTmp;
                for (int[] adj : ADJ) {
                    Tile t2;
                    if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                        if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                            continue;
                        }
                    } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                    if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp >= lowest || t2.module != source.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                    best = t2;
                    lowest = t2.pathCostTmp;
                }
                if (best == null) {
                    path = null;
                    break;
                }
                t = best;
                path.add(best);
            }
            if (!this.tilePaths.containsKey(source)) {
                this.tilePaths.put(source, new HashMap());
            }
            this.tilePaths.get(source).put(target, path);
        }
    }

    private void calcPathsForTarget(Module target) {
        LinkedList<Tile> tileQ = new LinkedList<Tile>();
        HashSet<Tile> tileQSet = new HashSet<Tile>();
        for (Tile t : this.tiles) {
            if (t.module == target && t.canOccupy) {
                t.pathCostTmp = 0;
                tileQ.add(t);
                tileQSet.add(t);
                continue;
            }
            t.pathCostTmp = 0x1FFFFFFF;
        }
        while (!tileQ.isEmpty()) {
            Tile t = (Tile)tileQ.pollFirst();
            tileQSet.remove(t);
            for (int[] adj : ADJ) {
                Tile t2;
                if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                    if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                        continue;
                    }
                } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp <= t.pathCostTmp + t2.getMoveDelay() || t2.module != t.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                t2.pathCostTmp = t.pathCostTmp + t2.getMoveDelay();
                if (tileQSet.contains(t2)) continue;
                tileQ.add(t2);
                tileQSet.add(t2);
            }
        }
        for (Tile source : this.tiles) {
            if (!source.canOccupy) continue;
            ArrayList<Tile> path = new ArrayList<Tile>();
            Tile t = source;
            while (t.pathCostTmp > 0) {
                Tile best = null;
                int lowest = t.pathCostTmp;
                for (int[] adj : ADJ) {
                    Tile t2;
                    if (adj[0] == -1 && adj[1] == 0 && t.x == t.module.x) {
                        if (!t.module.type.getLeftDoors()[t.y - t.module.y]) {
                            continue;
                        }
                    } else if (adj[0] != 1 || adj[1] != 0 || t.x != t.module.x + t.module.type.getW() - 1 ? adj[0] == 0 && adj[1] == -1 && t.y == t.module.y && !t.module.type.getUpDoors()[t.x - t.module.x] : !t.module.type.getRightDoors()[t.y - t.module.y]) continue;
                    if ((t2 = this.tileAt(t.x + adj[0], t.y + adj[1])) == null || !t2.canOccupy || t2.pathCostTmp >= lowest || t2.module != t.module && (adj[0] == -1 && adj[1] == 0 ? !t2.module.type.getRightDoors()[t2.y - t2.module.y] : (adj[0] == 1 && adj[1] == 0 ? !t2.module.type.getLeftDoors()[t2.y - t2.module.y] : adj[0] == 0 && adj[1] == 1 && !t2.module.type.getUpDoors()[t2.x - t2.module.x]))) continue;
                    best = t2;
                    lowest = t2.pathCostTmp;
                }
                if (best == null) {
                    path = null;
                    break;
                }
                t = best;
                path.add(best);
            }
            if (!this.paths.containsKey(source)) {
                this.paths.put(source, new HashMap());
            }
            this.paths.get(source).put(target, path);
        }
    }

    public boolean shouldSwitchSides() {
        int msz = this.modules.size();
        int bsz = this.boarders.size();
        int csz = this.crew.size();
        if (bsz == 0) {
            return false;
        }
        boolean hasCrewInCommandCenter = false;
        boolean hasBoarderInCommandCenter = false;
        boolean hasFunctioningCommandCenter = false;
        block0: for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.hp <= 0 || m.type.getCommand() <= 0) continue;
            hasFunctioningCommandCenter = true;
            if (!hasCrewInCommandCenter) {
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman c = this.crew.get(ci);
                    if (c.currentTile.module != m || !c.active()) continue;
                    hasCrewInCommandCenter = true;
                    break;
                }
            }
            if (hasBoarderInCommandCenter) continue;
            for (int bi = 0; bi < bsz; ++bi) {
                Crewman b = this.boarders.get(bi);
                if (b.currentTile.module != m || !b.active()) continue;
                hasBoarderInCommandCenter = true;
                continue block0;
            }
        }
        if (hasBoarderInCommandCenter && !hasCrewInCommandCenter) {
            return true;
        }
        if (hasFunctioningCommandCenter) {
            return false;
        }
        for (int i = 0; i < csz; ++i) {
            if (this.crew.get((int)i).type == CrewType.SAILOR || !this.crew.get(i).active()) continue;
            return false;
        }
        return true;
    }

    public void switchSides() {
        ArrayList<Crewman> oldBoarders = new ArrayList<Crewman>();
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman c = this.crew.get(ci);
            c.abandonJob();
            if (c.type != CrewType.SAILOR) {
                oldBoarders.add(c);
                c.ship = null;
                c.boardingShip = this;
                continue;
            }
            c.occupied = !c.occupied;
        }
        int bsz = this.boarders.size();
        for (int bi = 0; bi < bsz; ++bi) {
            Crewman b = this.boarders.get(bi);
            b.abandonJob();
            b.ship = this;
            b.boardingShip = null;
        }
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            this.modules.get((int)mi).prevTargetShip = null;
        }
        this.crew.removeAll(oldBoarders);
        this.crew.addAll(this.boarders);
        this.boarders.clear();
        this.boarders.addAll(oldBoarders);
        this.captured = !this.captured;
        this.assignJobs();
    }

    private void assignJobs() {
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman c = this.crew.get(ci);
            if (c.job == null || c.ultimateBoardTarget != null || c.job.active() && (!c.occupied || !c.job.requiredUnoccupied())) continue;
            c.abandonJob();
        }
        ArrayList<Job> jobs = new ArrayList<Job>();
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            ArrayList<Job> mjobs = m.jobs();
            int jsz = mjobs.size();
            block2: for (int ji = 0; ji < jsz; ++ji) {
                Job j = mjobs.get(ji);
                if (!j.active()) continue;
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman c = this.crew.get(ci);
                    if (c.job == j) continue block2;
                }
                jobs.add(j);
            }
        }
        Collections.sort(jobs, this);
        int jsz = jobs.size();
        for (int ji = 0; ji < jsz; ++ji) {
            Job job = (Job)jobs.get(ji);
            ArrayList<Module> targetModules = new ArrayList<Module>();
            if (job.resource() == null) {
                targetModules.add(job.module());
            } else {
                for (int mi = 0; mi < msz; ++mi) {
                    Module m = this.modules.get(mi);
                    if (m.getResource(job.resource()) <= 0) continue;
                    targetModules.add(m);
                }
            }
            ArrayList<Crewman> targetCrew = new ArrayList<Crewman>();
            if (job.resource() == Resource.INJURED) {
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman c = this.crew.get(ci);
                    if (!c.needsRescue()) continue;
                    targetCrew.add(c);
                }
            }
            if (targetModules.isEmpty() && targetCrew.isEmpty()) continue;
            Crewman best = null;
            Crewman targetCM = null;
            int leastdist = 0;
            for (int attempt = 0; attempt < 2; ++attempt) {
                for (int ci = 0; ci < csz; ++ci) {
                    boolean suitable;
                    Crewman c = this.crew.get(ci);
                    if (!c.active()) continue;
                    int d = Integer.MAX_VALUE;
                    boolean bl = c.ultimateBoardTarget == null && job.requiredType(c.type) && (!c.occupied || !job.requiredUnoccupied()) && (attempt == 0 ? c.job == null || c.job.unimportant() && !job.unimportant() : c.job != null && c.job.priority() < job.priority() * 0.3) ? true : (suitable = false);
                    if (!suitable) continue;
                    int tmsz = targetModules.size();
                    for (int tmi = 0; tmi < tmsz; ++tmi) {
                        ArrayList<Tile> modulePath;
                        Module m = (Module)targetModules.get(tmi);
                        ArrayList<Tile> path = this.getPath(c.currentTile, m);
                        if (path == null || (modulePath = this.getPath(path.isEmpty() ? c.currentTile : path.get(path.size() - 1), job.module())) == null) continue;
                        d = Math.min(d, path.size() + modulePath.size());
                    }
                    int tcsz = targetCrew.size();
                    for (int tci = 0; tci < tcsz; ++tci) {
                        int myD;
                        ArrayList<Tile> pathFrom;
                        Crewman tc = (Crewman)targetCrew.get(tci);
                        ArrayList<Tile> pathTo = this.getPath(c.currentTile, tc.currentTile);
                        if (pathTo == null || (pathFrom = this.getPath(tc.currentTile, job.module())) == null || (myD = pathTo.size() + pathFrom.size()) >= d) continue;
                        d = myD;
                        targetCM = tc;
                    }
                    d = d * 10 / c.hp;
                    if (best != null && d >= leastdist) continue;
                    best = c;
                    leastdist = d;
                }
            }
            if (best == null) continue;
            best.abandonJob();
            best.job = job;
            best.headingFor = targetCM;
        }
        block11: for (int ci = 0; ci < csz; ++ci) {
            Crewman c = this.crew.get(ci);
            if (c.job == null || !(c.job instanceof Module.StaffJob) || c.job.module().type.getClip() <= 0 || c.job.module().ammoLeft != 0) continue;
            for (int ci2 = 0; ci2 < csz; ++ci2) {
                Crewman c2 = this.crew.get(ci2);
                if (c2.job != null && c2.job instanceof Module.AmmoJob && c2.job.module() == c.job.module()) continue block11;
            }
            ArrayList<Job> js = c.job.module().jobs();
            jsz = js.size();
            for (int ji = 0; ji < jsz; ++ji) {
                Job j = js.get(ji);
                if (!(j instanceof Module.AmmoJob) || !j.active()) continue;
                c.abandonJob();
                c.job = j;
                continue block11;
            }
        }
    }

    public Tile getMostEmptyTile(Module m) {
        Tile t = null;
        int minOccupancy = 0;
        for (int dy = m.type.getH() - 1; dy >= 0; --dy) {
            for (int dx = 0; dx < m.type.getW(); ++dx) {
                Tile t2 = this.tileAt(m.x + dx, m.y + dy);
                if (!t2.canOccupy) continue;
                int occupancy = 0;
                for (Crewman c : this.crew) {
                    occupancy += c.currentTile == t2 ? 1 : 0;
                }
                if (t != null && occupancy >= minOccupancy) continue;
                t = t2;
                minOccupancy = occupancy;
            }
        }
        return t;
    }

    public Tile tileAt(int x, int y) {
        if (this.tileGrid == null) {
            for (Tile t : this.tiles) {
                if (t.x != x || t.y != y) continue;
                return t;
            }
            return null;
        }
        if (x < 0 || y < 0 || x >= this.w || y >= this.h) {
            return null;
        }
        return this.tileGrid[y][x];
    }

    public boolean hit(Shot shot, Combat c) {
        int tileY;
        int tileX = (int)((this.flipped ? (double)(this.getWidth() * 16) - (shot.tX - (double)this.getX()) : shot.tX - (double)this.getX()) / 16.0);
        Tile t = this.tileAt(tileX, tileY = (int)((shot.tY - (double)this.getY()) / 16.0));
        if (t != null) {
            t.hit(shot, c);
            return true;
        }
        return false;
    }

    public ArrayList<Module> getModules() {
        return this.modules;
    }

    @Override
    public int compare(Job j1, Job j2) {
        return Double.compare(j2.priority(), j1.priority());
    }

    public ArrayList<Crewman> getCrew() {
        return this.crew;
    }

    public double danger() {
        double danger = 0.0;
        if (!this.canShoot()) {
            return 0.0;
        }
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.hp <= 0 || !m.type.isWeapon()) continue;
            danger += (double)((m.type.getPenDmg() + m.type.getBlastDmg(this.currentBonuses)) * 1000 / m.type.getReload());
        }
        int cms = 0;
        int csz = this.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman c = this.crew.get(ci);
            if (!c.active()) continue;
            ++cms;
        }
        return danger * (double)cms;
    }

    public void commandGiven() {
        this.commandPoints = 0;
        this.wasReadyForCommand = false;
    }

    public boolean readyForCommand() {
        return this.commandPoints >= this.commandPointsRequired() && this.commandPointsGenerated() > 0;
    }

    public int commandPointsRequired() {
        int cps = 500 + this.crew.size() * 50;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            cps += m.type.getW() * m.type.getH() * 5;
        }
        return cps;
    }

    public int commandPointsGenerated() {
        int cp = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type.getCommand() <= 0 || !m.running()) continue;
            cp = (int)((double)cp + (double)m.type.getCommand() * m.staffProportion());
        }
        int cps = (int)Math.ceil(Math.log((double)cp * 1.5) * 4.0);
        if (this.currentBonuses.contains((Object)Bonus.FASTER_COMMANDS)) {
            cps *= 2;
        }
        return Math.max(0, cps);
    }

    public boolean canFirefight() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.getResource(Resource.WATER) <= 0 || m.hp <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canRepair() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.getResource(Resource.REPAIR) <= 0 || m.hp <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canMove() {
        Module m;
        int mi;
        boolean propel = false;
        int msz = this.modules.size();
        for (mi = 0; mi < msz; ++mi) {
            m = this.modules.get(mi);
            if (!(m.type.getPropulsion() > 0.0) || m.hp <= 0) continue;
            propel = true;
        }
        for (mi = 0; mi < msz; ++mi) {
            m = this.modules.get(mi);
            if (m.getResource(Resource.COAL) <= 0 || m.hp <= 0) continue;
            return propel;
        }
        return false;
    }

    public boolean isArmedCountingDamagedWeapons() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isWeapon()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRam() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.type != ModuleType.RAM && m.type != ModuleType.GRAND_RAM) continue;
            return true;
        }
        return false;
    }

    public boolean isArmed() {
        int msz = this.modules.size();
        boolean hasCoal = this.getTotalResource(Resource.COAL) > 0;
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.isWeapon() || m.hp <= 0) continue;
            if (m.type.getCoalReload() > 0) {
                if (!hasCoal) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean canShoot() {
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (m.getResource(Resource.AMMO) <= 0 || m.hp <= 0) continue;
            return this.isArmed();
        }
        return false;
    }

    public int availableLift() {
        int n = 0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.type.hasLift() || !m.canRun()) continue;
            n += m.type.getLift(this.constructionBonuses);
        }
        return n;
    }

    public double availableSuspendiumForce() {
        double distanceFromFloor = 512.0 - this.y;
        return (double)(this.availableLift() * 300 * 2) / (300.0 + distanceFromFloor) * 0.001;
    }

    public double engineForceForX(double tx) {
        int startSlowingDown;
        int n = startSlowingDown = this.type.onGround ? 10 : (int)Math.min(1200.0, 10.0 + 210.0 / this.getSpeed() * (Math.abs(this.xSpeed) + 0.01) / this.getSpeed());
        if (this.type.onGround && Math.abs(tx - this.x) < 12.0) {
            return 0.0;
        }
        if (Math.abs(this.x - tx) > this.availableSpeed() * (double)startSlowingDown) {
            if (tx > this.x) {
                return this.availablePropulsion();
            }
            return -this.availablePropulsion();
        }
        double simX = this.x;
        double speedEpsilon = 0.001;
        double simXSpeed = this.xSpeed;
        int ms = 64;
        int ticks = 0;
        while (Math.abs(simXSpeed) > speedEpsilon && ticks++ < 100) {
            double airSlowdown = simXSpeed * simXSpeed * this.horizontalAirFriction() * (double)ms + this.ySpeed * this.ySpeed * this.verticalAirFriction() * (double)ms;
            if (simXSpeed > 0.0) {
                simXSpeed -= airSlowdown;
            }
            if (simXSpeed < 0.0) {
                simXSpeed += airSlowdown;
            }
            simX += simXSpeed * (double)ms;
        }
        double posEpsilon = 3.0;
        if (Math.abs(simX - tx) < posEpsilon) {
            return 0.0;
        }
        if (tx > simX) {
            return this.availablePropulsion();
        }
        return -this.availablePropulsion();
    }

    public double suspendiumForceForY(double ty, boolean hasPreferredDelta, double preferredDelta, double maxSpeed) {
        double f = Math.abs(this.ySpeed) < Math.max(maxSpeed, 0.15) ? (ty > this.y ? (hasPreferredDelta ? Math.max(0.0, (double)this.getMass() * 0.001 - preferredDelta) : (double)this.getMass() * 0.001 * 0.88) : (hasPreferredDelta ? (double)this.getMass() * 0.001 + preferredDelta : (double)this.getMass() * 0.001 / 0.88)) : (double)this.getMass() * 0.001;
        return Math.min(this.availableSuspendiumForce(), f);
    }

    public int availableServiceCeiling() {
        if (this.getMass() == 0) {
            return 0;
        }
        return this.availableLift() * 300 * 2 / this.getMass() - 300;
    }

    public int realServiceCeiling() {
        return this.serviceCeiling() - this.getHeight() * 16;
    }

    public int serviceCeiling() {
        if (this.getMass() == 0) {
            return 0;
        }
        return this.getLift() * 300 * 2 / this.getMass() - 300;
    }

    public int turningCost() {
        int as = (int)Math.ceil(this.getSpeed());
        if (as == 0) {
            return 0;
        }
        return 5 + this.w * 15 + 500 / as + this.getWeight() / 10;
    }

    public int availableTurningCost() {
        int as = (int)Math.ceil(this.availableSpeed());
        if (as == 0) {
            return 0;
        }
        return 5 + this.w * 15 + 500 / as + this.getWeight() / 10;
    }

    public double getPropulsion() {
        double prop = 0.0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            prop += m.type.getPropulsion();
        }
        return prop;
    }

    public double availablePropulsion() {
        double prop = 0.0;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            if (!m.canRun()) continue;
            double p = m.type.getPropulsion();
            if (!m.legs.isEmpty()) {
                int downLegs = 0;
                for (int li = 0; li < m.legs.size(); ++li) {
                    if (!m.legs.get((int)li).touchingGround) continue;
                    ++downLegs;
                }
                if (downLegs == 0) {
                    p = 0.0;
                } else if (downLegs < m.legs.size() - 1) {
                    p /= 2.0;
                }
            }
            prop += p;
        }
        return prop;
    }

    public double getSpeed() {
        return Math.sqrt(this.getPropulsion() / (double)this.getMass() / this.horizontalAirFriction());
    }

    public double getMainMapSpeed() {
        double s = this.getSpeed();
        if (this.currentBonuses.contains((Object)Bonus.WOLFPACK) && this.type.mobile && this.type.onGround && this.getWeight() <= 2000) {
            s *= 2.0;
        }
        return s;
    }

    public double availableSpeed() {
        return Math.sqrt(this.availablePropulsion() / (double)this.getMass() / this.horizontalAirFriction());
    }

    public boolean isBuildable(EnumSet<Bonus> boni) {
        for (Module m : this.modules) {
            if (m.type.getRequired() == null || boni.contains((Object)m.type.getRequired())) continue;
            return false;
        }
        for (Tile t : this.tiles) {
            if (t.armour.type.required == null || boni.contains((Object)t.armour.type.required)) continue;
            return false;
        }
        return true;
    }

    public double groundOffset() {
        double totalSpringConstant = 0.0;
        int springLength = 0;
        for (Module m : this.modules) {
            for (Spring spring : m.type.getSprings()) {
                totalSpringConstant += spring.k;
                springLength = spring.baseLength;
            }
            for (Leg.Spec spec : m.type.getLegSpecs()) {
                totalSpringConstant += spec.spring.k;
                springLength = spec.spring.baseLength;
            }
        }
        if (totalSpringConstant == 0.0) {
            return 0.0;
        }
        return Math.max(0.0, (double)springLength - (double)this.getMass() * 0.001 / totalSpringConstant) * 0.75;
    }

    public int maxCarryWeight() {
        double maxUpwardsForce = 0.0;
        for (Module m : this.modules) {
            for (Leg.Spec ls : m.type.getLegSpecs()) {
                maxUpwardsForce += ls.spring.getMaxForce();
            }
            for (Spring spr : m.type.getSprings()) {
                maxUpwardsForce += spr.getMaxForce();
            }
        }
        return (int)(maxUpwardsForce / 0.001 * 0.55);
    }

    public void updateBalancingOnLegs(int ms) {
        if (this.sitting) {
            this.legBalanceFactor = 0.0;
            return;
        }
        double hipSpanStart = 0.0;
        double hipSpanEnd = 0.0;
        boolean hipSpanInit = false;
        double downFootSpanStart = 0.0;
        double downFootSpanEnd = 0.0;
        boolean downFootSpanInit = false;
        int msz = this.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.modules.get(mi);
            double mx = this.x + (double)(this.gridXToWorldX(m.x, m.type.getW()) * 16);
            int lsz = m.legs.size();
            for (int li = 0; li < lsz; ++li) {
                double hipX;
                Leg leg = m.legs.get(li);
                double d = hipX = this.flipped ? mx + ((double)m.type.getW() - leg.spec.xOffset) * 16.0 : mx + leg.spec.xOffset * 16.0;
                if (!hipSpanInit) {
                    hipSpanStart = hipX;
                    hipSpanEnd = hipX;
                    hipSpanInit = true;
                } else {
                    hipSpanStart = Math.min(hipSpanStart, hipX);
                    hipSpanEnd = Math.max(hipSpanEnd, hipX);
                }
                if (!leg.touchingGround) continue;
                Pt footPt = leg.getFootPt();
                if (!downFootSpanInit) {
                    downFootSpanStart = hipX + footPt.x;
                    downFootSpanEnd = hipX + footPt.x;
                    downFootSpanInit = true;
                    continue;
                }
                downFootSpanStart = Math.min(downFootSpanStart, hipX + footPt.x);
                downFootSpanEnd = Math.max(downFootSpanEnd, hipX + footPt.x);
            }
        }
        this.legBalanceFactor = hipSpanEnd < hipSpanStart + 0.01 || hipSpanInit && downFootSpanInit && downFootSpanEnd >= hipSpanStart && downFootSpanStart <= hipSpanEnd ? Math.min(1.0, this.legBalanceFactor + (double)ms * 0.003) : Math.max(0.25, this.legBalanceFactor - (double)ms * 0.003);
    }

    @Override
    public boolean canParticleStick(double px, double py) {
        if (!Rect2D.contains(this.x, this.y, this.getBBWidth(), this.getBBHeight(), px, py)) {
            return false;
        }
        int gx = (int)Math.floor((px - this.x) / 16.0);
        int gy = (int)Math.floor((py - this.y) / 16.0);
        return this.tileAt(this.gridXToWorldX(gx, 1), gy) != null;
    }

    public Airship clone() {
        return new Airship(this.toJSON(null));
    }

    public strictfp class OverlappingTile {
        public final Tile tile;
        public double dmgMultiplier;

        public OverlappingTile(Tile tile, double dmgMultiplier) {
            this.tile = tile;
            this.dmgMultiplier = dmgMultiplier;
        }
    }

    private strictfp static final class YCmp
    implements Comparator<Module> {
        private YCmp() {
        }

        @Override
        public int compare(Module t, Module t1) {
            return t1.y * 10000 - t.y * 10000 + t1.x - t.x;
        }
    }
}

