/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Achievement;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Integration;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PerfReport;
import com.zarkonnen.airships.ResChooserScreen;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.TextAdapter;
import com.zarkonnen.airships.UIGlowRect;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WebIntegrationBackend;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.ExceptionHandler;
import com.zarkonnen.catengine.Frame;
import com.zarkonnen.catengine.Game;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.MusicCallback;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.prefs.Preferences;

public strictfp class AirshipGame
implements Game,
ExceptionHandler {
    public Screen s = new ResChooserScreen(this);
    public boolean showFrameCosts = false;
    private final Hooks hs = new Hooks();
    private final MyDraw.State drawState = new MyDraw.State();
    private boolean first = true;
    public boolean exit = false;
    public Pt cursor = new Pt(0.0, 0.0);
    public static final Preferences PREFS = Preferences.userNodeForPackage(AirshipGame.class);
    public static final Clr ERR_BG_TINT = new Clr(0, 0, 0, 63);
    public String error = null;
    public int backgroundPlayTimeLeft = 0;
    public String helpText = null;
    public Runnable hideHelpRunnable = null;
    public ScrollBar helpTextScroll = new ScrollBar();
    public Integration integration = new Integration(new WebIntegrationBackend("https://airships.zarkonnen.com/api/", "https://airships.zarkonnen.com/static/media/", "https://airships.zarkonnen.com/do_login/", "https://airships.zarkonnen.com/do_login_calendar/"));
    public LinkedList<Integer> frameCosts = new LinkedList();
    public String currentMusic = null;
    public int fading = 0;
    public ArrayList<String> currentMusicOptions = new ArrayList();
    public int lastMs = 0;
    public Pt lastCursorPt;
    public boolean mouseMoved = false;
    public boolean phoneHomeAsked = false;
    public boolean phoneHomeWithErrors = true;
    public double volume = 1.0;
    public double musicVolume = 1.0;
    public static int scrollSpeed = 12;
    public boolean prevUserFirstTimev5 = false;
    public boolean swallowExceptions = false;
    static AirshipGame instance;
    public HashMap<String, String> helps = new HashMap();
    public HashSet<String> seenErrorMessages = new HashSet();
    private static final int TT_W = 300;
    private static final int TT_Y_OFFSET = 18;

    static void report(String text) {
        instance.reportError(text, null, null, false, true);
    }

    public final void loadSettings() {
        try {
            this.prevUserFirstTimev5 = PREFS.getDouble("volume", -100.0) > -1.0 && !PREFS.getBoolean("usedv5", false);
            this.phoneHomeAsked = PREFS.getBoolean("phoneHomeAsked", false);
            this.phoneHomeWithErrors = PREFS.getBoolean("phoneHomeWithErrors", true);
            this.volume = PREFS.getDouble("volume", 1.0);
            this.musicVolume = PREFS.getDouble("musicVolume", 1.0);
            scrollSpeed = PREFS.getInt("scrollSpeed", 12);
            String lang = PREFS.get("language", "-----");
            if (!lang.equals("-----")) {
                Lang.setCurrentLocale(Locale.forLanguageTag(lang));
            }
            Appearance.useSimpleGraphics = PREFS.getBoolean("useSimpleGraphics", false);
            Appearance.useLighting = PREFS.getBoolean("useLighting", true);
            for (SimplePref sp : SimplePref.values()) {
                sp.load();
            }
        }
        catch (Exception e) {
            this.reportError("Unable to load settings.", e, null, false);
        }
    }

    public final void saveSettings() {
        try {
            PREFS.putBoolean("phoneHomeAsked", this.phoneHomeAsked);
            PREFS.putBoolean("phoneHomeWithErrors", this.phoneHomeWithErrors);
            PREFS.putDouble("volume", this.volume);
            PREFS.putDouble("musicVolume", this.musicVolume);
            PREFS.putInt("scrollSpeed", scrollSpeed);
            PREFS.putBoolean("usedv5", true);
            PREFS.put("language", Lang.currentLocale.toLanguageTag());
            PREFS.putBoolean("useSimpleGraphics", Appearance.useSimpleGraphics);
            PREFS.putBoolean("useLighting", Appearance.useLighting);
            for (SimplePref sp : SimplePref.values()) {
                sp.save();
            }
        }
        catch (Exception e) {
            this.reportError("Unable to save settings.", e, null, false);
        }
    }

    public AirshipGame() {
        this.loadSettings();
        instance = this;
    }

    public boolean isIntegrated() {
        return this.integration != null;
    }

    public CoatOfArms getBestCOA() {
        if (this.integration != null && this.integration.registeredCoatOfArms != null) {
            return this.integration.registeredCoatOfArms;
        }
        return CoatEditor.getMyStrategicArms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showHelp(String name, Runnable hideHelpRunnable) {
        String key = name + "_" + Lang.currentLocale.toLanguageTag();
        if (!this.helps.containsKey(key)) {
            BufferedReader r = null;
            try {
                File introF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), Lang.currentLocale.toLanguageTag() + "_" + name + "_help.txt");
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(introF), "UTF-8"));
                String l = null;
                StringBuilder sb = new StringBuilder();
                while ((l = r.readLine()) != null) {
                    sb.append(l).append("\n");
                }
                this.helps.put(key, sb.toString());
            }
            catch (Exception e) {
                BufferedReader r2 = null;
                try {
                    File introF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), "en_" + name + "_help.txt");
                    r2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(introF), "UTF-8"));
                    String l = null;
                    StringBuilder sb = new StringBuilder();
                    while ((l = r2.readLine()) != null) {
                        sb.append(l).append("\n");
                    }
                }
                catch (Exception e2) {
                    this.helps.put(key, "No help available!");
                }
                finally {
                    try {
                        r2.close();
                    }
                    catch (Exception e2) {}
                }
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception e) {}
            }
        }
        this.helpText = this.helps.get(key);
        this.hideHelpRunnable = hideHelpRunnable;
        this.helpTextScroll.offset = 0;
    }

    public void reportPerformance(PerfReport pr) {
        System.out.println(pr.toString());
    }

    public void showError(String error) {
        this.error = error;
    }

    public void reportError(String message, Exception e, String detail, boolean fatal) {
        this.reportError(message, e, detail, fatal, false);
    }

    public void reportError(String message, Exception e, String detail, boolean fatal, boolean silent) {
        String origMsg = message;
        try {
            if (message == null) {
                message = e != null ? e.toString() : "";
            }
        }
        catch (Exception e2) {
            message = "";
        }
        try {
            if (e != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                message = message + "\n\nStack Trace:\n" + sw.toString();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (this.seenErrorMessages.contains(message)) {
            return;
        }
        this.seenErrorMessages.add(message);
        if (detail != null) {
            message = message + "\n\nDetail:\n" + detail;
        }
        try {
            if (this.s instanceof UniScreen) {
                UniScreen us = (UniScreen)this.s;
                if (us.combat != null) {
                    message = message + "\n\nCombat:\n" + us.combat.toJSON().toString();
                }
                if (us.standaloneEditShip != null) {
                    message = message + "\n\nShip:\n" + us.standaloneEditShip.toJSON(null);
                }
            }
            if (this.s instanceof StrategicScreen) {
                StrategicScreen ss = (StrategicScreen)this.s;
                message = message + "\n\nWorld:\n" + ss.w.toJSON().toString();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            System.err.println(message);
            System.err.flush();
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (this.phoneHomeWithErrors && this.isIntegrated() && this.integration.backend.getMultiplayerServer() != null) {
            try {
                this.integration.sendFeedback(message);
                if (!silent) {
                    if (origMsg != null) {
                        this.showError(origMsg + " " + Lang._t("error_log_sending", new Object[0]));
                    } else {
                        this.showError(Lang._t("unknown_error_log_sending", new Object[0]));
                    }
                    if (fatal) {
                        this.s = new MainMenu(this);
                    }
                }
                return;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        String logPath = new File(AGame.getGameDirectory(), "log.txt").getAbsolutePath();
        if (!silent) {
            if (origMsg != null) {
                this.showError(origMsg + " " + Lang._t("please_send_error_log", logPath, "david.stark@zarkonnen.com"));
            } else {
                this.showError(Lang._t("unknown_error_please_send_error_log", logPath, "david.stark@zarkonnen.com"));
            }
            if (fatal) {
                this.s = new MainMenu(this);
            }
        }
    }

    public void manageMusic(Input in) {
        if (this.musicVolume == 0.0) {
            in.stopMusic();
            return;
        }
        ArrayList<String> options = this.s.music();
        if (options == null) {
            options = this.currentMusicOptions;
        } else {
            this.currentMusicOptions = options;
        }
        if (this.fading > 0) {
            this.fading -= in.msDelta();
            if (this.fading <= 0) {
                this.currentMusic = null;
            }
        } else {
            if (this.currentMusic != null && options.isEmpty()) {
                this.fading = 2100;
                in.fadeOutMusic(2000);
                return;
            }
            if (this.currentMusic != null && !options.contains(this.currentMusic)) {
                this.fading = 2100;
                in.fadeOutMusic(2000);
                return;
            }
            if (this.currentMusic == null && !options.isEmpty()) {
                this.currentMusic = options.get(AGame.ANIM_R.nextInt(options.size()));
                this.fading = 0;
                in.playMusic(this.currentMusic, this.musicVolume, null, new MusicCallback(){

                    public void run(String music, double volume) {
                        if (AirshipGame.this.fading <= 0) {
                            AirshipGame.this.currentMusic = null;
                        }
                    }
                });
            }
        }
    }

    public void input(Input in) {
        try {
            Pt cs = in.cursor();
            this.mouseMoved = cs != null && !cs.equals((Object)this.lastCursorPt);
            this.lastCursorPt = cs;
            this.manageMusic(in);
            this.backgroundPlayTimeLeft -= in.msDelta();
            if (this.first) {
                in.setMode(new ScreenMode(1024, 768, false));
                this.first = false;
            }
            if (in.isCursorVisible() != SimplePref.SYSTEM_CURSOR.get()) {
                in.setCursorVisible(SimplePref.SYSTEM_CURSOR.get());
            }
            this.cursor = in.cursor();
            this.drawState.tick(in.msDelta(), this.cursor);
            if (this.error == null) {
                long start;
                this.hs.hit(in);
                if (this.exit) {
                    in.quit();
                    System.exit(0);
                    return;
                }
                long l = start = this.showFrameCosts ? System.nanoTime() : 0L;
                if (this.helpText == null) {
                    this.s.input(in, this.drawState, this.cursor, in.clicked(), in.msDelta());
                } else {
                    ScreenMode sm = in.mode();
                    this.helpTextScroll.tick(in, 0, 0, sm.width, sm.height);
                }
                if (this.showFrameCosts) {
                    this.frameCosts.add((int)((System.nanoTime() - start) / 100000L));
                    if (this.frameCosts.size() > 300) {
                        this.frameCosts.pollFirst();
                    }
                }
                if (this.exit) {
                    in.quit();
                    System.exit(0);
                }
            } else if (in.clicked() != null) {
                this.error = null;
                this.drawState.hasClicked();
            }
            this.hs.list.clear();
            if (this.integration != null) {
                this.integration.tick();
            }
            this.lastMs = in.msDelta();
            SteamBackend.tick();
            Achievement.tick(in.msDelta());
        }
        catch (Exception e) {
            this.reportError(null, e, null, true);
        }
    }

    public void render(Frame f) {
        try {
            ScreenMode sm;
            if (this.s.alwaysUseAppearancePostfix() || Appearance.useSimpleGraphics || !Appearance.canUseLighting || !Appearance.useLighting || Appearance.shaderLoadFailed) {
                Appearance.switchSpritesheet(this.s.appearancePostfix());
            } else {
                Appearance.switchSpritesheet("");
            }
            this.drawState.resetCursor();
            this.s.render(new MyDraw(f, this.hs, this.drawState, this.integration), f.mode(), this.hs, this.cursor);
            MyDraw d = new MyDraw(f, this.hs, this.drawState, this.integration);
            if (this.cursor != null && this.drawState.cursorText != null && this.drawState.cursorAppearance != null) {
                d.text("[" + this.drawState.cursorTint.toString() + "]" + this.drawState.cursorText, AGame.FOUNT, this.cursor.x + (double)this.drawState.cursorAppearance.dx, this.cursor.y + (double)this.drawState.cursorAppearance.dy + 18.0);
            }
            if (this.drawState.ticksSinceMouseMoved > 20 && !this.drawState.tooltipText.isEmpty() && this.cursor != null && this.drawState.cursorAppearance != null) {
                int ttY;
                sm = f.mode();
                Rect sz = d.textSize(this.drawState.tooltipText, AGame.FOUNT, 0.0, 0.0, 300);
                int ttH = (int)sz.height;
                int ttX = (int)this.cursor.x + this.drawState.cursorAppearance.dx + 16;
                int ttW = (int)sz.width;
                if (ttX + ttW + 12 + 16 >= sm.width) {
                    ttX = sm.width - (ttW + 12 + 16);
                }
                if ((ttY = (int)this.cursor.y + this.drawState.cursorAppearance.dy + 18) + ttH + 12 + 16 >= sm.height) {
                    ttY = sm.height - (ttH + 12 + 16);
                }
                d.drawShadowedPanel(ttX, ttY, ttW + 12, ttH + 12);
                d.text(this.drawState.tooltipText, AGame.FOUNT, ttX + 6, ttY + 6, 300);
            }
            sm = f.mode();
            if (this.helpText != null) {
                int w = 400;
                int x = sm.width / 2 - w / 2;
                int y = 10;
                int h = sm.height - 20;
                d.drawShadowedWindow(x, y, w, h);
                int scrollH = (h -= 24) - 24 - 12;
                this.drawState.glowRects.clear();
                this.hs.list.clear();
                this.helpTextScroll.draw(d, x += 12, y += 12, w -= 24, scrollH, Collections.singletonList(this.helpText), new TextAdapter());
                d.button(x, y + scrollH + 12, 100, Lang._t("OK", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        AirshipGame.this.helpText = null;
                        if (AirshipGame.this.hideHelpRunnable != null) {
                            AirshipGame.this.hideHelpRunnable.run();
                        }
                        AirshipGame.this.hideHelpRunnable = null;
                    }
                });
            }
            if (!SteamBackend.isEnabled() && Achievement.getRecentAchievement() != null) {
                Achievement rec = Achievement.getRecentAchievement();
                String txt = "Achievement unlocked:\n" + rec.displayName + "\n" + rec.desc;
                Pt sz = d.textSize(txt, AGame.FOUNT);
                int w = 79 + (int)sz.x;
                int h = 74;
                d.rect(MyDraw.BUTTON_C_1, sm.width - w, sm.height - h, w, h);
                d.blit(rec.logo, sm.width - w + 5, sm.height - h + 5);
                d.text(txt, AGame.FOUNT, sm.width - w + 5 + 64 + 5, sm.height - h + 5);
            }
            if (this.error != null) {
                d.rect(ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
                int x = sm.width / 4;
                d.rect(Clr.RED, x, 200.0, sm.width / 2, 200.0);
                d.rect(CoatEditor.BG, x + 2, 202.0, sm.width / 2 - 4, 196.0);
                d.text(this.error, AGame.FOUNT, x + 10, 210.0, sm.width / 2 - 20);
            }
            if (this.showFrameCosts) {
                this.drawFrameCosts(d, f.mode());
            }
            this.updateUIGlowRects(this.lastMs, this.drawState);
            for (UIGlowRect r : this.drawState.glowRects.values()) {
                if (r.hoverMs <= 0) continue;
                Clr c = new Clr(255, 255, 255, r.hoverMs / 7);
                d.rect(c, r.x, r.y, r.w, r.h);
            }
            if (this.drawState.cursorAppearance != null && !SimplePref.SYSTEM_CURSOR.get()) {
                this.drawState.cursorAppearance.draw(d, this.cursor.x, this.cursor.y, this.drawState.cursorTint);
            }
        }
        catch (Exception e) {
            this.reportError(null, e, null, true);
        }
    }

    public void drawFrameCosts(Draw d, ScreenMode sm) {
        int x = sm.width - 305;
        d.rect(Clr.WHITE, (double)x, 200.0, 300.0, 1.0);
        Iterator i$ = this.frameCosts.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            d.rect(Clr.WHITE, (double)x, (double)(360 - i), 1.0, (double)i);
            ++x;
        }
    }

    public void handle(Exception e, boolean fatal) {
        if (!this.swallowExceptions) {
            this.reportError(null, e, null, fatal);
        }
    }

    public void updateUIGlowRects(int ms, MyDraw.State s) {
        Iterator<UIGlowRect> it = s.glowRects.values().iterator();
        while (it.hasNext()) {
            UIGlowRect r = it.next();
            if (!r.confirmed) {
                it.remove();
                continue;
            }
            r.confirmed = false;
            if (Rect.contains((double)r.x, (double)r.y, (double)r.w, (double)r.h, (Pt)this.cursor)) {
                r.hoverMs = Math.min(512, r.hoverMs + ms * 2);
                continue;
            }
            r.hoverMs = Math.max(0, r.hoverMs - ms);
        }
    }
}

