/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.LightHaloLayer;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.SlickEngine;
import com.zarkonnen.catengine.util.Clr;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public strictfp class Appearance {
    public static final int SPRITESHEET = 0;
    public static final int CLOUDS = 1;
    public static final int BACKDROPS = 2;
    public static final int DAMAGED = 3;
    public static final int WHEELS_AND_LEGS = 4;
    public static final String[] SPRITESHEETS = new String[]{"spritesheet", "clouds", "backdrops", "damage_sheet", "wheels_and_legs"};
    public static final String[] BUMPS = new String[]{"bump", "clouds_bump", "backdrops_bump", "damage_bump", "wheels_and_legs_bump"};
    private static ShaderProgram sp;
    public static ShaderProgram lsp;
    private static ShaderProgram blsp;
    private static ShaderProgram blueprintShader;
    public static Texture[] texes;
    public static Texture[] bumps;
    public static boolean shaderLoadFailed;
    public static boolean useSimpleGraphics;
    public static boolean useLighting;
    public static boolean canUseLighting;
    private int spritesheet = 0;
    public ArrayList<Img> frames = new ArrayList();
    public ArrayList<Img> flippedFrames;
    public int interval = 300;
    private int w = 0;
    private int h = 0;
    private boolean isFlipped = false;
    private static HashMap<String, Image[]> postfixToSheets;
    private static HashMap<String, Texture[]> postfixToTexes;
    public static String currentPostfix;
    private static Image[] altSpriteSheets;
    private static int switchNum;
    public int mySwitchNum = 0;
    private static boolean inited;
    private static boolean shaderLocked;
    public static boolean bevelledLocked;

    public void draw(Draw d, double x, double y, int ms, boolean flipped) {
        this.draw(d, x, y, (double)this.frames.get((int)0).srcWidth, this.frames.get((int)0).srcHeight, ms, null, flipped);
    }

    public void draw(Draw d, double x, double y, int ms, boolean flipped, Image[] light, float strength, float ambient) {
        this.draw(d, x, y, this.frames.get((int)0).srcWidth, this.frames.get((int)0).srcHeight, ms, null, flipped, light, strength, ambient);
    }

    public void draw(Draw d, double x, double y, int ms, Clr tint, boolean flipped) {
        this.draw(d, x, y, (double)this.frames.get((int)0).srcWidth, this.frames.get((int)0).srcHeight, ms, tint, flipped);
    }

    public void draw(Draw d, double x, double y, int ms, Clr tint, boolean flipped, Image[] light, float strength, float ambient) {
        this.draw(d, x, y, this.frames.get((int)0).srcWidth, this.frames.get((int)0).srcHeight, ms, tint, flipped, light, strength, ambient);
    }

    public static Texture loadTex(String name) {
        if (!name.contains(".")) {
            name = name + ".png";
        }
        InputStream is = SlickEngine.class.getResourceAsStream("/com/zarkonnen/airships/images/" + name);
        try {
            Image img = new Image(is, name, false);
            img.setFilter(9728);
            return img.getTexture();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void draw(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped) {
        this.draw(d, x, y, w, h, ms, tint, flipped, null, 0.0f, 1.0f);
    }

    public static void switchSpritesheet(String postfix) {
        if (postfix.equals(currentPostfix)) {
            return;
        }
        currentPostfix = postfix;
        ++switchNum;
        if (!postfixToSheets.containsKey(postfix)) {
            Image[] newSheets = new Image[SPRITESHEETS.length];
            Texture[] newTexes = new Texture[SPRITESHEETS.length];
            for (int i = 0; i < newSheets.length; ++i) {
                newSheets[i] = LightHaloLayer.loadImage(SPRITESHEETS[i] + postfix + ".png");
                newSheets[i].setFilter(9728);
                newTexes[i] = newSheets[i].getTexture();
            }
            postfixToSheets.put(postfix, newSheets);
            postfixToTexes.put(postfix, newTexes);
        }
        altSpriteSheets = postfixToSheets.get(postfix);
        texes = postfixToTexes.get(postfix);
    }

    public static void init() {
        if (!inited) {
            Appearance.switchSpritesheet("");
            bumps = new Texture[SPRITESHEETS.length];
            for (int i = 0; i < bumps.length; ++i) {
                Appearance.bumps[i] = Appearance.loadTex(BUMPS[i]);
            }
            inited = true;
        }
    }

    public void updateSpritesheet() {
        if (this.mySwitchNum < switchNum) {
            if (this.flippedFrames == null) {
                this.flippedFrames = new ArrayList(this.frames.size());
                for (Img img : this.frames) {
                    this.flippedFrames.add(img.flip());
                }
            }
            for (Img img : this.frames) {
                img.machineImgCache = altSpriteSheets[this.spritesheet].getSubImage(img.srcX, img.srcY, img.srcWidth, img.srcHeight);
                img.machineWCache = img.srcWidth;
                img.machineHCache = img.srcHeight;
            }
            for (Img img : this.flippedFrames) {
                img.machineImgCache = altSpriteSheets[this.spritesheet].getSubImage(img.srcX, img.srcY, img.srcWidth, img.srcHeight).getFlippedCopy(true, false);
                img.machineWCache = img.srcWidth;
                img.machineHCache = img.srcHeight;
            }
            this.mySwitchNum = switchNum;
        }
    }

    public void drawFallback(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped) {
        Img img2;
        if ((flipped ^= this.isFlipped) && this.flippedFrames == null) {
            this.flippedFrames = new ArrayList(this.frames.size());
            for (Img img2 : this.frames) {
                this.flippedFrames.add(img2.flip());
            }
        }
        ArrayList<Img> fs = flipped ? this.flippedFrames : this.frames;
        img2 = fs.get(ms / this.interval % fs.size());
        if (img2.machineImgCache != null) {
            ((Image)img2.machineImgCache).setFilter(9728);
        }
        d.blit(img2, tint, x, y, w, h);
    }

    public void drawAsBlueprint(Draw d, double x, double y, int ms, boolean flipped, float intensity) {
        this.drawAsBlueprint(d, x, y, this.frames.get((int)0).srcWidth, this.frames.get((int)0).srcHeight, ms, flipped, intensity);
    }

    public static void drawAsBlueprint(Img img, Draw d, double x, double y, double w, double h, boolean flipped, float intensity) {
        if (shaderLoadFailed || useSimpleGraphics) {
            d.blit(img, x, y, w, h);
            return;
        }
        if (blueprintShader == null) {
            try {
                blueprintShader = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/passthrough.vert"), (String)AGame.getGameDirectoryPath("data/blueprint.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        blueprintShader.bind();
        blueprintShader.setUniform1f("intensity", intensity);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)texes[0].getTextureID());
        blueprintShader.setUniform1i("tex", 0);
        GL11.glBegin((int)7);
        if (flipped) {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        GL11.glEnd();
        blueprintShader.unbind();
        TextureImpl.bindNone();
    }

    public void drawAsBlueprint(Draw d, double x, double y, double w, double h, int ms, boolean flipped, float intensity) {
        this.updateSpritesheet();
        if (shaderLoadFailed || useSimpleGraphics || !useLighting || !canUseLighting) {
            this.drawFallback(d, x, y, w, h, ms, null, flipped);
            return;
        }
        if (blueprintShader == null) {
            try {
                blueprintShader = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/passthrough.vert"), (String)AGame.getGameDirectoryPath("data/blueprint.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        blueprintShader.bind();
        blueprintShader.setUniform1f("intensity", intensity);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)texes[0].getTextureID());
        blueprintShader.setUniform1i("tex", 0);
        Img img = this.frames.get(ms / this.interval % this.frames.size());
        GL11.glBegin((int)7);
        if (flipped ^ this.isFlipped) {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        GL11.glEnd();
        blueprintShader.unbind();
        TextureImpl.bindNone();
    }

    public static void lockShader(Draw d, Image[] light, float lightStrength, float ambient) {
        Appearance.lockShader(0, d, light, lightStrength, ambient);
    }

    public static void lockShader(int sheet, Draw d, Image[] light, float lightStrength, float ambient) {
        if (shaderLoadFailed || useSimpleGraphics) {
            return;
        }
        if (light != null) {
            if (lsp == null) {
                try {
                    lsp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/litfrag.vert"), (String)AGame.getGameDirectoryPath("data/litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            lsp.bind();
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)bumps[sheet].getTextureID());
            lsp.setUniform1i("bump", 1);
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
            lsp.setUniform1i("lightFromLeft", 2);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
            lsp.setUniform1i("lightFromTop", 3);
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
            lsp.setUniform1i("lightFromRight", 4);
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
            lsp.setUniform1i("lightFromBottom", 5);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)texes[sheet].getTextureID());
            lsp.setUniform1i("tex", 0);
            lsp.setUniform1f("strength", lightStrength);
            lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
            lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
            lsp.enableVertexAttribute("flipped");
            lsp.enableVertexAttribute("tint");
        } else {
            if (sp == null) {
                try {
                    sp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/passthrough.vert"), (String)AGame.getGameDirectoryPath("data/frag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            sp.bind();
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)texes[sheet].getTextureID());
            sp.setUniform1i("tex", 0);
            sp.enableVertexAttribute("tint");
        }
        GL11.glBegin((int)7);
        shaderLocked = true;
    }

    public static void unlockShader(boolean light) {
        if (shaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (light) {
                lsp.unbind();
            } else {
                sp.unbind();
            }
            TextureImpl.bindNone();
            shaderLocked = false;
        }
    }

    public void draw(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped, Image[] light, float lightStrength, float ambient) {
        this.updateSpritesheet();
        if (shaderLoadFailed || useSimpleGraphics) {
            this.drawFallback(d, x, y, w, h, ms, tint, flipped);
            return;
        }
        if (light != null) {
            if (lsp == null) {
                try {
                    lsp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/litfrag.vert"), (String)AGame.getGameDirectoryPath("data/litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!shaderLocked) {
                lsp.bind();
                GL13.glActiveTexture((int)33985);
                GL11.glBindTexture((int)3553, (int)bumps[this.spritesheet].getTextureID());
                lsp.setUniform1i("bump", 1);
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
                lsp.setUniform1i("lightFromLeft", 2);
                GL13.glActiveTexture((int)33987);
                GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
                lsp.setUniform1i("lightFromTop", 3);
                GL13.glActiveTexture((int)33988);
                GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
                lsp.setUniform1i("lightFromRight", 4);
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
                lsp.setUniform1i("lightFromBottom", 5);
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)texes[this.spritesheet].getTextureID());
                lsp.setUniform1i("tex", 0);
                lsp.setUniform1f("strength", lightStrength);
                lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
                lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
                lsp.enableVertexAttribute("flipped");
                lsp.enableVertexAttribute("tint");
            }
        } else {
            if (sp == null) {
                try {
                    sp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/passthrough.vert"), (String)AGame.getGameDirectoryPath("data/frag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!shaderLocked) {
                sp.bind();
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)texes[this.spritesheet].getTextureID());
                sp.setUniform1i("tex", 0);
                sp.enableVertexAttribute("tint");
            }
        }
        Img img = this.frames.get(ms / this.interval % this.frames.size());
        if (!shaderLocked) {
            GL11.glBegin((int)7);
        }
        if (light != null) {
            GL20.glVertexAttrib1f((int)lsp.getAttributeID("flipped"), (float)(flipped ^ this.isFlipped ? 1.0f : 0.0f));
            if (tint == null) {
                GL20.glVertexAttrib4f((int)lsp.getAttributeID("tint"), (float)ambient, (float)ambient, (float)ambient, (float)1.0f);
            } else {
                GL20.glVertexAttrib4f((int)lsp.getAttributeID("tint"), (float)((float)tint.r / 255.0f * ambient), (float)((float)tint.g / 255.0f * ambient), (float)((float)tint.b / 255.0f * ambient), (float)1.0f);
            }
        } else if (tint == null) {
            GL20.glVertexAttrib4f((int)sp.getAttributeID("tint"), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GL20.glVertexAttrib4f((int)sp.getAttributeID("tint"), (float)((float)tint.r / 255.0f), (float)((float)tint.g / 255.0f), (float)((float)tint.b / 255.0f), (float)1.0f);
        }
        if (flipped ^ this.isFlipped) {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        if (!shaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (light != null) {
                lsp.unbind();
            } else {
                sp.unbind();
            }
            TextureImpl.bindNone();
        }
    }

    public static void lockBevelledShader(Draw d, Image[] light, float lightStrength, float ambient) {
        Appearance.lockBevelledShader(0, d, light, lightStrength, ambient);
    }

    public static void lockBevelledShader(int sheet, Draw d, Image[] light, float lightStrength, float ambient) {
        if (shaderLoadFailed || useSimpleGraphics) {
            return;
        }
        if (light != null) {
            if (blsp == null) {
                try {
                    blsp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/bevelled_litfrag.vert"), (String)AGame.getGameDirectoryPath("data/bevelled_litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            blsp.bind();
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)bumps[sheet].getTextureID());
            blsp.setUniform1i("bump", 1);
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
            blsp.setUniform1i("lightFromLeft", 2);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
            blsp.setUniform1i("lightFromTop", 3);
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
            blsp.setUniform1i("lightFromRight", 4);
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
            blsp.setUniform1i("lightFromBottom", 5);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)texes[sheet].getTextureID());
            blsp.setUniform1i("tex", 0);
            blsp.setUniform1f("strength", lightStrength);
            blsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
            blsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
            blsp.enableVertexAttribute("flipped");
            blsp.enableVertexAttribute("bevel");
            blsp.enableVertexAttribute("t");
            blsp.enableVertexAttribute("m");
            blsp.enableVertexAttribute("b");
            blsp.enableVertexAttribute("tint");
            blsp.enableVertexAttribute("paint");
        } else {
            if (sp == null) {
                try {
                    sp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/passthrough.vert"), (String)AGame.getGameDirectoryPath("data/frag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            sp.bind();
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)texes[sheet].getTextureID());
            sp.setUniform1i("tex", 0);
        }
        GL11.glBegin((int)7);
        bevelledLocked = true;
    }

    public static void unlockBevelledShader(boolean light) {
        if (bevelledLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (light) {
                blsp.unbind();
            } else {
                sp.unbind();
            }
            TextureImpl.bindNone();
            bevelledLocked = false;
        }
    }

    public void drawBevelled(Draw d, double x, double y, double w, double h, int ms, Clr tint, boolean flipped, Image[] light, float lightStrength, float ambient, int top, int bottom, int left, int right, int[][] patch9, Clr paint) {
        this.updateSpritesheet();
        if (shaderLoadFailed || useSimpleGraphics) {
            this.drawFallback(d, x, y, w, h, ms, tint, flipped);
            return;
        }
        if (light != null) {
            if (blsp == null) {
                try {
                    blsp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/bevelled_litfrag.vert"), (String)AGame.getGameDirectoryPath("data/bevelled_litfrag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!bevelledLocked) {
                blsp.bind();
                GL13.glActiveTexture((int)33985);
                GL11.glBindTexture((int)3553, (int)bumps[this.spritesheet].getTextureID());
                blsp.setUniform1i("bump", 1);
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
                blsp.setUniform1i("lightFromLeft", 2);
                GL13.glActiveTexture((int)33987);
                GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
                blsp.setUniform1i("lightFromTop", 3);
                GL13.glActiveTexture((int)33988);
                GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
                blsp.setUniform1i("lightFromRight", 4);
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
                blsp.setUniform1i("lightFromBottom", 5);
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)texes[this.spritesheet].getTextureID());
                blsp.setUniform1i("tex", 0);
                blsp.setUniform1f("strength", lightStrength);
                blsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
                blsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
                blsp.enableVertexAttribute("flipped");
                blsp.enableVertexAttribute("bevel");
                blsp.enableVertexAttribute("t");
                blsp.enableVertexAttribute("m");
                blsp.enableVertexAttribute("b");
                blsp.enableVertexAttribute("tint");
                blsp.enableVertexAttribute("paint");
            }
        } else {
            if (sp == null) {
                try {
                    sp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/passthrough.vert"), (String)AGame.getGameDirectoryPath("data/frag.frag"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    shaderLoadFailed = true;
                    return;
                }
            }
            if (!bevelledLocked) {
                sp.bind();
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)texes[this.spritesheet].getTextureID());
                sp.setUniform1i("tex", 0);
            }
        }
        Img img = this.frames.get(ms / this.interval % this.frames.size());
        if (light != null) {
            GL20.glVertexAttrib1f((int)blsp.getAttributeID("flipped"), (float)(flipped ? 1.0f : 0.0f));
            GL20.glVertexAttrib4f((int)blsp.getAttributeID("bevel"), (float)top, (float)bottom, (float)left, (float)right);
            GL20.glVertexAttrib3f((int)blsp.getAttributeID("t"), (float)patch9[0][0], (float)patch9[0][1], (float)patch9[0][2]);
            GL20.glVertexAttrib3f((int)blsp.getAttributeID("m"), (float)patch9[1][0], (float)patch9[1][1], (float)patch9[1][2]);
            GL20.glVertexAttrib3f((int)blsp.getAttributeID("b"), (float)patch9[2][0], (float)patch9[2][1], (float)patch9[2][2]);
            if (tint == null) {
                GL20.glVertexAttrib4f((int)blsp.getAttributeID("tint"), (float)ambient, (float)ambient, (float)ambient, (float)1.0f);
            } else {
                GL20.glVertexAttrib4f((int)blsp.getAttributeID("tint"), (float)((float)tint.r / 255.0f * ambient), (float)((float)tint.g / 255.0f * ambient), (float)((float)tint.b / 255.0f * ambient), (float)1.0f);
            }
            if (paint == null) {
                GL20.glVertexAttrib4f((int)blsp.getAttributeID("paint"), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            } else {
                GL20.glVertexAttrib4f((int)blsp.getAttributeID("paint"), (float)((float)paint.r / 255.0f), (float)((float)paint.g / 255.0f), (float)((float)paint.b / 255.0f), (float)((float)paint.a / 255.0f));
            }
        } else if (tint == null) {
            GL20.glVertexAttrib4f((int)sp.getAttributeID("tint"), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GL20.glVertexAttrib4f((int)sp.getAttributeID("tint"), (float)((float)tint.r / 255.0f), (float)((float)tint.g / 255.0f), (float)((float)tint.b / 255.0f), (float)1.0f);
        }
        if (!bevelledLocked) {
            GL11.glBegin((int)7);
        }
        if (flipped ^ this.isFlipped) {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
        } else {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)x, (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)(x + w), (double)(y + h));
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)(x + w), (double)y);
        }
        if (!bevelledLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (light != null) {
                blsp.unbind();
            } else {
                sp.unbind();
            }
            TextureImpl.bindNone();
        }
    }

    public Appearance frame(int x, int y) {
        return this.frame(x, y, 1, 1);
    }

    public Appearance frame(int x, int y, int w, int h) {
        Img f = new Img(SPRITESHEETS[this.spritesheet], x * 16, y * 16, w * 16, h * 16, false);
        this.frames.add(f);
        this.w = Math.max(this.w, w);
        this.h = Math.max(this.h, h);
        return this;
    }

    public Appearance flip() {
        Appearance a2 = new Appearance();
        a2.frames = this.frames;
        a2.isFlipped = !this.isFlipped;
        a2.interval = this.interval;
        a2.w = this.w;
        a2.h = this.h;
        return a2;
    }

    public Appearance interval(int interval) {
        this.interval = interval;
        return this;
    }

    public static Appearance app() {
        return new Appearance();
    }

    public static Appearance app(int x, int y) {
        return new Appearance(x, y);
    }

    public static Appearance app(int spritesheet, int x, int y, int w, int h) {
        return new Appearance(spritesheet, x, y, w, h);
    }

    public Appearance() {
    }

    public Appearance(int spritesheet) {
        this.spritesheet = spritesheet;
    }

    public Appearance(int spritesheet, int x, int y, int w, int h) {
        this.spritesheet = spritesheet;
        this.frame(x, y, w, h);
    }

    public Appearance(int x, int y) {
        this.frame(x, y);
    }

    public Appearance(int x, int y, int w, int h) {
        this.frame(x, y, w, h);
    }

    public int width() {
        return this.w;
    }

    public int height() {
        return this.h;
    }

    public Appearance upToX(int x) {
        Appearance s = new Appearance();
        for (Img f : this.frames) {
            s.frames.add(new Img(SPRITESHEETS[this.spritesheet], f.srcX, f.srcY, x * 16, f.srcHeight, false));
        }
        s.interval = this.interval;
        s.isFlipped = this.isFlipped;
        return s;
    }

    public Appearance fromX(int x) {
        Appearance s = new Appearance();
        for (Img f : this.frames) {
            s.frames.add(new Img(SPRITESHEETS[this.spritesheet], f.srcX + x * 16, f.srcY, f.srcWidth - x * 16, f.srcHeight, false));
        }
        s.interval = this.interval;
        s.isFlipped = this.isFlipped;
        return s;
    }

    public Appearance leftSide() {
        Appearance s = new Appearance();
        for (Img f : this.frames) {
            s.frames.add(new Img(SPRITESHEETS[this.spritesheet], f.srcX, f.srcY, f.srcWidth / 2, f.srcHeight, false));
        }
        s.interval = this.interval;
        s.isFlipped = this.isFlipped;
        return s;
    }

    public Appearance rightSide() {
        Appearance s = new Appearance();
        for (Img f : this.frames) {
            s.frames.add(new Img(SPRITESHEETS[this.spritesheet], f.srcX + f.srcWidth / 2, f.srcY, f.srcWidth / 2, f.srcHeight, false));
        }
        s.interval = this.interval;
        return s;
    }

    public int getInterval() {
        return this.interval;
    }

    static {
        shaderLoadFailed = false;
        useSimpleGraphics = false;
        useLighting = true;
        canUseLighting = true;
        postfixToSheets = new HashMap();
        postfixToTexes = new HashMap();
        currentPostfix = null;
        switchNum = 0;
    }
}

