/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TimeOfDay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Arena {
    public static BufferedImage drawCombat(Combat c) {
        BufferedImage img = new BufferedImage(3200, 2000, 1);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.translate(1600, 512);
        Color baseColor = Color.GREEN;
        for (Combat.Side s : c.sides) {
            int i = 0;
            for (Airship ship : s.ships) {
                g.setColor(new Color(Math.min(255, baseColor.getRed() + i * 10), Math.min(255, baseColor.getGreen() + i * 10), Math.min(255, baseColor.getBlue() + i * 3)));
                ++i;
                for (Tile t : ship.tiles) {
                    int tx = ship.getX() + ship.gridXToWorldX(t.x, 1) * 16;
                    int ty = ship.getY() + t.y * 16;
                    g.fillRect(tx, ty, 16, 16);
                }
                g.setColor(Color.BLACK);
                g.drawString(ship.name, (int)(ship.x + ship.getBBWidth() / 2.0), (int)(ship.y + ship.getBBHeight() / 2.0));
            }
            baseColor = Color.RED;
        }
        g.setColor(Color.DARK_GRAY);
        for (LandFormation lf : c.landFormations) {
            for (int gy = 0; gy < lf.grid.length; ++gy) {
                for (int gx = 0; gx < lf.grid[0].length; ++gx) {
                    g.fillRect((int)lf.x + gx * 16, (int)lf.y + gy * 16, 16, 16);
                }
            }
        }
        return img;
    }

    public static void main(String[] args) {
        ArrayList<Airship> designs = new ArrayList<Airship>();
        for (String n : new String[]{"landships", "ships"}) {
            File shipsDir = new File(AGame.getGameDirectory(), n);
            for (File f : shipsDir.listFiles()) {
                if (!f.getName().endsWith(".json")) continue;
                try {
                    designs.add(new Airship(new JSONObject(new JSONTokener(new FileReader(f)))));
                }
                catch (Exception e) {
                    System.out.println(f.getName() + " is not loadable.");
                }
            }
        }
        int[] wins = new int[designs.size()];
        for (Airship da : designs) {
            if (da.getCost() > 300) continue;
            for (Airship db : designs) {
                if (db.getCost() > 300) continue;
                boolean bwins = Arena.fight(da, db);
                System.out.println(da.name + " vs " + db.name + ": " + (bwins ? db.name : da.name) + " wins");
                int n = designs.indexOf(bwins ? db : da);
                wins[n] = wins[n] + 1;
                Airship tmp = db;
                db = da;
                da = tmp;
                bwins = Arena.fight(da, db);
                System.out.println(da.name + " vs " + db.name + ": " + (bwins ? db.name : da.name) + " wins");
                int n2 = designs.indexOf(bwins ? db : da);
                wins[n2] = wins[n2] + 1;
            }
        }
        for (Airship d : designs) {
            System.out.println(wins[designs.indexOf(d)] + " wins for " + d.name);
        }
    }

    static boolean within15percent(double d) {
        return d <= 1.15 && d >= 0.8695652173913044;
    }

    public static boolean fight(Airship designA, Airship designB) {
        int numA = 1;
        int numB = 1;
        while (numA < 12 && numB < 12 && !Arena.within15percent(1.0 * (double)numA * (double)designA.getCost() / (double)numB / (double)designB.getCost())) {
            if (numA * designA.getCost() > numB * designB.getCost()) {
                ++numB;
                continue;
            }
            ++numA;
        }
        System.out.println(numA + " " + designA.name + " (" + numA * designA.getCost() + ") vs " + numB + " " + designB.name + " (" + numB * designB.getCost() + ")");
        Random r = new Random();
        int bWins = 0;
        for (int round = 0; round < 1; ++round) {
            int ticks;
            Airship ship;
            int i;
            Combat c = new Combat(null, TimeOfDay.DAY);
            long seed = -167288957399612368L;
            c.r = new Random(seed);
            for (i = 0; i < numA; ++i) {
                ship = designA.clone();
                if (ship.type.onGround) {
                    ship.x = -800.0 - (double)i * (ship.getBBWidth() + 20.0);
                    ship.y = 512.0 - ship.getBBHeight() - 50.0;
                } else {
                    ship.x = -800.0 - (double)(i / 3) * (ship.getBBWidth() + 20.0);
                    ship.y = 512.0 - (double)ship.serviceCeiling() * 0.95 + (double)(i % 3) * (ship.getBBHeight() + 20.0);
                }
                ship.ai = new TacticalAI(ship, c, c.sides.get(0), c.sides.get(1));
                ship.flipped = false;
                ship.flipTo = false;
                ship.repair();
                c.sides.get((int)0).ships.add(ship);
            }
            for (i = 0; i < numB; ++i) {
                ship = designB.clone();
                if (ship.type.onGround) {
                    ship.x = 800.0 + (double)i * (ship.getBBWidth() + 20.0);
                    ship.y = 512.0 - ship.getBBHeight() - 50.0;
                } else {
                    ship.x = 800.0 + (double)(i / 3) * (ship.getBBWidth() + 20.0);
                    ship.y = 512.0 - (double)ship.serviceCeiling() * 0.95 + (double)(i % 3) * (ship.getBBHeight() + 20.0);
                }
                ship.ai = new TacticalAI(ship, c, c.sides.get(1), c.sides.get(0));
                ship.flipped = true;
                ship.flipTo = true;
                ship.repair();
                c.sides.get((int)1).ships.add(ship);
            }
            LandFormation ground = new LandFormation(-1600.0, 512.0, 200, 2);
            for (int y = 0; y < ground.grid.length; ++y) {
                for (int x = 0; x < ground.grid[0].length; ++x) {
                    ground.grid[y][x] = LandBlockType.BEDROCK;
                }
            }
            ground.crop();
            ground.immobile = true;
            c.landFormations.add(ground);
            try {
                for (ticks = 0; ticks < 10000 && !c.isFinished(); ++ticks) {
                    if (ticks % 100 == 0) {
                        BufferedImage cimg = Arena.drawCombat(c);
                        ImageIO.write((RenderedImage)cimg, "PNG", new File("/home/zar/Desktop/setups/" + designA.name + " vs " + designB.name + " " + ticks + ".png"));
                    }
                    c.tick(16, c.sides.get(0), false);
                    c.sounds.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(designA.name + " vs " + designB.name + " tick " + ticks + " with seed " + seed);
                Runtime.getRuntime().exit(0);
            }
            if (!c.won(c.sides.get(1))) continue;
            ++bWins;
        }
        return bWins > 1;
    }
}

