/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.ModuleType;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public strictfp class ArmourPlate {
    public CoatOfArms.Tincture paint;
    public ArmourType type;
    public int hp;
    public boolean window;
    public transient Airship ship;
    public static final Appearance NO_APP = new Appearance(63, 63);

    public int getMaxHP() {
        int max = this.type.getHP(this.ship.constructionBonuses);
        if (this.window) {
            max /= 2;
        }
        return max;
    }

    public ArmourPlate(boolean window, Airship ship) {
        this.ship = ship;
        this.type = ArmourType.LT_WOOD;
        this.hp = this.getMaxHP();
        this.window = window;
    }

    public void setType(ArmourType type) {
        this.type = type;
        this.hp = this.getMaxHP();
    }

    public ArmourPlate(JSONObject o, Airship ship) {
        this.ship = ship;
        this.type = ArmourType.valueOf(o.getString("type"));
        this.hp = o.getInt("hp");
        this.window = o.getBoolean("window");
        this.paint = o.has("paint") ? CoatOfArms.Tincture.valueOf(o.getString("paint")) : null;
    }

    public void repair() {
        this.hp = this.getMaxHP();
    }

    public Appearance getApp() {
        int maxHP = this.getMaxHP();
        if (maxHP == 0) {
            return NO_APP;
        }
        if (this.window && this.hp > maxHP / 4) {
            return this.type.windowApp;
        }
        return this.type.damagedApps.get(Math.max(0, 4 - this.hp * 4 / maxHP));
    }

    public List<ModuleType.FragmentImg> getFragments() {
        int maxHP = this.getMaxHP();
        if (maxHP == 0) {
            return Collections.emptyList();
        }
        return this.type.fragments.get(Math.max(0, 4 - this.hp * 4 / maxHP));
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject().put("type", this.type.name()).put("hp", this.hp).put("window", this.window);
        if (this.paint != null) {
            o.put("paint", this.paint.name());
        }
        return o;
    }

    public boolean opaque() {
        return !this.window && this.hp > this.getMaxHP() * 3 / 4;
    }
}

