/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.BirdsVisualLayer;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;

public class BackdropVisualLayer
implements UniScreen.VisualLayer {
    public CombatBackgroundFlavor cbf;
    public final ArrayList<Backdrop> backdrops = new ArrayList();
    public int time;
    public static final Appearance[][] HILLS = new Appearance[][]{{Appearance.app(2, 0, 1, 7, 2), Appearance.app(2, 7, 1, 3, 2), Appearance.app(2, 10, 0, 10, 3), Appearance.app(2, 20, 2, 7, 1), Appearance.app(2, 28, 1, 2, 2), Appearance.app(2, 30, 1, 5, 2), Appearance.app(2, 35, 1, 7, 2), Appearance.app(2, 42, 1, 6, 2), Appearance.app(2, 49, 0, 15, 3)}, {Appearance.app(2, 0, 19, 7, 2), Appearance.app(2, 7, 19, 3, 2), Appearance.app(2, 10, 18, 10, 3), Appearance.app(2, 20, 20, 7, 1), Appearance.app(2, 28, 19, 2, 2), Appearance.app(2, 30, 19, 5, 2), Appearance.app(2, 35, 19, 7, 2), Appearance.app(2, 42, 19, 6, 2), Appearance.app(2, 49, 18, 15, 3)}};
    public static final Appearance[][] WOODS = new Appearance[][]{{Appearance.app(2, 0, 4, 6, 2), Appearance.app(2, 6, 4, 3, 2), Appearance.app(2, 9, 3, 7, 3), Appearance.app(2, 16, 4, 7, 2), Appearance.app(2, 24, 4, 6, 2), Appearance.app(2, 30, 3, 15, 3), Appearance.app(2, 45, 4, 10, 2), Appearance.app(2, 55, 3, 9, 3)}, {Appearance.app(2, 0, 22, 6, 2), Appearance.app(2, 6, 22, 3, 2), Appearance.app(2, 9, 21, 7, 3), Appearance.app(2, 16, 22, 7, 2), Appearance.app(2, 24, 22, 6, 2), Appearance.app(2, 30, 21, 15, 3), Appearance.app(2, 45, 22, 10, 2), Appearance.app(2, 55, 21, 9, 3)}};
    public static final Appearance[][] MEADOWS = new Appearance[][]{{Appearance.app(2, 0, 6, 5, 1), Appearance.app(2, 5, 6, 6, 1), Appearance.app(2, 11, 6, 3, 1), Appearance.app(2, 14, 6, 3, 1), Appearance.app(2, 17, 6, 9, 1), Appearance.app(2, 26, 6, 3, 1), Appearance.app(2, 29, 6, 8, 1), Appearance.app(2, 37, 6, 11, 1), Appearance.app(2, 48, 6, 7, 1), Appearance.app(2, 55, 6, 6, 1), Appearance.app(2, 61, 6, 3, 1)}, {Appearance.app(2, 0, 24, 5, 1), Appearance.app(2, 5, 24, 6, 1), Appearance.app(2, 11, 24, 3, 1), Appearance.app(2, 14, 24, 3, 1), Appearance.app(2, 17, 24, 9, 1), Appearance.app(2, 26, 24, 3, 1), Appearance.app(2, 29, 24, 8, 1), Appearance.app(2, 37, 24, 11, 1), Appearance.app(2, 48, 24, 7, 1), Appearance.app(2, 55, 24, 6, 1), Appearance.app(2, 61, 24, 3, 1)}};
    public static final Appearance[][] ROCKS = new Appearance[][]{{Appearance.app(2, 0, 7, 3, 1), Appearance.app(2, 3, 7, 1, 1), Appearance.app(2, 4, 7, 5, 1), Appearance.app(2, 9, 7, 5, 1), Appearance.app(2, 14, 7, 3, 1), Appearance.app(2, 17, 7, 2, 1), Appearance.app(2, 19, 7, 4, 1), Appearance.app(2, 23, 7, 2, 1), Appearance.app(2, 25, 7, 2, 1), Appearance.app(2, 27, 7, 2, 1), Appearance.app(2, 29, 7, 4, 1), Appearance.app(2, 33, 7, 7, 1), Appearance.app(2, 40, 7, 5, 1), Appearance.app(2, 45, 7, 4, 1), Appearance.app(2, 49, 7, 2, 1), Appearance.app(2, 51, 7, 7, 1), Appearance.app(2, 58, 6, 2, 1)}, {Appearance.app(2, 0, 25, 3, 1), Appearance.app(2, 3, 25, 1, 1), Appearance.app(2, 4, 25, 5, 1), Appearance.app(2, 9, 25, 5, 1), Appearance.app(2, 14, 25, 3, 1), Appearance.app(2, 17, 25, 2, 1), Appearance.app(2, 19, 25, 4, 1), Appearance.app(2, 23, 25, 2, 1), Appearance.app(2, 25, 25, 2, 1), Appearance.app(2, 27, 25, 2, 1), Appearance.app(2, 29, 25, 4, 1), Appearance.app(2, 33, 25, 7, 1), Appearance.app(2, 40, 25, 5, 1), Appearance.app(2, 45, 25, 4, 1), Appearance.app(2, 49, 25, 2, 1), Appearance.app(2, 51, 25, 7, 1), Appearance.app(2, 58, 24, 2, 1)}};
    public static final Appearance[][] MUD_MEADOWS = new Appearance[][]{{Appearance.app(2, 0, 13, 5, 1), Appearance.app(2, 5, 13, 6, 1), Appearance.app(2, 11, 13, 3, 1), Appearance.app(2, 14, 13, 3, 1), Appearance.app(2, 17, 13, 9, 1), Appearance.app(2, 26, 13, 3, 1), Appearance.app(2, 29, 13, 8, 1), Appearance.app(2, 37, 13, 11, 1), Appearance.app(2, 48, 13, 7, 1), Appearance.app(2, 55, 13, 6, 1), Appearance.app(2, 61, 13, 3, 1)}, {Appearance.app(2, 0, 31, 5, 1), Appearance.app(2, 5, 31, 6, 1), Appearance.app(2, 11, 31, 3, 1), Appearance.app(2, 14, 31, 3, 1), Appearance.app(2, 17, 31, 9, 1), Appearance.app(2, 26, 31, 3, 1), Appearance.app(2, 29, 31, 8, 1), Appearance.app(2, 37, 31, 11, 1), Appearance.app(2, 48, 31, 7, 1), Appearance.app(2, 55, 31, 6, 1), Appearance.app(2, 61, 31, 3, 1)}};
    public static final Appearance[][] MOUNTAINS = new Appearance[][]{{Appearance.app(2, 0, 9, 13, 4), Appearance.app(2, 13, 8, 11, 5), Appearance.app(2, 24, 9, 13, 4), Appearance.app(2, 37, 11, 8, 2), Appearance.app(2, 45, 11, 5, 2), Appearance.app(2, 50, 8, 7, 5), Appearance.app(2, 57, 11, 4, 2), Appearance.app(2, 61, 11, 3, 2)}, {Appearance.app(2, 0, 27, 13, 4), Appearance.app(2, 13, 26, 11, 5), Appearance.app(2, 24, 27, 13, 4), Appearance.app(2, 37, 29, 8, 2), Appearance.app(2, 45, 29, 5, 2), Appearance.app(2, 50, 26, 7, 5), Appearance.app(2, 57, 29, 4, 2)}};
    public static final Appearance[][] SEA = new Appearance[][]{{Appearance.app(2, 0, 14, 2, 2), Appearance.app(2, 2, 15, 3, 1), Appearance.app(2, 5, 14, 3, 2), Appearance.app(2, 8, 15, 1, 1), Appearance.app(2, 9, 15, 1, 1), Appearance.app(2, 10, 15, 1, 1)}, {Appearance.app(2, 2, 33, 3, 1), Appearance.app(2, 5, 32, 3, 2), Appearance.app(2, 8, 33, 1, 1), Appearance.app(2, 9, 33, 1, 1), Appearance.app(2, 10, 33, 1, 1)}};
    public static final Appearance[][] BUILDINGS = new Appearance[][]{{Appearance.app(2, 11, 14, 3, 2).frame(14, 14, 3, 2).frame(17, 14, 3, 2).interval(150), Appearance.app(2, 20, 14, 8, 2), Appearance.app(2, 28, 14, 7, 2), Appearance.app(2, 20, 14, 8, 2), Appearance.app(2, 35, 15, 7, 1), Appearance.app(2, 42, 15, 4, 1), Appearance.app(2, 46, 15, 2, 1), Appearance.app(2, 48, 15, 1, 1), Appearance.app(2, 49, 15, 2, 1), Appearance.app(2, 51, 15, 6, 1), Appearance.app(2, 57, 15, 3, 1).frame(60, 15, 3, 1).interval(800)}, {Appearance.app(2, 11, 32, 3, 2).frame(14, 32, 3, 2).frame(17, 32, 3, 2).interval(150), Appearance.app(2, 20, 32, 8, 2), Appearance.app(2, 28, 32, 7, 2), Appearance.app(2, 20, 32, 8, 2), Appearance.app(2, 35, 33, 7, 1), Appearance.app(2, 42, 33, 4, 1), Appearance.app(2, 46, 33, 2, 1), Appearance.app(2, 48, 33, 1, 1), Appearance.app(2, 49, 33, 2, 1), Appearance.app(2, 51, 33, 6, 1), Appearance.app(2, 57, 33, 3, 1).frame(60, 33, 3, 1).interval(800)}};
    public static final Appearance[][] PLAINS = new Appearance[][]{{Appearance.app(2, 0, 16, 5, 1), Appearance.app(2, 5, 16, 3, 1), Appearance.app(2, 8, 16, 4, 1), Appearance.app(2, 14, 16, 6, 1), Appearance.app(2, 20, 16, 4, 1), Appearance.app(2, 24, 16, 2, 1), Appearance.app(2, 26, 16, 8, 1), Appearance.app(2, 34, 16, 12, 1), Appearance.app(2, 46, 16, 6, 1), Appearance.app(2, 52, 16, 2, 1), Appearance.app(2, 54, 16, 4, 1), Appearance.app(2, 58, 16, 6, 1)}, {Appearance.app(2, 0, 34, 5, 1), Appearance.app(2, 5, 34, 3, 1), Appearance.app(2, 8, 34, 4, 1), Appearance.app(2, 14, 34, 6, 1), Appearance.app(2, 20, 34, 4, 1), Appearance.app(2, 24, 34, 2, 1), Appearance.app(2, 26, 34, 8, 1), Appearance.app(2, 34, 34, 12, 1), Appearance.app(2, 46, 34, 6, 1), Appearance.app(2, 52, 34, 2, 1), Appearance.app(2, 54, 34, 4, 1), Appearance.app(2, 58, 34, 6, 1)}};

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.cbf == null) {
            this.cbf = BirdsVisualLayer.getCBF(us);
        }
        this.time += ms;
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        int snow;
        if (us.intent.drawAsBlueprint()) {
            return;
        }
        int n = snow = us.getTimeOfDay() == TimeOfDay.SNOW ? 1 : 0;
        if (this.cbf != null && this.backdrops.isEmpty()) {
            Appearance app;
            for (int x = -1600; x < 1600; x += app.width() * 16) {
                Appearance[] apps = this.cbf.backgrounds[AGame.ANIM_R.nextInt(this.cbf.backgrounds.length)][snow];
                app = apps[AGame.ANIM_R.nextInt(apps.length)];
                this.backdrops.add(new Backdrop(app, x += AGame.ANIM_R.nextInt(100) + 15, AGame.ANIM_R.nextBoolean()));
            }
        }
        TimeOfDay tod = us.getTimeOfDay();
        Appearance.lockShader(2, d, us.lightingMap, tod.lightStrength, tod.ambient);
        int bsz = this.backdrops.size();
        for (int bi = 0; bi < bsz; ++bi) {
            Backdrop b = this.backdrops.get(bi);
            if ((double)b.x > cropX + cropW || (double)(b.x + b.app.width() * 16) < cropX || (double)(512 - b.app.height() * 16) > cropY + cropH) continue;
            b.app.draw(d, b.x, 512 - b.app.height() * 16, this.time, null, b.flipped, us.lightingMap, tod.lightStrength, tod.ambient);
        }
        Appearance.unlockShader(us.lightingMap != null);
        int tint = 100 + (int)Math.min(100.0, 50.0 / us.zoom);
        Clr bgt = new Clr(tint, tint, tint);
        LandBlockType lbt = LandBlockType.GRASS;
        int extra = -16;
        LandFormation ground = null;
        if (us.setupGround != null) {
            ground = us.setupGround;
        } else if (us.city != null) {
            ground = us.city.ground;
        } else if (us.combat != null) {
            ground = us.combat.landFormations.get(0);
        }
        for (int y = 0; y < 8; ++y) {
            int worldY = y * 16 + 512 + extra;
            if ((double)worldY < cropY - 32.0 || (double)worldY > cropY + cropH) continue;
            int groundY = ground == null ? 0 : Math.max(0, (int)((double)worldY - ground.y) / 16);
            for (int x = 0; x < 200; ++x) {
                int worldX = x * 16 - 1600;
                if ((double)worldX < cropX - 16.0 || (double)worldX > cropX + cropW || ground != null && ground.grid[groundY][x].opaque) continue;
                lbt.app.draw(d, worldX, worldY, x * 109 + y * 1934, bgt, false, us.lightingMap, tod.lightStrength, tod.ambient);
            }
            lbt = LandBlockType.SOIL;
            extra = 0;
        }
        Appearance.unlockShader(us.lightingMap != null);
        d.rect(us.getTimeOfDay().deepSoilTint, -1600.0, 640.0, 3200.0, 3200.0);
    }

    public static class Backdrop {
        Appearance app;
        int x;
        boolean flipped;

        public Backdrop(Appearance app, int x, boolean flipped) {
            this.app = app;
            this.x = x;
            this.flipped = flipped;
        }
    }
}

