/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Draw;
import org.newdawn.slick.Image;

public class BackgroundFloatie {
    public double x;
    public double y;
    public boolean flipped;
    public int time;
    public Type type;

    public BackgroundFloatie(Type type, boolean side) {
        this.type = type;
        this.y = 412 - AGame.ANIM_R.nextInt(1000);
        this.time = AGame.ANIM_R.nextInt(type.yPeriod);
        this.flipped = AGame.ANIM_R.nextBoolean();
        this.x = side ? (this.flipped ? 1610.0 : -1680.0) : (double)(AGame.ANIM_R.nextInt(3200) - 1600);
    }

    public void tick(int ms) {
        this.time += ms;
        this.x += this.flipped ? -this.type.xSpeed * (double)ms : this.type.xSpeed * (double)ms;
        if (this.x < -1700.0 || this.x > 1700.0) {
            int roll = AGame.ANIM_R.nextInt(BackgroundFloatie.totalWeightsMoving());
            for (Type t : Type.values()) {
                if (t.xSpeed == 0.0 || (roll -= t.weight) > 0) continue;
                this.type = t;
                break;
            }
            this.y = 412 - AGame.ANIM_R.nextInt(1000);
            this.flipped = AGame.ANIM_R.nextBoolean();
            this.x = this.flipped ? 1610.0 : -1680.0;
        }
    }

    public void draw(MyDraw d, Image[] light, float strength, float ambient) {
        this.type.app.draw((Draw)d, this.x, this.y + Math.sin((double)this.time * 1.0 / (double)this.type.yPeriod) * this.type.yAmplitude, this.time, this.flipped, light, strength, ambient);
    }

    public static int totalWeights() {
        int n = 0;
        for (Type t : Type.values()) {
            n += t.weight;
        }
        return n;
    }

    public static int totalWeightsMoving() {
        int n = 0;
        for (Type t : Type.values()) {
            if (t.xSpeed == 0.0) continue;
            n += t.weight;
        }
        return n;
    }

    public static enum Type {
        DRAGON(30, 0.3, 4.0, 2400, new Appearance().frame(35, 18, 2, 1).frame(37, 18, 2, 1).interval(400)),
        TURTLEDOVE(200, 0.02, 2.0, 800, new Appearance().frame(39, 18).frame(40, 18).interval(900)),
        BALLOON(400, 0.002, 3.0, 1200, new Appearance(41, 18)),
        ROCK1(100, 0.0, 3.0, 1200, new Appearance(42, 18)),
        ROCK2(100, 0.0, 3.0, 1200, new Appearance(43, 18)),
        ROCK3(100, 0.0, 3.0, 1200, new Appearance(44, 18)),
        FREIGHTER(200, 0.03, 3.0, 1200, new Appearance(45, 18)),
        FREIGHTER2(100, 0.03, 3.0, 900, new Appearance(46, 18)),
        ROCK4(100, 0.0, 3.0, 1200, new Appearance(47, 18)),
        ROCK5(100, 0.0, 3.0, 1200, new Appearance(48, 18)),
        BIG_COLONY(50, 0.002, 2.0, 2000, new Appearance().frame(49, 18).frame(50, 18).interval(2300)),
        SMALL_COLONY(50, 0.003, 3.0, 1500, new Appearance().frame(51, 18).frame(52, 18).interval(2300)),
        TRAWLER(200, 0.005, 3.0, 1200, new Appearance().frame(53, 18).frame(54, 18).interval(700)),
        PLATFORM(300, 0.0, 2.0, 1600, new Appearance(55, 18)),
        SKYSQUID(10, 0.05, 0.0, 1000, new Appearance().frame(56, 18, 2, 1).frame(58, 18, 2, 1).interval(1100));

        public final int weight;
        public final double xSpeed;
        public final double yAmplitude;
        public final int yPeriod;
        public final Appearance app;

        private Type(int weight, double xSpeed, double yAmplitude, int yPeriod, Appearance app) {
            this.weight = weight;
            this.xSpeed = xSpeed;
            this.yAmplitude = yAmplitude;
            this.yPeriod = yPeriod;
            this.app = app;
        }
    }
}

