/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.catengine.Draw;
import java.util.ArrayList;
import org.newdawn.slick.Image;

public class Bird {
    public Type type;
    public Behavior behavior;
    public double x;
    public double y;
    public double dx;
    public double dy;
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;
    public double targetX;
    public double targetY;
    public int counter;
    public int time;
    public static final Type STARLING = new Type(new Boid(), 300.0, new FlockSpawner(20, 30, 150), Appearance.app().frame(9, 20).frame(10, 20).frame(11, 20).frame(10, 20).interval(180), Appearance.app().frame(9, 20).frame(10, 20).frame(11, 20).frame(10, 20).interval(180), Appearance.app(12, 20));
    public static final Type CROW = new Type(new Boid(), 200.0, new FlockSpawner(5, 12, 150), Appearance.app().frame(13, 20).frame(14, 20).frame(15, 20).frame(14, 20).interval(230), Appearance.app().frame(13, 21).frame(14, 21).frame(15, 21).frame(14, 21).interval(230), Appearance.app(12, 21));
    public static final Type GOOSE = new Type(new FlyAcross(), 80.0, new VSpawner(-200.0, -800.0, 1000.0), Appearance.app().frame(20, 20).frame(21, 20).frame(20, 21).frame(21, 20).interval(500), Appearance.app().frame(20, 20).frame(21, 20).frame(20, 21).frame(21, 20).interval(500), null);
    public static final Type GULL = new Type(new Circle(300.0, 15.0, 50, 2100, 1700), 200.0, new FlockSpawner(3, 8, 300, 300), Appearance.app().frame(17, 20).frame(18, 20).frame(19, 20).frame(18, 20).interval(260), Appearance.app().frame(17, 21).frame(18, 21).frame(19, 21).frame(18, 21).interval(260), Appearance.app(16, 21));
    public static final Type EAGLE = new Type(new Circle(), 3.0, new FlockSpawner(1, 1, 50, 200), Appearance.app(21, 21), Appearance.app(21, 21), null);

    public Bird(Type type, double x, double y, double minX, double minY, double maxX, double maxY) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.time = AGame.ANIM_R.nextInt(5000);
        this.behavior = type.behavior.mutate();
    }

    public void tick(int ms, ArrayList<Bird> birds) {
        this.behavior.behave(this, birds, ms);
        if (this.dx * this.dx + this.dy * this.dy > this.type.maxSpeed * this.type.maxSpeed) {
            double sp = Math.abs(this.dx) + Math.abs(this.dy);
            this.dx = this.dx * this.type.maxSpeed / sp;
            this.dy = this.dy * this.type.maxSpeed / sp;
        }
        this.x += this.dx * (double)ms / 1000.0;
        this.y += this.dy * (double)ms / 1000.0;
        this.time += ms;
    }

    public void draw(Draw d, Image[] light, float strength, float ambient) {
        if (this.type.down == null || Math.abs(this.dx) * 3.0 > this.dy) {
            (this.dx > 0.0 ? this.type.right : this.type.left).draw(d, this.x - 8.0, this.y - 8.0, this.time, false, light, strength, ambient);
        } else {
            this.type.down.draw(d, this.x - 8.0, this.y - 8.0, this.time, false, light, strength, ambient);
        }
    }

    static double m(double v) {
        return v * (0.8 + AGame.ANIM_R.nextDouble() * 0.5);
    }

    static int m(int v) {
        return (int)Bird.m((double)v);
    }

    public static class Circle
    implements Behavior {
        public double circleW = 100.0;
        public double circleH = 10.0;
        public int upDownH = 200;
        public int circlePeriod = 5100;
        public int upDownPeriod = 62300;

        @Override
        public Behavior mutate() {
            Circle c2 = new Circle();
            c2.circleW = Bird.m(this.circleW);
            c2.circleH = Bird.m(this.circleH);
            c2.upDownH = Bird.m(this.upDownH);
            c2.circlePeriod = Bird.m(this.circlePeriod);
            c2.upDownPeriod = Bird.m(this.upDownPeriod);
            return c2;
        }

        public Circle(double circleW, double circleH, int upDownH, int circlePeriod, int upDownPeriod) {
            this.circleW = circleW;
            this.circleH = circleH;
            this.upDownH = upDownH;
            this.circlePeriod = circlePeriod;
            this.upDownPeriod = upDownPeriod;
        }

        public Circle() {
        }

        @Override
        public void behave(Bird b, ArrayList<Bird> birds, int ms) {
            if (b.counter == 0) {
                b.targetX = b.x;
                b.targetY = b.y - (double)this.upDownH;
                b.counter = AGame.ANIM_R.nextInt(this.circlePeriod + this.upDownPeriod) + 1;
            }
            double newX = b.targetX + Math.cos((double)b.counter * 1.0 / (double)this.circlePeriod) * this.circleW;
            double newY = b.targetY + Math.sin((double)b.counter * 1.0 / (double)this.circlePeriod) * this.circleH + Math.sin((double)b.counter * 1.0 / (double)this.upDownPeriod) * (double)this.upDownH;
            if (b.counter == 0) {
                b.x = newX;
                b.y = newY;
                b.dx = 0.0;
                b.dy = 0.0;
            } else {
                b.dx = (newX - b.x) * 1000.0 / (double)ms;
                b.dy = (newY - b.y) * 1000.0 / (double)ms;
            }
            b.counter += ms;
        }
    }

    public static class FlyAcross
    implements Behavior {
        @Override
        public void behave(Bird b, ArrayList<Bird> birds, int ms) {
            b.dx = -b.type.maxSpeed;
            b.dy = 0.0;
            if (b.x < b.minX) {
                b.x = b.maxX;
            }
        }

        @Override
        public Behavior mutate() {
            return this;
        }
    }

    public static class VSpawner
    implements Spawner {
        public double minY;
        public double maxY;
        public double xSpawn;

        public VSpawner(double minY, double maxY, double xSpawn) {
            this.minY = minY;
            this.maxY = maxY;
            this.xSpawn = xSpawn;
        }

        @Override
        public void spawn(ArrayList<Bird> birds, Type type, double minX, double minY, double maxX, double maxY) {
            double y = minY + AGame.ANIM_R.nextDouble() * (maxY - minY);
            birds.add(new Bird(type, this.xSpawn, y, minX, minY, maxX, maxY));
            birds.add(new Bird(type, this.xSpawn + 30.0 + (double)AGame.ANIM_R.nextInt(5), y + 10.0 + (double)AGame.ANIM_R.nextInt(3), minX, minY, maxX, maxY));
            birds.add(new Bird(type, this.xSpawn + 62.0 + (double)AGame.ANIM_R.nextInt(5), y + 21.0 + (double)AGame.ANIM_R.nextInt(3), minX, minY, maxX, maxY));
            birds.add(new Bird(type, this.xSpawn + 30.0 + (double)AGame.ANIM_R.nextInt(5), y - 10.0 - (double)AGame.ANIM_R.nextInt(3), minX, minY, maxX, maxY));
            birds.add(new Bird(type, this.xSpawn + 62.0 + (double)AGame.ANIM_R.nextInt(5), y - 21.0 - (double)AGame.ANIM_R.nextInt(3), minX, minY, maxX, maxY));
        }
    }

    public static class Boid
    implements Behavior {
        public double neighbourDistance = 150.0;
        public double centreOfMassWeight = 0.01;
        public double minDistance = 15.0;
        public double minDistanceWeight = 1.5;
        public double matchVelocityWeight = 0.125;
        public double stayInBoundsWeight = 0.04;

        @Override
        public Boid mutate() {
            Boid b2 = new Boid();
            b2.neighbourDistance = Bird.m(this.neighbourDistance);
            b2.centreOfMassWeight = Bird.m(this.centreOfMassWeight);
            b2.minDistance = Bird.m(this.minDistance);
            b2.minDistanceWeight = Bird.m(this.minDistanceWeight);
            b2.matchVelocityWeight = Bird.m(this.matchVelocityWeight);
            b2.stayInBoundsWeight = Bird.m(this.stayInBoundsWeight);
            return b2;
        }

        @Override
        public void behave(Bird me, ArrayList<Bird> birds, int ms) {
            double comX = 0.0;
            double comY = 0.0;
            double covX = 0.0;
            double covY = 0.0;
            int neighbourCount = 0;
            int bl = birds.size();
            for (int bi = 0; bi < bl; ++bi) {
                double distSq;
                Bird b = birds.get(bi);
                if (b == me || !((distSq = (me.x - b.x) * (me.x - b.x) + (me.y - b.y) * (me.y - b.y)) < this.neighbourDistance * this.neighbourDistance)) continue;
                comX += b.x;
                comY += b.y;
                covX += b.dx;
                covY += b.dy;
                ++neighbourCount;
                if (!(distSq < this.minDistance * this.minDistance)) continue;
                me.dx += (me.x - b.x) * this.minDistanceWeight;
                me.dy += (me.y - b.y) * this.minDistanceWeight;
            }
            if (neighbourCount > 0) {
                me.dx += (comX / (double)neighbourCount - me.x) * this.centreOfMassWeight;
                me.dy += (comY / (double)neighbourCount - me.y) * this.centreOfMassWeight;
                me.dx += covX / (double)neighbourCount * this.matchVelocityWeight;
                me.dy += covY / (double)neighbourCount * this.matchVelocityWeight;
            }
            if (me.x < me.minX) {
                me.dx += (me.minX - me.x) * this.stayInBoundsWeight * (double)(neighbourCount + 10);
            }
            if (me.x > me.maxX) {
                me.dx -= (me.x - me.maxX) * this.stayInBoundsWeight * (double)(neighbourCount + 10);
            }
            if (me.y < me.minY) {
                me.dy += (me.minY - me.y) * this.stayInBoundsWeight * (double)(neighbourCount + 10);
            }
            if (me.y > me.maxY) {
                me.dy -= (me.y - me.maxY) * this.stayInBoundsWeight * (double)(neighbourCount + 10);
            }
        }
    }

    public static class FlockSpawner
    implements Spawner {
        public final int min;
        public final int max;
        public final int flockDist;
        public final int targetH;
        public final boolean hasTargetH;

        public FlockSpawner(int min, int max, int flockDist) {
            this.min = min;
            this.max = max;
            this.flockDist = flockDist;
            this.targetH = 0;
            this.hasTargetH = false;
        }

        public FlockSpawner(int min, int max, int flockDist, int targetH) {
            this.min = min;
            this.max = max;
            this.flockDist = flockDist;
            this.targetH = targetH;
            this.hasTargetH = true;
        }

        @Override
        public void spawn(ArrayList<Bird> birds, Type type, double minX, double minY, double maxX, double maxY) {
            int n = this.min + (this.max > this.min ? AGame.ANIM_R.nextInt(this.max - this.min) : 0);
            double swarmX = minX + AGame.ANIM_R.nextDouble() * (maxX - minX);
            double swarmY = this.hasTargetH ? (double)this.targetH : minY + AGame.ANIM_R.nextDouble() * (maxY - minY);
            for (int i = 0; i < n; ++i) {
                birds.add(new Bird(type, swarmX + AGame.ANIM_R.nextDouble() * (double)this.flockDist - (double)(this.flockDist / 2), swarmY + AGame.ANIM_R.nextDouble() * (double)this.flockDist - (double)(this.flockDist / 2), minX, minY, maxX, maxY));
            }
        }
    }

    public static interface Spawner {
        public void spawn(ArrayList<Bird> var1, Type var2, double var3, double var5, double var7, double var9);
    }

    public static interface Behavior {
        public void behave(Bird var1, ArrayList<Bird> var2, int var3);

        public Behavior mutate();
    }

    public static class Type {
        public final Behavior behavior;
        public final double maxSpeed;
        public final Appearance left;
        public final Appearance right;
        public final Appearance down;
        public final Spawner spawner;

        public Type(Behavior behavior, double maxSpeed, Spawner spawner, Appearance left, Appearance right, Appearance down) {
            this.behavior = behavior;
            this.maxSpeed = maxSpeed;
            this.spawner = spawner;
            this.left = left;
            this.right = right;
            this.down = down;
        }

        public void spawn(ArrayList<Bird> birds, double minX, double minY, double maxX, double maxY) {
            this.spawner.spawn(birds, this, minX, minY, maxX, maxY);
        }
    }
}

