/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Cursor;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class BoardCommandTool
implements UniScreen.Tool {
    public boolean transfer;

    public BoardCommandTool(boolean transfer) {
        this.transfer = transfer;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        double y;
        if (us.combat == null || us.selectedShip == null) {
            return;
        }
        double x = us.screenToWorldX(cursor.x);
        Airship hs = this.hoverShip(us, x, y = us.screenToWorldY(cursor.y));
        if (hs != null) {
            d.state.setCursor(Cursor.FULL_TARGET, Clr.ORANGE, null);
            d.scale(us.zoom, us.zoom);
            d.shift(us.adjScrollX, us.adjScrollY);
            SelectionVisualLayer.drawGridBodyOutline(d, us, hs, SelectionVisualLayer.BOARD, SelectionVisualLayer.BOARD2);
            d.resetTransforms();
        } else {
            d.state.setCursor(Cursor.EMPTY_TARGET, Clr.ORANGE, null);
        }
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        boolean hasMarines = us.selectedShip.hasCrewType(CrewType.MARINE);
        boolean hasGrenadiers = us.selectedShip.hasCrewType(CrewType.GRENADIER);
        int tsz = us.mySide.troops.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Crewman cm = us.mySide.troops.get(ti);
            if (cm.attachedTo != us.selectedShip) continue;
            if (cm.type == CrewType.GRENADIER) {
                hasGrenadiers = true;
                continue;
            }
            hasMarines = true;
        }
        double w = 2.0 / us.zoom;
        if (hasMarines) {
            d.rect(SelectionVisualLayer.BOARD, us.selectedShip.x - 50.0, us.selectedShip.y, w, us.selectedShip.getBBHeight());
            d.rect(SelectionVisualLayer.BOARD, us.selectedShip.x + us.selectedShip.getBBWidth() + 50.0 - w, us.selectedShip.y, w, us.selectedShip.getBBHeight());
        }
        if (hasGrenadiers) {
            d.rect(SelectionVisualLayer.BOARD, us.selectedShip.x - 250.0, us.selectedShip.y, w, us.selectedShip.getBBHeight());
            d.rect(SelectionVisualLayer.BOARD, us.selectedShip.x + us.selectedShip.getBBWidth() + 250.0 - w, us.selectedShip.y, w, us.selectedShip.getBBHeight());
        }
        d.resetTransforms();
    }

    public Airship hoverShip(UniScreen us, double x, double y) {
        Combat.Side side = this.transfer ? us.mySide : us.combat.otherSide(us.mySide);
        for (Airship as : side.ships) {
            if (as == us.selectedShip || !Rect2D.contains(as.x, as.y, as.getBBWidth(), as.getBBHeight(), x, y)) continue;
            return as;
        }
        return null;
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        double y;
        double x = us.screenToWorldX(click.x);
        Airship hs = this.hoverShip(us, x, y = us.screenToWorldY(click.y));
        if (hs != null) {
            us.combat.giveCommand(Client.msg("board").put("id", us.combat.getShipID(us.selectedShip)).put("target", us.combat.getShipID(hs)));
            us.tool = UniScreen.NAVIGATE;
        }
        return true;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed("ESCAPE")) {
            us.tool = UniScreen.NAVIGATE;
        }
    }

    public static boolean canBoard(Airship ship, Combat.Side side) {
        if (ship.hasCrewType(CrewType.MARINE) || ship.hasCrewType(CrewType.GRENADIER) || ship.hasCrewType(CrewType.ARACHNID)) {
            return true;
        }
        int tsz = side.troops.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Crewman cm = side.troops.get(ti);
            if (cm.attachedTo != ship) continue;
            return true;
        }
        return false;
    }
}

