/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.WeatherEffect;
import java.util.ArrayList;
import java.util.Iterator;

public strictfp abstract class Body
extends PhysicsRect {
    public transient double newX;
    public transient double oldX;
    public transient double xSpeed;
    public transient double postCollideXSpeed;
    public transient double xForce;
    public transient double groupXSpeed;
    public transient double newY;
    public transient double oldY;
    public transient double ySpeed;
    public transient double postCollideYSpeed;
    public transient double yForce;
    public transient double groupYSpeed;
    public transient ArrayList<Body> colliderGroup;
    public transient ArrayList<Particle> stuckParticles = new ArrayList();

    public void particlesTick(int ms, Combat c) {
        double dripSpeed = c.timeOfDay.effect == WeatherEffect.RAIN || c.timeOfDay.effect == WeatherEffect.STORM ? 5.0E-4 : 2.0E-4;
        Iterator<Particle> it = this.stuckParticles.iterator();
        while (it.hasNext()) {
            Particle p = it.next();
            p.life -= ms;
            if (p.life <= 0) {
                it.remove();
                return;
            }
            if (p.type.dissolveWhenStuck) continue;
            p.y += dripSpeed * (double)ms;
            if (!(p.y > this.getBBHeight())) continue;
            p.dx = 0.0;
            p.dy = 0.02;
            p.x += this.x;
            p.y += this.y;
            p.life /= 64;
            p.lifespan = p.type.maxLifespan;
            c.particles.add(p);
            it.remove();
        }
    }

    public abstract boolean canParticleStick(double var1, double var3);

    public void removeUnstuckParticles() {
        Iterator<Particle> it = this.stuckParticles.iterator();
        while (it.hasNext()) {
            Particle p = it.next();
            if (this.canParticleStick(this.x + p.x, this.y + p.y)) continue;
            it.remove();
        }
    }

    public abstract int getCollisionMass();

    public abstract int getMass();

    public abstract boolean isImmobile();

    public abstract boolean removeMe();

    public abstract double elasticity();

    public abstract double horizontalAirFriction();

    public abstract double verticalAirFriction();

    public abstract boolean collidesWith(PhysicsRect var1);

    public abstract void doCollision(Body var1, double var2, Combat var4, boolean var5);

    public abstract boolean isAtSpeed();
}

