/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.LandFormation;
import java.util.ArrayList;
import java.util.LinkedList;

public strictfp class BodyPathing {
    public int[][] matrix;
    private int[] distFlood;
    private int lastUpdated = -1;

    public void update(Combat c) {
        if (c.time == this.lastUpdated) {
            return;
        }
        if (c.physics == null) {
            return;
        }
        if (this.matrix == null || this.matrix.length != c.physics.bodies.size()) {
            this.matrix = new int[c.physics.bodies.size()][c.physics.bodies.size()];
            this.distFlood = new int[c.physics.bodies.size()];
        }
        this.lastUpdated = c.time;
        for (int fromIndex = 0; fromIndex < this.matrix.length; ++fromIndex) {
            int toIndex;
            Body fromBody = c.physics.bodies.get(fromIndex);
            if (!(fromBody instanceof GridBody)) {
                for (toIndex = 0; toIndex < this.matrix.length; ++toIndex) {
                    this.matrix[fromIndex][toIndex] = 0;
                }
                continue;
            }
            for (toIndex = 0; toIndex < this.matrix.length; ++toIndex) {
                if (toIndex == fromIndex) {
                    this.matrix[fromIndex][toIndex] = 0;
                    continue;
                }
                Body toBody = c.physics.bodies.get(toIndex);
                this.matrix[fromIndex][toIndex] = toBody instanceof GridBody ? this.pathValue((GridBody)fromBody, (GridBody)toBody) : 0;
            }
        }
    }

    public int pathValue(GridBody from, GridBody to) {
        double yDelta;
        double xDist = to.x > from.x + from.getBBWidth() ? to.x - from.x - from.getBBWidth() : (from.x > to.x + to.getBBWidth() ? from.x - to.x - to.getBBWidth() : 0.0);
        double toY = to.y;
        if (to instanceof LandFormation && to.isImmobile()) {
            LandFormation ground = (LandFormation)to;
            toY = ground.y + ground.getBBHeight();
            for (double wx = from.x; wx < from.x + from.getBBWidth(); wx += 16.0) {
                toY = Math.min(toY, ground.yBoundaryAt(wx));
            }
        }
        double d = toY > from.y + from.getBBHeight() ? toY - from.y - from.getBBHeight() : (yDelta = from.y > toY + to.getBBHeight() ? toY + to.getBBHeight() - from.y : 0.0);
        if (xDist < 32.0 && yDelta >= 0.0 && yDelta < 120.0) {
            return 2;
        }
        if (from instanceof Airship && ((Airship)from).lastGrounded == to && ((Airship)from).msSinceOnGround < 100) {
            return 2;
        }
        if (to instanceof Airship && ((Airship)to).lastGrounded == from && ((Airship)to).msSinceOnGround < 100) {
            return 2;
        }
        if (xDist + Math.abs(yDelta) < 234.0 && !to.isImmobile()) {
            return 1;
        }
        return 0;
    }

    public boolean connected(GridBody src, GridBody trg, int requiredLink, Combat c) {
        this.update(c);
        int trgIndex = c.physics.bodies.indexOf(trg);
        if (trgIndex == -1) {
            return false;
        }
        int srcIndex = c.physics.bodies.indexOf(src);
        if (srcIndex == -1) {
            return false;
        }
        return this.matrix[srcIndex][trgIndex] >= requiredLink;
    }

    public GridBody getNextInPath(GridBody src, GridBody trg, int requiredLink, Combat c) {
        this.update(c);
        for (int i = 0; i < this.distFlood.length; ++i) {
            this.distFlood[i] = Integer.MAX_VALUE;
        }
        int trgIndex = c.physics.bodies.indexOf(trg);
        if (trgIndex == -1) {
            return null;
        }
        int srcIndex = c.physics.bodies.indexOf(src);
        if (srcIndex == -1) {
            return null;
        }
        this.distFlood[trgIndex] = 0;
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(trgIndex);
        while (this.distFlood[srcIndex] == Integer.MAX_VALUE && !q.isEmpty()) {
            int to = (Integer)q.pollFirst();
            for (int from = 0; from < this.matrix.length; ++from) {
                if (this.matrix[from][to] < requiredLink || this.distFlood[from] <= this.distFlood[to] + 1) continue;
                this.distFlood[from] = this.distFlood[to] + 1;
                q.add(from);
            }
        }
        if (this.distFlood[srcIndex] != Integer.MAX_VALUE) {
            for (int nextHopCandidate = 0; nextHopCandidate < this.matrix[srcIndex].length; ++nextHopCandidate) {
                if (this.distFlood[nextHopCandidate] >= this.distFlood[srcIndex] || this.matrix[srcIndex][nextHopCandidate] < requiredLink) continue;
                return (GridBody)c.physics.bodies.get(nextHopCandidate);
            }
        }
        return null;
    }

    public ArrayList<GridBody> getPath(GridBody src, GridBody trg, int requiredLink, Combat c) {
        this.update(c);
        for (int i = 0; i < this.distFlood.length; ++i) {
            this.distFlood[i] = Integer.MAX_VALUE;
        }
        int trgIndex = c.physics.bodies.indexOf(trg);
        if (trgIndex == -1) {
            return null;
        }
        int srcIndex = c.physics.bodies.indexOf(src);
        if (srcIndex == -1) {
            return null;
        }
        this.distFlood[trgIndex] = 0;
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(trgIndex);
        while (this.distFlood[srcIndex] == Integer.MAX_VALUE && !q.isEmpty()) {
            int to = (Integer)q.pollFirst();
            for (int from = 0; from < this.matrix.length; ++from) {
                if (this.matrix[from][to] < requiredLink || this.distFlood[from] <= this.distFlood[to] + 1) continue;
                this.distFlood[from] = this.distFlood[to] + 1;
                q.add(from);
            }
        }
        if (this.distFlood[srcIndex] != Integer.MAX_VALUE) {
            ArrayList<GridBody> l = new ArrayList<GridBody>();
            int pathI = srcIndex;
            block3: while (pathI != trgIndex) {
                for (int nextHopCandidate = 0; nextHopCandidate < this.matrix[pathI].length; ++nextHopCandidate) {
                    if (this.distFlood[nextHopCandidate] >= this.distFlood[pathI] || this.matrix[pathI][nextHopCandidate] < requiredLink) continue;
                    l.add((GridBody)c.physics.bodies.get(nextHopCandidate));
                    pathI = nextHopCandidate;
                    continue block3;
                }
            }
            return l;
        }
        return null;
    }
}

