/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AffordableFilter;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.json.JSONObject;
import org.json.JSONTokener;

public class BuildFromDesignButton
extends UniScreen.Button {
    public ShipType type;

    public BuildFromDesignButton(ShipType type) {
        this.type = type;
    }

    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof DefencesIntent;
    }

    @Override
    public boolean enabled(UniScreen us) {
        return us.city.constructing == null;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Build_" + this.type.name(), new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        this.buildFromTemplate(us, this.type);
    }

    @Override
    public String hotkey(UniScreen us) {
        switch (this.type) {
            case AIRSHIP: {
                return "S";
            }
            case BUILDING: {
                return "B";
            }
        }
        return null;
    }

    private void buildFromTemplate(UniScreen us, ShipType st) {
        Empire empire = us.wm.owner(us.city);
        ShipHelperWidget shw = ShipHelperWidget.get(new File(AGame.getGameDirectory(), st.dirName), empire.arms, empire.bonuses(), empire.money);
        FileScreen fs = new FileScreen(ShipEditorUtils.shipsList(st, shw), new OpenMission(us.g, us, st, empire), shw, new PriceInlineInfo(shw, null));
        fs.enabledFilter = new AffordableFilter(empire.money, empire.bonuses(), shw, null);
        us.g.s = fs;
    }

    private static class OpenMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;
        private final ShipType type;
        private final Empire empire;

        public OpenMission(AirshipGame g, UniScreen us, ShipType type, Empire empire) {
            this.g = g;
            this.us = us;
            this.type = type;
            this.empire = empire;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Open_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Open", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileSelected(String name) {
            this.g.s = this.us;
            BufferedReader r = null;
            try {
                r = new BufferedReader(new FileReader(new File(new File(AGame.getGameDirectory(), this.type.dirName), name + ".json")));
                Airship ship = new Airship(new JSONObject(new JSONTokener(r)));
                ship.constructionBonuses = this.empire.bonuses();
                ship.currentBonuses = this.empire.bonuses();
                this.us.tool = new PlaceShipTool(ship, false, null, 1, true);
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_ship_or_building", new Object[0]), e, name, false);
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

