/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.StrategicAI;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.Img;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.json.JSONObject;

public class CampaignWorld
implements JSONAble {
    public final WorldMap map;
    public Empire player;
    public Random r = new Random();
    public CombatInfo combatInfo;
    public Speed speed = Speed.NORMAL;
    private final AirshipGame g;
    public static final int SAVE_VERSION = 7000;

    public boolean victory() {
        return this.player.cities.containsAll(this.map.cities());
    }

    public boolean defeat() {
        return this.player.cities.isEmpty();
    }

    public CampaignWorld(long seed, WorldMap.Size size, AirshipGame g, CoatOfArms playerCOA) {
        this.map = new WorldMap(seed, size, g, playerCOA);
        this.g = g;
    }

    public void setupPlayer(String playerName, CoatOfArms coa) {
        this.player = this.map.empires.get(0);
        this.player.name = playerName;
        this.player.arms = coa;
        this.player.bonus = coa.getBonus();
        this.player.cities.get((int)0).name = playerName;
        this.player.cities.get((int)0).bonus = Bonus.NO_BONUS;
    }

    public CampaignWorld(WorldMap map, Empire player, AirshipGame g) {
        this.map = map;
        this.player = player;
        this.g = g;
    }

    public CampaignWorld(JSONObject o, AirshipGame g) {
        this.map = new WorldMap(o.getJSONObject("map"), g);
        this.player = this.map.empires.get(o.getInt("player"));
        this.speed = Speed.valueOf(o.getString("speed"));
        this.g = g;
        if (o.has("combatInfo")) {
            this.combatInfo = new CombatInfo(o.getJSONObject("combatInfo"), this, g);
            this.combatInfo.finish(o.getJSONObject("combatInfo"), this);
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject().put("version", 7000).put("map", this.map.toJSON()).put("player", this.map.empires.indexOf(this.player)).put("speed", this.speed.name());
        if (this.combatInfo != null) {
            o.put("combatInfo", this.combatInfo.toJSON(this));
        }
        return o;
    }

    public void tick(int ms) {
        ms = (int)((double)ms * this.speed.msMult);
        if (this.speed != Speed.STOP) {
            for (Empire e : new ArrayList<Empire>(this.map.empires)) {
                if (e == this.player || !this.map.empires.contains(e)) continue;
                StrategicAI.tick(this, this.map, e);
            }
        }
        this.map.tick(ms);
        this.map.resolveUncontestedSeaIntercepts(this.player);
        this.map.quickResolveCombats(this.player, this.r);
        this.combatInfo = this.map.getCombatFor(this.player, this.g);
        if (this.combatInfo != null) {
            for (Combat.Side side : this.combatInfo.combat.sides) {
                int count;
                for (Airship ship : side.ships) {
                    count = 0;
                    for (Airship ship2 : side.ships) {
                        if (ship != ship2) continue;
                        ++count;
                    }
                    for (Airship ship2 : side.reserve) {
                        if (ship != ship2) continue;
                        ++count;
                    }
                    if (count == 1) continue;
                    System.out.println("Miscount in combat setup: " + count);
                }
                for (Airship ship : side.reserve) {
                    count = 0;
                    for (Airship ship2 : side.ships) {
                        if (ship != ship2) continue;
                        ++count;
                    }
                    for (Airship ship2 : side.reserve) {
                        if (ship != ship2) continue;
                        ++count;
                    }
                    if (count == 1) continue;
                    System.out.println("Miscount in combat setup: " + count);
                }
            }
        }
    }

    public CombatOutcomeType postCombat() {
        Fleet garrison;
        Empire attacker = this.map.owner(this.combatInfo.attackingFleet);
        Empire defender = this.combatInfo.defendingCity == null ? this.map.owner(this.combatInfo.defendingFleet) : this.map.owner(this.combatInfo.defendingCity);
        boolean attackerWon = this.combatInfo.combat.won(this.combatInfo.combat.sides.get(0));
        boolean defenderWon = this.combatInfo.combat.won(this.combatInfo.combat.sides.get(1));
        boolean seaIntercept = this.combatInfo.defendingFleet != null && this.combatInfo.defendingFleet.usingRoad != null && this.combatInfo.defendingFleet.usingRoad.seaRoute;
        this.combatInfo.combat.pruneUselessShips();
        this.combatInfo.combat.repairShips();
        ArrayList<Airship> originalShips = new ArrayList<Airship>(this.combatInfo.attackingFleet.actives);
        originalShips.addAll(this.combatInfo.attackingFleet.reserve);
        this.combatInfo.attackingFleet.actives.clear();
        for (Airship sh : this.combatInfo.combat.sides.get((int)0).ships) {
            if (!sh.type.mobile) continue;
            this.combatInfo.attackingFleet.actives.add(sh);
        }
        this.combatInfo.attackingFleet.reserve.clear();
        for (Airship sh : this.combatInfo.combat.sides.get((int)0).reserve) {
            if (!sh.type.mobile) continue;
            this.combatInfo.attackingFleet.reserve.add(sh);
        }
        if (attacker == this.player && this.combatInfo.defendingCity != null) {
            for (Airship orig : originalShips) {
                if (this.combatInfo.attackingFleet.actives.contains(orig) || this.combatInfo.attackingFleet.reserve.contains(orig)) continue;
                this.combatInfo.defendingCity.addMessage(City.MessageType.LOST_SHIP, Lang._t("Lost_x", orig.name));
            }
        }
        if (this.combatInfo.attackingFleet.actives.isEmpty() && this.combatInfo.attackingFleet.reserve.isEmpty()) {
            Empire attackOwner = this.map.owner(this.combatInfo.attackingFleet);
            if (attackOwner != null) {
                attackOwner.fleets.remove(this.combatInfo.attackingFleet);
            }
            this.combatInfo.attackingFleet.broadcastDestroyed(this.map);
        } else if (!attackerWon || this.combatInfo.attackingFleet.interceptTarget != null) {
            this.combatInfo.attackingFleet.stopAndAskForHelp();
        }
        if (this.combatInfo.defendingFleet != null) {
            originalShips = new ArrayList<Airship>(this.combatInfo.defendingFleet.actives);
            originalShips.addAll(this.combatInfo.defendingFleet.reserve);
            if (attackerWon || !seaIntercept) {
                this.combatInfo.defendingFleet.actives.clear();
                this.combatInfo.defendingFleet.reserve.clear();
            } else {
                Iterator<Airship> shipIt = this.combatInfo.defendingFleet.actives.iterator();
                while (shipIt.hasNext()) {
                    if (shipIt.next().type == ShipType.LANDSHIP) continue;
                    shipIt.remove();
                }
                shipIt = this.combatInfo.defendingFleet.reserve.iterator();
                while (shipIt.hasNext()) {
                    if (shipIt.next().type == ShipType.LANDSHIP) continue;
                    shipIt.remove();
                }
            }
            for (Airship ship : this.combatInfo.combat.sides.get((int)1).ships) {
                if (!ship.type.mobile) continue;
                this.combatInfo.defendingFleet.actives.add(ship);
            }
            this.combatInfo.defendingFleet.reserve.addAll(this.combatInfo.combat.sides.get((int)1).reserve);
            Empire dOwner = this.map.owner(this.combatInfo.defendingFleet);
            if (this.combatInfo.defendingFleet.actives.isEmpty() && this.combatInfo.defendingFleet.reserve.isEmpty()) {
                dOwner.fleets.remove(this.combatInfo.defendingFleet);
                this.combatInfo.defendingFleet.broadcastDestroyed(this.map);
                if (seaIntercept) {
                    attacker.messages.add(new Empire.Message(Empire.MessageType.ENEMY_REMAINING_LANDSHIPS_DESTROYED, null, Lang._t("enemy_remaining_landships_destroyed", new Object[0])));
                }
            } else if (this.combatInfo.defendingFleet.interceptTarget != null || attackerWon) {
                this.combatInfo.defendingFleet.stopAndAskForHelp();
                if (attackerWon && seaIntercept) {
                    attacker.messages.add(new Empire.Message(Empire.MessageType.ENEMY_ABANDONED_LANDSHIPS, null, Lang._t("enemy_abandoned_landships", new Object[0])));
                }
            }
            if (defender == this.player && this.combatInfo.defendingCity != null) {
                for (Airship orig : originalShips) {
                    if (this.combatInfo.defendingFleet.actives.contains(orig) || this.combatInfo.defendingFleet.reserve.contains(orig)) continue;
                    this.combatInfo.defendingCity.addMessage(City.MessageType.LOST_SHIP, Lang._t("Lost_x", orig.name));
                }
            }
        }
        if (this.combatInfo.defendingCity != null) {
            this.combatInfo.defendingCity.clearDefences();
            for (Airship building : this.combatInfo.combat.sides.get((int)1).ships) {
                if (building.type.mobile) continue;
                this.combatInfo.defendingCity.addDefence(building);
            }
            for (Airship building : this.combatInfo.combat.sides.get((int)0).ships) {
                if (building.type.mobile) continue;
                this.combatInfo.defendingCity.addDefence(building);
            }
            if (attackerWon) {
                Empire loser = this.map.owner(this.combatInfo.defendingCity);
                loser.cities.remove(this.combatInfo.defendingCity);
                if (loser.cities.isEmpty()) {
                    this.map.removeEmpire(loser);
                }
                attacker.cities.add(this.combatInfo.defendingCity);
                if (this.combatInfo.defendingCity.constructing != null) {
                    attacker.money += this.combatInfo.defendingCity.constructionProgress / 400;
                    this.combatInfo.defendingCity.constructing = null;
                }
                this.combatInfo.defendingCity.takeoverAmount = 0;
                this.combatInfo.defendingCity.takeoverMethod = null;
                if (!attacker.bonuses().contains((Object)Bonus.RIGHTFUL_KING) && this.combatInfo.defendingCity.originalEmpire != attacker) {
                    this.combatInfo.defendingCity.takeoverNeeded = true;
                }
                this.map.dirty = true;
            }
            this.combatInfo.defendingCity.floaters.clear();
            if (this.combatInfo.combat.landFormations.size() > 1) {
                this.combatInfo.defendingCity.floaters.addAll(this.combatInfo.combat.landFormations.subList(1, this.combatInfo.combat.landFormations.size()));
            }
        }
        if (this.combatInfo.defendingCity != null && (garrison = this.map.getGarrison(this.combatInfo.defendingCity)) != null) {
            this.combatInfo.defendingCity.layoutGarrison(garrison);
        }
        this.combatInfo = null;
        if (attackerWon) {
            return attacker == this.player ? CombatOutcomeType.VICTORY : CombatOutcomeType.DEFEAT;
        }
        if (defenderWon) {
            return attacker != this.player ? CombatOutcomeType.VICTORY : CombatOutcomeType.DEFEAT;
        }
        return CombatOutcomeType.DRAW;
    }

    public static enum CombatOutcomeType {
        VICTORY,
        DEFEAT,
        DRAW;


        public String getName() {
            return Lang._t(this.name(), new Object[0]);
        }
    }

    public static class CombatInfo {
        public Combat combat;
        public Fleet attackingFleet;
        public Fleet defendingFleet;
        public City defendingCity;
        public int playerCombatSideIndex;
        public boolean setupComplete;

        public CombatInfo(Combat combat, Fleet attackingFleet, Fleet defendingFleet, City defendingCity, int playerCombatSideIndex, boolean setupComplete) {
            this.combat = combat;
            this.attackingFleet = attackingFleet;
            this.defendingFleet = defendingFleet;
            this.defendingCity = defendingCity;
            this.playerCombatSideIndex = playerCombatSideIndex;
            this.setupComplete = setupComplete;
        }

        public JSONObject toJSON(CampaignWorld w) {
            JSONObject o = new JSONObject().put("combat", this.combat.toJSON()).put("playerCombatSideIndex", this.playerCombatSideIndex).put("setupComplete", this.setupComplete);
            o.put("attackingFleetOwnerIndex", w.map.empires.indexOf(w.map.owner(this.attackingFleet)));
            o.put("attackingFleetIndex", w.map.owner((Fleet)this.attackingFleet).fleets.indexOf(this.attackingFleet));
            if (this.defendingFleet != null) {
                o.put("defendingFleetOwnerIndex", w.map.empires.indexOf(w.map.owner(this.defendingFleet)));
                o.put("defendingFleetIndex", w.map.owner((Fleet)this.defendingFleet).fleets.indexOf(this.defendingFleet));
            }
            if (this.defendingCity != null) {
                o.put("defendingCityOwnerIndex", w.map.empires.indexOf(w.map.owner(this.defendingCity)));
                o.put("defendingCityIndex", w.map.owner((City)this.defendingCity).cities.indexOf(this.defendingCity));
            }
            return o;
        }

        public CombatInfo(JSONObject o, CampaignWorld w, AirshipGame g) {
            this.combat = new Combat(g, o.getJSONObject("combat"));
            this.playerCombatSideIndex = o.getInt("playerCombatSideIndex");
            this.setupComplete = o.getBoolean("setupComplete");
        }

        public void finish(JSONObject o, CampaignWorld w) {
            this.attackingFleet = w.map.empires.get((int)o.getInt((String)"attackingFleetOwnerIndex")).fleets.get(o.getInt("attackingFleetIndex"));
            if (o.has("defendingFleetOwnerIndex")) {
                this.defendingFleet = w.map.empires.get((int)o.getInt((String)"defendingFleetOwnerIndex")).fleets.get(o.getInt("defendingFleetIndex"));
            }
            if (o.has("defendingCityOwnerIndex")) {
                this.defendingCity = w.map.empires.get((int)o.getInt((String)"defendingCityOwnerIndex")).cities.get(o.getInt("defendingCityIndex"));
            }
        }
    }

    public static enum Speed {
        STOP("||", 0.0, new Img("spritesheet", 96, 512, 16, 16, false)),
        NORMAL(">", 2.0, new Img("spritesheet", 112, 512, 16, 16, false)),
        FAST(">>", 4.0, new Img("spritesheet", 128, 512, 16, 16, false)),
        CHEETAH(">>>", 8.0, new Img("spritesheet", 144, 512, 16, 16, false));

        public final String symbol;
        public final double msMult;
        public final Img icon;

        private Speed(String symbol, double msMult, Img icon) {
            this.symbol = symbol;
            this.msMult = msMult;
            this.icon = icon;
        }
    }
}

