/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.ShipArrayList;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public class City {
    public static final String[] NAMES = new String[]{"Krantzberg", "Fjordon", "Dingleton", "Lonlin", "Northwestex", "Darkfellbane", "Stormness", "Hatwick", "Catwick", "Fruchtenbach", "Irem", "Mettepolis", "Retropolis", "Greytowers", "Blackspire", "Wombaton", "Nuyok", "Lepidoptera", "Tepid Falls", "Subtle Creek", "Ungrashzon", "Strultekud", "Gomdat", "Daggergild", "Sigun", "Lubbud", "Woundford", "Bardoom", "Gildfield", "Ulthar", "Squamos", "Narlikon", "Pale", "Kulinrovod", "Zirnoglesh", "Crowlantern", "Ringfast", "Likorsoth", "Korono", "Nettacar", "Kolaran", "Sacculina", "Fructopolis", "Ionesco", "Nimbus", "Ul Qoma", "Catbridge", "Gug", "Kooh Der", "Rizzugat", "Uncton"};
    public static final double ECON_DMG_MALUS = 0.2;
    public static final int MAX_ECON_DAMAGES = 4;
    public static final int ECON_DAMAGE_RECOVERY_TIME = 180000;
    public int id;
    public int x;
    public int y;
    public String name;
    public Bonus bonus;
    public int income;
    public int economicDamage;
    public int econDmgRecovery;
    public int appearance = AGame.ANIM_R.nextInt(10);
    public int shipyardLevel;
    public int takeoverAmount;
    public TakeoverMethod takeoverMethod;
    public boolean takeoverNeeded = false;
    private ArrayList<Airship> defences = new ArrayList();
    public Airship constructing;
    public int constructionCost;
    public int constructionProgress;
    public Airship constructionTarget;
    public Empire originalEmpire;
    public LinkedList<Message> messages = new LinkedList();
    public LandFormation ground;
    public ArrayList<LandFormation> floaters = new ArrayList();
    public int alertAmount = 0;
    public transient boolean probablyCoastal = true;
    public transient WorldMap.NavNode navNode = null;
    private static final int MAP_MSG_H = 30;
    private static final int MAP_MSG_TICK_LIFE = 240;
    public static final String[] SHIPYARD_SIZES = new String[]{"shipyard_no", "shipyard_tiny", "shipyard_small", "shipyard_medium", "shipyard_large", "shipyard_huge"};

    public void addDefence(Airship building) {
        if (building.type.mobile) {
            throw new RuntimeException("The defence construction " + building.name + " is mobile!");
        }
        this.defences.add(building);
    }

    public void removeDefence(Airship building) {
        this.defences.remove(building);
    }

    public ArrayList<Airship> getDefences() {
        return new ArrayList<Airship>(this.defences);
    }

    public void clearDefences() {
        this.defences.clear();
    }

    public boolean hasDefence(Airship ship) {
        return this.defences.contains(ship);
    }

    public void replaceDefence(Airship original, Airship newShip) {
        this.defences.set(this.defences.indexOf(original), newShip);
    }

    public City(int id, int x, int y, String name, Bonus bonus, int income, int shipyardLevel) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.name = name;
        this.bonus = bonus;
        this.income = income;
        this.shipyardLevel = shipyardLevel;
    }

    public final void generateLand(Random r) {
        Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(r);
        this.ground = (LandFormation)p.a;
        this.floaters.addAll((Collection)p.b);
    }

    public City(JSONObject o) {
        int i;
        this.id = o.getInt("id");
        this.x = o.getInt("x");
        this.y = o.getInt("y");
        this.name = o.getString("name");
        this.bonus = Bonus.valueOf(o.getString("bonus"));
        this.income = o.getInt("income");
        this.shipyardLevel = o.getInt("shipyardLevel");
        this.takeoverAmount = o.getInt("takeoverAmount");
        this.constructionProgress = o.getInt("constructionProgress");
        this.takeoverNeeded = o.getBoolean("takeoverNeeded");
        this.constructionCost = o.getInt("constructionCost");
        this.alertAmount = o.optInt("alertAmount", 0);
        this.economicDamage = o.optInt("economicDamage", 0);
        this.econDmgRecovery = o.optInt("econDmgRecovery", 0);
        this.appearance = o.optInt("appearance", AGame.ANIM_R.nextInt(10));
        if (o.has("takeoverMethod")) {
            this.takeoverMethod = TakeoverMethod.valueOf(o.getString("takeoverMethod"));
        }
        if (o.has("constructing")) {
            this.constructing = new Airship(o.getJSONObject("constructing"));
        }
        if (o.has("constructionTarget")) {
            this.constructionTarget = new Airship(o.getJSONObject("constructionTarget"));
        }
        JSONArray a = o.getJSONArray("defences");
        for (i = 0; i < a.length(); ++i) {
            this.defences.add(new Airship(a.getJSONObject(i)));
        }
        if (o.has("messages")) {
            a = o.getJSONArray("messages");
            for (i = 0; i < a.length(); ++i) {
                this.messages.add(new Message(a.getJSONObject(i)));
            }
        }
        if (!o.has("ground")) {
            this.generateLand(new Random(this.name.hashCode()));
        } else {
            this.ground = new LandFormation(o.getJSONObject("ground"));
            a = o.getJSONArray("floaters");
            for (i = 0; i < a.length(); ++i) {
                this.floaters.add(new LandFormation(a.getJSONObject(i)));
            }
        }
    }

    public void finish(JSONObject o, WorldMap wm) {
        if (o.has("originalEmpire") && o.getInt("originalEmpire") != -1) {
            this.originalEmpire = wm.empires.get(o.getInt("originalEmpire"));
        }
    }

    public JSONObject toJSON(WorldMap wm) {
        JSONObject o = new JSONObject().put("id", this.id).put("x", this.x).put("y", this.y).put("name", this.name).put("bonus", this.bonus.name()).put("income", this.income).put("shipyardLevel", this.shipyardLevel).put("takeoverAmount", this.takeoverAmount).put("constructionProgress", this.constructionProgress).put("takeoverNeeded", this.takeoverNeeded).put("constructionCost", this.constructionCost).put("ground", this.ground.toJSON()).put("alertAmount", 0).put("economicDamage", this.economicDamage).put("econDmgRecovery", this.econDmgRecovery).put("appearance", this.appearance);
        if (this.takeoverMethod != null) {
            o.put("takeoverMethod", this.takeoverMethod.name());
        }
        if (this.constructing != null) {
            o.put("constructing", this.constructing.toJSON(null));
        }
        if (this.constructionTarget != null) {
            o.put("constructionTarget", this.constructionTarget.toJSON(null));
        }
        JSONArray a = new JSONArray();
        o.put("defences", a);
        for (Airship ship : this.defences) {
            a.put(ship.toJSON(null));
        }
        if (this.originalEmpire != null && wm.empires.contains(this.originalEmpire)) {
            o.put("originalEmpire", wm.empires.indexOf(this.originalEmpire));
        }
        a = new JSONArray();
        o.put("messages", a);
        for (Message m : this.messages) {
            a.put(m.toJSON());
        }
        a = new JSONArray();
        o.put("floaters", a);
        for (LandFormation f : this.floaters) {
            a.put(f.toJSON());
        }
        return o;
    }

    public void addMessage(MessageType type, String text) {
        this.messages.add(0, new Message(type, text, 0));
        this.pushCityMessages();
    }

    private void pushCityMessages() {
        if (this.messages == null) {
            return;
        }
        for (int i = 1; i < this.messages.size(); ++i) {
            if (this.messages.get((int)i).offset >= this.messages.get((int)(i - 1)).offset + 30) continue;
            this.messages.get((int)i).offset = this.messages.get((int)(i - 1)).offset + 30;
        }
    }

    private void tickCityMessages() {
        Iterator it = this.messages.iterator();
        while (it.hasNext()) {
            Message mm = (Message)it.next();
            ++mm.offset;
            if (mm.offset < 240) continue;
            it.remove();
        }
    }

    public int adjustedIncome() {
        return (int)((double)this.income * (1.0 - (double)this.economicDamage * 0.2) * (double)(this.takeoverMethod == null ? 1 : this.takeoverMethod.lootingIncomeMultiplier));
    }

    public int defencesMaintenanceCost() {
        int c = 0;
        for (Airship b : this.defences) {
            c += b.maintenanceCost();
        }
        return c;
    }

    public int constructionTimeCost() {
        return Math.max(0, this.constructionCost) * 50 + 400;
    }

    public boolean canBuild() {
        return !this.takeoverNeeded && this.takeoverMethod == null;
    }

    public void tick(int ms, Empire owner, WorldMap map) {
        this.tickCityMessages();
        this.alertAmount -= ms;
        if (this.alertAmount < 0) {
            this.alertAmount = 0;
        }
        if (this.economicDamage > 0) {
            this.econDmgRecovery += ms;
            if (this.econDmgRecovery > 180000) {
                --this.economicDamage;
                this.econDmgRecovery -= 180000;
                this.addMessage(MessageType.ECON_RECOVERY, Lang._t(this.economicDamage == 0 ? "x_has_fully_recovered_from_the_war" : "x_has_partly_recovered_from_the_war", this.name));
            }
        }
        if (this.takeoverMethod != null) {
            this.takeoverAmount += ms;
            if (this.takeoverAmount >= this.takeoverMethod.takeoverTime) {
                this.economicDamage = Math.min(4, this.economicDamage + this.takeoverMethod.economicDamage);
                this.takeoverMethod = null;
            }
        }
        if (this.takeoverMethod == null && this.constructing != null) {
            this.constructionProgress += ms * this.shipyardLevel;
            if (this.constructionProgress >= this.constructionTimeCost()) {
                this.constructionProgress = 0;
                this.constructing.repair();
                Airship ship = this.constructing;
                this.constructing = null;
                if (ship.type.mobile) {
                    owner.addShipAt(ship, this);
                } else {
                    this.defences.add(ship);
                }
            }
        }
    }

    public ShipList shipList(WorldMap wm) {
        ShipArrayList l = new ShipArrayList(this.defences);
        Fleet fl = wm.getGarrison(this);
        if (fl != null) {
            l.ships.addAll(fl.actives);
        }
        return l;
    }

    public void layoutGarrison(WorldMap wm) {
        Fleet fl = wm.getGarrison(this);
        if (fl == null) {
            return;
        }
        this.layoutGarrison(fl);
    }

    public void layoutGarrison(Fleet fl) {
        ArrayList<Airship> ships = new ArrayList<Airship>(fl.actives);
        fl.actives.clear();
        for (Airship ship : ships) {
            if (this.canPlace(ship, ship.getX(), ship.getY(), 32, fl) || this.placeShip(ship, fl)) {
                fl.actives.add(ship);
                continue;
            }
            fl.reserve.add(ship);
        }
        ships = new ArrayList<Airship>(fl.reserve);
        fl.reserve.clear();
        for (Airship ship : ships) {
            if (this.canPlace(ship, ship.getX(), ship.getY(), 32, fl) || this.placeShip(ship, fl)) {
                fl.actives.add(ship);
                continue;
            }
            fl.reserve.add(ship);
        }
    }

    public boolean placeShip(Airship ship, Fleet garrison) {
        if (ship.type.onGround) {
            for (int sx = 100; sx < 1600; sx += 32) {
                int sy = (int)PlaceShipTool.getAdjustedY(ship, (double)sx, 512.0 - ship.getBBHeight() - ship.groundOffset(), this.ground, false);
                if (!this.canPlace(ship, sx, sy, 32, garrison)) continue;
                ship.setX(sx);
                ship.setY(sy);
                return true;
            }
        } else {
            for (int sy = 512 - ship.serviceCeiling(); sy < 512; ++sy) {
                for (int sx = 100; sx < 1600; sx += 32) {
                    if (!this.canPlace(ship, sx, sy, 32, garrison)) continue;
                    ship.setX(sx);
                    ship.setY(sy);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canPlace(Airship ship, int x, int y, int spacing, Fleet garrison) {
        int h2;
        int y2;
        int w2;
        int x2;
        if (x < 100) {
            return false;
        }
        if (y < -488) {
            return false;
        }
        int w = ship.getWidth() * 16;
        if (x + w > 1600) {
            return false;
        }
        int h = ship.getHeight() * 16;
        if (y + h > 512) {
            return false;
        }
        if (this.constructing != null) {
            int x22 = this.constructing.getX();
            int w22 = this.constructing.getWidth() * 16;
            int y22 = this.constructing.getY();
            int h22 = this.constructing.getHeight() * 16;
            if (x22 + w22 + spacing > x && x + w + spacing > x22 && y22 + h22 + spacing > y && y + h + spacing > y22) {
                return false;
            }
        }
        for (Airship s2 : this.defences) {
            x2 = s2.getX();
            w2 = s2.getWidth() * 16;
            y2 = s2.getY();
            h2 = s2.getHeight() * 16;
            if (x2 + w2 + spacing <= x || x + w + spacing <= x2 || y2 + h2 + spacing <= y || y + h + spacing <= y2) continue;
            return false;
        }
        if (garrison != null) {
            for (Airship s2 : garrison.actives) {
                x2 = s2.getX();
                w2 = s2.getWidth() * 16;
                y2 = s2.getY();
                h2 = s2.getHeight() * 16;
                if (x2 + w2 + spacing <= x || x + w + spacing <= x2 || y2 + h2 + spacing <= y || y + h + spacing <= y2) continue;
                return false;
            }
        }
        double ox = ship.x;
        double oy = ship.y;
        ship.x = x;
        ship.y = y;
        if (ship.overlapsWith(this.ground, false)) {
            ship.x = ox;
            ship.y = oy;
            return false;
        }
        for (LandFormation lf : this.floaters) {
            if (!ship.overlapsWith(lf, false)) continue;
            ship.x = ox;
            ship.y = oy;
            return false;
        }
        return true;
    }

    public static class Message
    implements JSONAble {
        MessageType type;
        String text;
        int offset;

        public Message(MessageType type, String text, int offset) {
            this.type = type;
            this.text = text;
            this.offset = offset;
        }

        public Message(JSONObject o) {
            this.type = MessageType.valueOf(o.getString("type"));
            this.text = o.getString("text");
            this.offset = o.getInt("offset");
        }

        @Override
        public JSONObject toJSON() {
            return new JSONObject().put("type", this.type.name()).put("text", this.text).put("offset", this.offset);
        }
    }

    public static enum MessageType {
        LOST_SHIP,
        COMBAT,
        REVOLT,
        ECON_RECOVERY;

    }
}

