/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MessageDialog;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Utils;

public class CitySpyButton
extends UniScreen.Button {
    public final Spy.CitySpyAction action;

    public CitySpyButton(Spy.CitySpyAction action) {
        this.action = action;
    }

    @Override
    public boolean visible(UniScreen us) {
        if (!(us.intent instanceof EspionageIntent)) {
            return false;
        }
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        return this.action.available(ss.w.player.getSpyFor(us.city), us.city, ss.w.map);
    }

    public int successChance(UniScreen us, StrategicScreen ss) {
        return this.action.successChance(ss.w.player.getSpyFor(us.city), ss.w.player, us.city, ss.w.map);
    }

    public int cost(UniScreen us, StrategicScreen ss) {
        return this.action.cost(ss.w.player.getSpyFor(us.city), ss.w.player, us.city, ss.w.map);
    }

    @Override
    public String text(UniScreen us) {
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        return this.action.getName() + " ($" + this.cost(us, ss) + ", " + this.successChance(us, ss) + "%)";
    }

    @Override
    public boolean enabled(UniScreen us) {
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        return this.successChance(us, ss) > 0 && this.cost(us, ss) <= ss.w.player.money;
    }

    @Override
    public void click(Input in, UniScreen us) {
        boolean abjectFailure;
        int chance;
        final StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        ss.w.player.money -= this.cost(us, ss);
        int roll = AGame.ANIM_R.nextInt(100);
        boolean success = roll < (chance = this.successChance(us, ss));
        boolean bl = abjectFailure = roll < chance * 2;
        if (success) {
            Utils.Pair<String, String> myYourText = this.action.success(ss.w.player.getSpyFor(us.city), us.city, ss.w.map);
            us.confirmDialog = new MessageDialog((String)myYourText.a){

                @Override
                public void ok(UniScreen us) {
                    if (ss.w.map.owner(us.city) == ss.w.player) {
                        us.g.s = ss;
                        us.city.alertAmount = 0;
                    } else {
                        us.city.alertAmount += 15000;
                        us.confirmDialog = null;
                    }
                }
            };
        } else {
            Utils.Pair<String, String> myYourText = this.action.failure(ss.w.player.getSpyFor(us.city), us.city, ss.w.map);
            if (abjectFailure) {
                ss.w.player.spies.remove(ss.w.player.getSpyFor(us.city));
                us.confirmDialog = new MessageDialog((String)myYourText.a + " " + Lang._t("Your_spy_has_been_captured", new Object[0])){

                    @Override
                    public void ok(UniScreen us) {
                        us.city.alertAmount += 30000;
                        us.g.s = ss;
                    }
                };
            } else {
                us.confirmDialog = new MessageDialog((String)myYourText.a){

                    @Override
                    public void ok(UniScreen us) {
                        us.confirmDialog = null;
                    }
                };
            }
        }
    }
}

