/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Lang;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.LinkedList;
import org.json.JSONObject;

public strictfp class Client
extends Thread {
    private LinkedList<JSONObject> messages = new LinkedList();
    private Socket socket;
    private PrintWriter w;
    private BufferedReader r;
    private boolean failed;
    private boolean doClose = false;
    private boolean disconnected = false;
    private String serverIP;
    private final AirshipGame g;

    public static JSONObject msg(String type) {
        return new JSONObject().put("type", type);
    }

    public synchronized JSONObject pollMessage() {
        return this.messages.pollFirst();
    }

    public synchronized void sendMessage(JSONObject msg) {
        this.w.println(msg.toString());
        this.w.flush();
    }

    public synchronized boolean isConnected() {
        return this.socket != null;
    }

    public synchronized boolean isDisconnected() {
        return this.disconnected;
    }

    public synchronized boolean connectionFailed() {
        return this.failed;
    }

    public Client(String serverIP, AirshipGame g) {
        this.serverIP = serverIP;
        this.g = g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Socket s = new Socket(this.serverIP, 29139);
            this.w = new PrintWriter(new OutputStreamWriter(s.getOutputStream(), "UTF-8"));
            this.r = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
            Client client = this;
            synchronized (client) {
                this.socket = s;
            }
        }
        catch (Exception e) {
            this.g.showError(Lang._t("Connection_lost", new Object[0]));
            Client client = this;
            synchronized (client) {
                this.failed = true;
                return;
            }
        }
        while (!this.doClose) {
            try {
                String l = this.r.readLine();
                if (l == null) {
                    this.disconnected = true;
                    try {
                        this.socket.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.socket = null;
                    return;
                }
                JSONObject msg = new JSONObject(l);
                Client client = this;
                synchronized (client) {
                    this.messages.add(msg);
                }
            }
            catch (Exception e) {
                this.g.showError(Lang._t("Connection_lost", new Object[0]));
                this.disconnected = true;
                break;
            }
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    public synchronized void close() {
        this.doClose = true;
        this.interrupt();
    }
}

