/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;

public class CloudsVisualLayer
implements UniScreen.VisualLayer {
    public ArrayList<Cloud> clouds = new ArrayList();
    public static Appearance[] SMALL_CLOUDS = new Appearance[]{Appearance.app(1, 0, 1, 18, 7), Appearance.app(1, 20, 1, 17, 7), Appearance.app(1, 43, 4, 19, 6), Appearance.app(1, 0, 9, 10, 5), Appearance.app(1, 13, 9, 10, 6), Appearance.app(1, 26, 9, 8, 4), Appearance.app(1, 36, 10, 11, 5), Appearance.app(1, 51, 11, 12, 4), Appearance.app(1, 1, 16, 15, 6), Appearance.app(1, 18, 15, 10, 6), Appearance.app(1, 30, 16, 10, 5), Appearance.app(1, 42, 16, 17, 6), Appearance.app(1, 0, 22, 17, 7), Appearance.app(1, 1, 30, 15, 5)};
    public static Appearance[] BIG_CLOUDS = new Appearance[]{Appearance.app(1, 19, 24, 25, 14), Appearance.app(1, 46, 25, 15, 11), Appearance.app(1, 1, 37, 32, 15), Appearance.app(1, 35, 39, 18, 13), Appearance.app(1, 1, 53, 17, 11), Appearance.app(1, 22, 55, 10, 8), Appearance.app(1, 37, 53, 17, 11)};

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        TimeOfDay tod = us.getTimeOfDay();
        if (this.clouds.isEmpty()) {
            int nc = AGame.ANIM_R.nextInt(3) + 5;
            int globalY = 312 - AGame.ANIM_R.nextInt(800);
            Appearance[] cs = tod.clouds;
            block0: for (int i = 0; i < nc; ++i) {
                int x = AGame.ANIM_R.nextInt(3200) - 1600;
                int y = tod.cloudBottomsAligned ? globalY : 312 - AGame.ANIM_R.nextInt(1000);
                Appearance app = cs[AGame.ANIM_R.nextInt(cs.length)];
                for (Cloud c : this.clouds) {
                    if (!(c.x + (double)(c.app.width() * 16) > (double)x) || !((double)(x + app.width() * 16) > c.x)) continue;
                    continue block0;
                }
                this.clouds.add(new Cloud(app, x, y - app.height() * 16));
            }
        }
        WeatherEffect we = tod.effect;
        for (int i = 0; i < this.clouds.size(); ++i) {
            Cloud c = this.clouds.get(i);
            c.x += we.wind * (0.3 + (double)i * 0.05) * (double)ms;
            if (c.x + (double)(c.app.width() * 16) < -1600.0) {
                c.x = 1610.0;
            }
            if (!(c.x > 1600.0)) continue;
            c.x = -1600 - c.app.width() * 16 - 10;
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.intent.drawAsBlueprint()) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        int csz = this.clouds.size();
        for (int ci = 0; ci < csz; ++ci) {
            Cloud cloud = this.clouds.get(ci);
            if (!Rect2D.intersects(cropX, cropY, cropW, cropH, cloud.x, cloud.y, cloud.app.width() * 16, cloud.app.height() * 16)) continue;
            cloud.app.draw((Draw)d, (double)((int)cloud.x), (double)((int)cloud.y), 0, false, us.lightingMap, tod.lightStrength, tod.ambient);
        }
    }

    public static class Cloud {
        public Appearance app;
        public double x;
        public double y;

        public Cloud(Appearance app, double x, double y) {
            this.app = app;
            this.x = x;
            this.y = y;
        }
    }
}

