/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Achievement;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.GameSetupScreen;
import com.zarkonnen.airships.IntegrationBackend;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.json.JSONObject;

public class CoatEditor
implements Screen {
    public static final Clr BG = Clr.fromHex((String)"7b421b").mix(0.3, Clr.BLACK);
    public CoatOfArms coa = CoatOfArms.getRandom();
    public AirshipGame g;
    public GameSetupScreen gss;
    public boolean editRegisteredCOA;
    public boolean waitingForRegistration;
    public HashSet<CoatOfArms> checking = new HashSet();
    public HashMap<CoatOfArms, Boolean> free = new HashMap();
    public final ScrollBar layoutScrollBar = new ScrollBar();
    public final IntRect layoutScrollBarR = new IntRect();
    public final ScrollBar[] chargeScrollBars = new ScrollBar[]{new ScrollBar(), new ScrollBar(), new ScrollBar(), new ScrollBar()};
    public final IntRect[] chargeScrollBarRs = new IntRect[]{new IntRect(), new IntRect(), new IntRect(), new IntRect()};
    public CoatOfArms.TinctureSlot hoverSlot = null;
    private final LayoutAdapter layoutAdapter = new LayoutAdapter();
    private final ChargeAdapter[] chargeAdapters = new ChargeAdapter[]{new ChargeAdapter(0), new ChargeAdapter(1), new ChargeAdapter(2), new ChargeAdapter(3)};
    public static final int COLOR_PICKER_H = 49;

    public CoatEditor(AirshipGame g, boolean editRegisteredCOA) {
        this.g = g;
        this.editRegisteredCOA = editRegisteredCOA;
        this.coa = (editRegisteredCOA ? g.getBestCOA() : CoatEditor.getMyStrategicArms()).copy();
    }

    public CoatEditor(AirshipGame g, GameSetupScreen gss) {
        this.g = g;
        this.gss = gss;
        this.coa = gss.empireCOA;
    }

    public static CoatOfArms getMyStrategicArms() {
        try {
            return new CoatOfArms(new JSONObject(AirshipGame.PREFS.get("coatOfArms", "")));
        }
        catch (Exception e) {
            return CoatOfArms.getRandom();
        }
    }

    private void save() {
        try {
            AirshipGame.PREFS.put("coatOfArms", this.coa.toJSON().toString());
            AirshipGame.PREFS.flush();
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
        }
    }

    private void vary() {
        switch (AGame.ANIM_R.nextInt(3)) {
            case 0: {
                this.coa.setCharge(CoatOfArms.Charge.values()[AGame.ANIM_R.nextInt(CoatOfArms.Charge.values().length)], AGame.ANIM_R.nextInt(this.coa.layout.charges));
                break;
            }
            case 1: {
                this.coa.setTincture(CoatOfArms.Tincture.values()[AGame.ANIM_R.nextInt(CoatOfArms.Tincture.values().length)], CoatOfArms.TinctureSlot.tinctureOf(AGame.ANIM_R.nextInt(this.coa.layout.tinctures)));
                break;
            }
            case 2: {
                this.coa.setTincture(CoatOfArms.Tincture.values()[AGame.ANIM_R.nextInt(CoatOfArms.Tincture.values().length)], CoatOfArms.TinctureSlot.chargeTOf(AGame.ANIM_R.nextInt(this.coa.layout.charges)));
                break;
            }
            case 3: {
                this.coa.setLayout(CoatOfArms.Layout.values()[AGame.ANIM_R.nextInt(CoatOfArms.Layout.values().length)]);
            }
        }
    }

    private void quit() {
        if (this.gss == null) {
            this.save();
            this.g.s = new MainMenu(this.g);
        } else {
            this.gss.empireCOA = this.coa;
            this.gss.empireNameField.reset();
            this.g.s = this.gss;
        }
    }

    private void registerCOA() {
        this.waitingForRegistration = true;
        if (SteamBackend.isEnabled()) {
            this.g.integration.backend.steamSetArms("" + SteamBackend.getUserID(), this.coa, new SteamArmsCB());
        } else {
            this.g.integration.backend.setArms(this.g.integration.username, this.g.integration.password, this.coa, new SACB());
        }
    }

    private Status coaTakenStatus() {
        if (this.coa.equals(this.g.integration.registeredCoatOfArms)) {
            return Status.YOURS;
        }
        if (this.waitingForRegistration) {
            return Status.REGISTERING;
        }
        if (this.free.containsKey(this.coa)) {
            return this.free.get(this.coa) != false ? Status.FREE : Status.TAKEN;
        }
        if (this.checking.contains(this.coa)) {
            return Status.CHECKING;
        }
        this.checking.add(this.coa.copy());
        this.g.integration.backend.checkArmsAvailable(this.coa, new CAAC(this.coa.copy()));
        return Status.CHECKING;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.waitingForRegistration) {
            return;
        }
        ScreenMode sm = in.mode();
        int armsSize = (sm.height - 320) / 32 * 32;
        int armsWinSize = armsSize + 24;
        this.layoutScrollBar.tick(in, this.layoutScrollBarR.x, this.layoutScrollBarR.y, this.layoutScrollBarR.w, this.layoutScrollBarR.h);
        for (int i = 0; i < this.coa.layout.charges; ++i) {
            this.chargeScrollBars[i].tick(in, this.chargeScrollBarRs[i].x, this.chargeScrollBarRs[i].y, this.chargeScrollBarRs[i].w, this.chargeScrollBarRs[i].h);
        }
        if (this.editRegisteredCOA && this.coaTakenStatus().canRegister && in.keyPressed("R")) {
            this.registerCOA();
            drawState.hasClicked();
            return;
        }
        if (in.keyPressed("Q") || in.keyPressed("ESCAPE")) {
            drawState.hasClicked();
            this.quit();
            return;
        }
        if (in.keyPressed("A")) {
            this.coa = CoatOfArms.getRandom();
            drawState.hasClicked();
        }
        if (in.keyPressed("V")) {
            this.vary();
            drawState.hasClicked();
        }
    }

    public void renderColorPicker(final MyDraw d, int x, int y, int w, Pt cursor, final CoatOfArms.TinctureSlot slot) {
        d.drawPanel(x, y, w, 49);
        x += 6;
        y += 6;
        for (final CoatOfArms.Tincture t : CoatOfArms.Tincture.values()) {
            if (this.coa.getTincture(slot) == t) {
                d.rect(t.metal ? Clr.BLACK : Clr.YELLOW, x + 1 + 18 * (t.ordinal() % 6), y + 1 + 18 * (t.ordinal() / 6), 18.0, 18.0);
            }
            d.rect(t.tint, x + 2 + 18 * (t.ordinal() % 6), y + 2 + 18 * (t.ordinal() / 6), 16.0, 16.0);
            d.hook(x + 1 + 18 * (t.ordinal() % 6), y + 1 + 18 * (t.ordinal() / 6), 18.0, 18.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    if (d.state.canClick() && !CoatEditor.this.waitingForRegistration) {
                        CoatEditor.this.coa.setTincture(t, slot);
                    }
                }
            });
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.hook(0.0, 0.0, sm.width, sm.height, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

            public void run(Input in, Pt p, Hook.Type type) {
                CoatEditor.this.hoverSlot = null;
            }
        });
        d.drawBG(AGame.CAST_IRON, sm);
        int armsSize = (sm.height - 320) / 32 * 32;
        int armsWinSize = armsSize + 24;
        int x = sm.width / 2 - armsWinSize / 2;
        int y = sm.height / 2 - armsWinSize / 2;
        d.drawWindow(x, y, armsWinSize, armsWinSize);
        this.coa.draw(d, (double)(x + 12), (double)(y + 12), armsSize, this.hoverSlot);
        d.text(this.editRegisteredCOA ? this.coa.blazon() : this.coa.blazon() + "\n" + this.coa.getBonus().getDesc(), AGame.BIG_FOUNT, x, y + armsWinSize + 12 - 4, armsWinSize);
        x = 10;
        y = 55;
        int w = (sm.width - armsWinSize) / 2 - 24;
        int h = sm.height - y - 10;
        int layoutH = h - 55 * this.coa.layout.tinctures;
        this.layoutScrollBar.draw(d, x, y, w, layoutH, Arrays.asList(CoatOfArms.Layout.values()), this.layoutAdapter);
        this.layoutScrollBarR.x = x;
        this.layoutScrollBarR.y = y;
        this.layoutScrollBarR.w = w;
        this.layoutScrollBarR.h = layoutH;
        int leftY = y + layoutH + 6;
        for (int i = 0; i < this.coa.layout.tinctures; ++i) {
            final int index = i;
            d.hook(x, leftY, w, 49.0, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

                public void run(Input in, Pt p, Hook.Type type) {
                    CoatEditor.this.hoverSlot = CoatOfArms.TinctureSlot.values()[index];
                }
            });
            this.renderColorPicker(d, x, leftY, w, cursor, CoatOfArms.TinctureSlot.tinctureOf(i));
            leftY += 55;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.g.isIntegrated() && this.g.integration.specialCharge != null && this.editRegisteredCOA) {
            l.add(this.g.integration.specialCharge);
        }
        l.addAll(Arrays.asList(CoatOfArms.Charge.values()));
        int chargeSegmentH = (h - 12 * (this.coa.layout.charges - 1)) / this.coa.layout.charges;
        int rightY = y;
        int rightX = sm.width - w - 10;
        for (int i = 0; i < this.coa.layout.charges; ++i) {
            final int index = i;
            d.hook(rightX, rightY, w, chargeSegmentH, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

                public void run(Input in, Pt p, Hook.Type type) {
                    CoatEditor.this.hoverSlot = CoatOfArms.TinctureSlot.values()[index + 4];
                }
            });
            int scrollBarH = chargeSegmentH - 49 - 6;
            this.chargeScrollBars[i].draw(d, rightX, rightY, w, scrollBarH, l, this.chargeAdapters[i]);
            this.chargeScrollBarRs[i].x = rightX;
            this.chargeScrollBarRs[i].y = rightY;
            this.chargeScrollBarRs[i].w = w;
            this.chargeScrollBarRs[i].h = scrollBarH;
            this.renderColorPicker(d, rightX, rightY += scrollBarH + 6, w, cursor, CoatOfArms.TinctureSlot.chargeTOf(i));
            rightY += 61;
        }
        d.drawTopBar(sm);
        x = sm.width - 10;
        if (this.editRegisteredCOA) {
            d.text(Lang._t("coa_status_" + this.coaTakenStatus().name(), new Object[0]), AGame.BIG_FOUNT, 10.0, 12.0);
            d.button(x - 100, 11, 100, Lang._t("Register", new Object[0]), "R", new Runnable(){

                @Override
                public void run() {
                    CoatEditor.this.registerCOA();
                }
            }, this.coaTakenStatus().canRegister && !this.waitingForRegistration);
            d.button((x -= 103) - 100, 11, 100, Lang._t("Quit", new Object[0]), "Q", new Runnable(){

                @Override
                public void run() {
                    CoatEditor.this.quit();
                }
            }, !this.waitingForRegistration);
            x -= 103;
        } else {
            d.button(x - 150, 11, 150, Lang._t("Save_and_Quit", new Object[0]), "Q", new Runnable(){

                @Override
                public void run() {
                    CoatEditor.this.quit();
                }
            });
            x -= 153;
        }
        d.button(x - 100, 11, 100, Lang._t("Random", new Object[0]), "a", new Runnable(){

            @Override
            public void run() {
                CoatEditor.this.coa = CoatOfArms.getRandom();
            }
        }, !this.waitingForRegistration);
        d.button((x -= 103) - 100, 11, 100, Lang._t("Variation", new Object[0]), "V", new Runnable(){

            @Override
            public void run() {
                CoatEditor.this.vary();
            }
        }, !this.waitingForRegistration);
        x -= 103;
    }

    @Override
    public ArrayList<String> music() {
        return AGame.MENU_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    private class ChargeAdapter
    implements ScrollBar.ScrollElementAdapter<Object> {
        public final int chargeIndex;

        public ChargeAdapter(int chargeIndex) {
            this.chargeIndex = chargeIndex;
        }

        @Override
        public int getHeight(Object ch, MyDraw d, int availableWidth) {
            String txt = null;
            if (ch instanceof String) {
                txt = ((String)ch).split("_")[0];
            } else {
                CoatOfArms.Charge c = (CoatOfArms.Charge)((Object)ch);
                txt = c.getName() + "\n" + (!c.bonus.working ? "[aaaaaa](" + Lang._t("no_bonus_implemented_yet", new Object[0]) + ")" : c.bonus.getDesc());
            }
            return Math.max(16, (int)d.textSize((String)txt, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(availableWidth - 16 - 6)).height) + 6;
        }

        @Override
        public void draw(Object ch, final MyDraw d, int x, int y, int width) {
            int height = this.getHeight(ch, d, width);
            int textW = width - 16 - 6;
            if (ch instanceof String) {
                final String specialCharge = (String)ch;
                d.drawSpecialCharge(specialCharge, Clr.WHITE, x, y, 16.0, 16.0);
                String txt = specialCharge.split("_")[0];
                if (CoatEditor.this.coa.charge[this.chargeIndex] == null && specialCharge.equals(CoatEditor.this.coa.specialCharge[this.chargeIndex])) {
                    d.text("[c8b84f]" + txt, AGame.FOUNT, x + 16 + 6, y, textW);
                } else {
                    d.text(txt, AGame.FOUNT, x + 16 + 6, y, textW);
                    d.hook(x, y, width, height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            if (d.state.canClick() && !CoatEditor.this.waitingForRegistration) {
                                CoatEditor.this.coa.setSpecialCharge(specialCharge, ChargeAdapter.this.chargeIndex);
                            }
                        }
                    });
                }
            } else {
                final CoatOfArms.Charge c = (CoatOfArms.Charge)((Object)ch);
                c.app.draw(d, x, y, 0, false);
                String txt = c.getName() + "\n" + (!c.bonus.working ? "[aaaaaa](" + Lang._t("no_bonus_implemented_yet", new Object[0]) + ")" : c.bonus.getDesc());
                if (CoatEditor.this.coa.charge[this.chargeIndex] == c) {
                    d.text("[c8b84f]" + txt, AGame.FOUNT, x + 16 + 6, y, textW);
                } else {
                    d.text(txt, AGame.FOUNT, x + 16 + 6, y, textW);
                    d.hook(x, y, width, height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            if (d.state.canClick() && !CoatEditor.this.waitingForRegistration) {
                                CoatEditor.this.coa.setCharge(c, ChargeAdapter.this.chargeIndex);
                            }
                        }
                    });
                }
            }
        }
    }

    private class LayoutAdapter
    implements ScrollBar.ScrollElementAdapter<CoatOfArms.Layout> {
        private LayoutAdapter() {
        }

        @Override
        public int getHeight(CoatOfArms.Layout l, MyDraw d, int availableWidth) {
            return 22;
        }

        @Override
        public void draw(final CoatOfArms.Layout l, final MyDraw d, int x, int y, int width) {
            l.drawLayout(d, x, y);
            if (CoatEditor.this.coa.layout == l) {
                d.text("[c8b84f]" + l.getName(), AGame.FOUNT, x + 16 + 6, y);
            } else {
                d.text(l.getName(), AGame.FOUNT, x + 16 + 6, y);
                d.hook(x, y, width, 22.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        if (d.state.canClick() && !CoatEditor.this.waitingForRegistration) {
                            CoatEditor.this.coa.setLayout(l);
                        }
                    }
                });
            }
        }
    }

    class CAAC
    implements IntegrationBackend.Receiver<IntegrationBackend.CheckArmsAvailableCallback> {
        private final CoatOfArms coa;

        public CAAC(CoatOfArms coa) {
            this.coa = coa;
        }

        @Override
        public void receive(IntegrationBackend.CheckArmsAvailableCallback callback) {
            if (callback.success) {
                CoatEditor.this.free.put(this.coa, callback.available);
            }
        }
    }

    private static enum Status {
        FREE(true),
        TAKEN(false),
        CHECKING(false),
        YOURS(true),
        REGISTERING(false);

        public final boolean canRegister;

        private Status(boolean canRegister) {
            this.canRegister = canRegister;
        }
    }

    class SteamArmsCB
    implements IntegrationBackend.Receiver<IntegrationBackend.SteamSetArmsCallback> {
        SteamArmsCB() {
        }

        @Override
        public void receive(IntegrationBackend.SteamSetArmsCallback callback) {
            if (callback.success) {
                CoatEditor.this.g.integration.registeredCoatOfArms = CoatEditor.this.coa.copy();
                Achievement.achieve(Achievement.COA);
                CoatEditor.this.quit();
            } else {
                CoatEditor.this.waitingForRegistration = false;
                CoatEditor.this.g.error = Lang._t("Unable_to_register_COA", new Object[0]) + "\n" + callback.errorMessage;
            }
        }
    }

    class SACB
    implements IntegrationBackend.Receiver<IntegrationBackend.SetArmsCallback> {
        SACB() {
        }

        @Override
        public void receive(IntegrationBackend.SetArmsCallback callback) {
            if (callback.success) {
                CoatEditor.this.g.integration.registeredCoatOfArms = CoatEditor.this.coa.copy();
                Achievement.achieve(Achievement.COA);
                CoatEditor.this.quit();
            } else {
                CoatEditor.this.waitingForRegistration = false;
                CoatEditor.this.g.error = "Unable to register your coat of arms. There may be a network problem.\n" + callback.errorMessage;
            }
        }
    }

    private static class IntRect {
        int x;
        int y;
        int w;
        int h;

        private IntRect() {
        }
    }
}

