/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Random;
import org.json.JSONObject;
import org.newdawn.slick.Image;

public strictfp class CoatOfArms
implements JSONAble {
    public static final int MAX_PARTS = 4;
    public Layout layout = Layout.CHARGE;
    public final Charge[] charge = new Charge[]{Charge.RAT, Charge.RAT, Charge.RAT, Charge.RAT};
    public final String[] specialCharge = new String[]{null, null, null, null};
    public final Tincture[] tincture = new Tincture[]{Tincture.ARGENT, Tincture.ARGENT, Tincture.ARGENT, Tincture.ARGENT};
    public final Tincture[] chargeT = new Tincture[]{Tincture.SABLE, Tincture.SABLE, Tincture.SABLE, Tincture.SABLE};
    private static final Appearance FLAG = new Appearance(0, 25);
    private static final Appearance FESS_DETAIL = new Appearance(1, 25);
    private static final Appearance PARTY_PER_PALE_DETAIL = new Appearance(3, 25);
    private static final Appearance BEND_SINISTER_DETAIL = new Appearance(6, 25);
    private static final Appearance BORDURE_DETAIL = new Appearance(7, 25);
    private static final Appearance PARTY_PER_BEND_SINISTER_DETAIL = new Appearance(8, 25);
    private static final Appearance PALE_DETAIL = new Appearance(9, 25);
    private static final Appearance PARTY_PER_CHEVRON_DETAIL = new Appearance(10, 25);
    public static final int SHIELD_W = 36;
    public static final int SHIELD_H = 41;
    private static final Img SHIELD_OUTLINE = new Img("spritesheet", 0, 544, 36, 41, false);
    private static final Img SHIELD_CONTENT = new Img("spritesheet", 481, 544, 36, 41, false);
    private static final Img SHIELD_CHEVRON = new Img("spritesheet", 37, 544, 36, 41, false);
    private static final Img SHIELD_FESS = new Img("spritesheet", 74, 544, 36, 41, false);
    private static final Img SHIELD_PARTY_PER_PALE = new Img("spritesheet", 111, 544, 36, 41, false);
    private static final Img SHIELD_BEND_SINISTER = new Img("spritesheet", 185, 544, 36, 41, false);
    private static final Img SHIELD_BORDURE = new Img("spritesheet", 222, 544, 36, 41, false);
    private static final Img SHIELD_PARTY_PER_BEND_SINISTER = new Img("spritesheet", 259, 544, 36, 41, false);
    private static final Img SHIELD_PALE = new Img("spritesheet", 296, 544, 36, 41, false);
    private static final Img SHIELD_Q_TL = new Img("spritesheet", 333, 544, 36, 41, false);
    private static final Img SHIELD_Q_BL = new Img("spritesheet", 370, 544, 36, 41, false);
    private static final Img SHIELD_Q_BR = new Img("spritesheet", 407, 544, 36, 41, false);
    private static final Img SHIELD_Q_TR = new Img("spritesheet", 444, 544, 36, 41, false);

    public Bonus getBonus() {
        for (int i = 0; i < this.layout.charges; ++i) {
            if (this.charge[i] == null || this.charge[i].bonus == Bonus.NO_BONUS) continue;
            return this.charge[i].bonus;
        }
        return Bonus.NO_BONUS;
    }

    public Tincture[] getRoundelTinctures() {
        Tincture[] tinctureArray;
        if (this.layout.tinctures == 1) {
            Tincture[] tinctureArray2 = new Tincture[3];
            tinctureArray2[0] = this.tincture[0];
            tinctureArray2[1] = this.chargeT[0];
            tinctureArray = tinctureArray2;
            tinctureArray2[2] = this.tincture[0];
        } else if (this.chargeT[0].metal == this.tincture[1].metal) {
            Tincture[] tinctureArray3 = new Tincture[3];
            tinctureArray3[0] = this.tincture[1];
            tinctureArray3[1] = this.tincture[0];
            tinctureArray = tinctureArray3;
            tinctureArray3[2] = this.chargeT[0];
        } else {
            Tincture[] tinctureArray4 = new Tincture[3];
            tinctureArray4[0] = this.tincture[0];
            tinctureArray4[1] = this.chargeT[0];
            tinctureArray = tinctureArray4;
            tinctureArray4[2] = this.tincture[1];
        }
        return tinctureArray;
    }

    @Override
    public JSONObject toJSON() {
        int i;
        JSONObject o = new JSONObject().put("layout", this.layout.name()).put("fieldT", this.tincture[0].name()).put("chargeT", this.chargeT[0].name());
        if (this.charge[0] == null) {
            o.put("specialCharge", this.specialCharge[0]);
        } else {
            o.put("charge", this.charge[0].name());
        }
        if (this.layout.tinctures > 1) {
            o.put("secondT", this.tincture[1].name());
        }
        for (i = 1; i < this.layout.charges; ++i) {
            if (this.charge[i] == null) {
                o.put("specialCharge" + i, this.specialCharge[i]);
            } else {
                o.put("charge" + i, this.charge[i].name());
            }
            o.put("chargeT" + i, this.chargeT[i].name());
        }
        for (i = 2; i < this.layout.tinctures; ++i) {
            o.put("tincture" + i, this.tincture[i].name());
        }
        return o;
    }

    public int hashCode() {
        int i;
        int code = this.layout.ordinal();
        for (i = 0; i < this.layout.charges; ++i) {
            code *= 37;
            code += this.charge[i] == null ? this.specialCharge[i].hashCode() : this.charge[i].ordinal();
        }
        for (i = 0; i < this.layout.tinctures; ++i) {
            code *= 37;
            code += this.tincture[i].ordinal();
        }
        return code;
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof CoatOfArms)) {
            return false;
        }
        CoatOfArms coa2 = (CoatOfArms)o;
        if (this.layout != coa2.layout) {
            return false;
        }
        for (i = 0; i < this.layout.charges; ++i) {
            if (this.charge[i] != coa2.charge[i]) {
                return false;
            }
            if (this.chargeT[i] != coa2.chargeT[i]) {
                return false;
            }
            if (this.specialCharge[i] == null || this.specialCharge[i].equals(coa2.specialCharge[i])) continue;
            return false;
        }
        for (i = 0; i < this.layout.tinctures; ++i) {
            if (this.tincture[i] == coa2.tincture[i]) continue;
            return false;
        }
        return true;
    }

    public CoatOfArms copy() {
        CoatOfArms coa = new CoatOfArms();
        coa.layout = this.layout;
        for (int i = 0; i < 4; ++i) {
            coa.charge[i] = this.charge[i];
            coa.specialCharge[i] = this.specialCharge[i];
            coa.chargeT[i] = this.chargeT[i];
            coa.tincture[i] = this.tincture[i];
        }
        return coa;
    }

    public CoatOfArms() {
    }

    public String toString() {
        return this.toJSON().toString(4);
    }

    public CoatOfArms(JSONObject o) {
        this.layout = Layout.valueOf(o.getString("layout"));
        if (o.has("charge")) {
            this.charge[0] = Charge.valueOf(o.getString("charge"));
        } else {
            this.charge[0] = null;
            this.specialCharge[0] = o.getString("specialCharge");
        }
        this.tincture[0] = Tincture.valueOf(o.getString("fieldT"));
        this.chargeT[0] = Tincture.valueOf(o.getString("chargeT"));
        if (this.layout.tinctures > 1) {
            this.tincture[1] = Tincture.valueOf(o.getString("secondT"));
        }
        for (int i = 1; i < this.layout.charges; ++i) {
            if (o.has("charge" + i)) {
                this.charge[i] = Charge.valueOf(o.getString("charge" + i));
                this.chargeT[i] = Tincture.valueOf(o.getString("chargeT" + i));
                continue;
            }
            if (o.has("specialCharge" + i)) {
                this.charge[i] = null;
                this.specialCharge[i] = o.getString("specialCharge" + i);
                this.chargeT[i] = Tincture.valueOf(o.getString("chargeT" + i));
                continue;
            }
            this.charge[i] = this.charge[0];
            this.specialCharge[i] = this.specialCharge[0];
            this.chargeT[i] = this.chargeT[0];
        }
        if (this.layout.tinctures > 2) {
            this.tincture[2] = o.has("tincture2") ? Tincture.valueOf(o.getString("tincture2")) : this.tincture[0];
        }
        if (this.layout.tinctures > 3) {
            this.tincture[3] = o.has("tincture3") ? Tincture.valueOf(o.getString("tincture3")) : this.tincture[1];
        }
    }

    public void setCharge(Charge c, int index) {
        this.charge[index] = c;
        this.specialCharge[index] = null;
    }

    public void setSpecialCharge(String specialCharge, int index) {
        this.specialCharge[index] = specialCharge;
        this.charge[index] = null;
    }

    public void draw(MyDraw d, double x, double y) {
        this.layout.draw(this, d, x, y, 16.0, null, null);
    }

    public void draw(MyDraw d, double x, double y, int size) {
        this.layout.draw(this, d, x, y, size, null, null);
    }

    public void draw(MyDraw d, double x, double y, int size, Clr tint) {
        this.layout.draw(this, d, x, y, size, tint, null);
    }

    public void draw(MyDraw d, double x, double y, int size, TinctureSlot highlight) {
        this.layout.draw(this, d, x, y, size, null, highlight);
    }

    public String blazon() {
        return this.layout.blazon(this);
    }

    public void setLayout(Layout newLayout) {
        Tincture t;
        int i;
        ArrayList<Tincture> metals = new ArrayList<Tincture>();
        ArrayList nonMetals = new ArrayList();
        ArrayList<Tincture> tinctures = new ArrayList<Tincture>();
        ArrayList<Charge> charges = new ArrayList<Charge>();
        String theSpecialCharge = null;
        for (i = 0; i < this.layout.tinctures; ++i) {
            t = this.tincture[i];
            (t.metal ? metals : nonMetals).add(t);
            tinctures.add(t);
        }
        for (i = 0; i < this.layout.charges; ++i) {
            t = this.chargeT[i];
            (t.metal ? metals : nonMetals).add(t);
            tinctures.add(t);
            if (this.charge[i] != null) {
                charges.add(this.charge[i]);
                continue;
            }
            theSpecialCharge = this.specialCharge[i];
        }
        for (i = this.layout.tinctures; i < newLayout.tinctures; ++i) {
            this.tincture[i] = (Tincture)((Object)tinctures.get(i % tinctures.size()));
        }
        for (i = this.layout.charges; i < newLayout.charges; ++i) {
            this.chargeT[i] = (Tincture)((Object)tinctures.get((i + this.layout.tinctures) % tinctures.size()));
            if (charges.isEmpty()) {
                this.charge[i] = null;
                this.specialCharge[i] = theSpecialCharge;
                continue;
            }
            this.charge[i] = (Charge)((Object)charges.get(i % charges.size()));
            this.specialCharge[i] = null;
        }
        this.layout = newLayout;
        while (!this.legal()) {
            for (TinctureSlot tsA : this.layout.adjacency.keySet()) {
                for (TinctureSlot tsB : this.layout.adjacency.get((Object)tsA)) {
                    if (this.getTincture((TinctureSlot)tsA).metal != this.getTincture((TinctureSlot)tsB).metal) continue;
                    this.setTinctureOnly((Tincture)((Object)(this.getTincture((TinctureSlot)tsB).metal ? nonMetals : metals).get(0)), tsB);
                }
            }
        }
    }

    public void setTincture(Tincture t, TinctureSlot slot) {
        EnumSet<TinctureSlot> visited = EnumSet.of(slot);
        this.setTincture(t, slot, visited);
    }

    public Tincture getTincture(TinctureSlot slot) {
        if (slot.tinctureIndex > -1) {
            return this.tincture[slot.tinctureIndex];
        }
        return this.chargeT[slot.chargeIndex];
    }

    private Tincture setTinctureOnly(Tincture t, TinctureSlot slot) {
        Tincture old;
        if (slot.tinctureIndex > -1) {
            old = this.tincture[slot.tinctureIndex];
            this.tincture[slot.tinctureIndex] = t;
        } else {
            old = this.chargeT[slot.chargeIndex];
            this.chargeT[slot.chargeIndex] = t;
        }
        return old;
    }

    public void setTincture(Tincture t, TinctureSlot slot, EnumSet<TinctureSlot> visited) {
        Tincture old = this.setTinctureOnly(t, slot);
        if (this.layout.adjacency.containsKey((Object)slot)) {
            for (TinctureSlot ts : this.layout.adjacency.get((Object)slot)) {
                if (visited.contains((Object)ts) || this.getTincture((TinctureSlot)ts).metal != t.metal) continue;
                visited.add(ts);
                this.setTincture(old, ts, visited);
            }
        }
    }

    public boolean legal() {
        for (TinctureSlot tsA : this.layout.adjacency.keySet()) {
            for (TinctureSlot tsB : this.layout.adjacency.get((Object)tsA)) {
                if (this.getTincture((TinctureSlot)tsA).metal != this.getTincture((TinctureSlot)tsB).metal) continue;
                return false;
            }
        }
        return true;
    }

    public static CoatOfArms getRandom() {
        return CoatOfArms.getRandom(AGame.ANIM_R);
    }

    public static CoatOfArms getRandom(Random r) {
        CoatOfArms coa = new CoatOfArms();
        coa.layout = Layout.values()[r.nextInt(Layout.values().length)];
        do {
            int i;
            for (i = 0; i < coa.layout.charges; ++i) {
                coa.charge[i] = Charge.values()[r.nextInt(Charge.values().length)];
                coa.chargeT[i] = Tincture.values()[r.nextInt(Tincture.values().length)];
            }
            for (i = 0; i < coa.layout.tinctures; ++i) {
                coa.tincture[i] = Tincture.values()[r.nextInt(Tincture.values().length)];
            }
        } while (!coa.legal() || coa.getBonus() == null || !coa.getBonus().working);
        return coa;
    }

    private String chargeName(int i) {
        return this.charge[i] == null ? this.specialCharge[i].split("_")[0] : this.charge[i].getName();
    }

    private String chargesName(int i) {
        return this.charge[i] == null ? this.specialCharge[i].split("_")[1] : this.charge[i].getPlural();
    }

    private static void d(MyDraw d, Img img, Clr tint, double x, double y, double w, double h) {
        if (img.machineImgCache != null) {
            ((Image)img.machineImgCache).setFilter(9728);
        }
        d.blit(img, tint, x, y, w, h);
    }

    static Clr tinc(MyDraw d, CoatOfArms coa, TinctureSlot slot, TinctureSlot highlight, Clr tint) {
        Tincture t = slot.get(coa);
        if (slot == highlight) {
            if (t.metal) {
                return d.darkPulse(t.tint.mult(tint));
            }
            return d.pulse(t.tint.mult(tint));
        }
        return t.tint.mult(tint);
    }

    public static void main(String[] args) {
        for (int i = Charge.ROUNDEL.ordinal(); i <= Charge.VOL.ordinal(); ++i) {
            Charge c = Charge.values()[i];
            for (Tincture t : Tincture.values()) {
                System.out.println(c.name() + "_" + t.name() + "=" + Lang._t(c.name() + "_singular", new Object[0]) + " " + Lang._t("tincture_" + t.name(), new Object[0]));
                System.out.println(c.name() + "_" + t.name() + "_plural=" + Lang._t(c.name() + "_plural", new Object[0]) + " " + Lang._t("tincture_" + t.name(), new Object[0]));
            }
        }
    }

    public strictfp static enum Charge {
        RAM(new Appearance(0, 24), Bonus.RAMMING_PROWS),
        TOWER(new Appearance(1, 24), Bonus.IMPROVED_STONE_WALLS),
        WHEEL(new Appearance(2, 24), Bonus.FASTER_COMMANDS),
        SCALES(new Appearance(3, 24), Bonus.EXTRA_INCOME),
        EAGLE(new Appearance(4, 24), Bonus.PRECISE_GUNNERY),
        TREE(new Appearance(5, 24), Bonus.IMPROVED_WOOD_CONSTRUCTION),
        RAT(new Appearance(6, 24), Bonus.WILL_TO_SURVIVE),
        LION(new Appearance(7, 24), Bonus.DANGEROUS_FIGHTERS),
        CROWN(new Appearance(8, 24), Bonus.RIGHTFUL_KING),
        ANVIL(new Appearance(9, 24), Bonus.IMPROVED_STEEL_ARMOUR),
        DRAGON(new Appearance(10, 24), Bonus.DRAGON_MASTERS),
        MOUNTAIN(new Appearance(11, 24), Bonus.SUSPENDIUM_SPECIALISTS),
        WAVES(new Appearance(12, 24), Bonus.FIREFIGHTERS),
        EYE(new Appearance(13, 24), Bonus.MASTER_SPIES),
        WRENCH(new Appearance(14, 24), Bonus.EXPERT_REPAIRS),
        GUILLOTINE(new Appearance(15, 24), Bonus.REVOLUTION),
        SPIDER(new Appearance(26, 24), Bonus.SPIDER_LEGS),
        WOLF(new Appearance(27, 24), Bonus.WOLFPACK),
        BOAR(new Appearance(28, 24), Bonus.ARMOURED_TANKS),
        ROUNDEL(new Appearance(16, 24), Bonus.NO_BONUS),
        ANNULET(new Appearance(17, 24), Bonus.NO_BONUS),
        CRESCENT(new Appearance(18, 24), Bonus.NO_BONUS),
        GOUTTE(new Appearance(19, 24), Bonus.NO_BONUS),
        SUN(new Appearance(20, 24), Bonus.NO_BONUS),
        MULLET(new Appearance(21, 24), Bonus.NO_BONUS),
        ESTOILE(new Appearance(22, 24), Bonus.NO_BONUS),
        GEAR(new Appearance(23, 24), Bonus.NO_BONUS),
        FLOWER(new Appearance(24, 24), Bonus.NO_BONUS),
        VOL(new Appearance(25, 24), Bonus.NO_BONUS);

        public final Appearance app;
        public final Appearance leftApp;
        public final Appearance rightApp;
        public final Bonus bonus;

        private Charge(Appearance app, Bonus bonus) {
            this.app = app;
            this.leftApp = app.leftSide();
            this.rightApp = app.rightSide();
            this.bonus = bonus;
        }

        public String getName() {
            return Lang._t(this.name() + "_singular", new Object[0]);
        }

        public String getPlural() {
            return Lang._t(this.name() + "_plural", new Object[0]);
        }
    }

    public strictfp static enum Layout {
        CHARGE(1, 1, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x, y, size, size);
                } else {
                    coa.charge[0].app.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.BLACK, x + 2.0, y + 2.0, 12.0, 12.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 32.0 * scale, 32.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 2.0 * scale, y + 2.0 * scale, 32.0 * scale, 32.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        FESS(1, 2, "fess_", new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE0}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                FESS_DETAIL.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.GREY, x, y + 3.0, 16.0, 10.0);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_FESS, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PALE(1, 2, "pale_", new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE0}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                PALE_DETAIL.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.GREY, x + 3.0, y, 10.0, 16.0);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PALE, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        QUARTERLY(4, 4, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1, TinctureSlot.TINCTURE2, TinctureSlot.CHARGE2, TinctureSlot.TINCTURE3, TinctureSlot.CHARGE3}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                for (int i = 0; i < 4; ++i) {
                    double x2 = x + size / 2.0 * (double)(i % 2);
                    double y2 = y + size / 2.0 * (double)(i / 2);
                    FLAG.draw((Draw)d, x2, y2, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.values()[i], highlight, tint), false);
                    if (coa.charge[i] == null) {
                        d.drawSpecialCharge(coa.specialCharge[i], CoatOfArms.tinc(d, coa, TinctureSlot.values()[i + 4], highlight, tint), x2, y2, size / 2.0, size / 2.0);
                        continue;
                    }
                    coa.charge[i].app.draw((Draw)d, x2, y2, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.values()[i + 4], highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.GREY, x + 8.0, y, 8.0, 8.0);
                d.rect(Clr.GREY, x, y + 8.0, 8.0, 8.0);
                d.rect(Clr.BLACK, x + 1.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 9.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 1.0, y + 9.0, 6.0, 6.0);
                d.rect(Clr.BLACK, x + 9.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_Q_TL, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_Q_TR, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_Q_BL, coa.tincture[2].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_Q_BR, coa.tincture[3].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                if (coa.charge[2] == null) {
                    d.drawSpecialCharge(coa.specialCharge[2], coa.chargeT[2].tint, x + 2.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[2].app.draw((Draw)d, x + 2.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[2].tint, false);
                }
                if (coa.charge[3] == null) {
                    d.drawSpecialCharge(coa.specialCharge[3], coa.chargeT[3].tint, x + 18.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[3].app.draw((Draw)d, x + 18.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[3].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PARTY_PER_PALE(2, 2, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                PARTY_PER_PALE_DETAIL.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].app.draw((Draw)d, x, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight, tint), x + size / 2.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + size / 2.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                PARTY_PER_PALE_DETAIL.draw(d, x, y, 0, Clr.GREY, false);
                d.rect(Clr.BLACK, x + 1.0, y + 5.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 9.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PARTY_PER_PALE, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 2.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 18.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + 18.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        BORDURE(1, 2, "bordure_", new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                BORDURE_DETAIL.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.GREY, x, y, 16.0, 16.0);
                d.rect(Clr.WHITE, x + 2.0, y + 2.0, 12.0, 12.0);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_BORDURE, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PARTY_PER_CHEVRON(2, 2, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                double offset;
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                PARTY_PER_CHEVRON_DETAIL.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight, tint), false);
                double d2 = offset = coa.charge[0] == Charge.WAVES ? 0.0 : -size / 32.0;
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x + size / 4.0, y + offset, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + size / 4.0, y + offset, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
                double d3 = offset = coa.charge[1] == Charge.WAVES ? 0.0 : size / 32.0;
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight, tint), x + size / 4.0, y + size / 2.0 + offset, size / 2.0, size / 2.0);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + size / 4.0, y + size / 2.0 + offset, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                PARTY_PER_CHEVRON_DETAIL.draw(d, x, y, 0, Clr.GREY, false);
                d.rect(Clr.BLACK, x + 5.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 5.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_CHEVRON, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 10.0 * scale, y + 22.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + 10.0 * scale, y + 22.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PARTY_PER_BEND_SINISTER(2, 2, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                PARTY_PER_BEND_SINISTER_DETAIL.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x, y, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].app.draw((Draw)d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight, tint), x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                PARTY_PER_BEND_SINISTER_DETAIL.draw(d, x, y, 0, Clr.GREY, false);
                d.rect(Clr.BLACK, x + 1.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 9.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PARTY_PER_BEND_SINISTER, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 10.0 * scale, y + 19.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + 18.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        SCARPE(2, 2, "scarpe_", new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE0, TinctureSlot.CHARGE1}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                BEND_SINISTER_DETAIL.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x, y, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].app.draw((Draw)d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight, tint), x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                BEND_SINISTER_DETAIL.draw(d, x, y, 0, Clr.GREY, false);
                d.rect(Clr.BLACK, x + 1.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.BLACK, x + 9.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_BEND_SINISTER, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].app.draw((Draw)d, x + 18.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        THREE(1, 1, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x + size / 4.0, y + size / 2.0, size / 2.0, size / 2.0);
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x, y, size / 2.0, size / 2.0);
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x + size / 2.0, y, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + size / 4.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                    coa.charge[0].app.draw((Draw)d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                    coa.charge[0].app.draw((Draw)d, x + size / 2.0, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.BLACK, x + 1.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.BLACK, x + 9.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.BLACK, x + 5.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 5.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].app.draw((Draw)d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                    coa.charge[0].app.draw((Draw)d, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                    coa.charge[0].app.draw((Draw)d, x + 10.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        COUNTERCHARGED(1, 1, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0}){

            @Override
            public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, Clr tint, TinctureSlot highlight) {
                FLAG.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                PARTY_PER_PALE_DETAIL.draw((Draw)d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialChargeLeft(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), x, y, size / 2.0, size);
                    d.drawSpecialChargeRight(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), x + size / 2.0, y, size / 2.0, size);
                } else {
                    coa.charge[0].leftApp.draw((Draw)d, x, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight, tint), false);
                    coa.charge[0].rightApp.draw((Draw)d, x + size / 2.0, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight, tint), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 8.0, 16.0);
                d.rect(Clr.BLACK, x + 8.0, y, 8.0, 16.0);
                d.rect(Clr.BLACK, x + 2.0, y + 2.0, 6.0, 12.0);
                d.rect(Clr.WHITE, x + 8.0, y + 2.0, 6.0, 12.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PARTY_PER_PALE, coa.chargeT[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialChargeLeft(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale);
                    d.drawSpecialChargeRight(coa.specialCharge[0], coa.tincture[0].tint, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale);
                } else {
                    coa.charge[0].leftApp.draw((Draw)d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale, 0, coa.chargeT[0].tint, false);
                    coa.charge[0].rightApp.draw((Draw)d, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale, 0, coa.tincture[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        };

        public final int charges;
        public final int tinctures;
        public final String detailPrefix;
        public final EnumMap<TinctureSlot, EnumSet<TinctureSlot>> adjacency = new EnumMap(TinctureSlot.class);

        public abstract void draw(CoatOfArms var1, MyDraw var2, double var3, double var5, double var7, Clr var9, TinctureSlot var10);

        public abstract void drawLayout(MyDraw var1, double var2, double var4);

        public abstract void drawShield(CoatOfArms var1, MyDraw var2, double var3, double var5, double var7, Clr var9);

        private void adjacent(TinctureSlot a, TinctureSlot b) {
            if (!this.adjacency.containsKey((Object)a)) {
                this.adjacency.put(a, EnumSet.of(b));
            } else {
                this.adjacency.get((Object)a).add(b);
            }
            if (!this.adjacency.containsKey((Object)b)) {
                this.adjacency.put(b, EnumSet.of(a));
            } else {
                this.adjacency.get((Object)b).add(a);
            }
        }

        public String blazon(CoatOfArms coa) {
            return Lang._t("layout_" + this.name() + "_blazon", this.detailPrefix != null ? Lang._t(this.detailPrefix + coa.tincture[1].name(), new Object[0]) : "", coa.tincture[0].getName(), coa.tincture[1].getName(), coa.tincture[2].getName(), coa.tincture[3].getName(), coa.charge[0] == null ? coa.chargeName(0) + " " + coa.chargeT[0].getName() : Lang._t(coa.charge[0].name() + "_" + coa.chargeT[0].name(), new Object[0]), coa.charge[1] == null ? coa.chargeName(1) + " " + coa.chargeT[1].getName() : Lang._t(coa.charge[1].name() + "_" + coa.chargeT[1].name(), new Object[0]), coa.charge[2] == null ? coa.chargeName(2) + " " + coa.chargeT[2].getName() : Lang._t(coa.charge[2].name() + "_" + coa.chargeT[2].name(), new Object[0]), coa.charge[3] == null ? coa.chargeName(3) + " " + coa.chargeT[3].getName() : Lang._t(coa.charge[3].name() + "_" + coa.chargeT[3].name(), new Object[0]), coa.charge[0] == null ? coa.chargesName(0) + " " + coa.chargeT[0].getName() : Lang._t(coa.charge[0].name() + "_" + coa.chargeT[0].name() + "_plural", new Object[0]), coa.charge[1] == null ? coa.chargesName(1) + " " + coa.chargeT[1].getName() : Lang._t(coa.charge[1].name() + "_" + coa.chargeT[1].name() + "_plural", new Object[0]), coa.charge[2] == null ? coa.chargesName(2) + " " + coa.chargeT[2].getName() : Lang._t(coa.charge[2].name() + "_" + coa.chargeT[2].name() + "_plural", new Object[0]), coa.charge[3] == null ? coa.chargesName(3) + " " + coa.chargeT[3].getName() : Lang._t(coa.charge[3].name() + "_" + coa.chargeT[3].name() + "_plural", new Object[0]), coa.chargeT[0].getName(), coa.chargeName(0));
        }

        public String getName() {
            return Lang._t("layout_" + this.name(), new Object[0]);
        }

        private Layout(int charges, int tinctures, String detailPrefix, TinctureSlot ... adjacencies) {
            this.charges = charges;
            this.tinctures = tinctures;
            this.detailPrefix = detailPrefix;
            for (int i = 0; i < adjacencies.length; i += 2) {
                this.adjacent(adjacencies[i], adjacencies[i + 1]);
            }
        }
    }

    public strictfp static enum Tincture {
        ARGENT(new Clr(240, 240, 240), true),
        OR(new Clr(255, 255, 145), true),
        GULES(new Clr(210, 0, 0), false),
        AZURE(new Clr(0, 0, 180), false),
        VERT(new Clr(0, 160, 0), false),
        PURPURE(new Clr(120, 0, 120), false),
        SABLE(new Clr(10, 10, 10), false),
        SANGUINE(new Clr(180, 0, 40), false),
        MURREY(new Clr(130, 0, 60), false),
        TENNE(new Clr(170, 70, 0), false),
        CENDREE(new Clr(70, 70, 70), false),
        BLEU_CELESTE(new Clr(96, 150, 164), false);

        public final Clr tint;
        public final Clr paintTint;
        public final Clr nicePaintTint;
        public final boolean metal;

        private Tincture(Clr tint, boolean metal) {
            this.tint = tint;
            this.metal = metal;
            this.paintTint = new Clr(tint.r, tint.g, tint.b, 100);
            this.nicePaintTint = new Clr(tint.r, tint.g, tint.b, 200).mix(0.3, Clr.DARK_GREY);
        }

        public String getName() {
            return Lang._t("tincture_" + this.name(), new Object[0]);
        }
    }

    public strictfp static enum TinctureSlot {
        TINCTURE0(0, -1),
        TINCTURE1(1, -1),
        TINCTURE2(2, -1),
        TINCTURE3(3, -1),
        CHARGE0(-1, 0),
        CHARGE1(-1, 1),
        CHARGE2(-1, 2),
        CHARGE3(-1, 3);

        public final int tinctureIndex;
        public final int chargeIndex;

        public static TinctureSlot tinctureOf(int index) {
            for (TinctureSlot ts : TinctureSlot.values()) {
                if (ts.tinctureIndex != index) continue;
                return ts;
            }
            return null;
        }

        public static TinctureSlot chargeTOf(int index) {
            for (TinctureSlot ts : TinctureSlot.values()) {
                if (ts.chargeIndex != index) continue;
                return ts;
            }
            return null;
        }

        private TinctureSlot(int tinctureIndex, int chargeIndex) {
            this.tinctureIndex = tinctureIndex;
            this.chargeIndex = chargeIndex;
        }

        public Tincture get(CoatOfArms coa) {
            return this.tinctureIndex == -1 ? coa.chargeT[this.chargeIndex] : coa.tincture[this.tinctureIndex];
        }
    }
}

