/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.BodyPathing;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.CombatSound;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.Fragment;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Physics;
import com.zarkonnen.airships.PlayerInfo;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.Trail;
import com.zarkonnen.airships.TroopPhysics;
import com.zarkonnen.airships.Wheel;
import com.zarkonnen.catengine.util.Pt;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Combat
implements JSONAble,
ShipList {
    public static final int COMBAT_AREA_W = 3200;
    public static final int COMBAT_AREA_H = 1000;
    public static final int EXCLUSION_ZONE_W = 200;
    public static final int RESERVE_ZONE_W = 100;
    public static final int TICK_LENGTH = 16;
    public static final boolean DEBUG_SYNC = true;
    public static final int HISTORY_KEEP = 500;
    public static final int INITIAL_QUEUE_SIZE = 5;
    public static final int CHAT_MESSAGE_STAY = 300;
    public CombatBackgroundFlavor backgroundFlavor = CombatBackgroundFlavor.SEA;
    public ArrayList<Side> sides = new ArrayList();
    public LinkedList<Shot> shots = new LinkedList();
    public LinkedList<Particle> particles = new LinkedList();
    public LinkedList<Fragment> fragments = new LinkedList();
    public ArrayList<LandFormation> landFormations = new ArrayList();
    public Random r = new Random();
    private HashMap<Integer, String> history = new HashMap(1000);
    private boolean desyncConfirmed = false;
    private Client mpClient;
    private Server mpServer;
    public int mpID;
    private HashMap<Side, PlayerInfo> sideToPlayer = new HashMap();
    private HashMap<PlayerInfo, Side> playerToSide = new HashMap();
    private HashMap<Integer, PlayerInfo> idToPlayer = new HashMap();
    private LinkedList<JSONObject> frameQueue = new LinkedList();
    private int ticksSinceLastFrame = 0;
    private boolean runSimAnyway = false;
    private int netTick = 0;
    public int simTick = 0;
    public String chatMessage = "";
    private int ticksSinceLastChatMessage = 0;
    private boolean initialQueueFilled = false;
    private int finishedCountdown = 1000;
    public boolean combatFinished = false;
    public transient int boringTicks = 0;
    private final AirshipGame g;
    public int time;
    public transient int pointsLimit;
    public Pt lightningPt;
    public int lightningAmt;
    public static final int LIGHTNING_P = 10000;
    public static final int LIGHTING_AMT = 90;
    public TimeOfDay timeOfDay;
    public transient boolean slowMotion = false;
    public Physics physics;
    public transient BodyPathing bodyPathing = new BodyPathing();
    public ArrayList<CombatSound> sounds = new ArrayList();
    public ArrayList<Trail> trails = new ArrayList();
    private static final MessageDigest MD5;
    private static final char[] hexArray;
    private static final HashMap<String, CommandExecutor> EXECS;

    public void play(String sound, int x, int y, double volume) {
        this.sounds.add(new CombatSound(sound, x, y, volume));
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String hash(String s) {
        if (s == null) {
            return "?";
        }
        try {
            byte[] data = s.getBytes("UTF-8");
            MD5.reset();
            byte[] digest = MD5.digest(data);
            return Combat.bytesToHex(digest);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return "?";
        }
    }

    public boolean connectionLost() {
        return this.mpClient != null && (this.mpClient.isDisconnected() || this.mpClient.connectionFailed());
    }

    private JSONArray getTickCommands() {
        if (this.mpClient != null) {
            JSONObject msg = this.mpClient.pollMessage();
            if (msg != null && msg.getString("type").equals("frame")) {
                this.frameQueue.add(msg);
            }
            if (this.frameQueue.size() >= 5) {
                this.initialQueueFilled = true;
            }
            if (this.initialQueueFilled && this.isTimeMoving()) {
                ++this.ticksSinceLastFrame;
                ++this.netTick;
                if (this.ticksSinceLastFrame == 4) {
                    this.ticksSinceLastFrame = 0;
                    JSONObject fr = this.frameQueue.pollFirst();
                    int fn = fr.getInt("frameNumber");
                    if (fn != -1 && !this.desyncConfirmed) {
                        String state = this.toJSON().toString();
                        this.history.remove(fn - 500);
                        this.history.put(fn, state);
                        this.mpClient.sendMessage(Client.msg("checksum").put("frameNumber", fr.getInt("frameNumber")).put("hash", Combat.hash(state)));
                    }
                    this.runSimAnyway = true;
                    return fr.getJSONArray("messages");
                }
            }
        }
        return new JSONArray();
    }

    public boolean isTimeMoving() {
        return this.mpClient == null || this.initialQueueFilled && !this.frameQueue.isEmpty();
    }

    private void runTickCommands() {
        JSONArray cs = this.getTickCommands();
        for (int i = 0; i < cs.length(); ++i) {
            this.execCommand(cs.getJSONObject(i));
        }
    }

    public void giveCommand(JSONObject cmd) {
        if (this.mpClient != null) {
            this.mpClient.sendMessage(cmd);
        } else {
            this.execCommand(cmd);
        }
    }

    private void execCommand(JSONObject cmd) {
        if (!EXECS.containsKey(cmd.getString("type"))) {
            this.g.reportError("Unknown command: " + cmd.getString("type"), null, this.chatMessage, false, true);
            return;
        }
        EXECS.get(cmd.getString("type")).run(cmd, this);
    }

    public GridBody getGridBody(JSONObject msg, String prefix) {
        int index;
        if (msg.has(prefix + "Ship")) {
            return this.getShip(msg.getJSONObject(prefix + "Ship"));
        }
        if (msg.has(prefix + "LF") && (index = msg.getInt(prefix + "LF")) >= 0 && index < this.landFormations.size()) {
            return this.landFormations.get(index);
        }
        return null;
    }

    public Airship getShip(JSONObject id) {
        if (id.has("netID")) {
            for (Side s : this.sides) {
                for (Airship ship : s.ships) {
                    if (!ship.networkID.equals(id.getString("netID"))) continue;
                    return ship;
                }
            }
        }
        if (id.has("side")) {
            System.err.println("old-style ship ID used!");
            int sideIndex = id.getInt("side");
            int shipIndex = id.getInt("ship");
            if (sideIndex < this.sides.size() && shipIndex < this.sides.get((int)sideIndex).ships.size()) {
                return this.sides.get((int)sideIndex).ships.get(shipIndex);
            }
        }
        return null;
    }

    public JSONObject getShipID(Airship ship) {
        return new JSONObject().put("netID", ship.networkID);
    }

    public boolean isFinished() {
        return this.combatFinished;
    }

    public boolean isBoring() {
        return this.boringTicks > 1000;
    }

    public void pruneUselessShips() {
        for (Side s : this.sides) {
            Iterator<Airship> it = s.ships.iterator();
            while (it.hasNext()) {
                if (!it.next().useless()) continue;
                it.remove();
            }
        }
    }

    public void repairShips() {
        for (Side s : this.sides) {
            for (Airship ship : s.ships) {
                ship.repair();
            }
        }
    }

    public Side otherSide(Side side) {
        for (Side s : this.sides) {
            if (s == side) continue;
            return s;
        }
        return null;
    }

    @Override
    public int size() {
        int sz = 0;
        int ssz = this.sides.size();
        for (int si = 0; si < ssz; ++si) {
            sz += this.sides.get((int)si).ships.size();
        }
        return sz;
    }

    @Override
    public Airship get(int index) {
        int sideI = 0;
        while (index >= this.sides.get((int)sideI).ships.size()) {
            index -= this.sides.get((int)sideI).ships.size();
            ++sideI;
        }
        return this.sides.get((int)sideI).ships.get(index);
    }

    public boolean done() {
        int nonLosers = 0;
        for (Side s : this.sides) {
            if (this.lost(s)) continue;
            ++nonLosers;
        }
        return nonLosers <= 1;
    }

    public Side sideOf(Airship ship) {
        int ssz = this.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Side side = this.sides.get(si);
            if (!side.ships.contains(ship) && !side.reserve.contains(ship)) continue;
            return side;
        }
        return null;
    }

    public boolean won(Side s) {
        if (s.hasWon) {
            return true;
        }
        if (s.lost()) {
            return false;
        }
        for (Side side : this.sides) {
            if (side == s || side.lost()) continue;
            return false;
        }
        s.hasWon = true;
        return true;
    }

    public boolean lost(Side s) {
        return s.lost();
    }

    public Side getSideForID(int id) {
        return this.playerToSide.isEmpty() ? this.sides.get(id) : this.playerToSide.get(this.idToPlayer.get(id));
    }

    public int getIDForSide(Side side) {
        return this.sideToPlayer.isEmpty() ? this.sides.indexOf(side) : this.sideToPlayer.get((Object)side).id;
    }

    public Combat(AirshipGame g, Client client, Server server, int myID, long seed, ArrayList<PlayerInfo> pis, int pointsLimit, TimeOfDay timeOfDay) {
        this.mpClient = client;
        this.mpServer = server;
        this.mpID = myID;
        this.r = new Random(seed);
        this.pointsLimit = pointsLimit;
        this.g = g;
        this.timeOfDay = timeOfDay;
        this.idToPlayer = new HashMap();
        for (PlayerInfo pi : pis) {
            this.idToPlayer.put(pi.id, pi);
            Side s = new Side(pi.name, Bonus.STANDARD_BONUSES);
            s.arms = pi.arms;
            s.ships = pi.fleet;
            this.sides.add(s);
            this.sideToPlayer.put(s, pi);
            this.playerToSide.put(pi, s);
        }
        for (int i = 0; i < 4; ++i) {
            this.frameQueue.add(new JSONObject().put("messages", new JSONArray()).put("frameNumber", -1));
        }
    }

    public boolean isMultiplayer() {
        return this.mpClient != null;
    }

    public boolean canAbandonShip(Airship ship) {
        if (!(ship.type.onGround || ship.lastGrounded != null && ship.msSinceOnGround <= 100)) {
            return false;
        }
        Side s = this.sideOf(ship);
        for (Airship as : s.ships) {
            if (as == ship || !as.canShoot() || as.crew.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Combat(AirshipGame g, TimeOfDay timeOfDay) {
        Side you = new Side(Lang._t("You_player", new Object[0]), Bonus.STANDARD_BONUSES);
        you.arms = CoatEditor.getMyStrategicArms();
        this.sides.add(you);
        this.sides.add(new Side(Lang._t("Enemy_player", new Object[0]), Bonus.STANDARD_BONUSES));
        this.g = g;
        this.timeOfDay = timeOfDay;
    }

    private void finish() {
        if (this.mpClient != null) {
            this.mpClient.close();
        }
        if (this.mpServer != null) {
            this.mpServer.close();
        }
    }

    public void tick(int ms, Side viewingSide, boolean lightning) {
        if (this.slowMotion && !this.isMultiplayer()) {
            ms /= 4;
        }
        if (this.combatFinished) {
            return;
        }
        if (this.connectionLost()) {
            this.finish();
            return;
        }
        if (this.done()) {
            this.finishedCountdown -= ms;
            if (this.finishedCountdown <= 0) {
                this.combatFinished = true;
                this.finish();
                return;
            }
        } else {
            this.finishedCountdown = 10000;
        }
        this.runTickCommands();
        if (this.ticksSinceLastChatMessage++ >= 300) {
            this.chatMessage = "";
        }
        if (!this.isTimeMoving() && !this.runSimAnyway) {
            return;
        }
        this.runSimAnyway = false;
        double wind = this.timeOfDay.effect.wind;
        ++this.simTick;
        ++this.boringTicks;
        this.time += ms;
        if (this.physics == null) {
            this.physics = new Physics();
            this.physics.gravity = 0.001;
            for (LandFormation lf : this.landFormations) {
                this.physics.bodies.add(lf);
            }
        }
        for (Side s : this.sides) {
            if (s.originalComposition.isEmpty()) {
                s.originalComposition.addAll(s.ships);
                s.originalComposition.addAll(s.reserve);
            }
            for (Airship a : s.ships) {
                if (!a.removeMe() && !this.physics.bodies.contains(a)) {
                    this.physics.bodies.add(a);
                    for (Module m : a.modules) {
                        for (Leg l : m.legs) {
                            this.physics.bodies.add(l.foot);
                        }
                        for (Wheel w : m.wheels) {
                            this.physics.bodies.add(w.body);
                        }
                    }
                    a.moveTo = new Pt(a.x, a.y);
                }
                for (Module m : a.modules) {
                    for (Leg l : m.legs) {
                        if (m.hp <= 0) {
                            this.physics.bodies.remove(l.foot);
                            continue;
                        }
                        if (this.physics.bodies.contains(l.foot)) continue;
                        this.physics.bodies.add(l.foot);
                    }
                }
            }
            for (Airship a : s.reserve) {
                this.physics.bodies.remove(a);
                for (Module m : a.modules) {
                    for (Leg l : m.legs) {
                        this.physics.bodies.remove(l.foot);
                    }
                    for (Wheel w : m.wheels) {
                        this.physics.bodies.remove(w.body);
                    }
                }
            }
        }
        this.physics.tick(ms, this);
        TroopPhysics.tick(ms, this);
        for (Side s : this.sides) {
            for (Airship ship : s.ships) {
                ship.precalcAIValues();
            }
        }
        for (Side s : this.sides) {
            s.tick(ms, this, this.won(s), this.physics);
        }
        Iterator it = this.particles.iterator();
        while (it.hasNext()) {
            if (!((Particle)it.next()).tick(ms, wind, this)) continue;
            it.remove();
        }
        it = this.fragments.iterator();
        while (it.hasNext()) {
            if (!((Fragment)it.next()).tick(ms)) continue;
            it.remove();
        }
        ArrayList<LandFormation> newLandFormations = new ArrayList<LandFormation>();
        Iterator<Object> it2 = this.landFormations.iterator();
        while (it2.hasNext()) {
            LandFormation lf = it2.next();
            if (lf.tick(ms, this)) {
                it2.remove();
                continue;
            }
            ArrayList<LandFormation> nlfs = lf.splitIntoChunksIfNeeded();
            if (nlfs == null) continue;
            newLandFormations.addAll(nlfs);
        }
        for (LandFormation lf : newLandFormations) {
            this.landFormations.add(lf);
            this.physics.bodies.add(lf);
        }
        it2 = this.shots.iterator();
        while (it2.hasNext()) {
            if (!((Shot)((Object)it2.next())).tick(ms, this)) continue;
            it2.remove();
        }
        it2 = this.trails.iterator();
        while (it2.hasNext()) {
            if (!((Trail)it2.next()).tick(ms)) continue;
            it2.remove();
        }
        boolean snow = this.timeOfDay == TimeOfDay.SNOW;
        for (LandFormation lf : this.landFormations) {
            for (int gy = 0; gy < lf.grid.length; ++gy) {
                for (int gx = 0; gx < lf.grid[gy].length; ++gx) {
                    Particle p;
                    if (!lf.edge[gy][gx]) continue;
                    LandBlockType lbt = lf.grid[gy][gx];
                    if (lbt.particleEmitter != null && !snow && (p = lbt.particleEmitter.emit(lf.x + (double)(gx * 16) + 8.0, lf.y + (double)(gy * 16) + 8.0, ms)) != null) {
                        this.particles.add(p);
                    }
                    if (lbt.snowParticleEmitter == null || !snow || (p = lbt.snowParticleEmitter.emit(lf.x + (double)(gx * 16) + 8.0, lf.y + (double)(gy * 16) + 8.0, ms)) == null) continue;
                    this.particles.add(p);
                }
            }
        }
        for (Side side : this.sides) {
            for (Airship ship : side.ships) {
                for (Module m : ship.getModules()) {
                    if (!m.running()) continue;
                    for (ModuleType.ModuleParticleEmitter e : m.type.getEmitters()) {
                        int x;
                        Particle p;
                        if (e.inside && ship.showingOutside || (p = e.emit((x = ship.flipped ? ship.getWidth() - m.x : m.x) * 16 + ship.getX(), m.y * 16 + ship.getY(), ms, ship.flipped)) == null) continue;
                        this.particles.add(p);
                    }
                    if (m.type.getReload() <= 0 || !m.fired || !m.type.muzzleFlash()) continue;
                    double x = ship.flipped ? (double)(ship.getWidth() - m.x - m.type.getW()) - 0.4 : (double)(m.x + m.type.getW()) + 0.4;
                    double y = (double)(m.y + m.type.getH()) - 0.5;
                    int parts = Math.min(3, (m.type.getBlastDmg(ship.currentBonuses) + m.type.getPenDmg()) / 30 + (AGame.ANIM_R.nextInt(20) == 0 ? 1 : 0));
                    for (int i = 0; i < parts; ++i) {
                        this.particles.add(new Particle(Particle.Type.SMOKE, x * 16.0 + (double)ship.getX(), y * 16.0 + (double)ship.getY()));
                    }
                    Particle.Type pt = m.type.getBlastDmg(ship.currentBonuses) + m.type.getPenDmg() > 20 ? Particle.Type.MUZZLE : Particle.Type.MUZZLE_SMALL;
                    Pt mz = m.currentMuzzle();
                    this.particles.add(new Particle(pt, mz.x, mz.y));
                    if (pt != Particle.Type.MUZZLE) continue;
                    for (int i = 0; i < 6; ++i) {
                        this.particles.add(new Particle(Particle.Type.MUZZLE_CHUNK, mz.x, mz.y));
                    }
                }
            }
        }
        for (Side side : this.sides) {
            ArrayList<Airship> ships = new ArrayList<Airship>(side.ships);
            for (Airship ship : ships) {
                if (!ship.shouldSwitchSides()) continue;
                ship.switchSides();
                side.ships.remove(ship);
                this.otherSide((Side)side).ships.add(ship);
                if (this.otherSide((Side)side).usingAI) {
                    ship.ai = new TacticalAI(ship, this, this.otherSide(side), side);
                    continue;
                }
                ship.ai = null;
            }
        }
        if (lightning) {
            this.lightningAmt -= ms;
            if (this.lightningAmt <= 0 && this.r.nextInt(10000) == 0) {
                ArrayList<Airship> victims = new ArrayList<Airship>();
                for (Side s : this.sides) {
                    victims.addAll(s.ships);
                }
                int xPos = this.r.nextInt(3200) - 1600;
                Airship victim = null;
                double bestDist = 0.0;
                for (Airship ship : victims) {
                    double sx = ship.x + ship.getBBWidth() / 2.0;
                    double sy = ship.y + ship.getBBHeight() / 2.0;
                    double ly = -1988.0;
                    double d = (sx - (double)xPos) * (sx - (double)xPos) + (sy - ly) * (sy - ly);
                    if (victim != null && !(d < bestDist)) continue;
                    victim = ship;
                    bestDist = d;
                }
                if (victim != null) {
                    int vx = this.r.nextInt(victim.getWidth());
                    int vy = 0;
                    while (victim.tileAt(vx, vy) == null) {
                        ++vy;
                    }
                    this.lightningPt = new Pt(victim.x + (double)(vx * 16) + 8.0, victim.y + (double)(vy * 16) + 8.0);
                    this.lightningAmt = 90;
                    Tile t = victim.tileAt(vx, vy);
                    t.armour.hp = Math.max(0, t.armour.hp - 20);
                    t.module.hp -= 30;
                    for (double ly = this.lightningPt.y; ly > -1988.0; ly -= (double)(20 + AGame.ANIM_R.nextInt(20))) {
                        this.particles.add(new Particle(Particle.Type.LIGHTNING_FLASH, this.lightningPt.x, ly));
                    }
                    t.module.fire += 10;
                    for (int dy = -1; dy < 2; ++dy) {
                        for (int dx = -1; dx < 2; ++dx) {
                            Tile t2;
                            if (dx == 0 && dy == 0 || (t2 = victim.tileAt(vx + dx, vy + dy)) == null) continue;
                            t2.armour.hp = Math.max(0, t2.armour.hp - 20);
                            t2.module.hp -= 30;
                            t.module.fire += 5;
                        }
                    }
                    this.play("lightning0", (int)this.lightningPt.x, (int)this.lightningPt.y, 3.0);
                }
            }
        }
    }

    public Combat(AirshipGame g, JSONObject o) {
        if (o.has("backgroundFlavor")) {
            this.backgroundFlavor = CombatBackgroundFlavor.valueOf(o.getString("backgroundFlavor"));
        }
        JSONArray a = o.getJSONArray("sides");
        for (int i = 0; i < a.length(); ++i) {
            this.sides.add(new Side(a.getJSONObject(i)));
        }
        this.timeOfDay = TimeOfDay.valueOf(o.optString("timeOfDay", TimeOfDay.DAY.name()));
        this.g = g;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        JSONArray a = new JSONArray();
        o.put("sides", a);
        for (Side s : this.sides) {
            a.put(s.toJSON(this));
        }
        return o;
    }

    public boolean canPlace(Airship ship, List<Airship> others, int x, int y, int spacing) {
        int w = ship.getWidth() * 16;
        int h = ship.getHeight() * 16;
        if (x + w > 1600 || x < -1600) {
            return false;
        }
        int ceiling = 512 - ship.serviceCeiling();
        if (!ship.type.onGround && y < ceiling) {
            return false;
        }
        for (Airship s2 : others) {
            int x2 = s2.getX();
            int y2 = s2.getY();
            int w2 = s2.getWidth() * 16;
            int h2 = s2.getHeight() * 16;
            if (x2 + w2 + spacing <= x || x + w + spacing <= x2 || y2 + h2 + spacing <= y || y + h + spacing <= y2) continue;
            return false;
        }
        double ox = ship.x;
        double oy = ship.y;
        ship.x = x;
        ship.y = y;
        for (LandFormation lf : this.landFormations) {
            if (!ship.overlapsWith(lf, false)) continue;
            ship.x = ox;
            ship.y = oy;
            return false;
        }
        ship.x = ox;
        ship.y = oy;
        return true;
    }

    static {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        MD5 = md;
        hexArray = "0123456789ABCDEF".toCharArray();
        EXECS = new HashMap();
        EXECS.put("surrender", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                ((Side)((Combat)c).playerToSide.get(((Combat)c).idToPlayer.get((Object)Integer.valueOf((int)cmd.getInt((String)"id"))))).surrendered = true;
            }
        });
        EXECS.put("checksum", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                String hash = cmd.getString("hash");
                int frameNumber = cmd.getInt("frameNumber");
                if (!c.desyncConfirmed && c.history.containsKey(frameNumber) && !Combat.hash((String)c.history.get(frameNumber)).equals(hash)) {
                    String report = "Checksum error at #" + frameNumber + "\n" + Combat.hash((String)c.history.get(frameNumber)) + " vs " + hash + "\n" + (String)c.history.get(frameNumber);
                    c.g.reportError(Lang._t("network_desync_detected", new Object[0]), null, report, false, true);
                    c.mpClient.sendMessage(Client.msg("historyRequest").put("frameNumber", frameNumber));
                }
            }
        });
        EXECS.put("historyRequest", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                int frameNumber = cmd.getInt("frameNumber");
                if (c.history.containsKey(frameNumber)) {
                    c.mpClient.sendMessage(Client.msg("historyResponse").put("frameNumber", frameNumber).put("frame", c.history.get(frameNumber)));
                } else {
                    System.out.println("History request for #" + frameNumber + " failed.");
                }
            }
        });
        EXECS.put("historyResponse", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                if (c.desyncConfirmed) {
                    return;
                }
                int frameNumber = cmd.getInt("frameNumber");
                String report = "History comparison at #" + frameNumber + "\n";
                if (c.history.containsKey(frameNumber)) {
                    report = report + "Mine:\n";
                    report = report + (String)c.history.get(frameNumber) + "\n";
                }
                report = report + "Theirs:\n";
                report = report + cmd.getString("frame") + "\n";
                c.g.reportError(Lang._t("network_diverge_warning", new Object[0]), null, report, false);
                c.desyncConfirmed = true;
            }
        });
        EXECS.put("focusOnShooting", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.focusOnShooting = true;
                ship.focusOnRepair = false;
                ship.focusOnFirefighting = false;
                ship.focusOnMoving = false;
                ship.commandGiven();
            }
        });
        EXECS.put("focusOnFirefighting", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.focusOnShooting = false;
                ship.focusOnRepair = false;
                ship.focusOnFirefighting = true;
                ship.focusOnMoving = false;
                ship.commandGiven();
            }
        });
        EXECS.put("focusOnRepair", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.focusOnShooting = false;
                ship.focusOnRepair = true;
                ship.focusOnFirefighting = false;
                ship.focusOnMoving = false;
                ship.commandGiven();
            }
        });
        EXECS.put("focusOnMoving", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.focusOnShooting = false;
                ship.focusOnRepair = false;
                ship.focusOnFirefighting = false;
                ship.focusOnMoving = true;
                ship.commandGiven();
            }
        });
        EXECS.put("fireMode", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.fireMode = FireMode.valueOf(cmd.getString("value"));
                ship.fireOrderSpoken = false;
                ship.commandGiven();
            }
        });
        EXECS.put("ground", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.groundShip();
                ship.commandGiven();
            }
        });
        EXECS.put("abandon", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.abandonShip(c);
                ship.commandGiven();
            }
        });
        EXECS.put("moveTo", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.moveTo = new Pt(cmd.getDouble("x"), cmd.getDouble("y"));
                ship.flipTo = cmd.getBoolean("flipTo");
                ship.ramming = false;
                ship.grounding = false;
                ship.sitting = false;
                ship.commandGiven();
            }
        });
        EXECS.put("ram", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                ship.moveTo = new Pt(cmd.getDouble("x"), cmd.getDouble("y"));
                ship.flipTo = cmd.getBoolean("flipTo");
                ship.ramming = true;
                ship.grounding = false;
                ship.ramOrderSpoken = false;
                ship.sitting = false;
                ship.commandGiven();
            }
        });
        EXECS.put("fireAt", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                if (c.getShip(cmd.getJSONObject("target")) == null) {
                    return;
                }
                ship.fireAt = c.getShip(cmd.getJSONObject("target"));
                ship.commandGiven();
            }
        });
        EXECS.put("board", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Airship ship = c.getShip(cmd.getJSONObject("id"));
                if (ship == null) {
                    return;
                }
                if (c.getShip(cmd.getJSONObject("target")) == null) {
                    return;
                }
                ship.board = c.getShip(cmd.getJSONObject("target"));
                ship.commandGiven();
            }
        });
        EXECS.put("chat", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                PlayerInfo pi = (PlayerInfo)c.idToPlayer.get(cmd.getInt("id"));
                c.chatMessage = pi != null ? pi.tint + pi.name + ": " + cmd.getString("text") : cmd.getString("text");
                c.ticksSinceLastChatMessage = 0;
            }
        });
        EXECS.put("moveTroops", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, Combat c) {
                Side side = c.getSideForID(cmd.getInt("playerID"));
                GridBody source = c.getGridBody(cmd, "source");
                GridBody target = c.getGridBody(cmd, "target");
                if (source == null || target == null) {
                    return;
                }
                boolean shouted = false;
                for (Crewman cm : side.troops) {
                    if (cm.attachedTo != source) continue;
                    cm.ultimateBoardTarget = target;
                    cm.proximateBoardTarget = null;
                    cm.hookLaunched = false;
                    cm.jumpTargetGR = null;
                    cm.walkToGR = null;
                    cm.walkToTargetGR = null;
                    if (shouted) continue;
                    cm.doShout(cm.pickShout("troopMove"));
                    shouted = true;
                }
            }
        });
    }

    public strictfp static class Side {
        public boolean hasWon;
        public boolean hasLost;
        public String name;
        public CoatOfArms arms = CoatOfArms.getRandom();
        public ArrayList<Airship> ships = new ArrayList();
        public ArrayList<Airship> reserve = new ArrayList();
        public ArrayList<Crewman> troops = new ArrayList();
        public transient ArrayList<Airship> originalComposition = new ArrayList();
        public EnumSet<Bonus> bonuses = Bonus.STANDARD_BONUSES;
        public boolean surrendered = false;
        public boolean usingAI = false;

        public boolean lost() {
            if (this.surrendered || this.hasLost) {
                return true;
            }
            int ssz = this.ships.size();
            for (int si = 0; si < ssz; ++si) {
                Airship ship = this.ships.get(si);
                if (!ship.canShoot() || ship.crew.isEmpty()) continue;
                return false;
            }
            this.hasLost = true;
            return true;
        }

        public Side(String name, EnumSet<Bonus> bonuses) {
            this.name = name;
            this.bonuses = bonuses;
        }

        public void tick(int ms, Combat c, boolean won, Physics ph) {
            boolean lost = this.lost();
            for (Airship s : new ArrayList<Airship>(this.ships)) {
                if (!s.tick(ms, c, won, lost)) continue;
                this.ships.remove(s);
                ph.bodies.remove(s);
            }
            for (Crewman cm : new ArrayList<Crewman>(this.troops)) {
                if (!cm.outsideTick(ms, c, this)) continue;
                this.troops.remove(cm);
            }
        }

        public Side(JSONObject o) {
            int i;
            this.name = o.getString("name");
            this.surrendered = o.getBoolean("surrendered");
            JSONArray a = o.getJSONArray("ships");
            for (i = 0; i < a.length(); ++i) {
                this.ships.add(new Airship(a.getJSONObject(i)));
            }
            a = o.optJSONArray("reserve");
            if (a != null) {
                for (i = 0; i < a.length(); ++i) {
                    this.reserve.add(new Airship(a.getJSONObject(i)));
                }
            }
            this.usingAI = o.optBoolean("usingAI", false);
            a = o.optJSONArray("troops");
            if (a != null) {
                for (i = 0; i < a.length(); ++i) {
                    this.troops.add(new Crewman(o, null));
                }
            }
            if (o.has("bonuses")) {
                this.bonuses = EnumSet.noneOf(Bonus.class);
                a = o.getJSONArray("bonuses");
                for (i = 0; i < a.length(); ++i) {
                    this.bonuses.add(Bonus.valueOf(a.getString(i)));
                }
            }
        }

        public JSONObject toJSON(Combat c) {
            JSONObject o = new JSONObject().put("name", this.name).put("surrendered", this.surrendered).put("usingAI", this.usingAI);
            JSONArray a = new JSONArray();
            o.put("ships", a);
            for (Airship s : this.ships) {
                a.put(s.toJSON(c));
            }
            a = new JSONArray();
            o.put("reserve", a);
            for (Airship s : this.reserve) {
                a.put(s.toJSON(c));
            }
            a = new JSONArray();
            o.put("troops", a);
            for (Crewman cm : this.troops) {
                a.put(cm.toJSON(c));
            }
            a = new JSONArray();
            o.put("bonuses", a);
            for (Bonus b : this.bonuses) {
                a.put(b.name());
            }
            return o;
        }

        public int getCost() {
            int c = 0;
            int al = this.ships.size();
            for (int ai = 0; ai < al; ++ai) {
                c += this.ships.get(ai).getCost();
            }
            return c;
        }

        public void layoutShips(Combat c, boolean flipped) {
            this.ships.addAll(this.reserve);
            this.reserve.clear();
            for (Airship s : this.ships) {
                if (!s.type.mobile) continue;
                s.setX(-10000.0);
                s.setY(-10000.0);
            }
            Iterator<Airship> it = this.ships.iterator();
            block1: while (it.hasNext()) {
                int x;
                Airship s;
                s = it.next();
                if (!s.type.mobile) continue;
                s.setFlipped(flipped);
                s.flipTo = flipped;
                int n = x = flipped ? 100 : -100 - s.getWidth() * 16;
                while (flipped ? x < 1600 : x > -1600) {
                    block8: {
                        int y;
                        if (s.type.onGround) {
                            y = c.landFormations.get(0).getVerticalPosition(s, x, false) - (int)s.groundOffset();
                            for (Airship s2 : this.ships) {
                                if (s == s2 || !((double)x + s.getBBWidth() >= s2.x) || !(s2.x + s2.getBBWidth() >= (double)x)) continue;
                                break block8;
                            }
                            if (c.canPlace(s, this.ships, x, y, 20)) {
                                s.setX(x);
                                s.setY(y);
                                continue block1;
                            }
                        } else {
                            for (y = -488; y < 512; y += 40) {
                                if (!c.canPlace(s, this.ships, x, y, 20)) continue;
                                s.setX(x);
                                s.setY(y);
                                continue block1;
                            }
                        }
                    }
                    x += flipped ? 80 : -80;
                }
                this.reserve.add(s);
                it.remove();
            }
        }
    }

    private static interface CommandExecutor {
        public void run(JSONObject var1, Combat var2);
    }
}

