/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CombatAchievement;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.PerfReport;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;

public abstract class CombatIntent
implements UniScreen.Intent {
    public static final int TICK_LENGTH = 16;
    public CombatSpeed speed = CombatSpeed.NORMAL;
    public int time = 0;
    public int accumulatedTime = 0;
    public ArrayList<CombatAchievement> achievements;
    public PerfReport perfRep;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.achievements == null) {
            this.achievements = CombatAchievement.get();
        }
        if (this.achievements != null) {
            for (CombatAchievement a : this.achievements) {
                a.tick(us.combat, us.mySide);
            }
        }
        if (this.perfRep == null) {
            this.perfRep = new PerfReport(us.combat, in.mode());
        }
        this.perfRep.countFrameTime(ms);
        for (int iter = 0; iter < this.speed.mult; ++iter) {
            this.time += ms;
            this.accumulatedTime += ms;
            while (this.accumulatedTime >= 16) {
                us.combat.tick(16, us.mySide, us.getTimeOfDay().effect.lightning);
                this.accumulatedTime -= 16;
            }
        }
        if (us.combat.connectionLost()) {
            us.g.s = new MainMenu(us.g);
        }
    }

    public void leave(UniScreen us) {
        us.g.reportPerformance(this.perfRep);
        this.doLeave(us);
    }

    public abstract void doLeave(UniScreen var1);

    @Override
    public boolean drawAsBlueprint() {
        return false;
    }
}

