/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatSound;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class CombatSoundEffects
implements UniScreen.InfoPanel {
    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.combat != null) {
            ScreenMode sm = in.mode();
            Combat combat = us.combat;
            int al = us.mySide.ships.size();
            for (int ai = 0; ai < al; ++ai) {
                Airship as = us.mySide.ships.get(ai);
                if (!as.readyForCommand() || as.wasReadyForCommand || as.ai != null) continue;
                combat.play("bell", (int)((double)as.getX() + as.getBBWidth() / 2.0), (int)((double)as.getY() + as.getBBHeight() / 2.0), 1.0);
                as.wasReadyForCommand = true;
            }
            int csl = combat.sounds.size();
            for (int csi = 0; csi < csl; ++csi) {
                CombatSound cs = combat.sounds.get(csi);
                double volume = Math.pow(us.zoom, 2.0) * cs.volume;
                if (volume < 0.01) continue;
                in.play(cs.name, 0.98 + AGame.ANIM_R.nextDouble() * 0.05, (0.9 + AGame.ANIM_R.nextDouble() * 0.1) * volume * us.g.volume, (double)(cs.x + us.adjScrollX) * us.zoom / (double)sm.width * 2.0 - 1.0, (double)(cs.y + us.adjScrollY) * us.zoom / (double)sm.height * 2.0 - 1.0);
            }
            combat.sounds.clear();
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

