/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.BoardCommandTool;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MoveCommandTool;
import com.zarkonnen.airships.MoveTroopsTool;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.TargetCommandTool;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class CommandButtonsPanel
implements UniScreen.InfoPanel {
    public String commandTooltip = null;
    public String nextTooltip = null;
    private static final Clr COA_BORDER = Clr.fromHex((String)"f5edb5");
    private final Img TOP = new Img("spritesheet", 125, 915, 54, 30, false);
    public static final Clr COOLDOWN = new Clr(255, 255, 255, 80);
    private final Img MOVE = new Img("spritesheet", 0, 416, 16, 16, false);
    private final Img RAM = new Img("spritesheet", 368, 416, 16, 16, false);
    private final Img GROUND = new Img("spritesheet", 16, 416, 16, 16, false);
    private final Img FIREFIGHT = new Img("spritesheet", 32, 416, 16, 16, false);
    private final Img REPAIR = new Img("spritesheet", 48, 416, 16, 16, false);
    private final Img MOVEFOCUS = new Img("spritesheet", 224, 416, 16, 16, false);
    private final Img SHOOT = new Img("spritesheet", 64, 416, 16, 16, false);
    private final Img AIMED_F = new Img("spritesheet", 80, 416, 16, 16, false);
    private final Img NORMAL_F = new Img("spritesheet", 96, 416, 16, 16, false);
    private final Img RAPID_F = new Img("spritesheet", 112, 416, 16, 16, false);
    private final Img TARGET = new Img("spritesheet", 128, 416, 16, 16, false);
    private final Img BOARD = new Img("spritesheet", 240, 416, 16, 16, false);
    private final Img MOVE_TROOPS = new Img("spritesheet", 384, 416, 16, 16, false);
    private final Img ABANDON = new Img("spritesheet", 400, 416, 16, 16, false);

    private void tooltipHook(MyDraw d, int x, int y, final String tt) {
        d.hook(x, y, 24.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

            public void run(Input in, Pt p, Hook.Type type) {
                CommandButtonsPanel.this.nextTooltip = tt;
            }
        });
    }

    public static String cmdTooltip(String key, String shortcut) {
        String v = Lang._t(key, new Object[0]);
        v = shortcut != null ? (v.contains(shortcut) ? "[ffffff]" + v.substring(0, v.indexOf(shortcut)) + "[ba872f]" + shortcut + "[ffffff]" + v.substring(v.indexOf(shortcut) + 1) : (v.contains(shortcut.toLowerCase()) ? "[ffffff]" + v.substring(0, v.indexOf(shortcut.toLowerCase())) + "[ba872f]" + shortcut.toLowerCase() + "[ffffff]" + v.substring(v.indexOf(shortcut.toLowerCase()) + 1) : "[ffffff]" + v + " ([ba872f]" + shortcut + "[ffffff])")) : "[ffffff]" + v;
        return v;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, final UniScreen us) {
        if (!(us.intent instanceof CombatIntent)) {
            return;
        }
        if (us.hideUI) {
            return;
        }
        int w = 471;
        int x = sm.width / 2 - w / 2;
        int h = Math.max(82, AGame.BIG_FOUNT.height * 2 + 24 + 3) + 12 + 12;
        int y = sm.height - h;
        d.drawWindow(x, y, w, h + 12 + 5);
        d.blit(this.TOP, x + w / 2 - this.TOP.srcWidth / 2, y - this.TOP.srcHeight);
        us.mySide.arms.layout.drawShield(us.mySide.arms, d, x += 12, y += 12, 2.0, COA_BORDER);
        x += 84;
        if (us.selectedLF != null || us.selectedShip != null && us.selectedShip.commandPointsGenerated() == 0) {
            if (us.selectedLF != null) {
                d.text(us.selectedLF.isImmobile() ? Lang._t("Ground", new Object[0]) : Lang._t("Floating_rock", new Object[0]), AGame.BIG_FOUNT, x, y);
            } else {
                d.text(us.selectedShip.name, AGame.BIG_FOUNT, x, y);
            }
            y += AGame.BIG_FOUNT.height;
            if (us.tool instanceof MoveTroopsTool) {
                d.button(x, y, 120, Lang._t("Cancel", new Object[0]), "C", new Runnable(){

                    @Override
                    public void run() {
                        us.tool = UniScreen.NAVIGATE;
                    }
                });
            }
            int nco = 0;
            for (Crewman cm : us.mySide.troops) {
                if (cm.attachedTo != us.selectedLF) continue;
                ++nco;
            }
            if (this.commandTooltip != null) {
                d.text(this.commandTooltip, AGame.BIG_FOUNT, x, y + 24 + 3);
            } else {
                d.text(Lang._t("Crew_", new Object[0]) + nco, AGame.FOUNT, x, y + 24 + 12);
            }
            if (us.tool == UniScreen.NAVIGATE) {
                d.iconButton(x, y, this.MOVE_TROOPS, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new MoveTroopsTool();
                    }
                }, nco > 0);
                this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Move_troops_", "M"));
                x += 27;
            }
        }
        if (us.selectedShip != null && us.selectedShip.commandPointsGenerated() > 0) {
            d.text(us.selectedShip.name, AGame.BIG_FOUNT, x, y);
            y += AGame.BIG_FOUNT.height;
            if (us.tool instanceof MoveCommandTool) {
                final MoveCommandTool mct = (MoveCommandTool)us.tool;
                d.button(x, y, 120, Lang._t("Flip", new Object[0]), "F", new Runnable(){

                    @Override
                    public void run() {
                        mct.flipped = !mct.flipped;
                    }
                });
            }
            if (us.tool != UniScreen.NAVIGATE) {
                return;
            }
            final Airship ship = us.selectedShip;
            int cooldown = Math.max(0, 24 - 24 * ship.commandPoints / ship.commandPointsRequired());
            if (this.commandTooltip != null) {
                d.text(this.commandTooltip, AGame.BIG_FOUNT, x, y + 24 + 3);
            } else {
                String info = ShipEditorUtils.indent(Lang._t("Crew_", new Object[0]), 12) + ShipEditorUtils.indent("" + ship.getCrewCount() + "/" + ship.getAllQuartered(), 10) + ShipEditorUtils.indent(Lang._t("Ammo_", new Object[0]), 12) + ShipEditorUtils.indent("" + ship.getTotalResource(Resource.AMMO) + "/" + ship.getAmmoCapacity(), 10) + "\n" + ShipEditorUtils.indent(Lang._t("Coal_", new Object[0]), 12) + ShipEditorUtils.indent("" + ship.getTotalResource(Resource.COAL) + "/" + ship.getCoalCapacity(), 10) + ShipEditorUtils.indent(Lang._t("Water_", new Object[0]), 12) + ShipEditorUtils.indent("" + ship.getTotalResource(Resource.WATER) + "/" + ship.getWaterCapacity(), 10);
                d.text(info, AGame.FOUNT, x, y + 24 + 12);
            }
            if (ship.type.mobile) {
                d.iconButton(x, y, this.MOVE, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new MoveCommandTool(us, false);
                    }
                }, ship.readyForCommand());
                d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
                this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Move_", "M"));
                d.iconButton(x += 27, y, this.RAM, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new MoveCommandTool(us, true);
                    }
                }, ship.readyForCommand());
                d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
                this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Ram_", "R"));
                x += 27;
                if (!ship.type.onGround && !us.combat.canAbandonShip(ship)) {
                    d.iconButton(x, y, this.GROUND, new Runnable(){

                        @Override
                        public void run() {
                            CommandButtonsPanel.this.groundShip(us.combat, ship);
                        }
                    }, ship.readyForCommand());
                    d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
                    this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Ground_ship_", "G"));
                    x += 27;
                }
            }
            if (us.combat.canAbandonShip(ship)) {
                d.iconButton(x, y, this.ABANDON, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.abandonShip(us.combat, ship);
                    }
                }, ship.readyForCommand());
                d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
                this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Abandon_" + ship.type.name(), "D"));
                x += 27;
            }
            d.iconButton(x, y, this.MOVE_TROOPS, new Runnable(){

                @Override
                public void run() {
                    us.tool = new BoardCommandTool(true);
                }
            }, ship.readyForCommand() && us.combat.canAbandonShip(ship));
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Transfer_crew_", "C"));
            d.iconButton(x += 27, y, this.BOARD, new Runnable(){

                @Override
                public void run() {
                    us.tool = new BoardCommandTool(false);
                }
            }, ship.readyForCommand() && BoardCommandTool.canBoard(ship, us.mySide));
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Board_ship_", "B"));
            d.iconButton(x += 27, y, this.TARGET, new Runnable(){

                @Override
                public void run() {
                    us.tool = new TargetCommandTool();
                }
            }, ship.readyForCommand() && ship.canShoot());
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Target_ship_", "T"));
            d.iconToggle(x += 36, y, this.FIREFIGHT, new Runnable(){

                @Override
                public void run() {
                    CommandButtonsPanel.this.focusOnFirefighting(us.combat, ship);
                }
            }, ship.focusOnFirefighting, !ship.focusOnFirefighting && ship.readyForCommand() && ship.canFirefight());
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Focus_on_firefighting", "F"));
            d.iconToggle(x += 27, y, this.REPAIR, new Runnable(){

                @Override
                public void run() {
                    CommandButtonsPanel.this.focusOnRepair(us.combat, ship);
                }
            }, ship.focusOnRepair, !ship.focusOnRepair && ship.readyForCommand() && ship.canRepair());
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Focus_on_repair", "E"));
            d.iconToggle(x += 27, y, this.MOVEFOCUS, new Runnable(){

                @Override
                public void run() {
                    CommandButtonsPanel.this.focusOnMoving(us.combat, ship);
                }
            }, ship.focusOnMoving, !ship.focusOnMoving && ship.readyForCommand() && ship.getPropulsion() > 0.0);
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Focus_on_moving", "V"));
            d.iconToggle(x += 27, y, this.SHOOT, new Runnable(){

                @Override
                public void run() {
                    CommandButtonsPanel.this.focusOnShooting(us.combat, ship);
                }
            }, ship.focusOnShooting, !ship.focusOnShooting && ship.readyForCommand() && ship.canShoot());
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Focus_on_shooting", "S"));
            d.iconToggle(x += 36, y, this.AIMED_F, new Runnable(){

                @Override
                public void run() {
                    CommandButtonsPanel.this.fireMode(us.combat, ship, FireMode.AIMED);
                }
            }, ship.fireMode == FireMode.AIMED, ship.readyForCommand() && ship.canShoot() && ship.fireMode != FireMode.AIMED);
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Aimed_fire", "A"));
            d.iconToggle(x += 27, y, this.NORMAL_F, new Runnable(){

                @Override
                public void run() {
                    CommandButtonsPanel.this.fireMode(us.combat, ship, FireMode.NORMAL);
                }
            }, ship.fireMode == FireMode.NORMAL, ship.readyForCommand() && ship.canShoot() && ship.fireMode != FireMode.NORMAL);
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Normal_fire", "N"));
            d.iconToggle(x += 27, y, this.RAPID_F, new Runnable(){

                @Override
                public void run() {
                    CommandButtonsPanel.this.fireMode(us.combat, ship, FireMode.RAPID);
                }
            }, ship.fireMode == FireMode.RAPID, ship.readyForCommand() && ship.canShoot() && ship.fireMode != FireMode.AIMED);
            d.rect(COOLDOWN, x, y + 24 - cooldown, 24.0, cooldown);
            this.tooltipHook(d, x, y, CommandButtonsPanel.cmdTooltip("Rapid_fire", "P"));
        }
    }

    private void focusOnShooting(Combat combat, Airship selected) {
        if (selected.focusOnShooting) {
            return;
        }
        combat.giveCommand(Client.msg("focusOnShooting").put("id", combat.getShipID(selected)));
    }

    private void focusOnRepair(Combat combat, Airship selected) {
        if (selected.focusOnRepair) {
            return;
        }
        combat.giveCommand(Client.msg("focusOnRepair").put("id", combat.getShipID(selected)));
    }

    private void focusOnFirefighting(Combat combat, Airship selected) {
        if (selected.focusOnFirefighting) {
            return;
        }
        combat.giveCommand(Client.msg("focusOnFirefighting").put("id", combat.getShipID(selected)));
    }

    private void focusOnMoving(Combat combat, Airship selected) {
        if (selected.focusOnMoving) {
            return;
        }
        combat.giveCommand(Client.msg("focusOnMoving").put("id", combat.getShipID(selected)));
    }

    private void groundShip(Combat combat, Airship selected) {
        if (selected.grounding) {
            return;
        }
        combat.giveCommand(Client.msg("ground").put("id", combat.getShipID(selected)));
    }

    private void abandonShip(Combat combat, Airship selected) {
        combat.giveCommand(Client.msg("abandon").put("id", combat.getShipID(selected)));
    }

    private void fireMode(Combat combat, Airship selected, FireMode m) {
        if (selected.fireMode == m) {
            return;
        }
        combat.giveCommand(Client.msg("fireMode").put("id", combat.getShipID(selected)).put("value", m.name()));
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        this.commandTooltip = this.nextTooltip;
        this.nextTooltip = null;
        if (!(us.intent instanceof CombatIntent)) {
            return;
        }
        if (us.selectedLF != null || us.selectedShip != null && us.selectedShip.commandPointsGenerated() == 0) {
            int nco = 0;
            for (Crewman cm : us.mySide.troops) {
                if (cm.attachedTo != us.selectedLF && cm.attachedTo != us.selectedShip) continue;
                ++nco;
            }
            if (us.tool instanceof MoveTroopsTool) {
                if (in.keyPressed("C") || in.keyPressed("ESCAPE")) {
                    us.tool = UniScreen.NAVIGATE;
                }
            } else if (nco > 0 && in.keyPressed("M")) {
                us.tool = new MoveTroopsTool();
            }
        }
        if (us.selectedShip != null && us.selectedShip.commandPointsGenerated() > 0) {
            Airship ship = us.selectedShip;
            if (us.tool == UniScreen.NAVIGATE && ship.readyForCommand() && !us.textInputOccurring()) {
                if (ship.type.mobile) {
                    if (in.keyPressed("M")) {
                        us.tool = new MoveCommandTool(us, false);
                    }
                    if (in.keyPressed("R")) {
                        us.tool = new MoveCommandTool(us, true);
                    }
                    if (!ship.type.onGround && in.keyPressed("G")) {
                        this.groundShip(us.combat, ship);
                    }
                }
                if (us.combat.canAbandonShip(ship) && in.keyPressed("D")) {
                    this.abandonShip(us.combat, ship);
                }
                if (in.keyPressed("T")) {
                    us.tool = new TargetCommandTool();
                }
                if (in.keyPressed("B") && BoardCommandTool.canBoard(ship, us.combat.sideOf(ship))) {
                    us.tool = new BoardCommandTool(false);
                }
                if (in.keyPressed("C")) {
                    us.tool = new BoardCommandTool(true);
                }
                if (in.keyPressed("E")) {
                    this.focusOnRepair(us.combat, ship);
                }
                if (in.keyPressed("F")) {
                    this.focusOnFirefighting(us.combat, ship);
                }
                if (in.keyPressed("V")) {
                    this.focusOnMoving(us.combat, ship);
                }
                if (in.keyPressed("S")) {
                    this.focusOnShooting(us.combat, ship);
                }
                if (in.keyPressed("A")) {
                    this.fireMode(us.combat, ship, FireMode.AIMED);
                }
                if (in.keyPressed("N")) {
                    this.fireMode(us.combat, ship, FireMode.NORMAL);
                }
                if (in.keyPressed("P")) {
                    this.fireMode(us.combat, ship, FireMode.RAPID);
                }
            }
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

