/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Tile;
import java.util.EnumSet;

public enum ConstructionAffinity {
    NONE{

        @Override
        public boolean accept(Empire e, Airship ship) {
            if (e.bonuses().contains((Object)Bonus.POWERFUL_EXPLOSIVES)) {
                return ship.type == ShipType.BUILDING || 1.has(ship, ModuleType.GRENADES, ModuleType.ROCKETS, ModuleType.FLIPPED_GRENADES, ModuleType.FLIPPED_ROCKETS);
            }
            if (e.bonuses().contains((Object)Bonus.CHEAP_GUNS)) {
                return 1.has(ship, ModuleType.CANNON, ModuleType.HV_CANNON, ModuleType.FLIPPED_CANNON, ModuleType.FLIPPED_HV_CANNON);
            }
            if (e.bonuses().contains((Object)Bonus.ROCKETS)) {
                return 1.has(ship, ModuleType.ROCKETS, ModuleType.FLIPPED_ROCKETS);
            }
            if (e.bonuses().contains((Object)Bonus.GATLING_GUNS)) {
                return 1.has(ship, ModuleType.GATLING_GUN, ModuleType.FLIPPED_GATLING_GUN);
            }
            if (e.bonuses().contains((Object)Bonus.HEAVY_CANNON)) {
                return 1.has(ship, ModuleType.HV_CANNON, ModuleType.FLIPPED_HV_CANNON);
            }
            if (e.bonuses().contains((Object)Bonus.FLAMETHROWERS)) {
                return ship.type == ShipType.BUILDING || 1.has(ship, ModuleType.FLAMETHROWER, ModuleType.FLIPPED_FLAMETHROWER);
            }
            if (e.bonuses().contains((Object)Bonus.SUSPENDIUM_CANNON)) {
                return ship.type == ShipType.BUILDING || 1.has(ship, ModuleType.SUSPENDIUM_CANNON, ModuleType.FLIPPED_SUSPENDIUM_CANNON);
            }
            if (e.bonuses().contains((Object)Bonus.GRAPPLING_HOOKS)) {
                return ship.type == ShipType.BUILDING || 1.has(ship, ModuleType.GRAPPLER_BARRACKS);
            }
            if (e.bonuses().contains((Object)Bonus.HEAVY_WOODEN_ARMOUR)) {
                return ship.type == ShipType.BUILDING || 1.has(ship, ArmourType.HV_WOOD);
            }
            if (e.bonuses().contains((Object)Bonus.HEAVY_STEEL_ARMOUR)) {
                return ship.type == ShipType.BUILDING || 1.has(ship, ArmourType.HV_STEEL);
            }
            if (e.bonuses().contains((Object)Bonus.MASSIVE_STONE_WALLS)) {
                return ship.type.mobile || 1.has(ship, ArmourType.MASSIVE_STONE_WALL);
            }
            if (e.bonuses().contains((Object)Bonus.CHEAP_STEEL)) {
                return ship.type == ShipType.BUILDING || 1.has(ship, ArmourType.MED_STEEL);
            }
            if (e.bonuses().contains((Object)Bonus.CHEAP_WOOD)) {
                return ship.type == ShipType.BUILDING || 1.has(ship, ArmourType.MED_WOOD);
            }
            return true;
        }
    }
    ,
    LANDSHIPS{

        @Override
        public boolean accept(Empire e, Airship ship) {
            return ship.type == ShipType.LANDSHIP || ship.type == ShipType.BUILDING;
        }
    }
    ,
    AIRSHIPS{

        @Override
        public boolean accept(Empire e, Airship ship) {
            return ship.type != ShipType.LANDSHIP && NONE.accept(e, ship);
        }
    }
    ,
    SMALL_SHIPS{

        @Override
        public boolean accept(Empire e, Airship ship) {
            return ship.getCost() < 400;
        }
    }
    ,
    GRENADES{

        @Override
        public boolean accept(Empire e, Airship ship) {
            return ship.type == ShipType.BUILDING || 5.has(ship, ModuleType.GRENADES, ModuleType.FLIPPED_GRENADES);
        }
    }
    ,
    BOARDERS{

        @Override
        public boolean accept(Empire e, Airship ship) {
            return ship.type == ShipType.BUILDING || 6.has(ship, ModuleType.BARRACKS, ModuleType.GRAPPLER_BARRACKS);
        }
    }
    ,
    HIGH_CEILING{

        @Override
        public boolean accept(Empire e, Airship ship) {
            return ship.type == ShipType.BUILDING || ship.serviceCeiling() > 700;
        }
    }
    ,
    OLDIES{

        @Override
        public boolean accept(Empire e, Airship ship) {
            return ship.type == ShipType.BUILDING || 8.has(ship, ModuleType.SAIL, ModuleType.SUSPENDIUM_DUST_TANK);
        }
    }
    ,
    RAMS{

        @Override
        public boolean accept(Empire e, Airship ship) {
            return ship.type == ShipType.BUILDING || 9.has(ship, ModuleType.RAM, ModuleType.GRAND_RAM);
        }
    };

    public static final EnumSet<Bonus> GIVE_NONE_TO_THESE;

    public abstract boolean accept(Empire var1, Airship var2);

    public static boolean has(Airship ship, ModuleType ... types) {
        for (Module m : ship.modules) {
            for (ModuleType mt : types) {
                if (m.type != mt) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean has(Airship ship, ArmourType ... types) {
        for (Tile t : ship.tiles) {
            for (ArmourType at : types) {
                if (t.armour.type != at) continue;
                return true;
            }
        }
        return false;
    }

    static {
        GIVE_NONE_TO_THESE = EnumSet.of(Bonus.CHEAP_STEEL, new Bonus[]{Bonus.CHEAP_WOOD, Bonus.POWERFUL_EXPLOSIVES, Bonus.CHEAP_GUNS, Bonus.ROCKETS, Bonus.GATLING_GUNS, Bonus.HEAVY_CANNON, Bonus.HEAVY_WOODEN_ARMOUR, Bonus.HEAVY_STEEL_ARMOUR, Bonus.MASSIVE_STONE_WALLS, Bonus.FLAMETHROWERS, Bonus.SUSPENDIUM_CANNON, Bonus.GRAPPLING_HOOKS});
    }
}

