/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.JSONFileBackend;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.ShipHelperWidget;
import java.io.File;
import java.util.Comparator;

public class ConstructionBackend
extends JSONFileBackend {
    public ShipHelperWidget shw;

    public ConstructionBackend(File dir, ShipHelperWidget shw) {
        super(dir);
        this.shw = shw;
        if (shw != null) {
            this.sorters.add(new CostSorter());
            for (ModuleType moduleType : ModuleType.values()) {
                this.filters.add(new ModuleTypeFilter(moduleType));
            }
            for (Enum enum_ : ArmourType.values()) {
                this.filters.add(new ArmourTypeFilter((ArmourType)enum_));
            }
        }
    }

    class ArmourTypeFilter
    implements FileScreen.SettableFilter {
        final ArmourType type;

        public ArmourTypeFilter(ArmourType type) {
            this.type = type;
        }

        @Override
        public String getNameKey() {
            return "armour_" + this.type.name();
        }

        @Override
        public FileScreen.FilterCheckResult check(String name) {
            Airship ship = ConstructionBackend.this.shw.getShipIfAvailable(name);
            if (ship == null) {
                return FileScreen.FilterCheckResult.UNKNOWN;
            }
            int tsz = ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                if (ship.tiles.get((int)ti).armour.type != this.type) continue;
                return FileScreen.FilterCheckResult.YES;
            }
            return FileScreen.FilterCheckResult.NO;
        }
    }

    class ModuleTypeFilter
    implements FileScreen.SettableFilter {
        final ModuleType type;

        public ModuleTypeFilter(ModuleType type) {
            this.type = type;
        }

        @Override
        public String getNameKey() {
            return "mod_" + this.type.name();
        }

        @Override
        public FileScreen.FilterCheckResult check(String name) {
            Airship ship = ConstructionBackend.this.shw.getShipIfAvailable(name);
            if (ship == null) {
                return FileScreen.FilterCheckResult.UNKNOWN;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                if (ship.modules.get((int)mi).type != this.type) continue;
                return FileScreen.FilterCheckResult.YES;
            }
            return FileScreen.FilterCheckResult.NO;
        }
    }

    class CostSorter
    implements FileScreen.Sorter {
        Comparator<String> asc = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Airship s1 = ConstructionBackend.this.shw.getShipIfAvailable(o1);
                Airship s2 = ConstructionBackend.this.shw.getShipIfAvailable(o2);
                if (s1 != null) {
                    if (s2 != null) {
                        return s1.getCost() - s2.getCost();
                    }
                    return -1;
                }
                if (s2 != null) {
                    return 1;
                }
                return 0;
            }
        };
        Comparator<String> desc = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Airship s1 = ConstructionBackend.this.shw.getShipIfAvailable(o1);
                Airship s2 = ConstructionBackend.this.shw.getShipIfAvailable(o2);
                if (s1 != null) {
                    if (s2 != null) {
                        return s2.getCost() - s1.getCost();
                    }
                    return -1;
                }
                if (s2 != null) {
                    return 1;
                }
                return 0;
            }
        };
        int oldShwCacheSize = 0;

        CostSorter() {
        }

        @Override
        public String getNameKey() {
            return "Cost";
        }

        @Override
        public Comparator<String> ascending() {
            return this.asc;
        }

        @Override
        public Comparator<String> descending() {
            return this.desc;
        }

        @Override
        public boolean popUpdateNeeded() {
            int newCacheSize = ConstructionBackend.this.shw.cacheSize();
            int oldCacheSize = this.oldShwCacheSize;
            this.oldShwCacheSize = newCacheSize;
            return newCacheSize != oldCacheSize;
        }
    }
}

