/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CrewLook;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import org.newdawn.slick.Image;

public class CrewAnimation {
    public static final int LOOPING = 0;
    public int length = 0;
    public Part[] parts = new Part[12];
    public int side;
    public static final CrewAnimation STANDING = new CrewAnimation(0).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(1.0, 6.0)).add(5, new Part().place(3.0, 6.0)).add(9, new Part().place(0.0, 1.0)).add(7, new Part().place(4.0, 1.0));
    public static final CrewAnimation STANDING_LEFT = new CrewAnimation(3).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(2.0, 6.0)).add(5, new Part().place(2.0, 6.0)).add(9, new Part().place(2.0, 1.0)).add(7, new Part().place(2.0, 1.0));
    public static final CrewAnimation STANDING_RIGHT = new CrewAnimation(2).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(2.0, 6.0)).add(5, new Part().place(2.0, 6.0)).add(9, new Part().place(2.0, 1.0)).add(7, new Part().place(2.0, 1.0));
    public static final CrewAnimation WALK_LEFT = new CrewAnimation(3).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(2.0, 5.8).wave(0.0, 800.0, -0.1, 0.1).rotate(0.0, 800.0, 1.0, -0.2)).add(5, new Part().place(2.0, 5.8).wave(400.0, 800.0, -0.1, 0.1).rotate(400.0, 800.0, 1.0, -0.2)).add(9, new Part().place(2.0, 1.0).wave(400.0, 800.0, -0.1, 0.1));
    public static final CrewAnimation WALK_RIGHT = new CrewAnimation(2).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(2.0, 5.8).wave(0.0, 800.0, -0.1, 0.1).rotate(0.0, 800.0, 1.0, 0.2)).add(5, new Part().place(2.0, 5.8).wave(400.0, 800.0, -0.1, 0.1).rotate(400.0, 800.0, 1.0, 0.2)).add(9, new Part().place(2.0, 1.0).wave(400.0, 800.0, -0.1, 0.1));
    public static final CrewAnimation CLIMB = new CrewAnimation(1).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(1.0, 5.0).rotate(0.0, 800.0, 0.0, 0.8)).add(5, new Part().place(3.0, 5.0).rotate(400.0, 800.0, 0.0, 0.8)).add(10, new Part().place(-1.0, 2.5).rotate(0.0, 800.0, 0.0, 0.5)).add(8, new Part().place(-1.0, 2.5).rotate(400.0, 800.0, 0.0, 0.5));
    public static final CrewAnimation FALL = new CrewAnimation(0).add(1, new Part().place(-1.0, -2.5).rotate(50.0, 200.0, 0.0, 0.2)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 5.8).rotate(100.0, 600.0, 0.0, 0.1)).add(6, new Part().place(1.0, 5.5).wave(300.0, 1000.0, -0.3, 0.3).rotate(100.0, 700.0, 0.1, 0.1)).add(5, new Part().place(3.0, 5.5).wave(100.0, 1200.0, -0.3, 0.3).rotate(300.0, 600.0, 0.1, 0.1)).add(9, new Part().place(0.0, 1.0).wave(200.0, 400.0, 2.791592653589793, 3.0915926535897933)).add(7, new Part().place(4.0, 1.0).wave(0.0, 400.0, 3.191592653589793, 3.491592653589793));
    public static final CrewAnimation JUMP_LEFT = new CrewAnimation(3).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(3.0, 5.6).wave(0.0, 100.0, -0.5, -0.5)).add(5, new Part().place(0.5, 5.2).wave(3000.0, 8000.0, -0.05, -0.2)).add(10, new Part().place(-1.0, 2.0).wave(0.0, 8000.0, -0.1, 0.1));
    public static final CrewAnimation JUMP_RIGHT = new CrewAnimation(2).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(3.5, 5.2).wave(3000.0, 8000.0, 0.05, 0.2)).add(5, new Part().place(1.0, 5.6).wave(0.0, 100.0, 0.5, 0.5)).add(10, new Part().place(-1.0, 2.0).wave(0.0, 8000.0, -0.1, 0.1));
    public static final CrewAnimation SHOOT_LEFT = new CrewAnimation(3).add(1, new Part().place(-1.0, -1.0)).add(0, new Part().place(0.0, 2.0)).add(2, new Part().place(0.0, 4.0)).add(4, new Part().place(0.0, 7.0)).add(6, new Part().place(3.0, 6.2).wave(0.0, 100.0, -0.5, -0.5)).add(5, new Part().place(0.5, 6.0)).add(10, new Part().place(-1.0, 3.0).wave(0.0, 100.0, 0.4, 0.4)).add(3, new Part().place(-6.0, 4.0));
    public static final CrewAnimation SHOOT_RIGHT = new CrewAnimation(2).add(1, new Part().place(-1.0, -1.0)).add(0, new Part().place(0.0, 2.0)).add(2, new Part().place(0.0, 4.0)).add(4, new Part().place(0.0, 7.0)).add(6, new Part().place(3.5, 6.0)).add(5, new Part().place(1.0, 6.2).wave(0.0, 100.0, 0.5, 0.5)).add(10, new Part().place(-1.0, 3.0).wave(0.0, 100.0, -0.4, -0.4)).add(3, new Part().place(-1.0, 4.0));
    public static final CrewAnimation REPAIR = new CrewAnimation(2).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(2.8, 5.9).wave(0.0, 100.0, -0.2, -0.2)).add(5, new Part().place(1.0, 6.0)).add(11, new Part().place(-3.0, 1.0).wave(0.0, 500.0, -0.4, -1.1));
    public static final CrewAnimation WORK = new CrewAnimation(2).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(2.8, 5.9).wave(0.0, 100.0, -0.2, -0.2)).add(5, new Part().place(1.0, 6.0)).add(10, new Part().place(-0.8, 2.0).wave(0.0, 1000.0, -0.6, -1.4).rotate(0.0, 1000.0, 0.5, 0.0));
    public static final CrewAnimation GIVE_LEFT = new CrewAnimation(3).length(500).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(3.0, 6.0)).add(5, new Part().place(1.2, 5.9).wave(0.0, 100.0, 0.2, 0.2)).add(9, new Part().place(2.0, 1.1).wave(0.0, 1000.0, 0.6, 1.4).rotate(500.0, 1000.0, -0.5, 0.0));
    public static final CrewAnimation GIVE_RIGHT = new CrewAnimation(2).length(500).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(2.8, 5.9).wave(0.0, 100.0, -0.2, -0.2)).add(5, new Part().place(1.0, 6.0)).add(9, new Part().place(2.0, 1.1).wave(0.0, 1000.0, -0.6, -1.4).rotate(500.0, 1000.0, 0.5, 0.0));
    public static final CrewAnimation HANG_IN_THERE = new CrewAnimation(1).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(1.0, 5.0).wave(0.0, 100.0, 0.1, 0.1)).add(5, new Part().place(3.0, 5.0).wave(0.0, 100.0, -0.1, -0.1)).add(10, new Part().place(-1.0, 1.0).wave(0.0, 100.0, 0.6, 0.6)).add(8, new Part().place(-1.0, 1.0).wave(0.0, 100.0, -0.6, -0.6));
    public static final CrewAnimation CLIMB_SIDEWAYS = new CrewAnimation(1).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(1.0, 5.0).rotate(0.0, 600.0, 0.4, 0.0).wave(0.0, 100.0, 0.1, 0.1)).add(5, new Part().place(3.0, 5.0).rotate(150.0, 600.0, 0.4, 0.0).wave(0.0, 100.0, -0.1, -0.1)).add(10, new Part().place(-1.0, 1.0).rotate(300.0, 600.0, 0.4, 0.0).wave(0.0, 100.0, 0.6, 0.6)).add(8, new Part().place(-1.0, 1.0).rotate(450.0, 600.0, 0.4, 0.0).wave(0.0, 100.0, -0.6, -0.6));
    public static final CrewAnimation INJURED = new CrewAnimation(3).add(1, new Part().place(5.0, 9.2).wave(0.0, 100.0, 1.7, 1.7)).add(0, new Part().place(4.0, 9.5).wave(0.0, 100.0, 1.5707963267948966, 1.5707963267948966)).add(2, new Part().place(1.5, 9.0).wave(0.0, 100.0, 1.5707963267948966, 1.5707963267948966)).add(4, new Part().place(-1.0, 9.5).wave(0.0, 100.0, 1.5707963267948966, 1.5707963267948966)).add(6, new Part().place(-0.5, 8.5).wave(0.0, 100.0, 1.4, 1.4)).add(7, new Part().place(4.5, 8.0).wave(0.0, 4000.0, 2.641592653589793, 3.641592653589793));
    public static final CrewAnimation DEAD = new CrewAnimation(0).add(1, new Part().place(5.0, 9.2).wave(0.0, 100.0, 1.7, 1.7)).add(0, new Part().place(4.0, 9.5).wave(0.0, 100.0, 1.5707963267948966, 1.5707963267948966)).add(2, new Part().place(1.5, 9.0).wave(0.0, 100.0, 1.5707963267948966, 1.5707963267948966)).add(4, new Part().place(-1.0, 9.5).wave(0.0, 100.0, 1.5707963267948966, 1.5707963267948966)).add(6, new Part().place(-0.5, 8.5).wave(0.0, 100.0, 1.4, 1.4)).add(7, new Part().place(4.5, 8.2).wave(0.0, 100.0, 1.3, 1.3));
    public static final CrewAnimation HAPPY = new CrewAnimation(0).add(1, new Part().place(-1.0, -2.0)).add(0, new Part().place(0.0, 1.0)).add(2, new Part().place(0.0, 3.0)).add(4, new Part().place(0.0, 6.0)).add(6, new Part().place(1.0, 6.0)).add(5, new Part().place(3.0, 6.0)).add(9, new Part().place(0.0, 0.3).wave(0.0, 100.0, 3.041592653589793, 3.041592653589793).rotate(0.0, 2000.0, 0.0, 0.8)).add(7, new Part().place(4.0, 0.3).wave(0.0, 100.0, 3.241592653589793, 3.241592653589793).rotate(0.0, 2000.0, 0.0, 0.8));
    public static final CrewAnimation SAD = new CrewAnimation(3).add(1, new Part().place(-1.7, -1.8).wave(0.0, 100.0, -0.15, -0.15)).add(0, new Part().place(-0.4, 1.0).wave(0.0, 100.0, -0.15, -0.15)).add(2, new Part().place(-0.1, 3.0).wave(0.0, 100.0, -0.1, -0.1)).add(4, new Part().place(0.1, 6.0).wave(0.0, 100.0, -0.05, -0.05)).add(6, new Part().place(2.0, 6.0)).add(5, new Part().place(2.0, 6.0)).add(7, new Part().place(1.2, 1.1).wave(0.0, 100.0, 0.1, 0.1));

    public CrewAnimation(int side) {
        this.side = side;
        for (int i = 0; i < 12; ++i) {
            this.parts[i] = new Part();
        }
    }

    public CrewAnimation length(int length) {
        this.length = length;
        return this;
    }

    public CrewAnimation add(int partIndex, Part part) {
        this.parts[partIndex] = part;
        return this;
    }

    public void draw(Draw d, double x, double y, CrewLook cl, int time, Resource carrying, Image[] light, float lightStrength, float ambient, Clr ambientTint) {
        boolean resDrawn = false;
        for (int i = 0; i < 12; ++i) {
            Part p = this.parts[i];
            if (!p.visible || cl.images[i][this.side] == null) continue;
            double px = x + p.x + Math.cos(Math.PI * 2 * ((double)time + p.rotationOffset) / p.rotationPeriod) * p.rotationWidth;
            double py = y + p.y + Math.sin(Math.PI * 2 * ((double)time + p.rotationOffset) / p.rotationPeriod) * p.rotationHeight;
            double angle = p.waveStartAngle + (p.waveEndAngle - p.waveStartAngle) * (0.5 - 0.5 * Math.cos(((double)time + p.waveOffset) * 2.0 * Math.PI / p.wavePeriod));
            Img img = cl.images[i][this.side];
            if (img.machineImgCache != null) {
                ((Image)img.machineImgCache).setFilter(9728);
            }
            RotatingShader.draw(img, d, px, py, angle, false, light, lightStrength, ambient, ambientTint);
            if (carrying == null || i != 9) continue;
            double endX = px + (double)(img.srcWidth / 2) - Math.sin(angle) * (double)img.srcHeight / 2.0;
            double endY = py + (double)(img.srcHeight / 2) + Math.cos(angle) * (double)img.srcHeight / 2.0;
            RotatingShader.draw(carrying.carryApp.frames.get(0), d, endX - 12.0, endY - 9.0, 0.0, false, light, lightStrength, ambient, ambientTint);
            resDrawn = true;
        }
        if (!resDrawn && carrying != null) {
            RotatingShader.draw(carrying.carryApp.frames.get(0), d, x - 10.0, y - 5.0, 0.0, false, light, lightStrength, ambient, ambientTint);
        }
    }

    public static class Part {
        public boolean visible = false;
        public double x;
        public double y;
        public double rotationOffset;
        public double rotationPeriod = 100.0;
        public double rotationWidth;
        public double rotationHeight;
        public double waveOffset;
        public double wavePeriod = 100.0;
        public double waveStartAngle;
        public double waveEndAngle;

        public Part place(double x, double y) {
            this.visible = true;
            this.x = x;
            this.y = y;
            return this;
        }

        public Part rotate(double rotationOffset, double rotationPeriod, double rotationWidth, double rotationHeight) {
            this.rotationOffset = rotationOffset;
            this.rotationPeriod = rotationPeriod;
            this.rotationWidth = rotationWidth;
            this.rotationHeight = rotationHeight;
            return this;
        }

        public Part wave(double waveOffset, double wavePeriod, double waveStartAngle, double waveEndAngle) {
            this.waveOffset = waveOffset;
            this.wavePeriod = wavePeriod;
            this.waveStartAngle = waveStartAngle;
            this.waveEndAngle = waveEndAngle;
            return this;
        }
    }
}

