/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CrewAnimation;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.util.Clr;
import org.newdawn.slick.Image;

public class CrewAnimator {
    public Crewman cm;
    public int time;
    public int ticksSinceClimb;
    public CrewAnimation specialAnim;
    public int specialDuration;
    public Resource specialResource;
    public boolean lastFlipped;

    public CrewAnimator(Crewman cm) {
        this.cm = cm;
    }

    public void tick(int ms) {
        this.time += ms;
        this.specialDuration -= ms;
        ++this.ticksSinceClimb;
    }

    public void animate(CrewAnimation anim, int duration, Resource res) {
        this.time = 0;
        this.specialDuration = duration;
        this.specialAnim = anim;
        this.specialResource = res;
        if (anim.side == 2) {
            this.lastFlipped = false;
        }
        if (anim.side == 3) {
            this.lastFlipped = true;
        }
    }

    public void draw(Draw d, double x, double y, boolean flipped, Image[] light, float lightStrength, float ambient, Clr ambientTint) {
        CrewAnimation anim = CrewAnimation.STANDING;
        Resource carrying = this.cm.carrying;
        if (!this.cm.active()) {
            anim = this.cm.hp <= 0 ? CrewAnimation.DEAD : CrewAnimation.INJURED;
        } else if (this.specialDuration > 0) {
            anim = this.specialAnim;
            carrying = this.specialResource;
        } else {
            if (this.cm.injuredCarried != null) {
                carrying = Resource.INJURED;
            }
            if (this.cm.ship == null && this.cm.boardingShip == null) {
                anim = this.cm.attachedTo == null ? (this.cm.dy > 0.4 || this.cm.dy >= 0.0 && Math.abs(this.cm.dx) < 0.01 ? CrewAnimation.FALL : (this.cm.dx < 0.0 ? CrewAnimation.JUMP_LEFT : CrewAnimation.JUMP_RIGHT)) : (this.cm.standing ? (this.cm.mvDx > 0.001 ? CrewAnimation.WALK_RIGHT : (this.cm.mvDx < -0.001 ? CrewAnimation.WALK_LEFT : CrewAnimation.STANDING)) : (this.cm.mvDx == 0.0 && this.cm.mvDy == 0.0 ? CrewAnimation.HANG_IN_THERE : (Math.abs(this.cm.mvDx) > Math.abs(this.cm.mvDy) ? CrewAnimation.CLIMB_SIDEWAYS : CrewAnimation.CLIMB)));
            } else if (this.cm.movingTowards != null) {
                if (this.cm.movingTowards.y != this.cm.currentTile.y) {
                    anim = CrewAnimation.CLIMB;
                    this.ticksSinceClimb = 0;
                } else if (this.ticksSinceClimb < 2) {
                    anim = CrewAnimation.CLIMB;
                } else {
                    this.lastFlipped = this.cm.movingTowards.x > this.cm.currentTile.x == flipped;
                    anim = this.lastFlipped ? CrewAnimation.WALK_LEFT : CrewAnimation.WALK_RIGHT;
                }
            } else if (this.cm.job != null && this.cm.job instanceof Module.StaffJob) {
                anim = flipped ? CrewAnimation.STANDING_LEFT : CrewAnimation.STANDING_RIGHT;
            }
        }
        anim.draw(d, x, y, this.cm.type.look, this.time, carrying, light, lightStrength, ambient, ambientTint);
    }
}

