/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.CrewLook;
import com.zarkonnen.airships.Lang;
import java.util.ArrayList;

public enum CrewType {
    SAILOR(1.0, 2, false, false, 0.2, 5, 3, Appearance.app(0, 14), new CrewLook().add(1, 0, 80, 256, 7, 5).add(1, 1, 80, 256, 7, 5).add(1, 2, 86, 256, 7, 5).add(0, 0, 81, 261, 5, 4).add(0, 2, 87, 261, 5, 4).add(0, 1, 93, 261, 5, 4).addAll(2, 99, 261, 5, 5).addAll(4, 104, 262, 5, 4).addAll(9, 86, 265, 1, 7).addAll(7, 86, 265, 1, 7).add(10, 2, 93, 266, 7, 5).add(10, 1, 99, 268, 7, 5).addFlipped(10, 3, 93, 266, 7, 5).addFlipped(10, 0, 99, 268, 7, 5).addFlipped(8, 2, 93, 266, 7, 5).addFlipped(8, 1, 99, 268, 7, 5).add(8, 3, 93, 266, 7, 5).add(8, 0, 99, 268, 7, 5).addAll(5, 92, 265, 1, 7).addAll(6, 92, 265, 1, 7).add(3, 2, 97, 256, 12, 4).add(11, 2, 106, 266, 11, 7)),
    MARINE(0.5, 4, true, false, 0.4, 6, 3, Appearance.app(6, 14), new CrewLook().add(1, 0, 120, 256, 7, 5).add(1, 1, 120, 256, 7, 5).add(1, 2, 126, 256, 7, 5).add(0, 0, 121, 261, 5, 4).add(0, 2, 127, 261, 5, 4).add(0, 1, 133, 261, 5, 4).addAll(2, 139, 261, 5, 5).add(2, 0, 149, 261, 5, 5).addAll(4, 154, 262, 5, 4).add(4, 0, 144, 262, 5, 4).addAll(9, 126, 265, 1, 7).addAll(7, 126, 265, 1, 7).add(10, 2, 133, 266, 7, 5).add(10, 1, 139, 268, 7, 5).addFlipped(10, 3, 133, 266, 7, 5).addFlipped(10, 0, 139, 268, 7, 5).addFlipped(8, 2, 133, 266, 7, 5).addFlipped(8, 1, 139, 268, 7, 5).add(8, 3, 133, 266, 7, 5).add(8, 0, 139, 268, 7, 5).addAll(5, 132, 265, 1, 7).addAll(6, 132, 265, 1, 7).add(3, 2, 137, 256, 12, 4).add(11, 2, 146, 266, 11, 7)),
    GRENADIER(0.7, 6, true, true, 0.6, 7, 3, Appearance.app(6, 15), new CrewLook().add(1, 0, 160, 256, 7, 5).add(1, 1, 159, 266, 7, 5).add(1, 2, 166, 256, 7, 5).add(0, 0, 161, 261, 5, 4).add(0, 2, 167, 261, 5, 4).add(0, 1, 173, 261, 5, 4).add(2, 1, 189, 261, 5, 5).add(2, 2, 189, 261, 5, 5).add(2, 0, 179, 261, 5, 5).addAll(4, 194, 262, 5, 4).add(4, 0, 184, 262, 5, 4).addAll(9, 166, 265, 1, 7).addAll(7, 166, 265, 1, 7).add(10, 2, 173, 266, 7, 5).add(10, 1, 179, 268, 7, 5).addFlipped(10, 3, 173, 266, 7, 5).addFlipped(10, 0, 179, 268, 7, 5).addFlipped(8, 2, 173, 266, 7, 5).addFlipped(8, 1, 179, 268, 7, 5).add(8, 3, 173, 266, 7, 5).add(8, 0, 179, 268, 7, 5).addAll(5, 172, 265, 1, 7).addAll(6, 172, 265, 1, 7).add(3, 2, 177, 256, 12, 4).add(11, 2, 176, 276, 11, 7)),
    GUARD(0.5, 4, false, false, 0.2, 6, 3, Appearance.app(12, 14), new CrewLook().add(1, 0, 200, 256, 7, 5).add(1, 1, 200, 256, 7, 5).add(1, 2, 206, 256, 7, 5).add(0, 0, 201, 261, 5, 4).add(0, 2, 207, 261, 5, 4).add(0, 1, 213, 261, 5, 4).addAll(2, 219, 261, 5, 5).add(2, 0, 229, 261, 5, 5).addAll(4, 234, 262, 5, 4).add(4, 0, 224, 262, 5, 4).addAll(9, 206, 265, 1, 7).addAll(7, 206, 265, 1, 7).add(10, 2, 213, 266, 7, 5).add(10, 1, 219, 268, 7, 5).addFlipped(10, 3, 213, 266, 7, 5).addFlipped(10, 0, 219, 268, 7, 5).addFlipped(8, 2, 213, 266, 7, 5).addFlipped(8, 1, 219, 268, 7, 5).add(8, 3, 213, 266, 7, 5).add(8, 0, 219, 268, 7, 5).addAll(5, 212, 265, 1, 7).addAll(6, 212, 265, 1, 7).add(3, 2, 217, 256, 12, 4).add(11, 2, 226, 266, 11, 7)),
    ARACHNID(0.5, 3, true, true, 0.2, 5, 3, Appearance.app(1, 14), new CrewLook().add(1, 0, 111, 224, 7, 5).add(1, 1, 111, 224, 7, 5).add(1, 2, 117, 224, 7, 5).add(0, 0, 112, 229, 5, 4).add(0, 2, 118, 229, 5, 4).add(0, 1, 124, 229, 5, 4).addAll(2, 130, 229, 5, 5).addAll(4, 135, 230, 5, 4).addAll(9, 117, 233, 1, 7).addAll(7, 117, 233, 1, 7).add(10, 2, 124, 234, 7, 5).add(10, 1, 130, 236, 7, 5).addFlipped(10, 3, 124, 234, 7, 5).addFlipped(10, 0, 130, 236, 7, 5).addFlipped(8, 2, 124, 234, 7, 5).addFlipped(8, 1, 130, 236, 7, 5).add(8, 3, 124, 234, 7, 5).add(8, 0, 130, 236, 7, 5).addAll(5, 123, 233, 1, 7).addAll(6, 123, 233, 1, 7).add(3, 2, 128, 224, 12, 4).add(11, 2, 137, 234, 11, 7));

    public final boolean hasHook;
    public final double supplyCost;
    public final double crewEffectiveness;
    public final int maxHP;
    public final int minWorkingHP;
    public final int combatStrength;
    public final int shotDamage;
    public final int weaponReload;
    public final int pickupMs;
    public final double pickupDmgMaxMalus;
    public final double pickupFireMult;
    public final double fireSpeedMult;
    public final double dmgWorstSpeedMalus;
    public final double goingUpSpeedMult;
    public final double carrySpeedMult;
    public final int repairTime;
    public final CrewLook look;
    public final Appearance simpleLook;
    public final boolean canBoard;

    private CrewType(double crewEffectiveness, int combatStrength, boolean canBoard, boolean hasHook, double supplyCost, int maxHP, int minWorkingHP, Appearance simpleLook, CrewLook look) {
        this.crewEffectiveness = crewEffectiveness;
        this.combatStrength = combatStrength;
        this.canBoard = canBoard;
        this.hasHook = hasHook;
        this.supplyCost = supplyCost;
        this.look = look;
        this.simpleLook = simpleLook;
        this.maxHP = maxHP;
        this.minWorkingHP = minWorkingHP;
        this.pickupMs = (int)(300.0 / crewEffectiveness);
        this.pickupDmgMaxMalus = 3.0;
        this.pickupFireMult = 1.0 + 0.5 / crewEffectiveness;
        this.fireSpeedMult = 1.0 - 0.3 / crewEffectiveness;
        this.dmgWorstSpeedMalus = -0.3;
        this.goingUpSpeedMult = 1.0 - 0.1 / crewEffectiveness;
        this.carrySpeedMult = 1.0 - 0.2 / crewEffectiveness;
        this.repairTime = (int)(4000.0 / crewEffectiveness);
        this.shotDamage = combatStrength;
        this.weaponReload = 2500 - 400 * combatStrength;
    }

    public static CrewAppearance app() {
        return new CrewAppearance();
    }

    public String getName() {
        return Lang._t("crew_" + this.name(), new Object[0]);
    }

    public String getPlural() {
        return Lang._t("crew_" + this.name() + "_plural", new Object[0]);
    }

    public static class CrewAppearance {
        public final ArrayList<Appearance> standing = new ArrayList();

        public CrewAppearance standing(int startX, int y) {
            for (int i = 0; i < 6; ++i) {
                this.standing.add(new Appearance(startX + i, y));
            }
            return this;
        }
    }
}

